package com.ejianc.business.car.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.car.vo.OilRecordDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 用油记录
 * 
 * @author generator
 * 
 */
public class OilRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String carCode; // 车牌号
    private String carName; // 车辆名称
    private Long carAreaId; // 车辆所在区域
    private String carAreaName; // 车辆所在区域
    private Long carProjectId; // 车辆所在项目
    private String carProjectName; // 车辆所在项目
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date monthDate; // 月份
    private BigDecimal totalOilConsumption; // 总油耗量
    private Long employeeId; // 经办人
    private Long carId; // 车辆id
    private String employeeName; // 经办人
    private String departmentName; // 经办部门
    private String memo; // 备注
    private Long orgId; // 所属公司
    private String orgName; // 所属公司
    private Long carOrgId; // 车辆所属公司
    private String carOrgName; // 车辆所属公司
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    
    private List<OilRecordDetailVO> oilRecordDetailList = new ArrayList<>(); // 用油记录详情

    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }

    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarAreaId() {
        return carAreaId;
    }
    @ReferDeserialTransfer
    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }
    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getCarProjectId() {
        return carProjectId;
    }
    @ReferDeserialTransfer
    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }
    public String getCarProjectName() {
        return carProjectName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }
    public Date getMonthDate() {
        return monthDate;
    }
    @ReferSerialTransfer(referCode = "car-info")
    public Long getCarId() {
        return carId;
    }
    @ReferDeserialTransfer
    public void setCarId(Long carId) {
        this.carId = carId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getCarOrgId() {
        return carOrgId;
    }
    @ReferDeserialTransfer
    public void setCarOrgId(Long carOrgId) {
        this.carOrgId = carOrgId;
    }

    public String getCarOrgName() {
        return carOrgName;
    }

    public void setCarOrgName(String carOrgName) {
        this.carOrgName = carOrgName;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    public BigDecimal getTotalOilConsumption() {
        return totalOilConsumption;
    }

    public void setTotalOilConsumption(BigDecimal totalOilConsumption) {
        this.totalOilConsumption = totalOilConsumption;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     public List<OilRecordDetailVO> getOilRecordDetailList() {
        return oilRecordDetailList;
     }

     public void setOilRecordDetailList(List<OilRecordDetailVO> oilRecordDetailList) {
        this.oilRecordDetailList = oilRecordDetailList;
     }
}
