/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.WageEnterEntity;
import com.ejianc.business.car.service.IWageEnterService;
import com.ejianc.business.car.vo.SalaryReportVo;
import com.ejianc.business.car.vo.WageEnterDetailVO;
import com.ejianc.business.car.vo.WageEnterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"wageEnter"})
public class WageEnterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SALARY_WAGE";
    @Autowired
    private IWageEnterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WageEnterVO> saveOrUpdate(@RequestBody WageEnterVO saveOrUpdateVO) {
        WageEnterEntity entity = (WageEnterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WageEnterEntity.class));
        int i = this.service.queryByWageOrgId(saveOrUpdateVO.getWageOrgId(), null == entity.getId() ? null : saveOrUpdateVO.getId());
        if (i > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u81ea\u7531\u6001\u5355\u636e\uff0c\u65e0\u6cd5\u5236\u5355\uff01");
        }
        CommonResponse<String> stringCommonResponse = this.service.queryUnEnter(saveOrUpdateVO.getOrgId(), saveOrUpdateVO.getSalaryMoth(), null == entity.getId() ? null : saveOrUpdateVO.getId());
        if (!stringCommonResponse.isSuccess()) {
            return CommonResponse.error((String)stringCommonResponse.getMsg());
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WageEnterVO vo = (WageEnterVO)BeanMapper.map((Object)((Object)entity), WageEnterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WageEnterVO> queryDetail(Long id) {
        WageEnterEntity entity = (WageEnterEntity)((Object)this.service.selectById(id));
        WageEnterVO vo = (WageEnterVO)BeanMapper.map((Object)((Object)entity), WageEnterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WageEnterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WageEnterVO wageEnterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WageEnterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("wageOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WageEnterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WageEnterVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (iPageCommonResponse.isSuccess()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        records.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        beans.put("records", records);
        ExcelExport.getInstance().export("WageEnter-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDetail(@RequestBody List<WageEnterDetailVO> detailVOS, HttpServletResponse response) {
        HashMap<String, List<WageEnterDetailVO>> beans = new HashMap<String, List<WageEnterDetailVO>>();
        beans.put("records", detailVOS);
        ExcelExport.getInstance().export("wageDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWageEnterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WageEnterVO>> refWageEnterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WageEnterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"project-moth-detail-import.xlsx", (String)"\u9879\u76ee\u6708\u5ea6\u5de5\u8d44\u8868\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response);
    }

    @RequestMapping(value={"/queryUnEnter"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryUnEnter(Long wageOrgId, Date salaryMoth) {
        return this.service.queryUnEnter(wageOrgId, salaryMoth, null);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryReport(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458\u5de5\u8d44\u7edf\u8ba1", (Object)this.service.queryReport(param));
    }

    @RequestMapping(value={"/excelExportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<SalaryReportVo> records = this.service.excelExportReport(queryParam);
        HashMap<String, List<SalaryReportVo>> beans = new HashMap<String, List<SalaryReportVo>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("salary-report-export.xlsx", beans, response);
    }
}

