package com.ejianc.business.car.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.car.vo.WageEnterDetailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人员工资
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_wage_enter")
public class WageEnterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;


    @TableField(value="wage_org_id")
    private Long wageOrgId; //组织
    @TableField(value="wage_org_name")
    private String wageOrgName; // 组织名称
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="pay_unit_id")
    private Long payUnitId; // 付款单位
    @TableField(value="pay_unit_name")
    private String payUnitName; // 付款单位名称
    @TableField(value="team")
    private String team; // 班组
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    @TableField(value="salary_moth")
    private Date salaryMoth; // 月份
    @TableField(value="total_salary_mny")
    private BigDecimal totalSalaryMny; // 实发工资合计
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="bill_date")
    private Date billDate; // 制单日期
    @TableField(exist=false)
    @SubEntity(serviceName="wageEnterDetailService" , pidName = "salaryId")
    private List<WageEnterDetailEntity> detailList = new ArrayList<>(); // 工资明细

    public String getTeam() {
        return team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public List<WageEnterDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<WageEnterDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Long getWageOrgId() {
        return wageOrgId;
    }

    public void setWageOrgId(Long wageOrgId) {
        this.wageOrgId = wageOrgId;
    }

    public String getWageOrgName() {
        return wageOrgName;
    }

    public void setWageOrgName(String wageOrgName) {
        this.wageOrgName = wageOrgName;
    }

    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getSalaryMoth() {
        return salaryMoth;
    }

    public void setSalaryMoth(Date salaryMoth) {
        this.salaryMoth = salaryMoth;
    }
    public BigDecimal getTotalSalaryMny() {
        return totalSalaryMny;
    }

    public void setTotalSalaryMny(BigDecimal totalSalaryMny) {
        this.totalSalaryMny = totalSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
