package com.ejianc.business.car.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.car.bean.OilRecordEntity;
import com.ejianc.business.car.vo.OilFeeReportVo;
import com.ejianc.business.car.vo.OilRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.car.bean.OilFeeEntity;
import com.ejianc.business.car.service.IOilFeeService;
import com.ejianc.business.car.vo.OilFeeVO;

/**
 * 车辆油卡充值
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("oilFee")
public class OilFeeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "OIL_FEE";//此处需要根据实际修改

    @Autowired
    private IOilFeeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OilFeeVO> saveOrUpdate(@RequestBody OilFeeVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        LambdaQueryWrapper<OilFeeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OilFeeEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(OilFeeEntity::getCarId, saveOrUpdateVO.getCarId());
        queryWrapper.eq(OilFeeEntity::getMonthDate, saveOrUpdateVO.getMonthDate());
        queryWrapper.ne(id != null, OilFeeEntity::getId, id);
        int count = service.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该车辆该月份已做单据！");
        }
    	OilFeeEntity entity = BeanMapper.map(saveOrUpdateVO, OilFeeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OilFeeVO vo = BeanMapper.map(entity, OilFeeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/queryOilFeeReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryOilFeeReport(@RequestBody QueryParam param) {

        return CommonResponse.success("查询用油统计表", service.queryOilFeeReport(param));
    }
    @RequestMapping(value = "/excelExportOilFeeReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportOilFeeReport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<OilFeeReportVo> records = service.excelExportOilFeeReport(queryParam);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("oil-fee-report-export.xlsx", beans, response);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OilFeeVO> queryDetail(Long id) {
    	OilFeeEntity entity = service.selectById(id);
    	OilFeeVO vo = BeanMapper.map(entity, OilFeeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryMonSurplusAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryMonSurplusAmount(@RequestParam(value = "carId")Long carId, @RequestParam(value = "monthDate")String monthDate) {
        monthDate=monthDate+"-01";
        BigDecimal monSurplusAmount = new BigDecimal(0);
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = null;
        String time=null;
        try {
            parse = simpleDateFormat.parse(monthDate);
            instance.setTime(parse);
            instance.add(Calendar.MONTH,-1);
             time = simpleDateFormat.format(instance.getTime());

        } catch (ParseException e) {
            e.printStackTrace();
        }
        LambdaQueryWrapper<OilFeeEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OilFeeEntity::getCarId, carId)
                .eq(OilFeeEntity::getMonthDate, time)
                .in(OilFeeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        OilFeeEntity entity = service.getOne(lambdaQueryWrapper);
        if (entity != null) {
            monSurplusAmount = entity.getSurplusAmount();
            return CommonResponse.success("查询上期余额数据成功！", monSurplusAmount);
        } else {
            return CommonResponse.success("查询上期余额数据成功！", monSurplusAmount);
        }
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OilFeeVO> vos) {
        service.removeByIds(vos.stream().map(OilFeeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OilFeeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("carCode");
        fuzzyFields.add("carName");
        fuzzyFields.add("oilCard");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OilFeeEntity> page = service.queryPage(param,false);
        IPage<OilFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OilFeeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("carCode");
        fuzzyFields.add("carName");
        fuzzyFields.add("oilCard");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OilFeeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<OilFeeVO> oilFeeVOS = BeanMapper.mapList(list, OilFeeVO.class);
        if (CollectionUtils.isNotEmpty(oilFeeVOS)) {
            oilFeeVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", oilFeeVOS);
        ExcelExport.getInstance().export("OilFee-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOilFeeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OilFeeVO>> refOilFeeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OilFeeEntity> page = service.queryPage(param,false);
        IPage<OilFeeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OilFeeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
