package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.mapper.CarMapper;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 车辆信息
 *
 * @author generator
 *
 */
@Service("carService")
public class CarServiceImpl extends BaseServiceImpl<CarMapper, CarEntity> implements ICarService {


    private final String CAR_TYPE = "car-type";
    private final String CAR_AREA = "car-area";

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public JSONObject carCount() {
        JSONObject obj = new JSONObject();
        LinkedList<JSONObject> head = new LinkedList<>();
        LinkedList<JSONObject> data = new LinkedList<>();
        CommonResponse<List<DefdocDetailVO>> carTypeRes = defdocApi.getDefDocByDefCode(CAR_TYPE);
        CommonResponse<List<DefdocDetailVO>> carAreaRes = defdocApi.getDefDocByDefCode(CAR_AREA);

        LambdaQueryWrapper<CarEntity> queryWrapper = new QueryWrapper<CarEntity>().
                select("CONCAT( car_type_id, car_area_id ) typeAreaKey, COUNT( 1 ) num").lambda();
        queryWrapper.in(CarEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CarEntity::getOrgId, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        queryWrapper.groupBy(CarEntity::getCarTypeId, CarEntity::getCarAreaId);
        List<Map<String, Object>> maps = this.listMaps(queryWrapper);

        Map<String, Integer> countData = new HashMap<>();
        if (CollectionUtils.isNotEmpty(maps)) {
            for (Map<String, Object> map : maps) {
                countData.put(String.valueOf(map.get("typeAreaKey")), Integer.parseInt(String.valueOf(map.get("num"))));
            }
        }

        List<DefdocDetailVO> carAreaData = new ArrayList<>();
        if (carAreaRes.isSuccess() && CollectionUtils.isNotEmpty(carAreaRes.getData())) {
            carAreaData = carAreaRes.getData();
            carAreaData.sort(Comparator.comparing(DefdocDetailVO::getId));
        }

        if (carTypeRes.isSuccess()) {
            List<DefdocDetailVO> carTypeData = carTypeRes.getData();
            if (CollectionUtils.isNotEmpty(carTypeData)) {
                carTypeData.sort(Comparator.comparing(DefdocDetailVO::getId));
                JSONObject areaHead = new JSONObject();
                areaHead.put("key", "carType");
                areaHead.put("name", "车辆类型");
                head.add(areaHead);

                for (DefdocDetailVO datum : carAreaData) {
                    JSONObject hh = new JSONObject();
                    String key = String.valueOf(datum.getId());
                    hh.put("key", key);
                    hh.put("name", datum.getName());
                    head.add(hh);
                }

                JSONObject totalHead = new JSONObject();
                totalHead.put("key", "total");
                totalHead.put("name", "合计");
                head.add(totalHead);

                for (DefdocDetailVO carType : carTypeData) {
                    String carTypeKey = String.valueOf(carType.getId());
                    JSONObject dd = new JSONObject();
                    dd.put("carTypeId", carType.getId());
                    dd.put("carType", carType.getName());
                    int total = 0;
                    for (DefdocDetailVO datum : carAreaData) {
                        Integer num = countData.get(carTypeKey + datum.getId());
                        dd.put(String.valueOf(datum.getId()), num);
                        total += num == null ? 0 : num;
                    }
                    dd.put("total", total);
                    data.add(dd);
                }
            }
        }
        obj.put("head", head);
        obj.put("data", data);
        return obj;
    }
}
