package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.bean.DispatchEntity;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.business.car.service.IDispatchService;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("dispatch") 
public class DispatchBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
	private IDispatchService service;
    @Autowired
	private ICarService carService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DispatchEntity entity = service.selectById(billId);
		if (entity.getDispatchType()==1&& null!=entity.getDispatchProjectId()){
			CarEntity car = carService.selectById(entity.getCarId());
			entity.setHistoryProjectId(car.getCarProjectId());
			entity.setHistoryProjectName(car.getCarProjectName());
//			entity.setCarProjectName(entity.getDispatchProjectName());
//			entity.setCarProjectId(entity.getDispatchProjectId());
			service.saveOrUpdate(entity);
			car.setCarProjectId(entity.getDispatchProjectId());
			car.setCarProjectName(entity.getDispatchProjectName());
			carService.saveOrUpdate(car);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		DispatchEntity entity = service.selectById(billId);
		if (entity.getDispatchType()==1&& null!=entity.getDispatchProjectId()){
			CarEntity car = carService.selectById(entity.getCarId());
//			entity.setCarProjectName(entity.getHistoryProjectName());
//			entity.setCarProjectId(entity.getHistoryProjectId());
//			service.saveOrUpdate(entity);
			car.setCarProjectId(entity.getHistoryProjectId());
			car.setCarProjectName(entity.getHistoryProjectName());
			carService.saveOrUpdate(car);
		}
		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}

}
