package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.car.vo.WageUserDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.car.mapper.WageUserMapper;
import com.ejianc.business.car.bean.WageUserEntity;
import com.ejianc.business.car.service.IWageUserService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 组织人员登记
 * 
 * @author generator
 * 
 */
@Service("wageUserService")
public class WageUserServiceImpl extends BaseServiceImpl<WageUserMapper, WageUserEntity> implements IWageUserService {

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<WageUserDetailVO> successList = new ArrayList<>();
            List<WageUserDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 6) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result != null && result.size() > 0) {
                    for (int i = 0; i < result.size(); i++) {
                        List<String> datas = result.get(i);
                        WageUserDetailVO vo = new WageUserDetailVO();
                        if (StringUtils.isBlank(datas.get(0))) {
                            vo.setErrorMessage("姓名为必填项");
                        } else {
                            vo.setWageName(datas.get(0));
                        }

                        if (StringUtils.isNotBlank(datas.get(1))) {
                            try {
                                vo.setBaseSalary(new BigDecimal(datas.get(1)));
                            } catch (Exception e) {
                                vo.setErrorMessage("基本薪资必须为数字");
                            }
                        } else {
                            vo.setErrorMessage("基本薪资为必填项");
                        }
                        if (StringUtils.isNotBlank(datas.get(2))) {
                            try {
                                vo.setJobSubsidy(new BigDecimal(datas.get(2)));
                            } catch (Exception e) {
                                vo.setErrorMessage("岗位津贴必须为数字");
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(3))) {
                            try {
                                vo.setPerformance(new BigDecimal(datas.get(3)));
                            } catch (Exception e) {
                                vo.setErrorMessage("绩效必须为数字");
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(4))) {
                            vo.setWageCard(datas.get(4));
                        }
                        if (StringUtils.isNotBlank(datas.get(5))) {
                            vo.setRemark(datas.get(5));
                        }


                        if (StringUtils.isBlank(vo.getErrorMessage())) {
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    }

                    resp.put("successList", successList);
                    resp.put("errorList", errorList);
                    resp.put("successNum", successList.size());
                    resp.put("errorNum", errorList.size());
                    return CommonResponse.success(resp);
                }
            }
            return CommonResponse.error("Excel为空");
        }
    }
}
