package com.ejianc.business.car.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.car.bean.WageUserDetailEntity;
/**
 * 组织人员登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_wage_user")
public class WageUserEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="total_people_num")
    private Integer totalPeopleNum; // 总人数
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_date")
    private Date billDate; // 制单日期
    @TableField(value="team")
    private String team; // 班组

    
    @TableField(exist=false)
    @SubEntity(serviceName="wageUserDetailService" , pidName = "wageUserId")
    private List<WageUserDetailEntity> wageUserDetailList = new ArrayList<>(); // 组织人员登记-人员明细
    

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getTotalPeopleNum() {
        return totalPeopleNum;
    }

    public void setTotalPeopleNum(Integer totalPeopleNum) {
        this.totalPeopleNum = totalPeopleNum;
    }
    public String getMemo() {
        return memo;
    }

    public String getTeam() {
        return team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    

    public List<WageUserDetailEntity> getWageUserDetailList() {
        return wageUserDetailList;
    }

    public void setWageUserDetailList(List<WageUserDetailEntity> wageUserDetailList) {
        this.wageUserDetailList = wageUserDetailList;
    }
}
