package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.MaintainEntity;
import com.ejianc.business.car.service.IMaintainService;
import com.ejianc.business.car.vo.MaintainMaterialVO;
import com.ejianc.business.car.vo.MaintainVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 车辆维修
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("maintain")
public class MaintainController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MAIN-CODE";//此处需要根据实际修改

    @Autowired
    private IMaintainService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaintainVO> saveOrUpdate(@RequestBody MaintainVO saveOrUpdateVO) {
        MaintainEntity entity = BeanMapper.map(saveOrUpdateVO, MaintainEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        MaintainVO vo = BeanMapper.map(entity, MaintainVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaintainVO> queryDetail(Long id) {
        MaintainEntity entity = service.selectById(id);
        MaintainVO vo = BeanMapper.map(entity, MaintainVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaintainVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaintainVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaintainVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaintainVO>> queryList(@RequestBody QueryParam param) {

        /** 车牌号、车辆名称、车辆所属区域、车辆所属项目
         * */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("carCode", "carName", "carAreaName", "carProjectName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse = iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                    collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<MaintainEntity> page = service.queryPage(param, false);
        IPage<MaintainVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaintainVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaintainEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<MaintainVO> dispatchVOS = BeanMapper.mapList(list, MaintainVO.class);
        if (CollectionUtils.isNotEmpty(dispatchVOS)) {
            dispatchVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", dispatchVOS);
        ExcelExport.getInstance().export("Maintain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaintainData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaintainVO>> refMaintainData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaintainEntity> page = service.queryPage(param, false);
        IPage<MaintainVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaintainVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Maintain-import.xlsx", "车辆维修材料费清单导入模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<MaintainMaterialVO> successList = new ArrayList<>();
            List<MaintainMaterialVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MaintainMaterialVO vo = new MaintainMaterialVO();
                    StringBuilder errMsg = new StringBuilder();
                    // 材料名称
                    if (StringUtils.isBlank(datas.get(0).trim())) {
                        errMsg.append("`材料名称为必填项`");
                    } else {
                        vo.setMaterialName(datas.get(0).trim());

                    }
                    // 数量
                    if (StringUtils.isNotBlank(datas.get(1).trim())) {
                        try {
                            vo.setNum(new BigDecimal(datas.get(1).trim()));
                        } catch (Exception e) {
                            errMsg.append("`数量必须为数字`");
                        }
                    }
                    // 单价
                    if (StringUtils.isNotBlank(datas.get(2).trim())) {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(2).trim()));
                        } catch (Exception e) {
                            errMsg.append("`单价必须为数字`");
                        }
                    }
                    // 金额
                    if (StringUtils.isNotBlank(datas.get(3).trim())) {
                        try {
                            vo.setTaxMny(new BigDecimal(datas.get(3).trim()));
                        } catch (Exception e) {
                            errMsg.append("`金额必须为数字`");
                        }
                    } else {
                        errMsg.append("`金额为必填项`");
                    }
                    // 备注
                    if (StringUtils.isNotBlank(datas.get(4).trim())) {
                        vo.setMemo(datas.get(4).trim());
                    }
                    if (vo.getNum() != null && vo.getPrice() != null) {
                        vo.setTaxMny(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(vo.getPrice(), vo.getNum())));
                    }
                    vo.setAddType("2");
                    if (StringUtils.isNotBlank(errMsg.toString())) {
                        vo.setId(Long.valueOf(i));
                        vo.setErrorMessage(errMsg.toString());
                        errorList.add(vo);
                    } else {
                        successList.add(vo);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
