package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.vo.OilFeeReportVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.car.mapper.OilFeeMapper;
import com.ejianc.business.car.bean.OilFeeEntity;
import com.ejianc.business.car.service.IOilFeeService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 车辆油卡充值
 * 
 * @author generator
 * 
 */
@Service("oilFeeService")
public class OilFeeServiceImpl extends BaseServiceImpl<OilFeeMapper, OilFeeEntity> implements IOilFeeService{

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public JSONObject queryOilFeeReport(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("oilCard");
        fuzzyFields.add("carName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("carAreaName");
        fuzzyFields.add("carCode");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,billstate));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        Parameter yyear = param.getParams().get("yyear");
        Object value = null != yyear ? yyear.getValue():null;
        param.getParams().remove("yyear");
        Page<OilFeeReportVo> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<OilFeeReportVo> wrapper = changeToQueryWrapper(param);
        wrapper.isNotNull("oil_card");
        wrapper.groupBy("car_id");
        wrapper.apply("YEAR(month_date) = "+value);
        List<OilFeeReportVo> oilRecordReportVos = baseMapper.queryOilFeeReport(pages, wrapper);
        jsonObject.put("records", oilRecordReportVos);
        jsonObject.put("total", pages.getTotal());
        jsonObject.put("current", pages.getCurrent());
        jsonObject.put("size", pages.getSize());
        jsonObject.put("pages", pages.getPages());
        return jsonObject;
    }

    @Override
    public List<OilFeeReportVo> excelExportOilFeeReport(QueryParam queryParam) {
        List<OilFeeReportVo> records = (List<OilFeeReportVo>) queryOilFeeReport(queryParam).get("records");
        return records;
    }
}
