package com.ejianc.business.car.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.vo.OilRecordReportVo;
import com.ejianc.business.car.vo.OilRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.car.mapper.OilRecordMapper;
import com.ejianc.business.car.bean.OilRecordEntity;
import com.ejianc.business.car.service.IOilRecordService;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 用油记录
 * 
 * @author generator
 * 
 */
@Service("oilRecordService")
public class OilRecordServiceImpl extends BaseServiceImpl<OilRecordMapper, OilRecordEntity> implements IOilRecordService{
    @Autowired
    private IOrgApi iOrgApi;
    @Override
    public JSONObject OilRecordReport(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("carName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("carAreaName");
        fuzzyFields.add("carCode");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN,billstate));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        Parameter yyear = param.getParams().get("yyear");
        Object value = null != yyear ? yyear.getValue():null;
        param.getParams().remove("yyear");
        Page<OilRecordReportVo> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<OilRecordReportVo> wrapper = changeToQueryWrapper(param);
        wrapper.apply("YEAR(month_date) = "+value);
        wrapper.groupBy("car_id");
        List<OilRecordReportVo> oilRecordReportVos = baseMapper.queryOilRecordReport(pages, wrapper);
        jsonObject.put("records", oilRecordReportVos);
        jsonObject.put("total", pages.getTotal());
        jsonObject.put("current", pages.getCurrent());
        jsonObject.put("size", pages.getSize());
        jsonObject.put("pages", pages.getPages());
        return jsonObject;
    }

    @Override
    public List<OilRecordVO> excelExportOilRecordReport(QueryParam queryParam) {
        List<OilRecordVO> records = (List<OilRecordVO>) OilRecordReport(queryParam).get("records");
        return records;
    }
}
