/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.car.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.car.bean.CarEntity;
import com.ejianc.business.car.bean.DispatchEntity;
import com.ejianc.business.car.bean.MaintainEntity;
import com.ejianc.business.car.bean.OilFeeEntity;
import com.ejianc.business.car.bean.OilRecordEntity;
import com.ejianc.business.car.service.ICarService;
import com.ejianc.business.car.service.IDispatchService;
import com.ejianc.business.car.service.IMaintainService;
import com.ejianc.business.car.service.IOilFeeService;
import com.ejianc.business.car.service.IOilRecordService;
import com.ejianc.business.car.vo.CarVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"car"})
public class CarController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICarService service;
    @Autowired
    private SessionManager sessionManager;
    private final String CAR_TYPE = "car-type";
    private final String CAR_MODEL = "car-model";
    private final String CAR_AREA = "car-area";
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectApi projectApi;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private IMaintainService maintainService;
    @Autowired
    private IDispatchService dispatchService;
    @Autowired
    private IOilRecordService oilRecordService;
    @Autowired
    private IOilFeeService oilFeeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CarVO> saveOrUpdate(@RequestBody CarVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(CarEntity::getCode, (Object)saveOrUpdateVO.getCode());
        queryWrapper.ne(id != null, BaseEntity::getId, (Object)id);
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8f66\u724c\u53f7\u5df2\u5b58\u5728\uff01");
        }
        CarEntity entity = (CarEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CarEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CarVO vo = (CarVO)BeanMapper.map((Object)((Object)entity), CarVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CarVO> queryDetail(Long id) {
        CarEntity entity = (CarEntity)((Object)this.service.selectById(id));
        CarVO vo = (CarVO)BeanMapper.map((Object)((Object)entity), CarVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CarVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CarVO carVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CarVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CarVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList((Iterable)list, CarVO.class));
        ExcelExport.getInstance().exportWithTrans("Car-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCarData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CarVO>> refCarData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "carName", "orgName", "carAreaName", "carProjectName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"range")) {
            param.getParams().remove("orgId");
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CarVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/carCount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> carCount() {
        return CommonResponse.success((Object)this.service.carCount());
    }

    @RequestMapping(value={"/carCountDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CarVO>> carCountDetail(@RequestParam Long carTypeId, @RequestParam(required=false) Long carAreaId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CarEntity::getCarTypeId, (Object)carTypeId);
        queryWrapper.eq(carAreaId != null, CarEntity::getCarAreaId, (Object)carAreaId);
        queryWrapper.in(CarEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CarEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryWrapper.orderByAsc(CarEntity::getCarModelId);
        List list = this.service.list((Wrapper)queryWrapper);
        return CommonResponse.success((Object)BeanMapper.mapList((Iterable)list, CarVO.class));
    }

    @RequestMapping(value={"exportCarCount"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportCarCount(HttpServletResponse response) throws IOException {
        JSONObject dataObj = this.service.carCount();
        List data = (List)dataObj.get((Object)"data");
        List head = (List)dataObj.get((Object)"head");
        if (ListUtil.isEmpty((List)data)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        }
        int lastColIndex = head.size();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, lastColIndex - 1));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("\u8f66\u8f86\u7edf\u8ba1\u8868");
        cell.setCellStyle((CellStyle)style);
        row = sheet.createRow(1);
        for (int a = 0; a < head.size(); ++a) {
            cell = row.createCell(a);
            cell.setCellValue(((JSONObject)head.get(a)).get((Object)"name").toString());
            cell.setCellStyle((CellStyle)style);
        }
        for (int i = 0; i < lastColIndex; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 10);
        }
        XSSFCellStyle dataStyle = workbook.createCellStyle();
        dataStyle.setAlignment((short)3);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject vo = (JSONObject)data.get(i);
            row = sheet.createRow(i + 2);
            for (int j = 0; j < lastColIndex; ++j) {
                String key = ((JSONObject)head.get(j)).get((Object)"key").toString();
                cell = row.createCell(j);
                String val = vo.get((Object)key) == null ? "" : vo.get((Object)key).toString();
                cell.setCellValue(val);
                if ("carType".equals(key)) continue;
                cell.setCellStyle((CellStyle)dataStyle);
            }
        }
        workbook.write((OutputStream)outputStream);
    }

    @RequestMapping(value={"/queryMaintainInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryMaintainInfo(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MaintainEntity::getCarId, (Object)id);
        wrapper.in(MaintainEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.maintainService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal maintainTaxMny = list.stream().filter(t -> t.getMaintainTaxMny() != null).map(MaintainEntity::getMaintainTaxMny).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("maintainTaxMny", (Object)maintainTaxMny);
            resObj.put("maintainCount", (Object)list.size());
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryDispatch"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDispatch(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DispatchEntity::getCarId, (Object)id);
        wrapper.in(DispatchEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.dispatchService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resObj.put("dispatchCount", (Object)list.size());
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryOilRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryOilRecord(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OilRecordEntity::getCarId, (Object)id);
        wrapper.in(OilRecordEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.oilRecordService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal totalOilConsumption = list.stream().filter(t -> t.getTotalOilConsumption() != null).map(OilRecordEntity::getTotalOilConsumption).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("totalOilConsumption", (Object)totalOilConsumption);
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/queryOilFee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryOilFee(@RequestParam Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OilFeeEntity::getCarId, (Object)id);
        wrapper.in(OilFeeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.oilFeeService.list((Wrapper)wrapper);
        JSONObject resObj = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal useAmount = list.stream().filter(t -> t.getUseAmount() != null).map(OilFeeEntity::getUseAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal totalRechargeAmount = list.stream().filter(t -> t.getTotalRechargeAmount() != null).map(OilFeeEntity::getTotalRechargeAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            resObj.put("useAmount", (Object)useAmount);
            resObj.put("totalRechargeAmount", (Object)totalRechargeAmount);
        }
        resObj.put("list", (Object)list);
        return CommonResponse.success((Object)resObj);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Car-import.xlsx", (String)"\u8f66\u8f86\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CarVO> successList = new ArrayList<CarVO>();
        ArrayList<CarVO> errorList = new ArrayList<CarVO>();
        if (result != null && result.size() > 0) {
            CommonResponse carTypeRes = this.defdocApi.getDefDocByDefCode("car-type");
            Map<String, Long> carTypeMap = ((List)carTypeRes.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            CommonResponse carAreaRes = this.defdocApi.getDefDocByDefCode("car-area");
            Map<String, Long> carAreaMap = ((List)carAreaRes.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            CommonResponse carModelRes = this.defdocApi.getDefDocByDefCode("car-model");
            Map<String, Long> carModelMap = ((List)carModelRes.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            CommonResponse carStatusRes = this.defdocApi.getDefDocByDefCode("car_car_status");
            Map<String, Long> carStatusMap = ((List)carStatusRes.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List list = this.service.list((Wrapper)queryWrapper);
            Set codeList = list.stream().map(CarEntity::getCode).collect(Collectors.toSet());
            CommonResponse orgByTenantId = this.iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1, 2, 3), null);
            Map<String, Long> orgMap = ((List)orgByTenantId.getData()).stream().collect(Collectors.toMap(OrgVO::getName, BaseVO::getId, (val1, val2) -> val2));
            CommonResponse commonResponse = this.projectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
            Map<String, Long> projectMap = ((List)commonResponse.getData()).stream().collect(Collectors.toMap(ProjectRegisterVO::getName, BaseVO::getId, (k1, k2) -> k2));
            for (int i = 0; i < result.size(); ++i) {
                Date parse;
                List datas = (List)result.get(i);
                CarVO carVO = new CarVO();
                StringBuilder errMsg = new StringBuilder();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errMsg.append("`\u8f66\u8f86\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setCarTypeName(((String)datas.get(0)).trim());
                    Long carTypeId = carTypeMap.get(carVO.getCarTypeName());
                    if (carTypeId == null) {
                        errMsg.append("`\u8f66\u8f86\u7c7b\u578b\u4e0d\u5b58\u5728`");
                    }
                    carVO.setCarTypeId(carTypeId);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errMsg.append("`\u578b\u53f7\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setCarModelName(((String)datas.get(1)).trim());
                    Long carModelId = carModelMap.get(carVO.getCarModelName());
                    if (carModelId == null) {
                        errMsg.append("`\u578b\u53f7\u4e0d\u5b58\u5728`");
                    }
                    carVO.setCarModelId(carModelId);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    errMsg.append("`\u8f66\u8f86\u540d\u79f0\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setCarName(((String)datas.get(2)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    errMsg.append("`\u8f66\u724c\u53f7\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setCode(((String)datas.get(3)).trim());
                    if (codeList.contains(carVO.getCode())) {
                        errMsg.append("`\u8f66\u724c\u53f7\u5df2\u5728\u5e93\u6216\u91cd\u590d`");
                    } else {
                        codeList.add(carVO.getCode());
                    }
                }
                if (StringUtils.isBlank((CharSequence)((String)datas.get(4)).trim())) {
                    errMsg.append("`\u6240\u5c5e\u516c\u53f8\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setOrgName(((String)datas.get(4)).trim());
                    Long orgId = orgMap.get(carVO.getOrgName());
                    if (orgId == null) {
                        errMsg.append("`\u6240\u5c5e\u516c\u53f8\u4e0d\u5b58\u5728`");
                    }
                    carVO.setOrgId(orgId);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    carVO.setCarProjectName(((String)datas.get(5)).trim());
                    Long projectId = projectMap.get(carVO.getCarProjectName());
                    if (projectId == null) {
                        errMsg.append("`\u6240\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728`");
                    }
                    carVO.setCarProjectId(projectId);
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(6)).trim())) {
                    carVO.setCarStatusName(((String)datas.get(6)).trim());
                    Long carStatusId = carStatusMap.get(carVO.getCarStatusName());
                    if (carStatusId == null) {
                        errMsg.append("`\u8f66\u8f86\u72b6\u6001\u4e0d\u5b58\u5728`");
                    }
                    carVO.setCarStatusId(carStatusId);
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(7)).trim())) {
                    carVO.setBrand(((String)datas.get(7)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(8)).trim())) {
                    carVO.setVinNo(((String)datas.get(8)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(9)).trim())) {
                    carVO.setEngineNo(((String)datas.get(9)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(10)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(10)).trim());
                        carVO.setRegistDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u6ce8\u518c\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(11)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(11)).trim());
                        carVO.setCertDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u53d1\u8bc1\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(12)).trim())) {
                    try {
                        carVO.setTotalWeight(new BigDecimal(((String)datas.get(12)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u603b\u8d28\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(13)).trim())) {
                    try {
                        carVO.setAllWeight(new BigDecimal(((String)datas.get(13)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6574\u5907\u8d28\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(14)).trim())) {
                    try {
                        carVO.setCheckWeight(new BigDecimal(((String)datas.get(14)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6574\u5907\u8d28\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(15)).trim())) {
                    try {
                        carVO.setBuyPrice(new BigDecimal(((String)datas.get(15)).trim()));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6574\u5907\u8d28\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(16)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(16)).trim());
                        carVO.setScrapDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u62a5\u5e9f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(17)).trim())) {
                    carVO.setCarSize(((String)datas.get(17)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(18)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(18)).trim());
                        carVO.setYearCheckDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u5e74\u68c0\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                } else {
                    errMsg.append("`\u5e74\u68c0\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(19)).trim())) {
                    carVO.setInsureCompany(((String)datas.get(19)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(20)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(20)).trim());
                        carVO.setInsureForceDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u4fdd\u9669\u65f6\u95f4(\u5f3a\u5236\u9669)\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(21)).trim())) {
                    try {
                        parse = this.sdf.parse(((String)datas.get(21)).trim());
                        carVO.setInsureBusinessDate(parse);
                    }
                    catch (ParseException e) {
                        errMsg.append("`\u4fdd\u9669\u65f6\u95f4(\u5546\u4e1a\u9669)\u683c\u5f0f\u4e0d\u6b63\u786e`");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(22)).trim())) {
                    carVO.setOilCard(((String)datas.get(22)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(23)))) {
                    errMsg.append("`\u8f66\u8f86\u6240\u5728\u533a\u57df\u4e3a\u5fc5\u586b\u9879`");
                } else {
                    carVO.setCarAreaName(((String)datas.get(23)).trim());
                    Long carAreaId = carAreaMap.get(carVO.getCarAreaName());
                    if (carAreaId == null) {
                        errMsg.append("`\u8f66\u8f86\u6240\u5728\u533a\u57df\u4e0d\u5b58\u5728`");
                    }
                    carVO.setCarAreaId(carAreaId);
                }
                if (StringUtils.isNotBlank((CharSequence)((String)datas.get(24)).trim())) {
                    carVO.setMemo(((String)datas.get(24)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                    carVO.setId(Long.valueOf(i));
                    carVO.setErrorMessage(errMsg.toString());
                    errorList.add(carVO);
                    continue;
                }
                UserContext userContext = this.sessionManager.getUserContext();
                carVO.setOrgId(userContext.getOrgId());
                carVO.setOrgName(userContext.getOrgName());
                carVO.setEmployeeId(userContext.getEmployeeId());
                carVO.setEmployeeName(userContext.getEmployeeName());
                carVO.setDepartmentName(userContext.getDeptName());
                successList.add(carVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<CarVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            this.service.saveBatch(BeanMapper.mapList(vos, CarEntity.class));
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

