package com.ejianc.cefoc.api;

import com.ejianc.cefoc.hystrix.CefocHystrix;
import com.ejianc.cefoc.vo.FeeCostVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
/**
 * 示例api
 * */
@FeignClient(name= "ejc-cefoctest-web", url="${common.env.feign-client-url}", path="ejc-cefoctest-web", fallback = CefocHystrix.class)
public interface ICefocApi {

    /**
     * @Description queryFeeCostVO 查询费用报销列表示例api
     * @param
     */
    @RequestMapping(value = "/api/feeCost/queryFeeCostVO", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<FeeCostVO>> queryFeeCostVO();
}
