package com.ejianc.cefoc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 用印申请表
 * 
 * @author generator
 * 
 */
public class SealApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编号
    private Integer billState; // 单据状态：0 自由态，1 已提交， 2/6审批中，3 审批通过，4 驳回，5 提交后有人审批中
    private Long deptSid; // 部门sid
    private String deptName; // 部门名称
    private String managerName; // 部门经理
    private long managerSid; // 部门经理主键
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sealdate; // 使用日期
    private String sealreason; // 用印事由
    private String title; // 审批主题
    private Long orgId; // 审批主题
    public long getOrgId() {
        return orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptSid() {
        return deptSid;
    }
    @ReferDeserialTransfer
    public void setDeptSid(Long deptSid) {
        this.deptSid = deptSid;
    }

    public String getDeptName() {
        return deptName;
    }
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getManagerName() {
        return managerName;
    }
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getManagerSid() {
        return managerSid;
    }
    @ReferDeserialTransfer
    public void setManagerSid(Long managerSid) {
        this.managerSid = managerSid;
    }
    public Date getSealdate() {
        return sealdate;
    }

    public void setSealdate(Date sealdate) {
        this.sealdate = sealdate;
    }
    public String getSealreason() {
        return sealreason;
    }

    public void setSealreason(String sealreason) {
        this.sealreason = sealreason;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    
}
