package com.ejianc.cefoc.controller.api;

import com.ejianc.cefoc.bean.FeeCostEntity;
import com.ejianc.cefoc.service.IFeeCostService;
import com.ejianc.cefoc.vo.FeeCostVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 通用费用报销单，示例api实现
 */
@Controller
@RequestMapping("api/feeCost")
public class CefocApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFeeCostService service;

    /**
     * @Description queryFeeCostVO 查询费用报销列表示例api实现
     * @param
     */
    @RequestMapping(value = "queryFeeCostVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<FeeCostVO>> queryFeeCostVO(){
        QueryParam param = new QueryParam();
        List<FeeCostEntity> costEntities = service.queryList(param,false);
        return CommonResponse.success(BeanMapper.mapList(costEntities,FeeCostVO.class));
    }
}
