package com.ejianc.business.chargingstationmanagement.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 充电站管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_chargingmanagement_chargingstation")
public class ChargingstationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="station_name")
    private String stationName; // 充电站名称
    @TableField(value="station_no")
    private String stationNo; // 充电站编号
    @TableField(value="station_long")
    private BigDecimal stationLong; // 充电站坐标位置经度（GCJ-02 坐标系）
    @TableField(value="station_lat")
    private BigDecimal stationLat; // 充电站坐标位置纬度（GCJ-02 坐标系）
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="busi_state")
    private Integer busiState; // 运营状态（1：初始；2：待运营；3：运营中；4：暂停营业；5：关闭；6：未运营）
    @TableField(value="fast_chargeCount")
    private Integer fastChargecount; // 快充桩数量
    @TableField(value="slow_chargeCount")
    private Integer slowChargecount; // 慢充桩数量
    @TableField(value="rated_power")
    private BigDecimal ratedPower;

    public BigDecimal getRatedPower() {
        return ratedPower;
    }

    public void setRatedPower(BigDecimal ratedPower) {
        this.ratedPower = ratedPower;
    }

    @TableField(value="server_tel")
    private String serverTel; // 服务电话
    @TableField(value = "station_type")
    private Integer stationType;

    public Integer getStationType() {
        return stationType;
    }

    public void setStationType(Integer stationType) {
        this.stationType = stationType;
    }

    @TableField(value = "industry")
    private String industry;

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="chargingdetailsService" ,pidName = "mid")
    private List<ChargingdetailsEntity> chargingdetailsEntities = new ArrayList<>(); // 充电站明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getStationNo() {
        return stationNo;
    }

    public void setStationNo(String stationNo) {
        this.stationNo = stationNo;
    }
    public BigDecimal getStationLong() {
        return stationLong;
    }

    public void setStationLong(BigDecimal stationLong) {
        this.stationLong = stationLong;
    }
    public BigDecimal getStationLat() {
        return stationLat;
    }

    public void setStationLat(BigDecimal stationLat) {
        this.stationLat = stationLat;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Integer getBusiState() {
        return busiState;
    }

    public void setBusiState(Integer busiState) {
        this.busiState = busiState;
    }
    public Integer getFastChargecount() {
        return fastChargecount;
    }

    public void setFastChargecount(Integer fastChargecount) {
        this.fastChargecount = fastChargecount;
    }
    public Integer getSlowChargecount() {
        return slowChargecount;
    }

    public void setSlowChargecount(Integer slowChargecount) {
        this.slowChargecount = slowChargecount;
    }
    public String getServerTel() {
        return serverTel;
    }

    public void setServerTel(String serverTel) {
        this.serverTel = serverTel;
    }


    public List<ChargingdetailsEntity> getChargingdetailsEntities() {
        return chargingdetailsEntities;
    }

    public void setChargingdetailsEntities(List<ChargingdetailsEntity> chargingdetailsEntities) {
        this.chargingdetailsEntities = chargingdetailsEntities;
    }
}
