package com.ejianc.business.chargingstationmanagement.controller.api;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.charging.vo.ChargingdetailVO;
import com.ejianc.business.charging.vo.ChargingstationVO;
import com.ejianc.business.chargingstationmanagement.bean.ChargingdetailsEntity;
import com.ejianc.business.chargingstationmanagement.bean.CharginginfoEntity;
import com.ejianc.business.chargingstationmanagement.bean.ChargingstationEntity;
import com.ejianc.business.chargingstationmanagement.service.IChargingdetailsService;
import com.ejianc.business.chargingstationmanagement.service.ICharginginfoService;
import com.ejianc.business.chargingstationmanagement.service.IChargingstationService;
import com.ejianc.business.chargingstationmanagement.utils.*;
import com.ejianc.business.chargingstationmanagement.vo.ChargingdetailsVO;
import com.ejianc.business.chargingstationmanagement.vo.CharginginfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

//import com.alibaba.fastjson.JSONObject;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/5
 * @description:充电桩管理相关查询接口
 */
@Controller
@RequestMapping("/no_auth/api/base/chargingstationApi")
public class ChargingstationApi {

    @Autowired
    private IChargingstationService service;
    @Autowired
    private ICharginginfoService inservice;
    @Autowired
    private IChargingdetailsService chargingdetailsService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 查询所有充电桩信息
     *
     * @return
     */
    @GetMapping(value = "/querychargingstation")
    @ResponseBody
    public CommonResponse<List<ChargingstationVO>> queryList() {
        List<ChargingstationEntity> list = service.list();
        List<ChargingstationVO> chargingstationVOS = BeanMapper.mapList(list, ChargingstationVO.class);
        return CommonResponse.success("查询充电成功", chargingstationVOS);
    }

    /**
     * 查询主表id下的所有充电桩信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/querychargingdetail")
    @ResponseBody
    public CommonResponse<List<ChargingdetailVO>> queryListDetail(Long id) {
        QueryWrapper<ChargingdetailsEntity> query = new QueryWrapper<>();
        query.eq("mid", id);
        List<ChargingdetailsEntity> list = chargingdetailsService.list(query);
        List<ChargingdetailVO> chargingdetailsVOS = BeanMapper.mapList(list, ChargingdetailVO.class);
        return CommonResponse.success("查询充电桩信息成功", chargingdetailsVOS);
    }

    /**
     * 查询所有订单信息推送
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/notifyChargeOrder", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject notifyChargeOrder(HttpServletRequest request) throws Exception {
        //request调用解析
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(MyUtils.getRequestPostStr(request));
        logger.info("------>" + jsonObject);
        JSON json1 = JSONUtil.parse(jsonObject);
        String data = json1.getByPath("data").toString();
        String responseData = AESUtils.Decrypt(data);
        if (!responseData.equals("null")) {
            JSONObject jsonObject1 = new JSONObject(responseData);

            Map<String, Object> map1 = (Map<String, Object>) jsonObject1;
            System.out.println("map1 = " + map1);
            CharginginfoVO charginginfoVO = new CharginginfoVO();
            charginginfoVO.setPileNo(map1.get("pileNo").toString());
            if (!map1.get("pileName").toString().equals("null")) {
                charginginfoVO.setPileName(map1.get("pileName").toString());
            }
            if (!map1.get("stationNo").toString().equals("null")) {
                charginginfoVO.setStationNo(map1.get("stationNo").toString());
            }
            if (!map1.get("stationName").toString().equals("null")) {
                charginginfoVO.setStationName(map1.get("stationName").toString());
            }
            if (!map1.get("orderNo").toString().equals("null")) {
                charginginfoVO.setStationName(map1.get("stationName").toString());
            }

            charginginfoVO.setChargeCardNo(map1.get("chargeCardNo").toString());

            if (!map1.get("chargeUserName").toString().equals("null")) {
                charginginfoVO.setChargeUserName(map1.get("chargeUserName").toString());
            }

            if (!Integer.valueOf(map1.get("pileState").toString()).equals("null")) {
                charginginfoVO.setPileState(Integer.valueOf(map1.get("pileState").toString()));
            }
            if (!Integer.valueOf(map1.get("payStatus").toString()).equals("null")) {
                charginginfoVO.setPayStatus(Integer.valueOf(map1.get("payStatus").toString()));
            }

            charginginfoVO.setPlateNo(map1.get("plateNo").toString());

            if (!new BigDecimal(map1.get("elecMeterBegin").toString()).equals("null")) {
                charginginfoVO.setElecMeterBegin(new BigDecimal(map1.get("elecMeterBegin").toString()));
            }
            if (!new BigDecimal(map1.get("elecMeterEnd").toString()).equals("null")) {
                charginginfoVO.setElecMeterBegin(new BigDecimal(map1.get("elecMeterEnd").toString()));
            }


            charginginfoVO.setChargeStartTime(map1.get("chargeStartTime").toString());
            charginginfoVO.setChargeEndTime(map1.get("chargeEndTime").toString());
            if (!new BigDecimal(map1.get("sharpChargeStandard").toString()).equals("null")) {
                charginginfoVO.setSharpChargeStandard(new BigDecimal(map1.get("sharpChargeStandard").toString()));
            }
            if (!new BigDecimal(map1.get("peakChargeStandard").toString()).equals("null")) {
                charginginfoVO.setPeakChargeStandard(new BigDecimal(map1.get("peakChargeStandard").toString()));
            }
            if (!new BigDecimal(map1.get("flatChargeStandard").toString()).equals("null")) {
                charginginfoVO.setFlatChargeStandard(new BigDecimal(map1.get("flatChargeStandard").toString()));
            }
            if (!new BigDecimal(map1.get("valleyChargeStandard").toString()).equals("null")) {
                charginginfoVO.setValleyChargeStandard(new BigDecimal(map1.get("valleyChargeStandard").toString()));
            }


            if (!new BigDecimal(map1.get("sharpServiceStandard").toString()).equals("null")) {
                charginginfoVO.setSharpServiceStandard(new BigDecimal(map1.get("sharpServiceStandard").toString()));
            }
            if (!new BigDecimal(map1.get("peakServiceStandard").toString()).equals("null")) {
                charginginfoVO.setPeakServiceStandard(new BigDecimal(map1.get("peakServiceStandard").toString()));
            }
            if (!new BigDecimal(map1.get("flatServiceStandard").toString()).equals("null")) {
                charginginfoVO.setFlatServiceStandard(new BigDecimal(map1.get("flatServiceStandard").toString()));
            }
            if (!new BigDecimal(map1.get("valleyServiceStandard").toString()).equals("null")) {
                charginginfoVO.setValleyServiceStandard(new BigDecimal(map1.get("valleyServiceStandard").toString()));
            }
            if (!new BigDecimal(map1.get("chargePower").toString()).equals("null")) {
                charginginfoVO.setChargePower(new BigDecimal(map1.get("chargePower").toString()));
            }
            if (!new BigDecimal(map1.get("sharpChargePower").toString()).equals("null")) {
                charginginfoVO.setSharpChargePower(new BigDecimal(map1.get("sharpChargePower").toString()));
            }
            if (!new BigDecimal(map1.get("peakChargePower").toString()).equals("null")) {
                charginginfoVO.setPeakChargePower(new BigDecimal(map1.get("peakChargePower").toString()));
            }

            if (!new BigDecimal(map1.get("flatChargePower").toString()).equals("null")) {
                charginginfoVO.setFlatChargePower(new BigDecimal(map1.get("flatChargePower").toString()));
            }
            if (!new BigDecimal(map1.get("valleyPower").toString()).equals("null")) {
                charginginfoVO.setValleyPower(new BigDecimal(map1.get("valleyPower").toString()));
            }
            if (!new BigDecimal(map1.get("chargeFee").toString()).equals("null")) {
                charginginfoVO.setChargeFee(new BigDecimal(map1.get("chargeFee").toString()));
            }
            if (!new BigDecimal(map1.get("serviceFee").toString()).equals("null")) {
                charginginfoVO.setServiceFee(new BigDecimal(map1.get("serviceFee").toString()));
            }
            if (!new BigDecimal(map1.get("totalFee").toString()).equals("null")) {
                charginginfoVO.setTotalFee(new BigDecimal(map1.get("totalFee").toString()));
            }
            if (!Integer.valueOf(map1.get("chargeDuration").toString()).equals("null")) {
                charginginfoVO.setChargeDuration(Integer.valueOf(map1.get("chargeDuration").toString()));
            }
            if (!map1.get("paymentTime").toString().equals("null")) {
                charginginfoVO.setPaymentTime(map1.get("paymentTime").toString());
            }

            charginginfoVO.setChargeStopReason(map1.get("chargeStopReason").toString());
            charginginfoVO.setCreateUserCode("adminjcjt");
            charginginfoVO.setCreateTime(new Date());
            charginginfoVO.setDr(0);
            charginginfoVO.setTenantId((long) 9999);
            charginginfoVO.setSyncEsFlag("0");
            charginginfoVO.setBillState(0);
            CharginginfoEntity entity = BeanMapper.map(charginginfoVO, CharginginfoEntity.class);
            if (entity.getId() == null || entity.getId() == 0) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), charginginfoVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);

                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    JSONObject a1 = new JSONObject();
                    a1.put("resultCode", "1");
                    a1.put("message", "推送失败");
                    a1.put("data", "{}");
                    return a1;
                }
            }
            boolean  bj = inservice.save(entity);
            if(bj!=true){
                JSONObject a1 = new JSONObject();
                a1.put("resultCode", "1");
                a1.put("message", "推送失败");
                a1.put("data", "{}");
                return a1;
            }
        }
        logger.info("充电桩订单信息推送拦截器-> " + responseData);
        JSONObject a1 = new JSONObject();
        a1.put("resultCode", "0");
        a1.put("message", "推送成功");
        a1.put("data", "{}");
//        logger.info("推送日志->"+a1);
//        Object toJSON = com.alibaba.fastjson.JSON.toJSON(a1);
//        logger.info("推送日志->"+toJSON.toString());

        logger.info("推送日志->" + a1);

        return a1;
    }
    /**
     * 查询充电桩状态信息
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/notifyPileStatus", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject notifyPileStatus(HttpServletRequest request) throws Exception {
        //request调用解析
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(MyUtils.getRequestPostStr(request));
        logger.info("------>" + jsonObject);
        JSON json1 = JSONUtil.parse(jsonObject);
        String data = json1.getByPath("data").toString();
        String responseData = AESUtils.Decrypt(data);
        if (!responseData.equals("null")) {
            JSONObject jsonObject1 = new JSONObject(responseData);
            Map<String, Object> map1 = (Map<String, Object>) jsonObject1;
            System.out.println("map1 = " + map1);
            QueryWrapper<ChargingdetailsEntity>queryWrapper = new QueryWrapper<ChargingdetailsEntity>();
            queryWrapper.eq("pile_no",map1.get("pileNo"));
            ChargingdetailsEntity entity1 = chargingdetailsService.getOne(queryWrapper);
            entity1.setPileStatus(Integer.valueOf(map1.get("pileStatus").toString()));
            entity1.setSamplingTime(map1.get("samplingTime").toString());
            chargingdetailsService.updateById(entity1);
        }
        logger.info("充电桩状态拦截器-> " + responseData);
        JSONObject a1 = new JSONObject();
        a1.put("resultCode", "0");
        a1.put("message", "推送成功");
        a1.put("data", "{}");
        System.out.println("a1 = " + a1);
        String aa = String.valueOf(a1);
        System.out.println("aa = " + aa);


//        return Response.rspMsg("0","推送成功");
        return a1;
//        return Response.success();
    }


    /**
     * 查询所有充电站信息
     * 同步数据
     */
    @GetMapping(value = "/queryStationInfo")
//    @ResponseBody
    public CommonResponse<String> queryStationInfo() {
        List<ChargingstationVO> chargingstationVOS = new ArrayList<>();
        String url = "https://jqcs.pjnes.com/cloud/datashare/api/queryStationInfo";
        //String url="https://jqcs.pjnes.com/cloud/datashare/api/queryPileInfo";
        JSON json2 = new JSONObject();
        json2.putByPath("pageNo", "1");
        json2.putByPath("pageSize", "10");
        String responseData = HttpRequestUtils.postRequest(url, json2);
        if (!responseData.equals("null")) {
            JSONObject jsonObject = new JSONObject(responseData);
            JSONArray jsonArray = new JSONArray(jsonObject.get("stationInfoArray"));
            for (Object object : jsonArray) {
                Map<String, Object> map1 = (Map<String, Object>) object;
                System.out.println("map1 = " + map1);
                QueryWrapper<ChargingstationEntity> queryWrapper = new QueryWrapper<ChargingstationEntity>();
                queryWrapper.eq("station_no", map1.get("stationNo").toString());
                ChargingstationEntity stationNot = service.getOne(queryWrapper);
                if (stationNot == null) {
                    ChargingstationVO chargingstationVO = new ChargingstationVO();
                    chargingstationVO.setStationNo(map1.get("stationNo").toString());
                    chargingstationVO.setStationName(map1.get("stationName").toString());
                    chargingstationVO.setStationType(Integer.valueOf(map1.get("stationType").toString()));
                    chargingstationVO.setStationLong(new BigDecimal(map1.get("stationLong").toString()));
                    chargingstationVO.setStationLat(new BigDecimal(map1.get("stationLat").toString()));
                    chargingstationVO.setAddress(map1.get("address").toString());
                    chargingstationVO.setIndustry(map1.get("industry").toString());
                    chargingstationVO.setBusiState(Integer.valueOf(map1.get("busiState").toString()));
                    if (!map1.get("ratedPower").toString().equals("null")) {
                        chargingstationVO.setRatedPower(new BigDecimal(map1.get("ratedPower").toString()));
                    }
                    chargingstationVO.setFastChargecount(Integer.valueOf(map1.get("fastChargeCount").toString()));
                    chargingstationVO.setSlowChargecount(Integer.valueOf(map1.get("slowChargeCount").toString()));
                    chargingstationVO.setServerTel(map1.get("serverTel").toString());
                    ChargingstationEntity entity = BeanMapper.map(chargingstationVO, ChargingstationEntity.class);
                    if (entity.getId() == null || entity.getId() == 0) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), chargingstationVO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        } else {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                    service.save(entity);
                } else {
                    ChargingstationVO chargingstationVO = new ChargingstationVO();

                    chargingstationVO.setStationNo(map1.get("stationNo").toString());
                    chargingstationVO.setStationName(map1.get("stationName").toString());
                    chargingstationVO.setStationType(Integer.valueOf(map1.get("stationType").toString()));

                    chargingstationVO.setStationLong(new BigDecimal(map1.get("stationLong").toString()));
//                    BigDecimal bigDecimal = new BigDecimal("0.00");
//                    Double result = bigDecimal.doubleValue();
                    chargingstationVO.setStationLat(new BigDecimal(map1.get("stationLat").toString()));
                    chargingstationVO.setAddress(map1.get("address").toString());
                    chargingstationVO.setIndustry(map1.get("industry").toString());
                    chargingstationVO.setBusiState(Integer.valueOf(map1.get("busiState").toString()));
                    if (!map1.get("ratedPower").toString().equals("null")) {
                        chargingstationVO.setRatedPower(new BigDecimal(map1.get("ratedPower").toString()));
                    }
                    chargingstationVO.setFastChargecount(Integer.valueOf(map1.get("fastChargeCount").toString()));
                    chargingstationVO.setSlowChargecount(Integer.valueOf(map1.get("slowChargeCount").toString()));
                    chargingstationVO.setServerTel(map1.get("serverTel").toString());
                    ChargingstationEntity entity = BeanMapper.map(chargingstationVO, ChargingstationEntity.class);
                    service.updateById(entity);
                }
            }
        }
        return CommonResponse.success("同步成功");
    }

    /**
     * 查询充电桩信息
     *
     * @return
     * @throws Exception
     */
    @GetMapping(value = "/queryPileInfo")
    public CommonResponse<String> queryPileInfo() {
//        List<ChargingdetailsVO> chargingdetailsVOS = new ArrayList<>();
        String url = "https://jqcs.pjnes.com/cloud/datashare/api/queryPileInfo";
        JSON json2 = new JSONObject();
        json2.putByPath("pageNo", "1");
        json2.putByPath("pageSize", "10");
        String responseData = HttpRequestUtils.postRequest(url, json2);
        if (!responseData.equals("null")) {
            JSONObject jsonObject = new JSONObject(responseData);
            JSONArray jsonArray = new JSONArray(jsonObject.get("pileInfoArray"));
            for (Object object : jsonArray) {
                Map<String, Object> map1 = (Map<String, Object>) object;
                System.out.println("map1 = " + map1);
                QueryWrapper<ChargingdetailsEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("pile_no", map1.get("pileNo").toString());
                ChargingdetailsEntity pileNolist = chargingdetailsService.getOne(queryWrapper1);
                if (pileNolist == null) {
                    ChargingdetailsVO chargingdetailsVO = new ChargingdetailsVO();
                    chargingdetailsVO.setPileNo(map1.get("pileNo").toString());
                    chargingdetailsVO.setPileName(map1.get("pileName").toString());
                    chargingdetailsVO.setStationNo(map1.get("stationNo").toString());
                    chargingdetailsVO.setStationName(map1.get("stationName").toString());
                    chargingdetailsVO.setPileModel(map1.get("pileModel").toString());
                    chargingdetailsVO.setPilePower(map1.get("pilePower").toString());
                    chargingdetailsVO.setChargeMode(Integer.valueOf(map1.get("chargeMode").toString()));
                    chargingdetailsVO.setChargeType(Integer.valueOf(map1.get("chargeType").toString()));
                    ChargingdetailsEntity entity = BeanMapper.map(chargingdetailsVO, ChargingdetailsEntity.class);
                    if (entity.getId() == null || entity.getId() == 0) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), chargingdetailsVO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                        } else {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                    }
                    chargingdetailsService.save(entity);
                } else {
                    ChargingdetailsVO chargingdetailsVO = new ChargingdetailsVO();
                    chargingdetailsVO.setPileNo(map1.get("pileNo").toString());
                    chargingdetailsVO.setPileName(map1.get("pileName").toString());
                    chargingdetailsVO.setStationNo(map1.get("stationNo").toString());
                    chargingdetailsVO.setStationName(map1.get("stationName").toString());
                    chargingdetailsVO.setPileModel(map1.get("pileModel").toString());
                    chargingdetailsVO.setPilePower(map1.get("pilePower").toString());
                    chargingdetailsVO.setChargeMode(Integer.valueOf(map1.get("chargeMode").toString()));
                    chargingdetailsVO.setChargeType(Integer.valueOf(map1.get("chargeType").toString()));
                    ChargingdetailsEntity entity = BeanMapper.map(chargingdetailsVO, ChargingdetailsEntity.class);
                    chargingdetailsService.updateById(entity);
                }
            }
        }
        return CommonResponse.success("同步成功");
    }
}