package com.ejianc.business.contractbase.cooperative.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 协同率调整设置
 * 
 * @author generator
 * 
 */
public class CooperativeAdjustVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String createUserName; // 创建人名称
    private String updateUserName; // 修改人名称
    private Integer cooperativeAdjustType; // 0-项目协同率调整设置 1-供应商协同率调整设置
    private BigDecimal projectCooperativeBillRatio; // 项目协同率调整（按单据）
    private BigDecimal projectCooperativeSupplierRatio; // 项目协同率调整（按供应商）
    private BigDecimal supplierCooperativeBillRatio; // 供应商协同率调整（按单据）
    private BigDecimal supplierCooperativeProjectRatio; // 供应商协同率调整（按供应商）
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String memo; // 备注 非必填，0-500字
    

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Integer getCooperativeAdjustType() {
        return cooperativeAdjustType;
    }

    public void setCooperativeAdjustType(Integer cooperativeAdjustType) {
        this.cooperativeAdjustType = cooperativeAdjustType;
    }
    public BigDecimal getProjectCooperativeBillRatio() {
        return projectCooperativeBillRatio;
    }

    public void setProjectCooperativeBillRatio(BigDecimal projectCooperativeBillRatio) {
        this.projectCooperativeBillRatio = projectCooperativeBillRatio;
    }
    public BigDecimal getProjectCooperativeSupplierRatio() {
        return projectCooperativeSupplierRatio;
    }

    public void setProjectCooperativeSupplierRatio(BigDecimal projectCooperativeSupplierRatio) {
        this.projectCooperativeSupplierRatio = projectCooperativeSupplierRatio;
    }
    public BigDecimal getSupplierCooperativeBillRatio() {
        return supplierCooperativeBillRatio;
    }

    public void setSupplierCooperativeBillRatio(BigDecimal supplierCooperativeBillRatio) {
        this.supplierCooperativeBillRatio = supplierCooperativeBillRatio;
    }
    public BigDecimal getSupplierCooperativeProjectRatio() {
        return supplierCooperativeProjectRatio;
    }

    public void setSupplierCooperativeProjectRatio(BigDecimal supplierCooperativeProjectRatio) {
        this.supplierCooperativeProjectRatio = supplierCooperativeProjectRatio;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
