package com.ejianc.business.contractbase.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description 供货内容自定义档案
 */
public enum MaterialContentEnum {

	材料招标立项("tenderStuff", "BT211110000000002", "pro-supply-material-supply-content", "pro-supply-revolving-materials-supply-content"),
	分包招标立项("tenderSub", "BT220111000000006", "pro-supply-labor-supply-content", "pro-supply-major-supply-content"),
	设备采购招标立项("tenderEquipment", "BT220121000000001", "pro-supply-equipment-supply-content", ""),
	设备租赁招标立项("tenderRent", "BT220125000000008", "pro-supply-equipment-supply-content", ""),
	周转材租赁招标立项("tenderRmat", "BT220210000000008", "pro-supply-revolving-materials-supply-content", ""),
	其他招标立项("tenderOther", "BT220210000000015", "pro-supply-other-goods-content", "pro-supply-consult-supply-content");

	private final String categoryProperty;
	private final String billTypeCode;
	private final String defdoc1;//自定义档案供货内容编码
	private final String defdoc2;//自定义档案供货内容编码

	MaterialContentEnum(String categoryProperty, String billTypeCode, String defdoc1, String defdoc2) {
		this.categoryProperty = categoryProperty;
		this.billTypeCode = billTypeCode;
		this.defdoc1 = defdoc1;
		this.defdoc2 = defdoc2;
	}

	private static Map<String, MaterialContentEnum> enumMap = new HashMap<>();

	public String getCategoryProperty() {
		return categoryProperty;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public String getDefdoc1() {
		return defdoc1;
	}

	public String getDefdoc2() {
		return defdoc2;
	}

	static {
		enumMap = EnumSet.allOf(MaterialContentEnum.class).stream().collect(Collectors.toMap(MaterialContentEnum::getCategoryProperty, Function.identity(), (k1, k2) -> k2));
	}

	public static MaterialContentEnum getByCategoryProperty(String categoryProperty) {
		return enumMap.get(categoryProperty);
	}


}
