package com.ejianc.business.contractbase.hystrix;

import com.ejianc.business.contractbase.api.IClauseSettingApi;
import com.ejianc.business.contractbase.api.ITemplateApi;
import com.ejianc.business.contractbase.vo.ClauseSettingVO;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 模板服务降级处理
 *
 * @author CJ
 * @Description: 模板服务降级处理
 * @date 2021/11/10 17:52
 */
@Component
public class ClauseSettingHystrix implements IClauseSettingApi {

    @Override
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryId(Long categoryId) {
        return CommonResponse.error("网络问题，查询失败！");
    }

    @Override
    public CommonResponse<List<ClauseSettingVO>> getListByCategoryProperty(String categoryProperty) {
        return CommonResponse.error("网络问题，查询失败！");
    }
}
