package com.ejianc.business.contractbase.pool.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 *
 * 合同属性枚举
 *
 * @author CJ
 * @Description:
 * @date 2022/3/28 14:44
 */
public enum ContractPropertyEnum {
    /**
     * 合同属性：收入合同
     */
    收入合同(1, "收入合同"),

    /**
     * 合同属性：支出合同
     */
    支出合同(0, "支出合同");

    ContractPropertyEnum(Integer propertyCode, String propertyName) {
        this.propertyCode = propertyCode;
        this.propertyName = propertyName;
    }

    private Integer propertyCode;
    private String propertyName;
    private static Map<String, ContractTypeEnum> enumMap = new HashMap<>();

    public Integer getPropertyCode() {
        return propertyCode;
    }

    public void setPropertyCode(Integer propertyCode) {
        this.propertyCode = propertyCode;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    static {
        enumMap = EnumSet.allOf(ContractTypeEnum.class).stream().collect(Collectors.toMap(ContractTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractTypeEnum getByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
