package com.ejianc.business.contractbase.vo.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 合同结算报表
 *
 * @author CJ
 * @Description:
 * @date 2023/4/11 15:21
 */
public class ContractSettleReportVO implements Serializable {

    private static final long serialVersionUID = 4494901704251472708L;

    private Long contractId; //合同Id
    private String contractCode; //合同编码
    private String contractName; //合同名称
    private String contractType; //合同大类别
    private String contractTypeName; //合同所属大分类名称
    private Long contractCategoryId; //合同分类id
    private String contractCategoryName; //合同分类名称
    private Integer contractProperty; //合同属性：1-收入，0支出
    private BigDecimal contractTaxMny; // 合同总金额（含税）
    private BigDecimal contractMny; // 合同总金额（不含税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal contractTaxMnyInW; //合同金额 一万元为单位
    private Long supplierId;//供应商id
    private String supplierName; //供应商名称
    private String contractPckUrl; //合同PC详情地址

    private BigDecimal curSettleTaxMny; //本期结算金额
    private BigDecimal curSettleMny; //本期结算金额（无税）
    private BigDecimal curSettleTax; //本期结算税额
    private Date curSettleDate; //本期最新结算日期

    private BigDecimal totalSettleTaxMnyThisYear; //本年度累计结算金额含税
    private BigDecimal totalSettleMnyThisYear; //本年度累计结算金额无税
    private BigDecimal totalSettleTaxThisYear; //本年度累计结算税额

    private BigDecimal totalStartSettleTaxMny; //开工累计结算金额
    private BigDecimal totalStartSettleMny; //开工累计结算金额（无税）
    private BigDecimal totalStartSettleTax; //开工累计结算税额

    private BigDecimal totalSettleTaxMnyLastYear; //上一年累计结算金额
    private BigDecimal totalSettleMnyLastYear; //上一年累计结算金额（无税）
    private BigDecimal totalSettleTaxLastYear; //上一年累计结算税额

    private BigDecimal curPaidMny; //本期付款金额
    private BigDecimal totalStartPaidMny ;//开工累计付款金额
    private BigDecimal totalPaidMnyLastYear; //上一年度付款总金额

    private BigDecimal payScale; //合同付款比例  开工累计付款金额/合同金额*100%
    private BigDecimal overPaidMny; //合同欠付金额  合同金额-开工累计付款金额
    private BigDecimal settleOverPaidMnyLastYear; //上年结算累计欠付款：取期间结束年，该合同的查询年份的上一年结算金额-付款金额

    private String contractIds; //合同Id列表
    private String settleIds; //结算单Id列表
    private String payRegisterIds; //付款登记单Id列表

    private String curSettleDateStr;

    private Long incomeContractId; //施工合同Id
    private String incomeContractName; //施工合同名称
    private BigDecimal incomeContractTaxMny; //施工合同金额
    private BigDecimal incomeContractMny; //施工合同金额（无税）
    private BigDecimal incomeContractTax; //施工合同税额
    private String incomeContractPcUrl; //施工合同PC详情地址
    private String contractFeeTypeName; //合同费用名称
    private BigDecimal incomeContractTaxMnyInW; //施工合同金额 一万元为单位

    private BigDecimal curConTypeRatioInIncomeCon; //下游合同金额占主合同比例（%） 合同金额/施工合同金额*100%

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getContractIds() {
        return contractIds;
    }

    public void setContractIds(String contractIds) {
        this.contractIds = contractIds;
    }

    public BigDecimal getContractTaxMnyInW() {
        return contractTaxMnyInW;
    }

    public void setContractTaxMnyInW(BigDecimal contractTaxMnyInW) {
        this.contractTaxMnyInW = contractTaxMnyInW;
    }

    public Long getIncomeContractId() {
        return incomeContractId;
    }

    public void setIncomeContractId(Long incomeContractId) {
        this.incomeContractId = incomeContractId;
    }

    public String getIncomeContractName() {
        return incomeContractName;
    }

    public void setIncomeContractName(String incomeContractName) {
        this.incomeContractName = incomeContractName;
    }

    public BigDecimal getIncomeContractTaxMny() {
        return incomeContractTaxMny;
    }

    public void setIncomeContractTaxMny(BigDecimal incomeContractTaxMny) {
        this.incomeContractTaxMny = incomeContractTaxMny;
    }

    public BigDecimal getIncomeContractMny() {
        return incomeContractMny;
    }

    public void setIncomeContractMny(BigDecimal incomeContractMny) {
        this.incomeContractMny = incomeContractMny;
    }

    public BigDecimal getIncomeContractTax() {
        return incomeContractTax;
    }

    public void setIncomeContractTax(BigDecimal incomeContractTax) {
        this.incomeContractTax = incomeContractTax;
    }

    public String getIncomeContractPcUrl() {
        return incomeContractPcUrl;
    }

    public void setIncomeContractPcUrl(String incomeContractPcUrl) {
        this.incomeContractPcUrl = incomeContractPcUrl;
    }

    public BigDecimal getCurConTypeRatioInIncomeCon() {
        return curConTypeRatioInIncomeCon;
    }

    public void setCurConTypeRatioInIncomeCon(BigDecimal curConTypeRatioInIncomeCon) {
        this.curConTypeRatioInIncomeCon = curConTypeRatioInIncomeCon;
    }

    public String getCurSettleDateStr() {
        return curSettleDateStr;
    }

    public void setCurSettleDateStr(String curSettleDateStr) {
        this.curSettleDateStr = curSettleDateStr;
    }

    public String getSettleIds() {
        return settleIds;
    }

    public void setSettleIds(String settleIds) {
        this.settleIds = settleIds;
    }

    public String getPayRegisterIds() {
        return payRegisterIds;
    }

    public void setPayRegisterIds(String payRegisterIds) {
        this.payRegisterIds = payRegisterIds;
    }

    public String getContractPckUrl() {
        return contractPckUrl;
    }

    public void setContractPckUrl(String contractPckUrl) {
        this.contractPckUrl = contractPckUrl;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Integer getContractProperty() {
        return contractProperty;
    }

    public void setContractProperty(Integer contractProperty) {
        this.contractProperty = contractProperty;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getCurSettleTaxMny() {
        return curSettleTaxMny;
    }

    public void setCurSettleTaxMny(BigDecimal curSettleTaxMny) {
        this.curSettleTaxMny = curSettleTaxMny;
    }

    public BigDecimal getCurSettleMny() {
        return curSettleMny;
    }

    public void setCurSettleMny(BigDecimal curSettleMny) {
        this.curSettleMny = curSettleMny;
    }

    public BigDecimal getCurSettleTax() {
        return curSettleTax;
    }

    public void setCurSettleTax(BigDecimal curSettleTax) {
        this.curSettleTax = curSettleTax;
    }

    public Date getCurSettleDate() {
        return curSettleDate;
    }

    public void setCurSettleDate(Date curSettleDate) {
        this.curSettleDate = curSettleDate;
    }

    public BigDecimal getTotalSettleTaxMnyThisYear() {
        return totalSettleTaxMnyThisYear;
    }

    public void setTotalSettleTaxMnyThisYear(BigDecimal totalSettleTaxMnyThisYear) {
        this.totalSettleTaxMnyThisYear = totalSettleTaxMnyThisYear;
    }

    public BigDecimal getTotalSettleMnyThisYear() {
        return totalSettleMnyThisYear;
    }

    public void setTotalSettleMnyThisYear(BigDecimal totalSettleMnyThisYear) {
        this.totalSettleMnyThisYear = totalSettleMnyThisYear;
    }

    public BigDecimal getTotalSettleTaxThisYear() {
        return totalSettleTaxThisYear;
    }

    public void setTotalSettleTaxThisYear(BigDecimal totalSettleTaxThisYear) {
        this.totalSettleTaxThisYear = totalSettleTaxThisYear;
    }

    public BigDecimal getTotalStartSettleTaxMny() {
        return totalStartSettleTaxMny;
    }

    public void setTotalStartSettleTaxMny(BigDecimal totalStartSettleTaxMny) {
        this.totalStartSettleTaxMny = totalStartSettleTaxMny;
    }

    public BigDecimal getTotalStartSettleMny() {
        return totalStartSettleMny;
    }

    public void setTotalStartSettleMny(BigDecimal totalStartSettleMny) {
        this.totalStartSettleMny = totalStartSettleMny;
    }

    public BigDecimal getTotalStartSettleTax() {
        return totalStartSettleTax;
    }

    public void setTotalStartSettleTax(BigDecimal totalStartSettleTax) {
        this.totalStartSettleTax = totalStartSettleTax;
    }

    public BigDecimal getTotalSettleTaxMnyLastYear() {
        return totalSettleTaxMnyLastYear;
    }

    public void setTotalSettleTaxMnyLastYear(BigDecimal totalSettleTaxMnyLastYear) {
        this.totalSettleTaxMnyLastYear = totalSettleTaxMnyLastYear;
    }

    public BigDecimal getTotalSettleMnyLastYear() {
        return totalSettleMnyLastYear;
    }

    public void setTotalSettleMnyLastYear(BigDecimal totalSettleMnyLastYear) {
        this.totalSettleMnyLastYear = totalSettleMnyLastYear;
    }

    public BigDecimal getTotalSettleTaxLastYear() {
        return totalSettleTaxLastYear;
    }

    public void setTotalSettleTaxLastYear(BigDecimal totalSettleTaxLastYear) {
        this.totalSettleTaxLastYear = totalSettleTaxLastYear;
    }

    public BigDecimal getCurPaidMny() {
        return curPaidMny;
    }

    public void setCurPaidMny(BigDecimal curPaidMny) {
        this.curPaidMny = curPaidMny;
    }

    public BigDecimal getTotalStartPaidMny() {
        return totalStartPaidMny;
    }

    public void setTotalStartPaidMny(BigDecimal totalStartPaidMny) {
        this.totalStartPaidMny = totalStartPaidMny;
    }

    public BigDecimal getTotalPaidMnyLastYear() {
        return totalPaidMnyLastYear;
    }

    public void setTotalPaidMnyLastYear(BigDecimal totalPaidMnyLastYear) {
        this.totalPaidMnyLastYear = totalPaidMnyLastYear;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getOverPaidMny() {
        return overPaidMny;
    }

    public void setOverPaidMny(BigDecimal overPaidMny) {
        this.overPaidMny = overPaidMny;
    }

    public BigDecimal getSettleOverPaidMnyLastYear() {
        return settleOverPaidMnyLastYear;
    }

    public void setSettleOverPaidMnyLastYear(BigDecimal settleOverPaidMnyLastYear) {
        this.settleOverPaidMnyLastYear = settleOverPaidMnyLastYear;
    }

    public String getContractFeeTypeName() {
        return contractFeeTypeName;
    }

    public void setContractFeeTypeName(String contractFeeTypeName) {
        this.contractFeeTypeName = contractFeeTypeName;
    }

    public BigDecimal getIncomeContractTaxMnyInW() {
        return incomeContractTaxMnyInW;
    }

    public void setIncomeContractTaxMnyInW(BigDecimal incomeContractTaxMnyInW) {
        this.incomeContractTaxMnyInW = incomeContractTaxMnyInW;
    }
}
