package com.ejianc.business.contractbase.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * @author:刘家乐
 * @date:2021/11/8
 * @document:
 */
@TableName("ejc_conbase_contract_template_category")
public class TemplateCategoryEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 分类名称
     */
    @TableField("category_name")
    private String categoryName;
    /**
     *分类属性：每个大的分类下该属性保持一致', 这里选择的是顶级分类是本身id
     *子类是父id
     */
    @TableField("inner_code")
    private String innerCode;
    /**
     * 父id
     */
    @TableField("pid")
    private Long pid;

    /**
     * 启用状态：0-停用，1-启用
     */
    @TableField("enable_status")
    private Integer enableStatus;

    /**
     * 类别：0-内置项，1-新增项
     */
    @TableField("source_type")
    private Integer sourceType;
    /**
     *编码
     */
    @TableField("code")
    private String code;
    /**
     * 排序
     */
    @TableField("sequence")
    private Integer sequence;
    /**
     *分类属性：每个大的分类下该属性保持一致', 这里选择的是顶级分类是本身id
     *子类是父id
     */
    @TableField("category_property")
    private String  categoryProperty;
    /**
     *0-固定分类，1-下级分类
     */
    @TableField("is_top")
    private Integer isTop;

    /**
     * 对应单据类型
     */
    @TableField(value = "bill_type_code")
    private String billTypeCode;

    /**
     * 合同属性id
     */
    @TableField(value = "contract_property_id")
    private Long contractPropertyId;

    /**
     * 合同属性名称
     */
    @TableField(value = "contract_property_name")
    private String contractPropertyName;

    /**
     * 合同属性编码
     */
    @TableField(value = "contract_property_code")
    private String contractPropertyCode;

    /**
     * 父级分类名称
     */
    @TableField(value = "p_name")
    private String pName;

    /**
     * 所属组织Id
     */
    @TableField(value = "belong_org_id")
    private Long belongOrgId;
    /**
     * 所属组织名称
     */
    @TableField(value = "belong_org_name")
    private String belongOrgName;
    /**
     * 所属组织编码
     */
    @TableField(value = "belong_org_code")
    private String belongOrgCode;

    /**
     * 所属组织内码
     */
    @TableField(value = "belong_org_inner_code")
    private String belongOrgInnerCode;

    public String getBelongOrgInnerCode() {
        return belongOrgInnerCode;
    }

    public void setBelongOrgInnerCode(String belongOrgInnerCode) {
        this.belongOrgInnerCode = belongOrgInnerCode;
    }

    public Long getBelongOrgId() {
        return belongOrgId;
    }

    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }

    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }

    public String getBelongOrgCode() {
        return belongOrgCode;
    }

    public void setBelongOrgCode(String belongOrgCode) {
        this.belongOrgCode = belongOrgCode;
    }

    public Long getContractPropertyId() {
        return contractPropertyId;
    }

    public void setContractPropertyId(Long contractPropertyId) {
        this.contractPropertyId = contractPropertyId;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }

    public String getpName() {
        return pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getCategoryProperty() {
        return categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public Integer getIsTop() {
        return isTop;
    }

    public void setIsTop(Integer isTop) {
        this.isTop = isTop;
    }
}
