package com.ejianc.business.contractbase.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.contractbase.vo.PartyVO;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.ArrayList;
import java.util.List;

/**
 * @author:刘家乐
 */
@TableName("ejc_conbase_contract_template")
public class TemplateEntity extends BaseEntity {

	private static final long serialVersionUID = -2614244573363772246L;
	/**
	 * 类型id
	 */
	@TableField("category_id")
	private Long categoryId;
	/**
	 * 分类名称
	 */
	@TableField("category_name")
	private String categoryName;
	/**
	 * 当前最新版本id
	 */
	@TableField("cur_version_id")
	private Long curVersionId;
	/**
	 * 模板名称
	 */
	@TableField("template_name")
	private String templateName;

	/**
	 * 文件类型  w-doc,p-ppt,s-excel,f-pdf
	 */
	@TableField("file_type")
	private String fileType;

	/**
	 * 文件大小 以 B 为单位
	 */
	@TableField("file_size")
	private Integer fileSize;

	/**
	 * 排序号
	 */
	@TableField("sequence")
	private Integer sequence;

	/**
	 * 文件路径
	 */
	@TableField("file_path")
	private String filePath;

	/**
	 * 预览地址
	 */
	@TableField("online_path")
	private String onlinePath;

	@TableField("file_id")
	private Long fileId;
	/**
	 * 模板描述
	 */
	@TableField("description")
	private String description;

	/**
	 * 模板文件名称
	 */
	@TableField("file_name")
	private String fileName;
	/**
	 * 停启用状态：0停用，1-启用
	 */
	@TableField("enable_status")
	private Integer enableStatus;

	/**
	 * 当前最新版本号
	 */
	@TableField(value = "cur_version")
	private Long curVersion;

	/**
	 * 对应单据类型
	 */
	@TableField(value = "bill_type_code")
	private String billTypeCode;

	/**
	 * 模板选择元数据
	 */
	@TableField(value = "metadata")
	private String metadata;

	/**
	 * 模板编码
	 */
	@TableField(value = "code")
	private String code;

	/**
	 * 是否开启二维码：0-否，1-是
	 */
	@TableField(value = "qr_code_flag")
	private Boolean qrCodeFlag;

	/**
	 * 二维码显示方式
	 */
	@TableField(value = "qr_code_show_type")
	private String qrCodeShowType;

	/**
	 * 二维码在页面显示位置
	 */
	@TableField(value = "qr_code_page_position")
	private String qrCodePagePosition;

	@TableField(exist = false)
	private List<PartyVO> partyList = new ArrayList<>();

	/**
	 * 所属组织Id
	 */
	@TableField(value = "belong_org_id")
	private Long belongOrgId;
	/**
	 * 所属组织名称
	 */
	@TableField(value = "belong_org_name")
	private String belongOrgName;
	/**
	 * 所属组织编码
	 */
	@TableField(value = "belong_org_code")
	private String belongOrgCode;

	/**
	 * 所属组织内码
	 */
	@TableField(value = "belong_org_inner_code")
	private String belongOrgInnerCode;

	public String getBelongOrgInnerCode() {
		return belongOrgInnerCode;
	}

	public void setBelongOrgInnerCode(String belongOrgInnerCode) {
		this.belongOrgInnerCode = belongOrgInnerCode;
	}

	public Long getBelongOrgId() {
		return belongOrgId;
	}

	public void setBelongOrgId(Long belongOrgId) {
		this.belongOrgId = belongOrgId;
	}

	public String getBelongOrgName() {
		return belongOrgName;
	}

	public void setBelongOrgName(String belongOrgName) {
		this.belongOrgName = belongOrgName;
	}

	public String getBelongOrgCode() {
		return belongOrgCode;
	}

	public void setBelongOrgCode(String belongOrgCode) {
		this.belongOrgCode = belongOrgCode;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMetadata() {
		return metadata;
	}

	public void setMetadata(String metadata) {
		this.metadata = metadata;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public void setBillTypeCode(String billTypeCode) {
		this.billTypeCode = billTypeCode;
	}

	public Long getCurVersion() {
		return curVersion;
	}

	public void setCurVersion(Long curVersion) {
		this.curVersion = curVersion;
	}

	public Long getFileId() {
		return fileId;
	}

	public void setFileId(Long fileId) {
		this.fileId = fileId;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Long getCurVersionId() {
		return curVersionId;
	}

	public void setCurVersionId(Long curVersionId) {
		this.curVersionId = curVersionId;
	}

	public String getTemplateName() {
		return templateName;
	}

	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Integer getFileSize() {
		return fileSize;
	}

	public void setFileSize(Integer fileSize) {
		this.fileSize = fileSize;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getOnlinePath() {
		return onlinePath;
	}

	public void setOnlinePath(String onlinePath) {
		this.onlinePath = onlinePath;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Integer getEnableStatus() {
		return enableStatus;
	}

	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}

	public List<PartyVO> getPartyList() {
		return partyList;
	}

	public void setPartyList(List<PartyVO> partyList) {
		this.partyList = partyList;
	}

	public Boolean getQrCodeFlag() {
		return qrCodeFlag;
	}

	public void setQrCodeFlag(Boolean qrCodeFlag) {
		this.qrCodeFlag = qrCodeFlag;
	}

	public String getQrCodeShowType() {
		return qrCodeShowType;
	}

	public void setQrCodeShowType(String qrCodeShowType) {
		this.qrCodeShowType = qrCodeShowType;
	}

	public String getQrCodePagePosition() {
		return qrCodePagePosition;
	}

	public void setQrCodePagePosition(String qrCodePagePosition) {
		this.qrCodePagePosition = qrCodePagePosition;
	}
}
