package com.ejianc.business.contractbase.pool.contractpool.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractSubPaymentNodeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author baipengyan
 * @date 2022/8/20
 * @description 合同池付款阶段
 */
@RestController
@RequestMapping("contractPoolPaymentNode")
public class ContractPoolPaymentNodeController {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private final IContractSubPaymentNodeService service;


	public ContractPoolPaymentNodeController(IContractSubPaymentNodeService service) {
		this.service = service;
	}

	/**
	 * 根据合同id查询合同池付款阶段详情
	 *
	 * @param contractId 合同id
	 *
	 * @return 合同池付款阶段详情
	 */
	@GetMapping(value = "queryDetailByContractId")
	public CommonResponse<JSONObject> queryDetailByContractId(@RequestParam("contractId") Long contractId) {

		List<ContractSubPaymentNodeVO> contractSubPaymentNodeVOS = service.queryDetailByContractId(contractId);
		JSONObject jsonObject = new JSONObject();
		if (contractSubPaymentNodeVOS.isEmpty()) {
			jsonObject.put("data", null);
			return CommonResponse.success(jsonObject);
		}
		List<Map<String, Object>> list = new ArrayList<>();
		for (ContractSubPaymentNodeVO paymentNodeVO : contractSubPaymentNodeVOS) {
			JSONObject o = (JSONObject) JSON.toJSON(paymentNodeVO);
			o.put("text", paymentNodeVO.getPaymentNodeName());
			o.put("value", paymentNodeVO.getId());
			list.add(o);
		}
		jsonObject.put("data", list);

		return CommonResponse.success("查询成功！", jsonObject);
	}

}
