/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.enums.PartyEnum;
import com.ejianc.business.contractbase.enums.QRCodePagePositonEnum;
import com.ejianc.business.contractbase.enums.QRCodeShowTypeEnum;
import com.ejianc.business.contractbase.service.ITemplDetailExportSettingService;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateSignatoryRectService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.util.ReferTool;
import com.ejianc.business.contractbase.vo.PartyVO;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"templateController"})
public class TemplateController {
    @Autowired
    private IBillCodeApi billCodeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "LJL_TEMPLATE";
    @Autowired
    private ITemplateService service;
    @Autowired
    private ITemplateCategoryService categoryService;
    @Autowired
    private ITemplateVersionService versionService;
    @Autowired
    private ITemplateSignatoryRectService templateSignatoryRectService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ITemplDetailExportSettingService templDetailExportSettingService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> saveOrUpdate(@RequestBody TemplateVO saveorUpdateVO) {
        TemplateEntity entity = (TemplateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TemplateEntity.class));
        if (entity.getId() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setId(IdWorker.getId());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setCode((String)billCode.getData());
            entity.setQrCodeFlag(false);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter("eq", (Object)entity.getCategoryId()));
        List templateEntityList = this.service.queryList(queryParam);
        if (templateEntityList.isEmpty()) {
            entity.setEnableStatus(TemplateVO.STATUS_ENABLE);
        } else {
            entity.setEnableStatus(TemplateVO.STATUS_DISABLE);
        }
        TemplateCategoryEntity templateCategoryEntity = (TemplateCategoryEntity)((Object)this.categoryService.getById(entity.getCategoryId()));
        if (null != templateCategoryEntity) {
            entity.setBillTypeCode(templateCategoryEntity.getBillTypeCode());
        } else {
            entity.setBillTypeCode(saveorUpdateVO.getBillTypeCode());
        }
        if (null != saveorUpdateVO.getBelongOrgId()) {
            CommonResponse orgResp = this.orgApi.getOneById(saveorUpdateVO.getBelongOrgId());
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            entity.setBelongOrgInnerCode(((OrgVO)orgResp.getData()).getInnerCode());
        }
        TemplateVersionEntity version = this.versionService.createVersion(entity);
        entity.setCurVersionId(version.getId());
        entity.setCurVersion(1L);
        this.service.saveOrUpdate((Object)entity, false);
        return this.service.returnCommon(entity.getId());
    }

    @RequestMapping(value={"/updateEnable"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> updateEnable(@RequestBody TemplateVO updateVo) {
        TemplateEntity entity = (TemplateEntity)((Object)this.service.selectById(updateVo.getId()));
        entity.setEnableStatus(updateVo.getEnableStatus());
        UpdateWrapper updateWrapper = (UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"enable_status", (Object)TemplateVO.STATUS_DISABLE)).eq((Object)"category_id", (Object)entity.getCategoryId());
        this.service.update((Wrapper)updateWrapper);
        this.service.saveOrUpdate((Object)entity, false);
        return this.service.returnCommon(entity.getId());
    }

    @RequestMapping(value={"/copyTemplate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> copyTemplate(@RequestBody TemplateVO copyVo) {
        QueryWrapper nameRepeatCheck = new QueryWrapper();
        nameRepeatCheck.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        nameRepeatCheck.eq((Object)"template_name", (Object)copyVo.getTemplateName());
        List list = this.service.list((Wrapper)nameRepeatCheck);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6a21\u677f\u540d\u79f0\u91cd\u590d\uff01");
        }
        return CommonResponse.success((Object)this.service.saveCopyTempl(copyVo));
    }

    @RequestMapping(value={"/updateQeCodeFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemplateVO> updateQeCodeFlag(@RequestBody TemplateVO updateVo) {
        TemplateEntity entity = (TemplateEntity)((Object)this.service.selectById(updateVo.getId()));
        if (updateVo.getQrCodeFlag().booleanValue()) {
            entity.setQrCodeShowType(QRCodeShowTypeEnum.\u9996\u9875.getTypeCode());
            entity.setQrCodePagePosition(QRCodePagePositonEnum.\u53f3\u4e0a\u89d2.getPositionCode());
        } else {
            entity.setQrCodeShowType(null);
            entity.setQrCodePagePosition(null);
        }
        entity.setQrCodeFlag(updateVo.getQrCodeFlag());
        this.service.saveOrUpdate((Object)entity, false);
        return this.service.returnCommon(entity.getId());
    }

    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryPage(@RequestBody QueryParam queryParam) {
        ArrayList<String> idList = new ArrayList<String>();
        if (queryParam.getParams().containsKey("categoryId")) {
            Parameter parameter = (Parameter)queryParam.getParams().get("categoryId");
            String value = (String)parameter.getValue();
            QueryParam query = new QueryParam();
            query.getParams().put("pid", new Parameter("eq", (Object)value));
            List categoryEntityList = this.categoryService.queryList(query, false);
            if (!categoryEntityList.isEmpty()) {
                for (TemplateCategoryEntity t : categoryEntityList) {
                    idList.add(String.valueOf(t.getId()));
                }
            }
        }
        if (!idList.isEmpty()) {
            queryParam.getParams().put("categoryId", new Parameter("in", idList));
        }
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            Map<String, String> modeMap = this.templDetailExportSettingService.getTemplExportMode(pageData.getRecords().stream().map(BaseVO::getId).collect(Collectors.toList()));
            pageData.getRecords().forEach(record -> {
                if (null != record.getQrCodeShowType()) {
                    record.setQrCodeShowTypeName(QRCodeShowTypeEnum.getByCode((String)record.getQrCodeShowType()).getTypeName());
                }
                if (StringUtils.isNotBlank((CharSequence)record.getQrCodePagePosition())) {
                    StringBuilder positionNames = new StringBuilder();
                    for (String pCode : record.getQrCodePagePosition().split(",")) {
                        positionNames.append(",").append(QRCodePagePositonEnum.getByCode((String)pCode).getPositionName());
                    }
                    record.setQrCodePagePositionName(positionNames.substring(1));
                }
                record.setDetailExportMode((String)modeMap.get(record.getId().toString()));
                record.setPartyList(this.getPartyList());
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<PartyVO> getPartyList() {
        ArrayList<PartyVO> partyList = new ArrayList<PartyVO>();
        for (PartyEnum party : PartyEnum.values()) {
            PartyVO partyVO = new PartyVO();
            partyVO.setPartyName(party.getPartyName());
            partyVO.setPartyCode(party.getPartyCode());
            partyList.add(partyVO);
        }
        return partyList;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemplateVO> vos) {
        Collection templateEntities = this.service.listByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        this.versionService.removeByIds(templateEntities.stream().map(TemplateEntity::getCurVersionId).collect(Collectors.toList()), true);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        List<Long> templateIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.templateSignatoryRectService.batchRemove(templateIds);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveTempleMetaData"})
    @ResponseBody
    public CommonResponse<String> saveTempleMetaData(@RequestBody TemplateVO tmplVo) {
        TemplateEntity tmpl = (TemplateEntity)((Object)this.service.selectById(tmplVo.getId()));
        if (null == tmpl) {
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u6a21\u677f\u4fe1\u606f\uff01");
        }
        tmpl.setMetadata(tmplVo.getMetadata());
        this.service.saveOrUpdate((Object)tmpl, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @GetMapping(value={"/detail"})
    @ResponseBody
    public CommonResponse<TemplateVO> detailById(@RequestParam Long id) {
        return CommonResponse.success((Object)BeanMapper.map((Object)this.service.selectById(id), TemplateVO.class));
    }

    @ResponseBody
    @RequestMapping(value={"/pageListRef"}, method={RequestMethod.GET})
    public CommonResponse<IPage<TemplateVO>> getCategoryParent(@RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="relyCondition") String relyCondition) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.getFuzzyFields().add("templateName");
        param.getFuzzyFields().add("code");
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> parameterMap = ReferTool.parseCondition(relyCondition);
        parameterMap.keySet().stream().forEach(key -> {
            Parameter cfr_ignored_0 = (Parameter)param.getParams().put(key, parameterMap.get(key));
        });
        IPage page = this.service.queryPage(param);
        Page pageDate = new Page();
        pageDate.setCurrent(page.getCurrent());
        pageDate.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        pageDate.setSize(page.getSize());
        pageDate.setTotal(page.getTotal());
        pageDate.setPages(page.getPages());
        return CommonResponse.success((Object)pageDate);
    }

    @GetMapping(value={"/preview"})
    public void templatePreview(@RequestParam(value="id") Long id, HttpServletResponse resp) throws IOException {
        TemplateEntity templ = (TemplateEntity)((Object)this.service.selectById(id));
        if (null == templ.getFileId()) {
            throw new BusinessException("\u6a21\u677f\u6587\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9884\u89c8\uff01");
        }
        resp.sendRedirect(this.BaseHost + "ejc-file-web/onlinePreview?fileId=" + templ.getFileId());
    }
}

