package com.ejianc.business.contractbase.disclose.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.contractbase.disclose.bean.EngineerContractDetailEntity;
/**
 * 工程承包合同一二级交底
 * 
 * @author generator
 * 
 */
 @TableName("ejc_conbase_engineer_contract")
public class EngineerContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // orgName
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="contract_type")
    private Long contractType; // 合同类型
    @TableField(value="contract_type_name")
    private String contractTypeName; // 合同类型
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方/发包人
    @TableField(value="customer_name")
    private String customerName; // 合同甲方/发包人
    @TableField(value="supervisor")
    private String supervisor; // 监理单位
    @TableField(value="designer")
    private String designer; // 设计单位
    @TableField(value="survey")
    private String survey; // 勘察单位
    @TableField(value="address")
    private String address; // 工程地址
    @TableField(value="transfer_file_id")
    private Long transferFileId; // 移交文件
    @TableField(value="transfer_file_name")
    private String transferFileName; // 移交文件
    @TableField(value="other_transfer_file")
    private String otherTransferFile; // 其他移交文件
    @TableField(value="disclose_date")
    private Date discloseDate; // 交底日期
    @TableField(value="disclose_id")
    private Long discloseId; // 交底人
    @TableField(value="disclose_name")
    private String discloseName; // 交底人名称
    @TableField(value="receive_disclose_id")
    private String receiveDiscloseId; // 接收交底人
    @TableField(value="receive_disclose_name")
    private String receiveDiscloseName; // 接收交底人
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="contract_mny_wan")
    private BigDecimal contractMnyWan; // 合同金额（万元）
    @TableField(value="temporarily_mny")
    private BigDecimal temporarilyMny; // 暂列金
    @TableField(value="provisional_mny")
    private BigDecimal provisionalMny; // 暂估价
    @TableField(value="subcontractor_mny")
    private BigDecimal subcontractorMny; // 甲分包
    @TableField(value="advance_mny")
    private BigDecimal advanceMny; // 垫资额
    @TableField(value="finance_mny")
    private BigDecimal financeMny; // 财务费用
    @TableField(value="project_overview")
    private String projectOverview; // 工程概况
    @TableField(value="tender_content")
    private String tenderContent; // 承包内容
    @TableField(value="pay_commit")
    private String payCommit; // 付款约定
    @TableField(value="change_price_content")
    private String changePriceContent; // 调价调差
    @TableField(value="measure")
    private String measure; // 措施约定
    @TableField(value="visa_aims")
    private String visaAims; // 签证索赔
    @TableField(value="a_supply")
    private String aSupply; // 甲供材及认质认价
    @TableField(value="settle_content")
    private String settleContent; // 结算程序与结算款约定
    @TableField(value="progress_commit")
    private String progressCommit; // 进度约定（目标）
    @TableField(value="quality_commit")
    private String qualityCommit; // 质量约定（目标）
    @TableField(value="safe_worker")
    private String safeWorker; //  安全约定（目标）
    @TableField(value="progress_commit_reward")
    private String progressCommitReward; // 进度约定（奖罚）
    @TableField(value="quality_commit_reward")
    private String qualityCommitReward; // 质量约定（奖罚）
    @TableField(value="safe_worker_reward")
    private String safeWorkerReward; //  安全约定（奖罚）
    @TableField(value="a_supply_sub")
    private String aSupplySub; // 甲分包及甲指分包
    @TableField(value="argue")
    private String argue; // 争议解决
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="engineerContractDetailService", pidName = "engineerContractId")
    private List<EngineerContractDetailEntity> detailList = new ArrayList<>(); // 工程承包合同一二级交底子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }
    public String getSurvey() {
        return survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getTransferFileId() {
        return transferFileId;
    }

    public void setTransferFileId(Long transferFileId) {
        this.transferFileId = transferFileId;
    }
    public String getTransferFileName() {
        return transferFileName;
    }

    public void setTransferFileName(String transferFileName) {
        this.transferFileName = transferFileName;
    }
    public String getOtherTransferFile() {
        return otherTransferFile;
    }

    public void setOtherTransferFile(String otherTransferFile) {
        this.otherTransferFile = otherTransferFile;
    }
    public Date getDiscloseDate() {
        return discloseDate;
    }

    public void setDiscloseDate(Date discloseDate) {
        this.discloseDate = discloseDate;
    }
    public Long getDiscloseId() {
        return discloseId;
    }

    public void setDiscloseId(Long discloseId) {
        this.discloseId = discloseId;
    }
    public String getDiscloseName() {
        return discloseName;
    }

    public void setDiscloseName(String discloseName) {
        this.discloseName = discloseName;
    }

    public String getReceiveDiscloseId() {
        return receiveDiscloseId;
    }

    public void setReceiveDiscloseId(String receiveDiscloseId) {
        this.receiveDiscloseId = receiveDiscloseId;
    }

    public String getReceiveDiscloseName() {
        return receiveDiscloseName;
    }

    public void setReceiveDiscloseName(String receiveDiscloseName) {
        this.receiveDiscloseName = receiveDiscloseName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractMnyWan() {
        return contractMnyWan;
    }

    public void setContractMnyWan(BigDecimal contractMnyWan) {
        this.contractMnyWan = contractMnyWan;
    }
    public BigDecimal getTemporarilyMny() {
        return temporarilyMny;
    }

    public void setTemporarilyMny(BigDecimal temporarilyMny) {
        this.temporarilyMny = temporarilyMny;
    }
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    public BigDecimal getSubcontractorMny() {
        return subcontractorMny;
    }

    public void setSubcontractorMny(BigDecimal subcontractorMny) {
        this.subcontractorMny = subcontractorMny;
    }
    public BigDecimal getAdvanceMny() {
        return advanceMny;
    }

    public void setAdvanceMny(BigDecimal advanceMny) {
        this.advanceMny = advanceMny;
    }
    public BigDecimal getFinanceMny() {
        return financeMny;
    }

    public void setFinanceMny(BigDecimal financeMny) {
        this.financeMny = financeMny;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public String getTenderContent() {
        return tenderContent;
    }

    public void setTenderContent(String tenderContent) {
        this.tenderContent = tenderContent;
    }
    public String getPayCommit() {
        return payCommit;
    }

    public void setPayCommit(String payCommit) {
        this.payCommit = payCommit;
    }
    public String getChangePriceContent() {
        return changePriceContent;
    }

    public void setChangePriceContent(String changePriceContent) {
        this.changePriceContent = changePriceContent;
    }
    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }
    public String getVisaAims() {
        return visaAims;
    }

    public void setVisaAims(String visaAims) {
        this.visaAims = visaAims;
    }
    public String getASupply() {
        return aSupply;
    }

    public void setASupply(String aSupply) {
        this.aSupply = aSupply;
    }
    public String getSettleContent() {
        return settleContent;
    }

    public void setSettleContent(String settleContent) {
        this.settleContent = settleContent;
    }
    public String getProgressCommit() {
        return progressCommit;
    }

    public void setProgressCommit(String progressCommit) {
        this.progressCommit = progressCommit;
    }
    public String getQualityCommit() {
        return qualityCommit;
    }

    public void setQualityCommit(String qualityCommit) {
        this.qualityCommit = qualityCommit;
    }
    public String getSafeWorker() {
        return safeWorker;
    }

    public void setSafeWorker(String safeWorker) {
        this.safeWorker = safeWorker;
    }
    public String getProgressCommitReward() {
        return progressCommitReward;
    }

    public void setProgressCommitReward(String progressCommitReward) {
        this.progressCommitReward = progressCommitReward;
    }
    public String getQualityCommitReward() {
        return qualityCommitReward;
    }

    public void setQualityCommitReward(String qualityCommitReward) {
        this.qualityCommitReward = qualityCommitReward;
    }
    public String getSafeWorkerReward() {
        return safeWorkerReward;
    }

    public void setSafeWorkerReward(String safeWorkerReward) {
        this.safeWorkerReward = safeWorkerReward;
    }
    public String getASupplySub() {
        return aSupplySub;
    }

    public void setASupplySub(String aSupplySub) {
        this.aSupplySub = aSupplySub;
    }
    public String getArgue() {
        return argue;
    }

    public void setArgue(String argue) {
        this.argue = argue;
    }


    public List<EngineerContractDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<EngineerContractDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
