package com.ejianc.business.contractbase.disclose.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailEntity;
import com.ejianc.business.contractbase.disclose.bean.ContractArchiveDetailFileEntity;
import com.ejianc.business.contractbase.disclose.service.IContractArchiveDetailFileService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.contractbase.disclose.bean.ContractArchiveEntity;
import com.ejianc.business.contractbase.disclose.service.IContractArchiveService;
import com.ejianc.business.contractbase.disclose.vo.ContractArchiveVO;

/**
 * 合同归档
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractArchive")
public class ContractArchiveController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CONTRACT_ARCHIVE";//此处需要根据实际修改

    @Autowired
    private IContractArchiveService service;
    @Autowired
    private IContractArchiveDetailFileService detailFileService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractArchiveVO> saveOrUpdate(@RequestBody ContractArchiveVO saveOrUpdateVO) {

        //编号重复校验
        if (null != saveOrUpdateVO.getBillCode()){
            QueryWrapper<ContractArchiveEntity> query = new QueryWrapper();
            query.eq("bill_code", saveOrUpdateVO.getBillCode());
            if(null != saveOrUpdateVO.getId()) {
                query.ne("id", saveOrUpdateVO.getId());
            }
            List<ContractArchiveEntity> billCodeEntityList = service.list(query);
            if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
                return CommonResponse.error("保存失败，组卷号重复！");
            }
        }

    	ContractArchiveEntity entity = BeanMapper.map(saveOrUpdateVO, ContractArchiveEntity.class);
        if(null == entity.getBillCode() || StringUtils.isBlank(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<Long> oldFileIdList = new ArrayList<>();
        if (null == entity.getId()){
            entity.setId(IdWorker.getId());
        }else {
            List<ContractArchiveDetailFileEntity> detailFileEntityList = detailFileService.list(new QueryWrapper<ContractArchiveDetailFileEntity>().eq("contract_archive_id", entity.getId()));
            if (CollectionUtils.isNotEmpty(detailFileEntityList)){
                oldFileIdList = detailFileEntityList.stream().map(ContractArchiveDetailFileEntity::getId).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList()) && entity.getDetailList().size() > 0){
            List<ContractArchiveDetailFileEntity> delList = new ArrayList<>();
            List<ContractArchiveDetailFileEntity> addList = new ArrayList<>();
            for (ContractArchiveDetailEntity detailEntity : entity.getDetailList()) {
                if (null == detailEntity.getId()){
                    detailEntity.setId(IdWorker.getId());
                }
                if (CollectionUtils.isNotEmpty(detailEntity.getFileList()) && detailEntity.getFileList().size() > 0){
                    for (ContractArchiveDetailFileEntity fileEntity : detailEntity.getFileList()) {
                        if ("add".equals(fileEntity.getRowState())) {
                            fileEntity.setContractArchiveId(entity.getId());
                            fileEntity.setContractArchiveDetailId(detailEntity.getId());
                        }
                        oldFileIdList.remove(fileEntity.getId());
                        addList.add(fileEntity);
                    }
                }
            }
            if (oldFileIdList.size() > 0){
                detailFileService.removeByIds(oldFileIdList);
            }
            if (addList.size() > 0){
                detailFileService.saveOrUpdateBatch(addList, addList.size(), false);
            }
        }
    	service.saveOrUpdate(entity, false);
    	ContractArchiveVO vo = BeanMapper.map(entity, ContractArchiveVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractArchiveVO> queryDetail(Long id) {
    	ContractArchiveEntity entity = service.selectById(id);
    	if (CollectionUtils.isNotEmpty(entity.getDetailList()) && entity.getDetailList().size() > 0){
            List<ContractArchiveDetailFileEntity> detailFileList = detailFileService.list(new QueryWrapper<ContractArchiveDetailFileEntity>().eq("contract_archive_id", entity.getId()));
            Map<Long, List<ContractArchiveDetailFileEntity>> detailFileMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(detailFileList) && detailFileList.size() > 0){
                detailFileMap = detailFileList.stream().collect(Collectors.groupingBy(ContractArchiveDetailFileEntity::getContractArchiveDetailId));
            }
            for (ContractArchiveDetailEntity contractArchiveDetailEntity : entity.getDetailList()) {
                if (detailFileMap.containsKey(contractArchiveDetailEntity.getId())){
                    contractArchiveDetailEntity.setFileList(detailFileMap.get(contractArchiveDetailEntity.getId()));
                }
            }
        }
    	ContractArchiveVO vo = BeanMapper.map(entity, ContractArchiveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractArchiveVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractArchiveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                detailFileService.remove(new QueryWrapper<ContractArchiveDetailFileEntity>().eq("contract_archive_id", vo.getId()));
            }
        }
        service.removeByIds(vos.stream().map(ContractArchiveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractArchiveVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("discloseName");
        fuzzyFields.add("transferFileName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ContractArchiveEntity> page = service.queryPage(param,false);
        IPage<ContractArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractArchiveVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("discloseName");
        fuzzyFields.add("transferFileName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractArchiveEntity> list = service.queryList(param);
        List<ContractArchiveVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,ContractArchiveVO.class);
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("ContractArchive-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refContractArchiveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractArchiveVO>> refContractArchiveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContractArchiveEntity> page = service.queryPage(param,false);
        IPage<ContractArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractArchiveVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
