package com.ejianc.business.contractbase.disclose.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.disclose.bean.PurchaseContractEntity;
import com.ejianc.business.contractbase.disclose.mapper.PurchaseContractMapper;
import com.ejianc.business.contractbase.disclose.service.IPurchaseContractService;
import com.ejianc.business.contractbase.disclose.vo.PurchaseContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 工程及服务采购合同交底 
 * 
 * @author generator
 * 
 */
@Service("purchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractType");
        fuzzyFields.add("contractName");
        fuzzyFields.add("receiveEmployeeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billState");
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<PurchaseContractEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<PurchaseContractVO> list = BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class);
            if (list != null) {
                list.forEach(vo -> {
                    Integer billState = vo.getBillState();
                    if (billState != null) {
                        BillStateEnum billStateEnum = BillStateEnum.getEnumByStateCode(billState);
                       if (billStateEnum != null) {
                            vo.setBillStateName(billStateEnum.getDescription());
                       }
                    }
                });
            }

            beans.put("records", list);
            ExcelExport.getInstance().export("purchase-contract.xlsx", beans, response);
        }
    }
}
