package com.ejianc.business.contractbase.pool.contractpool.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.entity.TemplateCategoryEntity;
import com.ejianc.business.contractbase.mapper.TemplateCategoryMapper;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractSubPaymentNodeEntity;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractSubPaymentNodeService;
import com.ejianc.business.contractbase.pool.contractpool.vo.*;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.mapper.SettlePoolMapper;
import com.ejianc.business.contractbase.pool.settlepool.service.IBillUrlDictService;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.util.BeanUtil;
import com.ejianc.business.contractbase.service.ITemplateCategoryService;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.business.pro.rmat.api.IRentCalculateApi;
import com.ejianc.business.pro.supplier.api.IAbnormalApi;
import com.ejianc.business.pro.supplier.api.ICheckSupplierApi;
import com.ejianc.business.pro.supplier.vo.AbnormalVO;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.pub.commonupdate.param.CommonUpdateParam;
import com.ejianc.business.rent.api.IRentRentalApi;
import com.ejianc.business.rent.vo.RentalSumVo;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.OutFlowVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同池主实体
 * 
 * @author generator
 * 
 */
@Service("contractPoolService")
public class ContractPoolServiceImpl extends BaseServiceImpl<ContractPoolMapper, ContractPoolEntity> implements IContractPoolService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ContractPoolMapper contractPoolMapper;

    @Autowired
    private IContractSubPaymentNodeService contractSubPaymentNodeService;

    @Autowired
    private IBillUrlDictService billUrlDictService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IShareSupplierApi shareSupplierApi;

    @Autowired
    private SettlePoolMapper settlePoolMapper;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;

    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;
    @Autowired
    private ISettlePoolService settleService;

    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private IRentRentalApi rentalApi;

    @Autowired
    private IRentCalculateApi rentCalculateApi;
    private static final String BILL_CODE = "CONTRACT_POOL";// 单据编码规则

    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ICheckSupplierApi checkSupplierApi;
    @Autowired
    private IAbnormalApi abnormalApi;

    @Autowired
    private ITemplateCategoryService categoryService;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Value("${common.env.base-host}")
    private String BaseHost;


    @Override
    public void deleteBySourceId(Long sourceId) {
        contractSubPaymentNodeService.deleteByContractSourceId(sourceId);
        contractPoolMapper.deleteBySourceId(sourceId);
    }

    private ContractPoolEntity copyBaseFields(ContractPoolEntity dbEntity, ContractPoolVO contractPoolVO) {
        ContractPoolEntity saveEntity = null;
        if(UpdateLevelEnum.全量覆盖更新.getLevelCode().equals(contractPoolVO.getUpdateLevel())) {
            logger.info("全量跟新合同数据-{}", JSONObject.toJSONString(contractPoolVO));
            //全量覆盖更新
            saveEntity = BeanMapper.map(contractPoolVO, ContractPoolEntity.class);
        } else {
            //部分更新
            saveEntity = BeanMapper.map(dbEntity, ContractPoolEntity.class);
            String[] updateFields = BeanUtil.getPropertyNames(contractPoolVO, contractPoolVO.getUpdateLevel());
            logger.info("部分跟新合同数据-{}, 本次更新字段-{}", JSONObject.toJSONString(contractPoolVO), updateFields);
            BeanUtils.copyProperties(contractPoolVO, saveEntity, updateFields);
        }

        Map<Long, ContractSubPaymentNodeEntity> sourceIdMap = new HashMap<>();
        dbEntity.getContractSubPaymentNodeList().stream().forEach(sub -> {
            sub.setRowState("del");
            sourceIdMap.put(sub.getSourceId(), sub);
        });
        ContractSubPaymentNodeEntity tmp = null;
        if(CollectionUtils.isNotEmpty(contractPoolVO.getContractSubPaymentNodeList())) {
            for(ContractSubPaymentNodeVO sub : contractPoolVO.getContractSubPaymentNodeList()) {
                tmp = sourceIdMap.get(sub.getSourceId());
                if(null != tmp) {
                    sub.setRowState("edit");
                    sourceIdMap.remove(sub.getSourceId());
                    sub.setVersion(tmp.getVersion());
                } else {
                    sub.setRowState("add");
                }
            }
            saveEntity.setContractSubPaymentNodeList(BeanMapper.mapList(contractPoolVO.getContractSubPaymentNodeList(), ContractSubPaymentNodeEntity.class));

            if(MapUtils.isNotEmpty(sourceIdMap)) {
                saveEntity.setContractSubPaymentNodeList(new ArrayList<>(sourceIdMap.values()));
            }
        }

        logger.info("本次更新合同数据-{}", JSONObject.toJSONString(saveEntity));
        saveEntity.setId(dbEntity.getId());
        saveEntity.setVersion(dbEntity.getVersion());
        saveEntity.setCreateTime(dbEntity.getCreateTime());
        saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
        saveEntity.setTenantId(dbEntity.getTenantId());

        //若PC或移动端详情地址为空，则根据字典信息设置详情地址
        if(StringUtils.isBlank(saveEntity.getPcCardUrl()) || StringUtils.isBlank(saveEntity.getMobileCardUrl())) {
            findDetailUrl(saveEntity);
        }

        return saveEntity;
    }

    @Override
    public ContractPoolVO saveOrUpdateContract(ContractPoolVO contract) {
        ContractPoolEntity dbEntity = selectBySourceId(contract.getSourceId());

        ContractPoolEntity saveEntity = null;
        if(null != dbEntity) {
            saveEntity = copyBaseFields(dbEntity, contract);
        } else {
            if(null == contract.getSourceId()) {
                throw new BusinessException("同步合同失败， 合同来源业务单据id-[sourceId]为空！");
            }
            if(null != contract.getId() && !contract.getId().equals(contract.getSourceId())) {
                throw new BusinessException("同步合同失败， 合同Id与合同sourceId不一致！");
            }
            //属性校验
            if(null == contract.getCategoryId()) {
                throw new BusinessException("同步合同失败， 合同分类Id-[categoryId]为空");
            }
            if(null == contract.getSourceType()) {
                throw new BusinessException("同步合同失败， 合同来源单业务单据类型-[sourceType]为空");
            }
            if(StringUtils.isBlank(contract.getPerformanceStatus())) {
                throw new BusinessException("同步合同失败， 合同合同履约状态-[performanceStatus]为空");
            }
            if(null == contract.getSupplementFlag()) {
                throw new BusinessException("同步合同失败， 合同是否为补充协议标识为空-[supplementFlag]为空");
            }
            if(null == contract.getContractProperty()) {
                throw new BusinessException("同步合同失败， 合同属性为空-[contractProperty]为空");
            }
            if(null == contract.getHandleType()) {
                contract.setHandleType(0); //业务系统推送
            }

            //新增走下物理删除逻辑，防止数据insert时主键重复
            deleteBySourceId(contract.getSourceId());

            saveEntity = BeanMapper.map(contract, ContractPoolEntity.class);
            //填充遗漏属性
            String msg = findDetailUrl(saveEntity);
            if(StringUtils.isNotBlank(msg)) {
                throw new BusinessException(msg);
            }

        }

        if(StringUtils.isNotBlank(saveEntity.getSourceType())) {
            ContractTypeEnum ct = ContractTypeEnum.getByCode(saveEntity.getSourceType());
            if(null != ct) {
                saveEntity.setSourceTypeName(ct.getTypeName());
            }
        }
        super.saveOrUpdate(saveEntity, false);
        return BeanMapper.map(saveEntity, ContractPoolVO.class);
    }

    /**
     * 更新合同履约状态
     *
     * @param contractPoolVO
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public ContractPoolVO updatePerformanceStatusByContractId(ContractPoolVO contractPoolVO) {
        ContractPoolEntity dbEntity = null;
        if(null != contractPoolVO.getSourceId()) {
            dbEntity = selectBySourceId(contractPoolVO.getSourceId());
        } else if(null != contractPoolVO.getId()) {
            dbEntity = super.selectById(contractPoolVO.getId());
        }

        if (dbEntity == null) {
           throw new BusinessException("更新合同履约状态失败，合同池中未找到匹配的合同信息！");
        }

        if(contractPoolVO.getSyncWithContractBill()) {
            if(null == dbEntity.getCategoryId()) {
                throw new BusinessException("更新合同履约状态失败，合同分类信息为空！");
            }
            //需要更新对应的合同单据的履约状态
            TemplateCategoryEntity category = categoryService.selectById(dbEntity.getCategoryId());
            if(null == category) {
                throw new BusinessException("更新合同履约状态失败，没有匹配的合同分类信息！");
            }

            //1 根据单据类型编码查询到对应的元数据信息
            CommonResponse<MdReferVO> mdRefResp = billTypeApi.queryMetadataByBillType(category.getBillTypeCode());
            logger.error("根据单据类型-{}，查询元数据结果-{}", category.getBillTypeCode(), JSONObject.toJSONString(mdRefResp));

            if(!mdRefResp.isSuccess()) {
                throw new BusinessException("保存失败，更新合同履约状态失败！");
            }

            //2 根据元数据信息找到对应实体信息，
            String projectName = mdRefResp.getData().getProjectName();

            //3 从元数据获取到表名， 然后更单据归档状态
            CommonUpdateParam updateParam = new CommonUpdateParam();
            updateParam.setBillId(dbEntity.getId());
            updateParam.setTableName(mdRefResp.getData().getTableName());
            updateParam.setFieldValue(contractPoolVO.getPerformanceStatus());

            if(ContractTypeEnum.设备租赁.getTypeCode().equals(category.getCategoryProperty()) || ContractTypeEnum.设备采购.getTypeCode().equals(category.getCategoryProperty())) {
                updateParam.setFieldName("contract_performance_state");
            } else {
                updateParam.setFieldName("performance_status");
            }

            ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
            logger.info("获取的请求头 authority：{}", request.getHeader("authority"));
            String authority = null;
            if (StringUtils.isNotBlank(request.getHeader("authority"))) {
                authority = request.getHeader("authority");
            }
            String url = BaseHost + projectName+"/commonUpdate/updateStatus";

            String response = HttpUtil.createRequest(Method.POST, url)
                    .header("authority", authority)
                    .header("content-type", "application/json;charset=UTF-8")
                    .body(JSON.toJSONString(updateParam))
                    .timeout(10000)
                    .execute().body();

            logger.info("更新合同-【id-{}】履约状态，url-{}，param-{}，结果：{}", dbEntity.getId(), url,
                    JSON.toJSONString(updateParam, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), response);

            CommonResponse<String> commonResponse = JSON.parseObject(response, CommonResponse.class);
            if (!commonResponse.isSuccess()) {
                logger.error("更新合同单据履约状态失败：{}！", response);
                throw new BusinessException("更新合同单据履约状态失败!");
            }
        }

        dbEntity.setPerformanceStatus(contractPoolVO.getPerformanceStatus());
        super.saveOrUpdate(dbEntity, false);
        return BeanMapper.map(dbEntity, ContractPoolVO.class);
    }

    /**
     * 子分单位排名
     * @param topN 取前几条数据，默认前五条
     * @param mnyFlag 0-新签合同额，1-产值统计
     * @param yearFlag 0-年度，1-季度，2-月度
     * @return
     */
    @Override
    public List<SubUnitTopVO> querySubUnitTopN(Integer topN, Integer mnyFlag, Integer yearFlag, Long orgId) {
        // 年度
        String year = null;
        // 季度开始时间、季度结束时间
        String beginQuarterDate = null;
        String endQuarterDate = null;
        // 月度
        String month = null;

        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }

        // 分子公司、经理部
        List<OrgVO> allOrgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<OrgVO> orgVOList = allOrgVOList.stream().filter(e -> e.getOrgType() == 2 || e.getOrgType() == 3).collect(Collectors.toList());

        List<Long> ordIdsList = allOrgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());

        if (yearFlag == 1) {
            beginQuarterDate = DateUtil.formatDate(DateUtil.beginOfQuarter(new Date()).toJdkDate());
            endQuarterDate = DateUtil.formatDate(DateUtil.endOfQuarter(new Date()).toJdkDate());
        }else if (yearFlag == 2) {
            month = DateUtil.format(new Date(), "yyyy-MM");
        }else {
            year = String.valueOf(DateUtil.year(new Date()));
        }

        List<SubUnitTopVO> list = new ArrayList<>();
        if (mnyFlag == 0) {
            // 施工合同
            list = baseMapper.queryContractionSubUnitTopN(ContractTypeEnum.施工合同.getTypeCode(), year, beginQuarterDate, endQuarterDate, month, ordIdsList);
        }else {
            // 查询产值统计
            list = settlePoolMapper.queryProductSubUnitTopN(SettleSourceTypeEnum.产值报量.getCode(), year, beginQuarterDate, endQuarterDate, month, ordIdsList);
        }
        
        Map<Long, OrgVO> orgIdMap = allOrgVOList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity(), (k1, k2) -> k2));
        Map<String, OrgVO> innerCodeMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity(), (k1, k2) -> k2));


        Map<String, SubUnitTopVO> map = new HashMap<>();

        // 拼装数据
        for (SubUnitTopVO vo : list) {
            OrgVO orgVO = orgIdMap.get(vo.getOrgId());
            String innerCode = orgVO.getInnerCode();
            
            for (Map.Entry<String, OrgVO> entry : innerCodeMap.entrySet()) {
                if (innerCode.contains(entry.getKey())) {
                    OrgVO subOrgVO = entry.getValue();
                    String orgName = subOrgVO.getName();
                    
                    BigDecimal money = null;
                    if (mnyFlag == 0) {
                        money = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny().setScale(2, RoundingMode.HALF_DOWN);
                    }else {
                        money = vo.getSettleTaxMny() == null ? BigDecimal.ZERO : vo.getSettleTaxMny().setScale(2, RoundingMode.HALF_DOWN);
                    }

                    if (map.containsKey(orgName)) {
                        SubUnitTopVO topVO = map.get(orgName);
                        topVO.setMoney(ComputeUtil.safeAdd(topVO.getMoney(), money));
                        map.put(orgName, topVO);
                    }else {
                        SubUnitTopVO topVO = new SubUnitTopVO();
                        topVO.setOrgId(subOrgVO.getId());
                        topVO.setOrgCode(subOrgVO.getCode());
                        topVO.setOrgName(subOrgVO.getName());
                        topVO.setOrgType(subOrgVO.getOrgType());
                        topVO.setMoney(money);
                        map.put(orgName, topVO);
                    }

                }
            }
        }

        List<SubUnitTopVO> resultList = new ArrayList<>(map.values());
        resultList = resultList.stream().sorted(Comparator.comparing(SubUnitTopVO::getMoney).reversed()).limit(topN).collect(Collectors.toList());

        return resultList;
    }

    @Override
    public List<ContractDTO> getContractList(SupplyVO vo) {
        return contractPoolMapper.queryContractList(vo);
    }

    @Override
    public List<ContractDTO> getContractListByHeadUser(HeadUserVO vo) {
        return contractPoolMapper.getContractListByHeadUser(vo);
    }

    @Override
    public BigDecimal queryContractHonourMny(ContractPoolVO vo) {
        BigDecimal honourMny =  BigDecimal.ZERO;
        switch (vo.getSourceType()){
            case "contractMaterial" :
                //物资采购
                OutFlowVO outFlowVO = new OutFlowVO();
                outFlowVO.setContractId(vo.getContractId());
//                List<Integer> inOutTypeList = new ArrayList<>();
//                inOutTypeList.add(11);
//                inOutTypeList.add(30);
//                inOutTypeList.add(19);
//                outFlowVO.setInOutTypeList(inOutTypeList);
                outFlowVO.setPartyaFlag(0); //非甲供材
                CommonResponse<BigDecimal> response = storeManageApi.queryInstoreTaxMnyByPurchaseContractId(outFlowVO);
                if (response.isSuccess()){
                    honourMny = response.getData();
                }else {
                    logger.error(response.getMsg());
                }
                break;
            case "rmat":
                //周转材
                CommonResponse<BigDecimal> bigDecimalCommonResponse = rentCalculateApi.queryRentMny(vo.getContractId());
                if (bigDecimalCommonResponse.isSuccess()){
                    honourMny = bigDecimalCommonResponse.getData();
                }else {
                    logger.error(bigDecimalCommonResponse.getMsg());
                }
                break;
            case "equipmentRent":
                //设备租赁
                CommonResponse<RentalSumVo> result = rentalApi.queryRentalMnyByContractId(vo.getContractId());
                if (result.isSuccess()){
                    honourMny = result.getData().getTotalTaxMny();
                }else {
                    logger.error(result.getMsg());
                }
                break;
            case "proSub":
                //专业分包
                QueryWrapper<SettlePoolEntity> queryPro = new QueryWrapper<>();
                queryPro.eq("contract_id", vo.getContractId());
                queryPro.in("source_type", Arrays.asList(SettleSourceTypeEnum.专业分包月度结算.getCode(), SettleSourceTypeEnum.专业分包最终结算.getCode()));
                queryPro.select("sum(if(source_type = 'pro_final', finish_cur_tax_mny, 0)) as totalFinishSettleTaxMny," +
                        " sum(if(source_type = 'pro_month', cur_tax_mny, 0)) as totalMonthSettleTaxMny");
                queryPro.groupBy("contract_id");
                Map<String, Object> proSumMap = settleService.getMap(queryPro);
                if(MapUtils.isNotEmpty(proSumMap) && !(null == proSumMap.get("totalFinishSettleTaxMny")
                        && null == proSumMap.get("totalFinishSettleTaxMny")&&!"0".equals(proSumMap.get("totalFinishSettleTaxMny")))) {
                    if(null != proSumMap.get("totalFinishSettleTaxMny") && BigDecimal.ZERO.compareTo(new BigDecimal(proSumMap.get("totalFinishSettleTaxMny").toString())) != 0) {
                        honourMny = honourMny.add(new BigDecimal(proSumMap.get("totalFinishSettleTaxMny").toString()));
                    } else if(null != proSumMap.get("totalMonthSettleTaxMny")) {
                        honourMny = honourMny.add(new BigDecimal(proSumMap.get("totalMonthSettleTaxMny").toString()));
                    }
                }

                break;
            case "laborSub":
                //劳务分包
                QueryWrapper<SettlePoolEntity> queryLabor = new QueryWrapper<>();
                queryLabor.eq("contract_id", vo.getContractId());
                queryLabor.in("source_type", Arrays.asList(SettleSourceTypeEnum.劳务分包月度结算.getCode(), SettleSourceTypeEnum.劳务分包最终结算.getCode()));
                queryLabor.select("sum(if(source_type = 'labor_final', finish_cur_tax_mny, 0)) as totalFinishSettleTaxMny," +
                        " sum(if(source_type = 'labor_month', cur_tax_mny, 0)) as totalMonthSettleTaxMny");
                queryLabor.groupBy("contract_id");
                Map<String, Object> laborSumMap = settleService.getMap(queryLabor);
                if(MapUtils.isNotEmpty(laborSumMap) && !(null == laborSumMap.get("totalFinishSettleTaxMny")
                        && null == laborSumMap.get("totalFinishSettleTaxMny") &&!"0".equals(laborSumMap.get("totalFinishSettleTaxMny")))) {
                    if(null != laborSumMap.get("totalFinishSettleTaxMny") && BigDecimal.ZERO.compareTo(new BigDecimal(laborSumMap.get("totalFinishSettleTaxMny").toString())) != 0) {
                        honourMny = honourMny.add(new BigDecimal(laborSumMap.get("totalFinishSettleTaxMny").toString()));
                    } else if(null != laborSumMap.get("totalMonthSettleTaxMny")) {
                        honourMny = honourMny.add(new BigDecimal(laborSumMap.get("totalMonthSettleTaxMny").toString()));
                    }
                }
                break;
            case "equipmentPurchase":
                //设备采购
                QueryParam queryEqu = new QueryParam();
                queryEqu.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
                queryEqu.getParams().put("source_type",new Parameter(QueryParam.EQ,SettleSourceTypeEnum.设备采购结算.getCode()));
                queryEqu.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
                List<SettlePoolEntity> settlePoolEqu = settleService.queryList(queryEqu);
                if (CollectionUtil.isNotEmpty(settlePoolEqu)){
                    for (SettlePoolEntity entity:settlePoolEqu){
                        if (entity.getCurTaxMny()!=null){
                            honourMny = honourMny.add(entity.getCurTaxMny());
                        }
                    }
                }
                break;
            case "tempEquip":
                //临时设备
                QueryParam queryTem = new QueryParam();
                queryTem.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
                queryTem.getParams().put("source_type",new Parameter(QueryParam.EQ,SettleSourceTypeEnum.临时设备结算.getCode()));
                queryTem.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
                List<SettlePoolEntity> settlePoolTem = settleService.queryList(queryTem);
                if (CollectionUtil.isNotEmpty(settlePoolTem)){
                    for (SettlePoolEntity entity:settlePoolTem){
                        if (entity.getCurTaxMny()!=null){
                            honourMny = honourMny.add(entity.getCurTaxMny());
                        }
                    }
                }
                break;
            case "contractAC":
                //设备安拆
                QueryParam queryBig= new QueryParam();
                queryBig.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
                queryBig.getParams().put("source_type",new Parameter(QueryParam.IN, Arrays.asList(
                        SettleSourceTypeEnum.安拆合同过程结算.getCode(),
                        SettleSourceTypeEnum.安拆合同最终结算.getCode()
                )));
                queryBig.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
                List<SettlePoolEntity> settlePoolBig = settleService.queryList(queryBig);
                if (CollectionUtil.isNotEmpty(settlePoolBig)){
                    for (SettlePoolEntity entity:settlePoolBig){
                        if (entity.getCurTaxMny()!=null){
                            honourMny = honourMny.add(entity.getCurTaxMny());
                        }
                    }
                }
                break;
            case "contractOther":
                //其他支出合同
                QueryParam queryOth= new QueryParam();
                queryOth.getParams().put("contract_id",new Parameter(QueryParam.EQ,vo.getContractId()));
                queryOth.getParams().put("source_type",new Parameter(QueryParam.IN,Arrays.asList(
                        SettleSourceTypeEnum.其他支出合同最终结算.getCode(),
                        SettleSourceTypeEnum.其他支出合同过程结算.getCode())));
                queryOth.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
                List<SettlePoolEntity> settlePoolOth = settleService.queryList(queryOth);
                if (CollectionUtil.isNotEmpty(settlePoolOth)){
                    for (SettlePoolEntity entity:settlePoolOth){
                        if (entity.getCurTaxMny()!=null){
                            honourMny = honourMny.add(entity.getCurTaxMny());
                        }
                    }
                }
                break;
            case "contractConcrete":
                //混凝土合同
                QueryParam conQuery = new QueryParam();
                conQuery.getParams().put("purchase_contract_id", new Parameter(QueryParam.EQ, vo.getContractId()));
                conQuery.getParams().put("in_out_flag", new Parameter(QueryParam.EQ, 1));
                conQuery.getParams().put("in_out_type", new Parameter(QueryParam.EQ, 30));
                conQuery.getParams().put("source_bill_type_code", new Parameter(QueryParam.EQ, "BT220224000000004"));
                CommonResponse<List<FlowVO>> flowResp = storeFlowApi.getFlowList(conQuery);
                logger.error("根据参数合同id-{}，in_out_flag-{}, in_out_type-{}, source_bill_type_code-{}查询对应的混凝土验收单结果：{}",
                        vo.getContractId(), 1, 30, "BT220224000000004", JSONObject.toJSONString(flowResp));
                if(flowResp.isSuccess() && CollectionUtils.isNotEmpty(flowResp.getData())) {
                    honourMny = flowResp.getData().stream().map(FlowVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                break;
            default:
                break;
        }
        return honourMny;
    }

    @Override
    public CommonResponse<IPage<com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO>> querySumContract(QueryParam param) {
        logger.info("入参打印_map:"+JSONObject.toJSONString(param));
        // 分页
        int Index = param.getPageIndex();
        int Size = param.getPageSize();
        long pageIndex = Index;
        long pageSize = Size;
        // 排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        String orderName = "";
        String orderValue = "";
        String order1 = orderMap.get("contractMny") == null ? "" : orderMap.get("contractMny").toString();
        String order2 = orderMap.get("lastSignDate") == null ? "" : orderMap.get("lastSignDate").toString();

        Long suplyId = param.getParams().get("suplyId") == null ? null : (Long) param.getParams().get("suplyId").getValue();
        if(!StringUtils.isEmpty(order1)){
            orderName = "contractMny";
            orderValue = order1;
        }else{
            orderName = "lastSignDate";
            orderValue = order2;
        }

        // 组织本下
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = orgApi.findChildrenByParentId(orgId);
        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        logger.info("orgIdList:"+orgIdList);


        Map<String, Parameter> params = param.getParams();
        // 企业/个人
        Parameter personalParameter = params.get("personal");
        String personal = "";
        if(null != personalParameter){
            personal = personalParameter.getValue().toString();
        }
        // 等级
        Parameter gradeIdParameter = params.get("grade_id");
        String grade_id = "";
        if(null != gradeIdParameter){
            grade_id = gradeIdParameter.getValue().toString();
        }
        // 供应商类别
        Parameter supplyTypeParameter = params.get("supply_type");
        List<String> supply_type = new ArrayList<>();
        if(null != supplyTypeParameter){
            String supplyTypeStr = supplyTypeParameter.getValue().toString();
            String[] split = supplyTypeStr.split(",");
            supply_type = Arrays.asList(split);
        }
        // 处置状态
        Parameter punishTypeParameter = params.get("punish_type");
        String punish_type = "";
        if(null != punishTypeParameter){
            punish_type = punishTypeParameter.getValue().toString();
        }

        // 模糊搜索
        String searchText = param.getSearchText();
        List<String> searchTexts = new ArrayList<>();
        searchTexts.add("code"); //供应商编号
        searchTexts.add("area"); //地区
        searchTexts.add("name");     //供应商名称
        searchTexts.add("tax_payer_identifier");     //证件号

        searchTexts.add("material_content");     //物资供货内容名称
        searchTexts.add("equipment_content");     //设备供货内容
        searchTexts.add("major_content");     //专业分包供货内容
        searchTexts.add("labor_content");     //劳务分包供货内容
        searchTexts.add("sub_content");     //分包班组供货内容
        searchTexts.add("other_content");     //其他供货内容
        searchTexts.add("revolv_material_content");     //周转材供货内容

        // 数据条数
        Long queryCount = contractPoolMapper.queryCount(suplyId, orgIdList, orderName, orderValue
                , personal, grade_id, supply_type, punish_type, searchText, searchTexts);
        logger.info("查询条数成功:"+queryCount);
        List<com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO> supplierVOS = contractPoolMapper.queryContractInfo(suplyId, orgIdList, orderName, orderValue
        ,personal,grade_id,supply_type,punish_type,searchText,searchTexts, (pageIndex - 1) * pageSize, pageSize);
        // 查询实际付款金额 并赋值
        Map<String,List<Long>> paramMap = new HashMap<>();
        List<Long> supplierIds = new ArrayList<>();
        supplierVOS.forEach(item->{
            supplierIds.add(item.getSuplyId());
        });
        paramMap.put("suplyIds",supplierIds);
        paramMap.put("orgIds",orgIdList);
        CommonResponse<Map<Long, BigDecimal>> mapCommonResponse = paymentApplyApi.querySumMny(paramMap);
        logger.info("mapCommonResponse:"+JSONObject.toJSONString(mapCommonResponse));
        CommonResponse<Map<Long, BigDecimal>> mapCommonResponse1 = checkSupplierApi.queryTotalBranch(paramMap);
        logger.info("mapCommonResponse1:"+JSONObject.toJSONString(mapCommonResponse1));
        if(mapCommonResponse.isSuccess() && mapCommonResponse1.isSuccess()){
            Map<Long, BigDecimal> data = mapCommonResponse.getData();
            Map<Long, BigDecimal> data1 = mapCommonResponse1.getData();
            supplierVOS.forEach(item->{
                item.setActualMny(data.get(item.getSuplyId()));
                item.setTotalBranch(data1.get(item.getSuplyId()));
            });
        }
        IPage<com.ejianc.business.contractbase.pool.contractpool.vo.SupplierVO> page = new Page<>(pageIndex, pageSize,queryCount);
        // 查询异常等级
        Map<Long,String> abnormalMap = new HashMap<>();
        CommonResponse<List<AbnormalVO>> listCommonResponse = abnormalApi.queryAbnormal();
        if(listCommonResponse.isSuccess() && listCommonResponse.getData() != null){
            List<AbnormalVO> data = listCommonResponse.getData();
            data.forEach(item->{
                abnormalMap.put(item.getId(),item.getName());
            });
        }
        supplierVOS.forEach(item->{
            String allContent = "";
            if(!StringUtils.isEmpty(item.getMaterialContent())){
                allContent = allContent+item.getMaterialContent()+",";
            }
            if(!StringUtils.isEmpty(item.getEquipmentContent())){
                allContent = allContent+item.getEquipmentContent()+",";
            }
            if(!StringUtils.isEmpty(item.getMajorContent())){
                allContent = allContent+item.getMajorContent()+",";
            }
            if(!StringUtils.isEmpty(item.getLaborContent())){
                allContent = allContent+item.getLaborContent()+",";
            }

            if(!StringUtils.isEmpty(item.getSubContent())){
                allContent = allContent+item.getSubContent()+",";
            }
            if(!StringUtils.isEmpty(item.getOtherContent())){
                allContent = allContent+item.getOtherContent()+",";
            }
            if(!StringUtils.isEmpty(item.getRevolvMaterialContent())){
                allContent = allContent+item.getRevolvMaterialContent()+",";
            }
            if(!StringUtils.isEmpty(item.getConsultContent())){
                allContent = allContent+item.getConsultContent()+",";
            }
            item.setAllContent(allContent);
            if(null != item.getPunishType()){
                item.setPunishTypeStr(abnormalMap.get(item.getPunishType()));
            }
        });
        page.setRecords(supplierVOS);
        return CommonResponse.success(page);
    }

    /**
     * 填充单据详情地址
     *
     * @param saveEntity
     */
    private String findDetailUrl(ContractPoolEntity saveEntity) {
        List<String> sourceTypes = new ArrayList<>();
        sourceTypes.add(saveEntity.getSourceType()+"Pc");
        sourceTypes.add(saveEntity.getSourceType()+"Mobile");
        if(null == saveEntity.getId()) {
            saveEntity.setId(saveEntity.getSourceId());
        }

        //合同来源类型不为空
        Map<String, String> urlMap = billUrlDictService.getDictMapBySourceTypes(sourceTypes);
        if(MapUtils.isNotEmpty(urlMap)) {
            //不覆盖已有的详情地址
            if(StringUtils.isBlank(saveEntity.getPcCardUrl()) &&  null != urlMap.get(saveEntity.getSourceType()+"Pc")) {
                saveEntity.setPcCardUrl(urlMap.get(saveEntity.getSourceType()+"Pc"));
            }
            if(StringUtils.isBlank(saveEntity.getMobileCardUrl()) && null != urlMap.get(saveEntity.getSourceType()+"Mobile")) {
                saveEntity.setMobileCardUrl(urlMap.get(saveEntity.getSourceType()+"Mobile"));
            }
        } else {
            logger.info("根据合同来源类型-[{}]未获取到合同对应的详情地址信息，请检查字典表配置！！！", saveEntity.getSourceType());
        }

        if(StringUtils.isBlank(saveEntity.getSourceTypeName())) {
            saveEntity.setSourceTypeName(ContractTypeEnum.getByCode(saveEntity.getSourceType()).getTypeName());
        }
        if(null == saveEntity.getAddType()) {
            saveEntity.setAddType(1); //业务系统推送
        }
        TemplateCategoryEntity category = templateCategoryMapper.selectById(saveEntity.getCategoryId());
        if(null == category) {
            logger.error("合同-【{}】没有匹配的合同分类数据！", JSONObject.toJSON(saveEntity));
            return "同步合同池失败，没有匹配的合同分类";
        }
        saveEntity.setCategoryName(category.getCategoryName());
        saveEntity.setCategoryProperty(category.getCategoryProperty());

        return null;
    }

    private ContractPoolEntity selectBySourceId(Long sourceId) {
        QueryWrapper<ContractPoolEntity> query = new QueryWrapper();
        query.eq("source_id", sourceId)
                .eq("tenant_id", InvocationInfoProxy.getTenantid());
        ContractPoolEntity main = super.getOne(query);
        if(null != main) {
            List<ContractSubPaymentNodeEntity> subList = contractSubPaymentNodeService.listByPid(main.getId());
            if(CollectionUtils.isNotEmpty(subList)) {
                main.setContractSubPaymentNodeList(subList);
            }
        }
        return main;
    }
    
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    // 数据导入
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 用于存储从组织查询到的数据，key为当前行的所属组织，value为查询到的组织数据
        Map<String, OrgVO> orgVOMap = new HashMap<>();
        // 用于存储从项目池查询到的数据，key为 当前行的项目名称 ，value为查询到的项目池数据
        Map<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<>();
        // 用于存储从合同大类表查询到的数据，key为 当前行的 合同大类+&+合同类别，value为查询到的合同大类数据
        Map<String, TemplateCategoryEntity> categoryMap = new HashMap<>();
        // 用于存储合同编码为空的数据查询到的合同数据，key为 当前行的合同名称
        Map<String, ContractPoolEntity> contractPoolVoNoCodeMap = new HashMap<>();
        // 用于存储从供应商查询到的数据，key为 当前行的合同乙方 ，value为查询到的供应商数据
        Map<String, SupplierVO> supplierVOMap = new HashMap<>();
        // 用于存储从组织查询到的数据-用于获取当前项目所在项目部数据，key为 当前行的项目所在项目部id ，value为查询到的组织数据
        Map<String, OrgVO> projectOrgVoMap = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            if (mf == null) {
                throw new BusinessException("导入的文件中没有数据");
            }
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractPoolVO> successList = new ArrayList<>();
            List<ImportContractPoolVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 27) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                // 从自定义档案接口查询计价方式并封装成map
                Map<String, String> defMap = new HashMap<>();
                Map<String, Object> defParamMap = new HashMap<>();
                defParamMap.put("tenantId", tenantid);
                String defCondition = JSONObject.toJSONString(defParamMap);
                CommonResponse<List<Map<String, Object>>> defRes = defdocApi.queryDetailListByDefdocCode("pricing_type", defCondition);
                if (defRes.isSuccess() && defRes.getData() != null) {
                    List<Map<String, Object>> defList = defRes.getData();
                    defMap = defList.stream().collect(Collectors.toMap(item -> item.get("name") == null ? "" : item.get("name").toString(), item -> item.get("id") == null ? "" : item.get("id").toString()));
                }
                for (int i = 1; i < result.size(); i++) {
                    Long orgIdP = 0L;
                    List<String> datas = result.get(i);
                    ImportContractPoolVO detailVO = new ImportContractPoolVO();
                    // 从Excel拿到的数据
                    String parentOrgNameEx = datas.get(0);// 所属组织，必填项，与【组织管理】“组织名称”进行匹配
                    detailVO.setParentOrgName(parentOrgNameEx);
                    String contractCodeEx = datas.get(1);// 合同编码，非必填
                    detailVO.setContractCode(contractCodeEx);
                    String contractNameEx = datas.get(2);// 合同名称，必填项
                    detailVO.setContractName(contractNameEx);
                    String purchaseTypeNameEx = datas.get(3);// 是否集采，必填项，只能录入“是”或“否”
                    detailVO.setPurchaseTypeName(purchaseTypeNameEx);
                    String projectNameEx = datas.get(4);// 项目名称，必填项，与【项目池】的“项目名称”进行匹配
                    detailVO.setProjectName(projectNameEx);
                    String contractPropertyNameEx = datas.get(5);// 属性类别，必填项，只能录入“收入”、“支出”，如果不是，需要提示
                    detailVO.setContractPropertyName(contractPropertyNameEx);
                    String categoryBigEx = datas.get(6);// 合同大类，必填项，属性类别与合同大类必须匹配
                    detailVO.setCategoryProperty(categoryBigEx);
                    String categoryNameEx = datas.get(7);// 合同类别，必填项，合同类别与合同大类必须匹配
                    detailVO.setCategoryName(categoryNameEx);
                    String supplementFlagNameEx = datas.get(8);// 是否补充协议，必填项，只能录入“是”或“否”
                    detailVO.setSupplementFlagName(supplementFlagNameEx);
                    String mainContractNameEx = datas.get(9);// 主合同名称，如果“是否补充协议”为“是”，则“主合同名称”必填，与【合同池】的“合同名称”进行匹配
                    detailVO.setMainContractName(mainContractNameEx);
                    String performanceStatusNameEx = datas.get(10);// 合同状态，必填项，只能录入“履约中”、“已封账”、“已解除”
                    detailVO.setPerformanceStatusName(performanceStatusNameEx);
                    String partyaNameEx = datas.get(11);// 合同甲方，必填项，与【客户库】的“客户名称”进行匹配，如果匹配多了，就提示
                    detailVO.setPartyaName(partyaNameEx);
                    String partybNameEx = datas.get(12);// 合同乙方，必填项，与【供应商库】的“供应商名称”进行匹配，如果匹配多了，就提示
                    detailVO.setPartybName(partybNameEx);
                    String partycNameEx = datas.get(13);// 合同丙方，非必填
                    detailVO.setPartycName(partycNameEx);
                    String joinPartyNameEx = datas.get(14);// 联合体方，非必填
                    detailVO.setJoinPartyName(joinPartyNameEx);
                    String signDateStrEx = datas.get(15);// 签订日期，必填项，日期
                    String signPlaceEx = datas.get(16);// 签订地点，非必填
                    detailVO.setSignPlace(signPlaceEx);
                    String taxRateEx = datas.get(17);// 税率，数值，必填项，大于等于0，保留2位小数
                    detailVO.setTaxRateStr(taxRateEx);
                    String baseTaxMnyEx = datas.get(18);// 合同签订金额，数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setBaseTaxMnyStr(baseTaxMnyEx);
                    String baseMnyEx = datas.get(19);// 合同签订金额（无税），数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setBaseMnyStr(baseMnyEx);
                    String contractTaxMnyEx = datas.get(20);// 合同总金额，数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setContractTaxMnyStr(contractTaxMnyEx);
                    String contractMnyEx = datas.get(21);// 合同总金额（无税），数值，必填项，大于等于0，数据库保留8位小数
                    detailVO.setContractMnyStr(contractMnyEx);
                    String pricingTypeNameEx = datas.get(22);// 计价方式，必填项，只能录入：固定单价、固定总价、可调价格
                    detailVO.setPricingType(pricingTypeNameEx);
                    String taxCalcTypeNameEx = datas.get(23);// 计税方式名称，必填项，只能录入：一般计税、简易征收
                    detailVO.setTaxCalcTypeName(taxCalcTypeNameEx);
                    String contractStartDateStrEx = datas.get(24);// 合同开工日期，非必填，日期
                    String contractFinishDateStrEx = datas.get(25);// 合同竣工日期，非必填，日期
                    String memoEx = datas.get(26);// 备注，非必填
                    detailVO.setMemo(memoEx);

                    // 所属组织
                    if (StringUtils.isBlank(parentOrgNameEx)) {
                        detailVO.setErrorMessage("所属组织不可为空");
                    } else {
                        // 与【组织管理】“组织名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(parentOrgNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                OrgVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据所属组织查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    orgVOMap.put(parentOrgNameEx, orgVO);
                                    // 封装数据
                                    orgIdP = orgVO.getId();
                                    detailVO.setParentOrgId(orgVO.getId());
                                    detailVO.setParentOrgCode(orgVO.getCode());
                                    detailVO.setParentOrgName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据所属组织查询数据失败");
                            }
                        } else {
                            OrgVO orgVO = orgVOMap.get(parentOrgNameEx);
                            detailVO.setParentOrgId(orgVO.getId());
                            detailVO.setParentOrgCode(orgVO.getCode());
                            detailVO.setParentOrgName(orgVO.getName());
                        }
                    }
                    // 合同名称
                    if (StringUtils.isBlank(contractNameEx)) {
                        detailVO.setErrorMessage("合同名称不可为空");
                    } else {
                        detailVO.setContractName(contractNameEx);
                    }
                    detailVO.setContractCode(contractCodeEx);
                    // 是否集采
                    if (StringUtils.isBlank(purchaseTypeNameEx)) {
                        detailVO.setErrorMessage("是否集采不可为空");
                    } else {
                        if ("是".equals(purchaseTypeNameEx)) {
                            detailVO.setPurchaseType(2);
                        } else if ("否".equals(purchaseTypeNameEx)) {
                            detailVO.setPurchaseType(1);
                        } else {
                            detailVO.setErrorMessage("是否集采填写不正确");
                        }
                    }

                    // 项目名称
                    if (StringUtils.isBlank(projectNameEx)) {
                        detailVO.setErrorMessage("项目名称不可为空");
                    } else {
                        // 优先查询缓存map
                        if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx) == null) {
                            CommonResponse<List<ProjectPoolSetVO>> projectVOListRes = projectPoolApi.queryProjectListByNameAndTenantId(projectNameEx, tenantid);
                            if (projectVOListRes.isSuccess()) {
                                List<ProjectPoolSetVO> projectVOList = projectVOListRes.getData();
                                if (CollectionUtils.isEmpty(projectVOList)) {
                                    detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                } else {
                                    if (projectVOList.size() == 1) {
                                        // 存储到缓存map
                                        ProjectPoolSetVO projectPoolSetVO = projectVOList.get(0);
                                        // 项目所在项目部
                                        Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                        if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                            // 缓存map为空或无当前行数据，调用接口查询
                                            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.detailById(projectDepartmentId);
                                            if (orgVOCommonResponse.isSuccess()) {
                                                OrgVO orgVO = orgVOCommonResponse.getData();
                                                if (orgVO == null) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    // 存入缓存map
                                                    projectOrgVoMap.put(projectDepartmentId.toString(), orgVO);
                                                    // 封装数据
                                                    String innerCode = orgVO.getInnerCode();
                                                    if (StringUtils.isEmpty(innerCode)) {
                                                        detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                                    } else {
                                                        List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                        if (!innerCodes.contains(orgIdP)) {
                                                            detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                        } else {
                                                            detailVO.setOrgId(orgVO.getId());
                                                            detailVO.setOrgCode(orgVO.getCode());
                                                            detailVO.setOrgName(orgVO.getName());
                                                        }
                                                    }
                                                }
                                            } else {
                                                detailVO.setErrorMessage("根据项目名称和编码查询所在项目部信息失败");
                                            }
                                        } else {
                                            // 缓存map有当前数据
                                            OrgVO orgVO = projectOrgVoMap.get(projectDepartmentId.toString());
                                            String innerCode = orgVO.getInnerCode();
                                            if (StringUtils.isEmpty(innerCode)) {
                                                detailVO.setErrorMessage("根据项目名称和项目编码查询所属组织失败");
                                            } else {
                                                List<Long> innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                if (!innerCodes.contains(orgIdP)) {
                                                    detailVO.setErrorMessage("当前项目名称和项目编码所在的项目不在所属组织下");
                                                } else {
                                                    detailVO.setOrgId(orgVO.getId());
                                                    detailVO.setOrgCode(orgVO.getCode());
                                                    detailVO.setOrgName(orgVO.getName());
                                                }
                                            }
                                        }
                                        projectPoolVoMap.put(projectNameEx, projectPoolSetVO);
                                        // 封装数据
                                        detailVO.setProjectId(projectPoolSetVO.getId());
                                        detailVO.setProjectCode(projectPoolSetVO.getCode());
                                        detailVO.setProjectName(projectPoolSetVO.getName());
                                    } else {
                                        detailVO.setErrorMessage("根据项目名称查询不到项目信息");
                                    }
                                }
                            } else {
                                detailVO.setErrorMessage("根据项目名称查询项目失败");
                            }
                        } else {
                            ProjectPoolSetVO projectPoolSetVO = projectPoolVoMap.get(projectNameEx);
                            detailVO.setProjectId(projectPoolSetVO.getId());
                            detailVO.setProjectCode(projectPoolSetVO.getCode());
                            detailVO.setProjectName(projectPoolSetVO.getName());
                        }
                    }

                    // 属性类别
                    if (StringUtils.isBlank(contractPropertyNameEx)) {
                        detailVO.setErrorMessage("属性类别不可为空");
                    } else {
                        if ("收入".equals(contractPropertyNameEx)) {
                            detailVO.setContractProperty(1);
                        } else if ("支出".equals(contractPropertyNameEx)) {
                            detailVO.setContractProperty(0);
                        } else {
                            detailVO.setErrorMessage("属性类别填写不正确");
                        }
                    }

                    // 合同大类和合同类别
                    if (StringUtils.isBlank(categoryBigEx) || StringUtils.isBlank(categoryNameEx)) {
                        detailVO.setErrorMessage("合同大类和合同类别不可为空");
                    } else {
                        String categoryBigCode = getCategoryBigCode(categoryBigEx);
                        if (StringUtils.isBlank(categoryBigCode)) {
                            detailVO.setErrorMessage("合同大类填写不正确");
                        } else {
                            // 判断属性类别判断合同大类是否匹配
                            if ("施工合同".equals(categoryBigEx) || "其他收入合同".equals(categoryBigEx)) {
                                // 当前合同大类属于收入
                                if ("支出".equals(contractPropertyNameEx)) {
                                    detailVO.setErrorMessage("合同大类和合同类别不匹配");
                                }
                            } else {
                                // 当前合同大类属于支出
                                if ("收入".equals(contractPropertyNameEx)) {
                                    detailVO.setErrorMessage("合同大类和合同类别不匹配");
                                }
                            }
                            // 判断合同大类和合同类别是否匹配
                            // 优先从缓存map中拿数据，减少数据库查询次数
                            if (MapUtils.isEmpty(categoryMap) || categoryMap.get(categoryBigEx + "&" + categoryNameEx) == null) {
                                // 缓存map为空或无当前行数据，调用接口查询数据
                                QueryWrapper<TemplateCategoryEntity> templateCategoryEntityQueryWrapper = new QueryWrapper<>();
                                templateCategoryEntityQueryWrapper
                                        .eq("category_name", categoryNameEx)
                                        .eq("category_property", categoryBigCode)
                                        .eq("dr", 0)
                                        .eq("tenant_id", tenantid);
                                List<TemplateCategoryEntity> templateCategoryEntityList = templateCategoryMapper.selectList(templateCategoryEntityQueryWrapper);
                                if (CollectionUtils.isEmpty(templateCategoryEntityList)) {
                                    detailVO.setErrorMessage("合同大类和合同类别不匹配");
                                } else if (templateCategoryEntityList.size() == 1) {
                                    TemplateCategoryEntity templateCategoryEntity = templateCategoryEntityList.get(0);
                                    // 存储到缓存map中
                                    categoryMap.put(categoryBigEx + "&" + categoryNameEx, templateCategoryEntity);
                                    // 封装数据
                                    detailVO.setCategoryId(templateCategoryEntity.getId());
                                    detailVO.setCategoryName(templateCategoryEntity.getCategoryName());
                                    detailVO.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                                } else {
                                    detailVO.setErrorMessage("根据合同大类和合同类型查询到多条数据");
                                }
                            } else {
                                TemplateCategoryEntity templateCategoryEntity = categoryMap.get(categoryBigEx + "&" + categoryNameEx);
                                detailVO.setCategoryId(templateCategoryEntity.getId());
                                detailVO.setCategoryName(templateCategoryEntity.getCategoryName());
                                detailVO.setCategoryProperty(templateCategoryEntity.getCategoryProperty());
                            }
                        }
                    }

                    // 是否补充协议
                    if (StringUtils.isBlank(supplementFlagNameEx)) {
                        detailVO.setErrorMessage("是否补充协议不可为空");
                    } else {
                        if ("是".equals(supplementFlagNameEx)) {
                            detailVO.setSupplementFlag(1);
                            // 是补充协议，此时主合同名称必填
                            if (StringUtils.isBlank(mainContractNameEx)) {
                                detailVO.setErrorMessage("主合同名称不可为空");
                            } else {
                                // 优先查询缓存map，减少数据库查询次数
                                if (MapUtils.isEmpty(contractPoolVoNoCodeMap) || contractPoolVoNoCodeMap.get(mainContractNameEx) == null) {
                                    // map为空或未查询到当前行数据，调用接口查询
                                    QueryWrapper<ContractPoolEntity> contractPoolEntityQueryWrapper = new QueryWrapper<>();
                                    contractPoolEntityQueryWrapper
                                            .eq("contract_name", mainContractNameEx)
                                            .eq("dr", 0)
                                            .eq("tenant_id", tenantid);
                                    List<ContractPoolEntity> contractPoolEntityList = contractPoolMapper.selectList(contractPoolEntityQueryWrapper);
                                    if (CollectionUtils.isEmpty(contractPoolEntityList)) {
                                        detailVO.setErrorMessage("根据主合同名称查询合同信息失败");
                                    } else {
                                        if (contractPoolEntityList.size() == 1) {
                                            ContractPoolEntity contractPoolEntity = contractPoolEntityList.get(0);
                                            // 存储到缓存map中
                                            contractPoolVoNoCodeMap.put(mainContractNameEx, contractPoolEntity);
                                            // 封装数据
                                            detailVO.setMainContractId(contractPoolEntity.getContractId());
                                            detailVO.setMainContractCode(contractPoolEntity.getContractCode());
                                            detailVO.setMainContractName(contractPoolEntity.getContractName());
                                        } else {
                                            detailVO.setErrorMessage("根据主合同名称查询合同信息失败");
                                        }
                                    }
                                } else {
                                    ContractPoolEntity contractPoolEntity = contractPoolVoNoCodeMap.get(mainContractNameEx);
                                    detailVO.setMainContractId(contractPoolEntity.getContractId());
                                    detailVO.setMainContractCode(contractPoolEntity.getContractCode());
                                    detailVO.setMainContractName(contractPoolEntity.getContractName());
                                }
                            }
                        } else if ("否".equals(supplementFlagNameEx)) {
                            detailVO.setSupplementFlag(0);
                        } else {
                            detailVO.setErrorMessage("是否补充协议填写不正确");
                        }
                    }

                    // 合同状态
                    if (StringUtils.isBlank(performanceStatusNameEx)) {
                        detailVO.setErrorMessage("合同状态不可为空");
                    } else {
                        switch (performanceStatusNameEx) {
                            case "履约中":
                                detailVO.setPerformanceStatus("2");
                                break;
                            case "已封账":
                                detailVO.setPerformanceStatus("3");
                                break;
                            case "已解除":
                                detailVO.setPerformanceStatus("4");
                                break;
                            default:
                                detailVO.setErrorMessage("合同状态填写填不正确");
                                break;
                        }
                    }

                    // 合同甲方
                    if (StringUtils.isBlank(partyaNameEx)) {
                        detailVO.setErrorMessage("合同甲方不可为空");
                    } else {
                        // 与【客户库】的“客户名称”进行匹配---目前甲方暂时使用组织的数据
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(partyaNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<OrgVO> orgVORes = orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                            if (orgVORes.isSuccess()) {
                                OrgVO orgVO = orgVORes.getData();
                                if (orgVO == null) {
                                    detailVO.setErrorMessage("根据合同甲方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    orgVOMap.put(partyaNameEx, orgVO);
                                    // 封装数据
                                    detailVO.setPartyaId(orgVO.getId());
                                    detailVO.setPartyaName(orgVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同甲方查询数据失败");
                            }
                        } else {
                            OrgVO orgVO = orgVOMap.get(partyaNameEx);
                            detailVO.setPartyaId(orgVO.getId());
                            detailVO.setPartyaName(orgVO.getName());
                        }
                    }
                    // 合同乙方
                    if (StringUtils.isBlank(partybNameEx)) {
                        detailVO.setErrorMessage("合同乙方不可为空");
                    } else {
                        // 与【供应商库】的“供应商名称”进行匹配
                        // 先从缓存map中查询，若map中有数据，优先从map中匹配，减少数据库查询次数
                        if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                            // 缓存map为空或当前map中尚未存储当前行的数据，则调用接口查询
                            CommonResponse<SupplierVO> supplierVORes = shareSupplierApi.findOneByName(partybNameEx, tenantid);
                            if (supplierVORes.isSuccess()) {
                                SupplierVO supplierVO = supplierVORes.getData();
                                if (supplierVO == null) {
                                    detailVO.setErrorMessage("根据合同乙方查询数据失败");
                                } else {
                                    // 将查询到的数据缓存到map中
                                    supplierVOMap.put(partybNameEx, supplierVO);
                                    // 封装数据
                                    detailVO.setPartybId(supplierVO.getId());
                                    detailVO.setPartybName(supplierVO.getName());
                                }
                            } else {
                                detailVO.setErrorMessage("根据合同乙方查询数据失败");
                            }
                        } else {
                            SupplierVO supplierVO = supplierVOMap.get(partybNameEx);
                            detailVO.setPartybId(supplierVO.getId());
                            detailVO.setPartybName(supplierVO.getName());
                        }
                    }
                    // 合同丙方
                    detailVO.setPartycName(partycNameEx);
                    // 联合体方
                    detailVO.setJoinPartyName(joinPartyNameEx);
                    // 签订日期
                    if (StringUtils.isBlank(signDateStrEx)) {
                        detailVO.setErrorMessage("签订日期不可为空");
                    } else {
                        try {
                            detailVO.setSignDate(HSSFDateUtil.getJavaDate(Double.parseDouble(signDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("签订日期填写不正确");
                        }
                    }
                    // 签订地点
                    detailVO.setSignPlace(signPlaceEx);
                    // 税率
                    if (StringUtils.isBlank(taxRateEx)) {
                        detailVO.setErrorMessage("税率不可为空");
                    } else {
                        try {
                            BigDecimal taxRate = new BigDecimal(taxRateEx);
                            if (taxRate.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("税率不可小于0");
                            } else {
                                detailVO.setTaxRate(taxRate);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("税率必须为数字");
                        }
                    }
                    // 合同签订金额
                    if (StringUtils.isBlank(baseTaxMnyEx)) {
                        detailVO.setErrorMessage("合同签订金额不可为空");
                    } else {
                        try {
                            BigDecimal baseTaxMny = new BigDecimal(baseTaxMnyEx);
                            if (baseTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("合同签订金额不可小于0");
                            } else {
                                detailVO.setBaseTaxMny(baseTaxMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同签订金额必须为数字");
                        }
                    }
                    // 合同签订金额（无税）
                    if (StringUtils.isBlank(baseMnyEx)) {
                        detailVO.setErrorMessage("合同签订金额（无税）不可为空");
                    } else {
                        try {
                            BigDecimal baseMny = new BigDecimal(baseMnyEx);
                            if (baseMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("合同签订金额（无税）不可小于0");
                            } else {
                                detailVO.setBaseMny(baseMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同签订金额（无税）必须为数字");
                        }
                    }
                    // 计算合同签订税额
                    try {
                        BigDecimal baseTax = new BigDecimal(baseTaxMnyEx).subtract(new BigDecimal(baseMnyEx));
                        if (baseTax.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("合同签订金额不可小于合同签订金额（无税）");
                        } else {
                            detailVO.setBaseTax(baseTax);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("计算合同签订税额失败，合同签订金额和合同签订金额（无税）不可为空且必须为数字");
                    }
                    // 合同总金额
                    if (StringUtils.isBlank(contractTaxMnyEx)) {
                        detailVO.setErrorMessage("合同总金额不可为空");
                    } else {
                        try {
                            BigDecimal contractTaxMny = new BigDecimal(contractTaxMnyEx);
                            if (contractTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("合同总金额不可小于0");
                            } else {
                                detailVO.setContractTaxMny(contractTaxMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同总金额必须为数字");
                        }
                    }
                    // 合同总金额（无税）
                    if (StringUtils.isBlank(contractMnyEx)) {
                        detailVO.setErrorMessage("合同总金额（无税）不可为空");
                    } else {
                        try {
                            BigDecimal contractMny = new BigDecimal(contractMnyEx);
                            if (contractMny.compareTo(BigDecimal.ZERO) < 0) {
                                detailVO.setErrorMessage("合同总金额（无税）不可小于0");
                            } else {
                                detailVO.setContractMny(contractMny);
                            }
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同总金额（无税）必须为数字");
                        }
                    }
                    // 计算合同总税额
                    try {
                        BigDecimal contractTax = new BigDecimal(contractTaxMnyEx).subtract(new BigDecimal(contractMnyEx));
                        if (contractTax.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("合同总金额不可小于合同总金额（无税）");
                        } else {
                            detailVO.setContractTax(contractTax);
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMessage("计算合同总税额失败，合同总金额和合同总金额（无税）不可为空且必须为数字");
                    }
                    // 计价方式
                    if (StringUtils.isBlank(pricingTypeNameEx)) {
                        detailVO.setErrorMessage("计价方式不可为空");
                    } else {
                        String pricingTypeIdStr = defMap.get(pricingTypeNameEx);
                        Long pricingTypeId = null;
                        if (StringUtils.isNotBlank(pricingTypeIdStr)) {
                            pricingTypeId = Long.parseLong(pricingTypeIdStr);
                        }
                        switch (pricingTypeNameEx) {
                            case "固定单价":
                                detailVO.setPricingType(pricingTypeNameEx);
                                detailVO.setPricingTypeId(pricingTypeId);
                                break;
                            case "固定总价":
                                detailVO.setPricingType(pricingTypeNameEx);
                                detailVO.setPricingTypeId(pricingTypeId);
                                break;
                            case "可调单价":
                                detailVO.setPricingType(pricingTypeNameEx);
                                detailVO.setPricingTypeId(pricingTypeId);
                                break;
                            case "费率合同":
                                detailVO.setPricingType(pricingTypeNameEx);
                                detailVO.setPricingTypeId(pricingTypeId);
                                break;
                            default:
                                detailVO.setErrorMessage("计价方式填写不正确");
                                break;
                        }
                    }
                    // 计税方式
                    if (StringUtils.isBlank(taxCalcTypeNameEx)) {
                        detailVO.setErrorMessage("计税方式不可为空");
                    } else {
                        if (!"一般计税".equals(taxCalcTypeNameEx) && !"简易征收".equals(taxCalcTypeNameEx)) {
                            detailVO.setErrorMessage("计税方式填写不正确");
                        }
                        detailVO.setTaxCalcTypeName(taxCalcTypeNameEx);
                    }
                    // 合同开工日期
                    if (StringUtils.isNotBlank(contractStartDateStrEx)) {
                        try {
                            detailVO.setContractStartDate(HSSFDateUtil.getJavaDate(Double.parseDouble(contractStartDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同开工日期填写不正确");
                        }
                    }
                    // 合同竣工日期
                    if (StringUtils.isNotBlank(contractFinishDateStrEx)) {
                        try {
                            detailVO.setContractFinishDate(HSSFDateUtil.getJavaDate(Double.parseDouble(contractStartDateStrEx)));
                        } catch (Exception e) {
                            detailVO.setErrorMessage("合同竣工日期填写不正确");
                        }
                    }
                    // 备注
                    if (StringUtils.isNotBlank(memoEx) && memoEx.length() > 100) {
                        detailVO.setErrorMessage("备注长度不可大于100");
                    } else {
                        detailVO.setMemo(memoEx);
                    }
                    // 封装返回的数据
                    if (StringUtils.isBlank(detailVO.getErrorMessage())) {
                        // 导入的数据默认为手动新增
                        detailVO.setHandleType(1);
                        detailVO.setHandleTypeName("是");
                        successList.add(detailVO);
                    } else {
                        errorList.add(detailVO);
                    }
                }
            }
            // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);

            // 拼接入库数据并入库
            Date createTime = new Date();
            UserContext userContext = sessionManager.getUserContext();
            String userCode = "";
            if (userContext != null) {
                userCode = userContext.getUserCode();
            }
            List<ContractPoolVO> sucVoList = BeanMapper.mapList(successList, ContractPoolVO.class);
            if (CollectionUtils.isNotEmpty(sucVoList)) {
                for (ContractPoolVO vo : sucVoList) {
                    vo.setCreateTime(createTime);
                    vo.setCreateUserCode(userCode);
                    long contractId = IdWorker.getId();
                    vo.setContractId(contractId);
                    vo.setSourceId(contractId);
                    if (StringUtils.isBlank(vo.getContractCode())) {
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, tenantid, vo);
                        CommonResponse<String> billCodeRes = billCodeApi.generateBillCode(billCodeParam);
                        if(billCodeRes.isSuccess()) {
                            vo.setContractCode(billCodeRes.getData());
                        }else{
                            throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                        }
                    }
                }
                List<ContractPoolEntity> sucEntityList = BeanMapper.mapList(sucVoList, ContractPoolEntity.class);
                saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
            }
            return CommonResponse.success(json);
        }
    }

    private String getCategoryBigCode(String categoryName) {
        String categoryCode = "";
        if (StringUtils.isBlank(categoryName)) {
            return categoryCode;
        }
        switch (categoryName) {
            case "周转材合同":
                categoryCode = "rmat";
                break;
            case "施工合同":
                categoryCode = "contraction";
                break;
            case "专业分包合同":
                categoryCode = "proSub";
                break;
            case "劳务分包合同":
                categoryCode = "laborSub";
                break;
            case "物资采购合同":
                categoryCode = "contractMaterial";
                break;
            case "混凝土合同":
                categoryCode = "contractConcrete";
                break;
            case "收入合同":
                categoryCode = "contractIn";
                break;
            case "支出合同":
                categoryCode = "contractOut";
                break;
            case "其他收入合同":
                categoryCode = "otherIn";
                break;
            case "其他支出合同":
                categoryCode = "contractOther";
                break;
            case "设备租赁合同":
                categoryCode = "equipmentRent";
                break;
            case "设备采购合同":
                categoryCode = "equipmentPurchase";
                break;
            case "临时设备合同":
                categoryCode = "tempEquip";
                break;
            case "安拆合同":
                categoryCode = "contractAC";
                break;
            case "辅料中心周转材租赁合同":
                categoryCode = "assistrmat";
                break;
            case "辅料中心周转材采购合同":
                categoryCode = "assistmaterial";
                break;
            default:
                break;
        }
        return categoryCode;
    }

    public ContractPoolVO queryContractPool(String param) {
        logger.info("ContractPoolServiceImpl--queryContractPool()--查询合同池的合同--begin--入参：param={}", param);
        List<ContractPoolVO> contractPoolVOList = queryContractPoolList(param);
        if (CollectionUtils.isEmpty(contractPoolVOList)) {
            logger.info("未查询到数据");
            return new ContractPoolVO();
        }
        if (contractPoolVOList.size() > 1) {
            logger.error("查询到多条数据，查询结果：{}", JSONObject.toJSONString(contractPoolVOList));
            throw new BusinessException("查询多条数据");
        }
        ContractPoolVO contractPoolVO = contractPoolVOList.get(0);
        logger.info("ContractPoolServiceImpl--queryContractPool()--查询合同池的合同--end--返回结果：result={}", JSONObject.toJSONString(contractPoolVO));
        return contractPoolVO;
    }

    public List<ContractPoolVO> queryContractPoolList(String param) {
        logger.info("ContractPoolServiceImpl--queryContractPoolList()--查询合同池的合同列表--begin--入参：param={}", param);
        QueryParam queryParam = getQueryParam(param);
        if (queryParam == null) {
            logger.info("入参为空，返回空结果集");
            return new ArrayList<ContractPoolVO>();
        }
        List<ContractPoolEntity> contractPoolEntityList = super.queryList(queryParam);
        logger.info("ContractPoolServiceImpl--queryContractPoolList()--查询合同池的合同列表--end--返回结果：result={}", JSONObject.toJSONString(contractPoolEntityList));
        return BeanMapper.mapList(contractPoolEntityList, ContractPoolVO.class);
    }

    private QueryParam getQueryParam(String param) {
        if (StringUtils.isBlank(param)) {
            return null;
        }
        QueryParam queryParam = new QueryParam();
        Map<String, Parameter> params = queryParam.getParams();
        JSONObject paramJson = JSONObject.parseObject(param);
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 租户隔离
        params.put("tenantId", new Parameter(QueryParam.EQ, tenantid));
        // 所属组织
        String parentOrgIdStr = paramJson.getString("parentOrgId");
        if (StringUtils.isNotBlank(parentOrgIdStr)) {
            if (parentOrgIdStr.contains(",")) {
                List<Long> parentOrgIdList = Arrays.stream(parentOrgIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("parentOrgId", new Parameter(QueryParam.IN, parentOrgIdList));
            } else {
                params.put("parentOrgId", new Parameter(QueryParam.EQ, Long.parseLong(parentOrgIdStr)));
            }
        }
        // 所属项目部
        String orgIdStr = paramJson.getString("orgId");
        if (StringUtils.isNotBlank(orgIdStr)) {
            if (orgIdStr.contains(",")) {
                List<Long> orgIdList = Arrays.stream(orgIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("orgId", new Parameter(QueryParam.IN, orgIdList));
            } else {
                params.put("orgId", new Parameter(QueryParam.EQ, Long.parseLong(orgIdStr)));
            }
        }
        // 合同id
        String contractIdStr = paramJson.getString("contractId");
        if (StringUtils.isNotBlank(contractIdStr)) {
            if (contractIdStr.contains(",")) {
                List<Long> contractIdList = Arrays.stream(contractIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("contractId", new Parameter(QueryParam.IN, contractIdList));
            } else {
                params.put("contractId", new Parameter(QueryParam.EQ, Long.parseLong(contractIdStr)));
            }
        }
        // 合同名称
        String contractNameStr = paramJson.getString("contractName");
        if (StringUtils.isNotBlank(contractNameStr)) {
            if (contractNameStr.contains(",")) {
                params.put("contractId", new Parameter(QueryParam.IN, contractNameStr.split(",")));
            } else {
                params.put("contractId", new Parameter(QueryParam.EQ, contractNameStr));
            }
        }
        // 合同编码
        String contractCodeStr = paramJson.getString("contractCode");
        if (StringUtils.isNotBlank(contractCodeStr)) {
            if (contractCodeStr.contains(",")) {
                params.put("contractCode", new Parameter(QueryParam.IN, contractCodeStr.split(",")));
            } else {
                params.put("contractCode", new Parameter(QueryParam.EQ, contractCodeStr));
            }
        }
        // 合同属性：1-收入，0支出
        String contractPropertyStr = paramJson.getString("contractProperty");
        if (StringUtils.isNotBlank(contractPropertyStr)) {
            params.put("contractProperty", new Parameter(QueryParam.EQ, Integer.parseInt(contractPropertyStr)));
        }
        // 合同来源
        String sourceTypeStr = paramJson.getString("sourceType");
        if (StringUtils.isNotBlank(sourceTypeStr)) {
            if (sourceTypeStr.contains(",")) {
                params.put("sourceType", new Parameter(QueryParam.IN, sourceTypeStr.split(",")));
            } else {
                params.put("sourceType", new Parameter(QueryParam.EQ, sourceTypeStr));
            }
        }
        // 合同履约状态
        String performanceStatusStr = paramJson.getString("performanceStatus");
        if (StringUtils.isNotBlank(performanceStatusStr)) {
            if (performanceStatusStr.contains(",")) {
                params.put("performanceStatus", new Parameter(QueryParam.IN, performanceStatusStr.split(",")));
            } else {
                params.put("performanceStatus", new Parameter(QueryParam.EQ, performanceStatusStr));
            }
        }
        // 项目id
        String projectIdStr = paramJson.getString("projectId");
        if (StringUtils.isNotBlank(projectIdStr)) {
            if (projectIdStr.contains(",")) {
                List<Long> projectIdList = Arrays.stream(projectIdStr.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                params.put("projectId", new Parameter(QueryParam.IN, projectIdList));
            } else {
                params.put("projectId", new Parameter(QueryParam.EQ, projectIdStr));
            }
        }
        // 项目名称
        String projectNameStr = paramJson.getString("projectName");
        if (StringUtils.isNotBlank(projectNameStr)) {
            if (projectNameStr.contains(",")) {
                params.put("projectName", new Parameter(QueryParam.IN, projectNameStr.split(",")));
            } else {
                params.put("projectName", new Parameter(QueryParam.EQ, projectNameStr));
            }
        }
        // 项目编码
        String projectCodeStr = paramJson.getString("projectCode");
        if (StringUtils.isNotBlank(projectCodeStr)) {
            if (projectCodeStr.contains(",")) {
                params.put("projectCode", new Parameter(QueryParam.IN, projectCodeStr.split(",")));
            } else {
                params.put("projectCode", new Parameter(QueryParam.EQ, projectCodeStr));
            }
        }
        // 是否补充协议(1:是，0：否)
        String supplementFlagStr = paramJson.getString("supplementFlag");
        if (StringUtils.isNotBlank(supplementFlagStr)) {
            params.put("supplementFlag", new Parameter(QueryParam.EQ, Integer.parseInt(supplementFlagStr)));
        }
        // 主合同id
        String mainContractIdStr = paramJson.getString("mainContractId");
        if (StringUtils.isNotBlank(mainContractIdStr)) {
            params.put("mainContractId", new Parameter(QueryParam.EQ, Integer.parseInt(mainContractIdStr)));
        }
        // 主合同名称
        String mainContractNameStr = paramJson.getString("mainContractName");
        if (StringUtils.isNotBlank(mainContractNameStr)) {
            params.put("mainContractName", new Parameter(QueryParam.EQ, Integer.parseInt(mainContractNameStr)));
        }
        // 主合同编码
        String mainContractCodeStr = paramJson.getString("mainContractCode");
        if (StringUtils.isNotBlank(mainContractCodeStr)) {
            params.put("mainContractCode", new Parameter(QueryParam.EQ, Integer.parseInt(mainContractCodeStr)));
        }
        return queryParam;
    }

    /**
     * 根据项目id查询当前项目下的 最新一条施工合同的合同金额 - 专业合同的合同金额的累计
     *
     * @param projectId
     * @return
     */
    @Override
    public BigDecimal queryContractionSubtractProTaxMny(Long projectId) {
        logger.info("contractbase---ContractPoolServiceImpl---queryContractionSubtractProTaxMny()---入参-projectId={}", projectId);
        BigDecimal contractionTaxMny = BigDecimal.ZERO;
        BigDecimal proTaxMny = BigDecimal.ZERO;
        Long tenantid = InvocationInfoProxy.getTenantid();
        // 拿到最新一条施工合同的合同金额
        QueryWrapper<ContractPoolEntity> cpWra = new QueryWrapper<>();
        cpWra.eq("dr", 0).eq("tenant_id", tenantid)
                .eq("project_id", projectId)
                .eq("source_type", ContractTypeEnum.施工合同.getTypeCode())
                .orderByDesc("create_time")
                .last("limit 1");
        cpWra.select("ifnull(contract_tax_mny, 0) as contractionTaxMny");
        Map<String, Object> contractionMap = super.getMap(cpWra);
        logger.info("查询当前项目下最新的施工合同的合同含税金额，查询结果={}", JSONObject.toJSONString(contractionMap));
        if (MapUtils.isNotEmpty(contractionMap)) {
            contractionTaxMny = contractionMap.get("contractionTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(contractionMap.get("contractionTaxMny").toString());
        }
        // 拿到专业合同的合同金额的累计
        cpWra = new QueryWrapper<ContractPoolEntity>();
        cpWra.eq("dr", 0).eq("tenant_id", tenantid)
                .eq("project_id", projectId)
                .eq("source_type", ContractTypeEnum.专业分包合同.getTypeCode());
        cpWra.select("sum(ifnull(contract_tax_mny, 0)) as proTaxMny");
        Map<String, Object> proMap = super.getMap(cpWra);
        logger.info("查询当前项目下所有专业分包合同的合同含税金额的累加值，查询结果={}", JSONObject.toJSONString(proMap));
        if (MapUtils.isNotEmpty(proMap)) {
            proTaxMny = proMap.get("proTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(proMap.get("proTaxMny").toString());
        }
        // 计算 施工合同金额 - 专业合同金额
        BigDecimal subtract = contractionTaxMny.subtract(proTaxMny);
        logger.info("contractbase---ContractPoolServiceImpl---queryContractionSubtractProTaxMny()---返回结果---当前项目下(施工合同含税金额 - 专业分包合同含税金额) = {}", JSONObject.toJSONString(subtract));
        return subtract;
    }

    @Override
    public List<ContractPoolEntity> queryMdmPage(QueryParam param) {
        Map<String, Object> condition = new HashMap<>();
        Parameter parameter = param.getParams().get("syncTime");
        if(parameter != null) {
            condition.put("syncTime", parameter.getValue());
        }
        parameter = param.getParams().get("contractProperty");
        if(parameter != null) {
            condition.put("contractProperty", parameter.getValue());
        }
        condition.put("pageIndex",(param.getPageIndex()-1)*500);
        condition.put("pageSize",param.getPageSize());

        List<ContractPoolEntity> poolEntities = contractPoolMapper.queryMdmPage(condition);
        return poolEntities;
    }

    @Override
    public BigDecimal calcTotalMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(contract_tax_mny) as totalMny");
        Map<String, BigDecimal> result = super.getMap(wrapper);
        return  null != result && null != result.get("totalMny") ? result.get("totalMny") : BigDecimal.ZERO;
    }
}
