/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.util.DateUtil;
import com.ejianc.business.contractbase.vo.enums.ContractFeeTypeEnum;
import com.ejianc.business.contractbase.vo.report.ContractSettleReportVO;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/conSettleReport/"})
public class ContractSettleReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private ISettlePoolService settlePoolService;
    @Autowired
    private ICostSettingApi costSettingApi;

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws ParseException {
        Map<String, Object> totalInfo;
        CommonResponse settingResp;
        JSONObject resp = new JSONObject();
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("projectId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate") || null == parameterMap.get("contractType")) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        String[] contractType = ((Parameter)parameterMap.get("contractType")).getValue().toString().split(",");
        paramMap.put("contractType", contractType);
        paramMap.put("conTypes", contractType.length > 1 ? "multiConType" : "oneConType");
        if (null != parameterMap.get("supplierName")) {
            paramMap.put("supplierName", ((Parameter)parameterMap.get("supplierName")).getValue());
        }
        if (null != parameterMap.get("contractFeeTypeName")) {
            paramMap.put("contractFeeTypeName", ((Parameter)parameterMap.get("contractFeeTypeName")).getValue());
        }
        if (!(settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId())).isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        if (null == setting) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8fdb\u884c\u6210\u672c\u5176\u95f4\u8bbe\u7f6e\uff01");
        }
        String startDate = ((Parameter)parameterMap.get("startDate")).getValue().toString();
        String endDate = ((Parameter)parameterMap.get("endDate")).getValue().toString();
        paramMap.put("projectId", ((Parameter)parameterMap.get("projectId")).getValue());
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)startDate));
            endDate = endDate + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate = startDate + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)startDate), "yyyy-MM-dd")), 1);
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", DateUtil.addDay(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)(Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-" + setting.getEndDay())), "yyyy-MM-dd")), 1));
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            startDate = startDate + "-01";
            endDate = endDate + "-" + DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            parameterMap.remove("startDate");
            parameterMap.remove("endDate");
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-01");
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-31");
        }
        if (null != parameterMap.get("contractCode")) {
            paramMap.put("contractCode", ((Parameter)parameterMap.get("contractCode")).getValue());
        }
        if (null != parameterMap.get("contractName")) {
            paramMap.put("contractName", ((Parameter)parameterMap.get("contractName")).getValue());
        }
        if (Integer.valueOf((totalInfo = this.settlePoolService.count(paramMap)).get("total").toString()) == 0) {
            resp.put("total", (Object)0);
            resp.put("records", new ArrayList());
            resp.put("current", (Object)queryParam.getPageIndex());
            resp.put("size", (Object)queryParam.getPageSize());
            resp.put("pages", (Object)0);
            resp.put("curTotalSettleMny", (Object)0);
            resp.put("curTotalSettleTaxMny", (Object)0);
            resp.put("totalSettleMnyThisYear", (Object)0);
            resp.put("totalSettleTaxMnyThisYear", (Object)0);
            resp.put("totalStartSettleMny", (Object)0);
            resp.put("totalStartSettleTaxMny", (Object)0);
            return CommonResponse.success((Object)resp);
        }
        Page page = new Page();
        page.setTotal(Long.valueOf(totalInfo.get("total").toString()).longValue());
        page.setSize((long)queryParam.getPageSize());
        page.setCurrent((long)queryParam.getPageIndex());
        resp = (JSONObject)BeanMapper.map((Object)page, JSONObject.class);
        paramMap.put("pageSize", queryParam.getPageSize());
        paramMap.put("startLine", queryParam.getPageIndex() - 1 < 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        this.logger.info("\u5408\u540c\u7ed3\u7b97\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        List<ContractSettleReportVO> rsList = this.settlePoolService.pageList(paramMap);
        HashMap<Long, ContractSettleReportVO> conIdMap = new HashMap<Long, ContractSettleReportVO>();
        HashMap<String, ContractSettleReportVO> conTypeMap = new HashMap<String, ContractSettleReportVO>();
        if (contractType.length > 1) {
            ArrayList<JSONObject> conTypeMapList = new ArrayList<JSONObject>();
            ArrayList<Long> condIds = new ArrayList<Long>();
            JSONObject tmp = null;
            for (ContractSettleReportVO item2 : rsList) {
                item2.setContractFeeTypeName(ContractFeeTypeEnum.getByCode((String)item2.getContractType()).getContractFeeTypeName());
                if (null != item2.getContractTaxMny()) {
                    item2.setContractTaxMnyInW(ComputeUtil.safeDiv((BigDecimal)item2.getContractTaxMny(), (BigDecimal)BigDecimal.valueOf(10000L)).setScale(2, RoundingMode.HALF_UP));
                }
                if (null != item2.getIncomeContractTaxMny()) {
                    item2.setCurConTypeRatioInIncomeCon(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)item2.getContractTaxMny(), (BigDecimal)item2.getIncomeContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                } else {
                    item2.setCurConTypeRatioInIncomeCon(BigDecimal.ZERO);
                }
                conTypeMap.put(item2.getContractType(), item2);
                for (String conId : item2.getContractIds().split(",")) {
                    tmp = new JSONObject();
                    tmp.put("contractId", (Object)conId);
                    tmp.put("contractType", (Object)item2.getContractType());
                    condIds.add(Long.valueOf(conId));
                    conTypeMapList.add(tmp);
                }
            }
            conTypeMap.putAll(rsList.stream().collect(Collectors.toMap(item -> item.getContractType(), item -> item)));
            paramMap.put("contractIds", new ArrayList());
            paramMap.put("contractTypeMap", conTypeMapList);
        } else {
            conIdMap.putAll(rsList.stream().collect(Collectors.toMap(item -> item.getContractId(), item -> item)));
            paramMap.put("contractIds", conIdMap.keySet());
        }
        this.logger.info("\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(paramMap));
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"paramJson", (Object)JSONObject.toJSONString(paramMap));
        CommonResponse payInfoResp = this.receiptAndPaymentRegisterApi.queryContractPayInfo((MultiValueMap)param);
        if (!payInfoResp.isSuccess()) {
            this.logger.error("\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff1a", (Object)JSONObject.toJSONString((Object)payInfoResp));
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
            ((List)payInfoResp.getData()).parallelStream().forEach(payInfo -> {
                ContractSettleReportVO tmp = contractType.length == 1 ? (ContractSettleReportVO)conIdMap.get(Long.valueOf(payInfo.get("contractId").toString())) : (ContractSettleReportVO)conTypeMap.get(payInfo.get("conType"));
                tmp.setCurPaidMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setTotalPaidMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
                tmp.setTotalStartPaidMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setPayScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTotalStartPaidMny(), (BigDecimal)tmp.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                tmp.setOverPaidMny(ComputeUtil.safeSub((BigDecimal)tmp.getContractTaxMny(), (BigDecimal)tmp.getTotalStartPaidMny()));
                tmp.setSettleOverPaidMnyLastYear(ComputeUtil.safeSub((BigDecimal)tmp.getTotalSettleTaxMnyLastYear(), (BigDecimal)tmp.getTotalPaidMnyLastYear()));
            });
        }
        resp.put("records", rsList);
        resp.put("curTotalSettleMny", (Object)new BigDecimal(totalInfo.get("curTotalSettleMny").toString()));
        resp.put("curTotalSettleTaxMny", (Object)new BigDecimal(totalInfo.get("curTotalSettleTaxMny").toString()));
        resp.put("totalSettleMnyThisYear", (Object)new BigDecimal(totalInfo.get("totalSettleMnyThisYear").toString()));
        resp.put("totalSettleTaxMnyThisYear", (Object)new BigDecimal(totalInfo.get("totalSettleTaxMnyThisYear").toString()));
        resp.put("totalStartSettleMny", (Object)new BigDecimal(totalInfo.get("totalStartSettleMny").toString()));
        resp.put("totalStartSettleTaxMny", (Object)new BigDecimal(totalInfo.get("totalStartSettleTaxMny").toString()));
        if (null != rsList.get(0).getIncomeContractTaxMny()) {
            resp.put("incomeContractTaxMnyInW", (Object)ComputeUtil.safeDiv((BigDecimal)rsList.get(0).getIncomeContractTaxMny(), (BigDecimal)BigDecimal.valueOf(10000L)).setScale(2, RoundingMode.HALF_UP));
        }
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"export"})
    public void pageList(@RequestBody QueryParam queryParam, HttpServletResponse response) throws ParseException {
        CommonResponse settingResp;
        Map parameterMap = queryParam.getParams();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == parameterMap.get("projectId") || null == parameterMap.get("startDate") || null == parameterMap.get("endDate") || null == parameterMap.get("contractType")) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u53c2\u6570\uff01");
        }
        String[] contractType = ((Parameter)parameterMap.get("contractType")).getValue().toString().split(",");
        paramMap.put("contractType", contractType);
        paramMap.put("conTypes", contractType.length > 1 ? "multiConType" : "oneConType");
        if (null != parameterMap.get("supplierName")) {
            paramMap.put("supplierName", ((Parameter)parameterMap.get("supplierName")).getValue());
        }
        if (null != parameterMap.get("contractFeeTypeName")) {
            paramMap.put("contractFeeTypeName", ((Parameter)parameterMap.get("contractFeeTypeName")).getValue());
        }
        if (!(settingResp = this.costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId())).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u6210\u672c\u671f\u95f4\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        SettingVO setting = (SettingVO)settingResp.getData();
        String startDate = ((Parameter)parameterMap.get("startDate")).getValue().toString();
        String endDate = ((Parameter)parameterMap.get("endDate")).getValue().toString();
        paramMap.put("projectId", ((Parameter)parameterMap.get("projectId")).getValue());
        if ("0".equals(setting.getPeriodRule())) {
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)startDate));
            endDate = endDate + "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startDate = startDate + "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startDate = DateUtil.addDay(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)startDate), "yyyy-MM-dd")), 1);
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", DateUtil.addDay(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)DateUtil.getLastMonth(DateFormatUtil.parseDate((String)"yyyy-MM-dd", (String)(Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-" + setting.getEndDay())), "yyyy-MM-dd")), 1));
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-" + setting.getEndDay());
        } else {
            startDate = startDate + "-01";
            endDate = endDate + "-" + DateUtil.getDaysOfMonth(DateFormatUtil.parseDate((String)"yyyy-MM", (String)endDate));
            paramMap.put("curStartDate", startDate);
            paramMap.put("curEndDate", endDate);
            parameterMap.remove("startDate");
            parameterMap.remove("endDate");
            paramMap.put("curYear", endDate.substring(0, 4));
            paramMap.put("lastYearStartDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-01-01");
            paramMap.put("lastYearEndDate", Integer.valueOf(endDate.substring(0, 4)) - 1 + "-12-31");
        }
        if (null != parameterMap.get("contractCode")) {
            paramMap.put("contractCode", ((Parameter)parameterMap.get("contractCode")).getValue());
        }
        if (null != parameterMap.get("contractName")) {
            paramMap.put("contractName", ((Parameter)parameterMap.get("contractName")).getValue());
        }
        String exportTitle = ((Parameter)parameterMap.get("exportTitle")).getValue().toString();
        List<ContractSettleReportVO> rsList = this.settlePoolService.pageList(paramMap);
        HashMap conIdMap = new HashMap();
        HashMap<String, ContractSettleReportVO> conTypeMap = new HashMap<String, ContractSettleReportVO>();
        if (contractType.length > 1) {
            ArrayList<JSONObject> conTypeMapList = new ArrayList<JSONObject>();
            ArrayList<Long> condIds = new ArrayList<Long>();
            JSONObject tmp = null;
            for (ContractSettleReportVO item2 : rsList) {
                item2.setContractFeeTypeName(ContractFeeTypeEnum.getByCode((String)item2.getContractType()).getContractFeeTypeName());
                if (null != item2.getContractTaxMny()) {
                    item2.setContractTaxMnyInW(ComputeUtil.safeDiv((BigDecimal)item2.getContractTaxMny(), (BigDecimal)BigDecimal.valueOf(10000L)).setScale(2, RoundingMode.HALF_UP));
                }
                if (null != item2.getIncomeContractTaxMny()) {
                    item2.setCurConTypeRatioInIncomeCon(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)item2.getContractTaxMny(), (BigDecimal)item2.getIncomeContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                } else {
                    item2.setCurConTypeRatioInIncomeCon(BigDecimal.ZERO);
                }
                conTypeMap.put(item2.getContractType(), item2);
                for (String conId : item2.getContractIds().split(",")) {
                    tmp = new JSONObject();
                    tmp.put("contractId", (Object)conId);
                    tmp.put("contractType", (Object)item2.getContractType());
                    condIds.add(Long.valueOf(conId));
                    conTypeMapList.add(tmp);
                }
            }
            conTypeMap.putAll(rsList.stream().collect(Collectors.toMap(item -> item.getContractType(), item -> item)));
            paramMap.put("contractIds", new ArrayList());
            paramMap.put("contractTypeMap", conTypeMapList);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            rsList.parallelStream().forEach(item -> {
                item.setCurSettleDateStr(null != item.getCurSettleDate() ? sdf.format(item.getCurSettleDate()) : null);
                conIdMap.put(item.getContractId(), item);
            });
            paramMap.put("contractIds", conIdMap.keySet());
        }
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"paramJson", (Object)JSONObject.toJSONString(paramMap));
        CommonResponse payInfoResp = this.receiptAndPaymentRegisterApi.queryContractPayInfo((MultiValueMap)param);
        if (!payInfoResp.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4ed8\u6b3e\u767b\u8bb0\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (null != payInfoResp.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)payInfoResp.getData()))) {
            ((List)payInfoResp.getData()).parallelStream().forEach(payInfo -> {
                ContractSettleReportVO tmp = contractType.length == 1 ? (ContractSettleReportVO)conIdMap.get(Long.valueOf(payInfo.get("contractId").toString())) : (ContractSettleReportVO)conTypeMap.get(payInfo.get("conType"));
                tmp.setCurPaidMny(null != payInfo.get("curPaidMny") ? new BigDecimal(payInfo.get("curPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setTotalPaidMnyLastYear(null != payInfo.get("totalPaidMnyLastYear") ? new BigDecimal(payInfo.get("totalPaidMnyLastYear").toString()) : BigDecimal.ZERO);
                tmp.setTotalStartPaidMny(null != payInfo.get("totalStartPaidMny") ? new BigDecimal(payInfo.get("totalStartPaidMny").toString()) : BigDecimal.ZERO);
                tmp.setPayScale(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)tmp.getTotalStartPaidMny(), (BigDecimal)tmp.getContractTaxMny()), (BigDecimal)new BigDecimal("100")));
                tmp.setOverPaidMny(ComputeUtil.safeSub((BigDecimal)tmp.getContractTaxMny(), (BigDecimal)tmp.getTotalStartPaidMny()));
                tmp.setSettleOverPaidMnyLastYear(ComputeUtil.safeSub((BigDecimal)tmp.getTotalSettleTaxMnyLastYear(), (BigDecimal)tmp.getTotalPaidMnyLastYear()));
            });
        }
        HashMap<String, List<ContractSettleReportVO>> records = new HashMap<String, List<ContractSettleReportVO>>();
        records.put("records", rsList);
        ExcelExport.getInstance().exportWithTrans(contractType.length > 1 ? "ProjectSettleReport-export.xlsx" : "ContractSettleReport-export.xlsx", records, response, exportTitle);
    }
}

