/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.filing.controller;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.entity.ContractFilingEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.filing.service.IContractFilingService;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.ContractFilingVO;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"contractFiling"})
public class ContractFilingController {
    private static final String BILL_CODE = "FIL_LAB";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractFilingService service;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IFilingTypeService typeService;
    @Autowired
    private IContractPoolService contractPoolService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractFilingVO> saveOrUpdate(@RequestBody ContractFilingVO saveorUpdateVO) {
        this.logger.info("nnnnno{}", (Object)saveorUpdateVO.getContractId());
        ContractFilingVO resp = this.service.saveOrUpdateFilingVO(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f!", (Object)resp);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractFilingVO> queryDetail(String id) {
        this.logger.info("\u5f52\u6863");
        ContractFilingEntity entity = null;
        ContractFilingVO vo = null;
        entity = (ContractFilingEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return CommonResponse.error((String)"\u5f53\u524d\u6570\u636e\u662f\u81ea\u52a8\u5f52\u6863\u65e0\u5bf9\u5e94\u4fe1\u606f\uff01");
        }
        vo = (ContractFilingVO)BeanMapper.map((Object)((Object)entity), ContractFilingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractFilingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractFilingVO vo : vos) {
                ContractFilingEntity contractFilingEntity = (ContractFilingEntity)((Object)this.service.selectById(vo.getId()));
                this.service.updateFilingStatus(contractFilingEntity, FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode(), 0);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractFilingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractFilingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("create_time", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ContractFilingVO.class);
            for (ContractFilingVO vo : list) {
                vo.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                vo.setFilingDateStr(sdf.format(vo.getFilingDate()));
            }
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            this.logger.error(JSONObject.toJSONString((Object)list));
            beans.put("records", list);
            ExcelExport.getInstance().export("filing-export.xlsx", beans, response);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/filingDataRef"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> filingDataRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        if (null == condition || StringUtils.isBlank((String)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u4f20\u5165condition\u4e3a\u7a7a\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("orgId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7id\u4e3a\u7a7a\uff01");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        String columns = null;
        String databaseName = null;
        String parameter = null;
        String tableName = null;
        String authority = null;
        if (null == conditionMap.get("filingTypeId")) {
            return CommonResponse.error((String)"\u5f53\u524d\u4f20\u5165\u5f52\u6863\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        Object filingTypeId = conditionMap.get("filingTypeId");
        FilingTypeEntity typeEntity = (FilingTypeEntity)((Object)this.typeService.selectById((Serializable)((Object)filingTypeId.toString())));
        columns = typeEntity.getQueryColumns();
        databaseName = typeEntity.getQueryDatabaseName();
        tableName = typeEntity.getQueryTableName();
        parameter = typeEntity.getQueryParameter();
        Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
            parameter = parameter + " and org_id =" + orgId + " ";
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            parameter = parameter + " and org_id in (" + org.apache.commons.lang3.StringUtils.join(orgIdList, (String)",") + ")";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
            parameter = parameter + "and(contract_name LIKE '%" + searchText + "%' OR project_name LIKE '%" + searchText + "%' OR bill_code LIKE '%" + searchText + "%')";
        }
        parameter = parameter + " ORDER BY create_time DESC limit " + (pageNumber - 1) * pageSize + "," + pageSize;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        this.logger.info("\u83b7\u53d6\u7684\u8bf7\u6c42\u5934 authority\uff1a{}", (Object)request.getHeader("authority"));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)request.getHeader("authority"))) {
            authority = request.getHeader("authority");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columns", columns);
        params.put("databaseName", databaseName);
        params.put("parameter", parameter);
        params.put("tableName", tableName);
        params.put("projectName", typeEntity.getQueryProjectName());
        this.logger.info("\u67e5\u8be2\u53c2\u6570 params\uff1a{}", (Object)JSONObject.toJSONString(params));
        String url = this.BaseHost + typeEntity.getQueryProjectName() + "/pubQuery/queryBillMap";
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("authority", authority)).body(JSON.toJSONString(params)).timeout(10000).execute().body();
        Assert.hasLength((String)response, (String)"\u5408\u540c\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
        this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{}\uff0cparam-{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), response});
        CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a{}\uff01", (Object)commonResponse);
            throw new BusinessException("\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a" + commonResponse);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", (Object)pageNumber);
        jsonObject.put("size", (Object)pageSize);
        if (((JSONObject)commonResponse.getData()).get((Object)"count") != null && Integer.valueOf((String)((JSONObject)commonResponse.getData()).get((Object)"count")) != 0) {
            jsonObject.put("records", ((JSONObject)commonResponse.getData()).get((Object)"data"));
            jsonObject.put("total", ((JSONObject)commonResponse.getData()).get((Object)"count"));
            jsonObject.put("pages", (Object)this.getPages(pageSize.intValue(), Integer.valueOf((String)((JSONObject)commonResponse.getData()).get((Object)"count")).intValue()));
        } else {
            jsonObject.put("records", null);
            jsonObject.put("total", (Object)0);
            jsonObject.put("pages", (Object)0);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)jsonObject);
    }

    long getPages(long size, long total) {
        if (size == 0L) {
            return 0L;
        }
        long pages = total / size;
        if (total % size != 0L) {
            ++pages;
        }
        return pages;
    }

    @GetMapping(value={"/checkReturnFileId"})
    public CommonResponse<JSONObject> checkReturnFileId(@RequestParam(value="billId") Long billId, Long fileId, String fileName) {
        JSONObject json = new JSONObject();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)billId);
        queryWrapper.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && ((ContractFilingEntity)((Object)list.get(0))).getFileId() != null) {
            fileId = ((ContractFilingEntity)((Object)list.get(0))).getFileId();
            fileName = ((ContractFilingEntity)((Object)list.get(0))).getFileName();
        }
        json.put("fileId", (Object)fileId);
        json.put("fileName", (Object)fileName);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)json);
    }

    @RequestMapping(value={"/queryContractDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryContractDetail(String contractId, String contractSubType) {
        this.logger.info("\u5f52\u6863\u901a\u8fc7\u5408\u540cid\uff1a{}\uff0c\u5355\u636e\u7f16\u7801-contractSubType\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u8be6\u60c5\uff01", (Object)contractId, (Object)contractSubType);
        JSONObject object = this.service.queryContractDetail(contractId, contractSubType);
        if (object.getString("record") == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u5408\u540cid\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5408\u540c\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)object);
    }
}

