package com.ejianc.business.contractbase.home.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.home.vo.FinanceCountVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.contractbase.home.vo.ProjectInOutVO;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 门户首页 服务类
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
public interface IHomePortalService extends IBaseService<ContractPoolEntity> {

    CommonResponse<Map<String,BigDecimal>> capitalCount(String range, String dateIn, Long orgId);

    CommonResponse<Map<String,BigDecimal>> capitalCountLeader(String range, String dateIn, Long orgId);

    IPage<FinanceCountVO> capitalCountOrgLeader(QueryParam param);

    IPage<ProjectInOutVO> proPageList(Map<String, Object> params);

    CommonResponse<FinanceUseResVO> queryFinanceUse(String dateIn, Long orgId);

    CommonResponse<FinanceUseResVO> queryFinanceUseLeader(String dateIn, Long orgId);

    JSONObject queryOutputScale(Long projectId);

    JSONObject costSquareChart(Long projectId);

    BigDecimal thisProductMny();

    IPage<ProjectInOutVO> proPageOrgList(Map<String, Object> params);

    CommonResponse<FinanceUseResVO> queryFinanceUseByYear(String year, Long orgId);

    CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractMnyByYear(String year, Long orgId);

    CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractProjectMnyByYear(String year, Long orgId);

    CommonResponse<List<SubUnitTopVO>> querySubUnitTopByYear(String year, Long orgId);
}
