/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.filing.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.filing.entity.ContractFilingEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.enums.FilingBillTypeEnum;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.filing.mapper.ContractFilingMapper;
import com.ejianc.business.contractbase.filing.service.IContractFilingService;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.ContractFilingVO;
import com.ejianc.business.contractbase.filing.vo.FilingTypeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.seata.spring.annotation.GlobalTransactional;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="contractFilingService")
public class ContractFilingServiceImpl
extends BaseServiceImpl<ContractFilingMapper, ContractFilingEntity>
implements IContractFilingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IFilingTypeService filingTypeService;

    @Override
    @GlobalTransactional(name="ContractFilingServiceImpl_updateFilingStatus", rollbackFor={Exception.class})
    public void updateFilingStatus(ContractFilingEntity entity, Integer status, Integer refStatus) {
        this.logger.error("\u4fee\u6539\u5f52\u6863 \u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        String[] billTypeCodes = entity.getUpdateBillType().split(",");
        CommonResponse mdRefResp = null;
        String tableName = null;
        String projectName = null;
        for (String billType : billTypeCodes) {
            mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
            if (!mdRefResp.isSuccess()) {
                this.logger.error("\u66f4\u65b0\u5355\u636e\u5f52\u6863\u72b6\u6001\u5931\u8d25, \u5f52\u6863\u5355\u636e-{}\uff0c\u67e5\u8be2\u5143\u6570\u636e\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)((Object)entity)), (Object)JSONObject.toJSONString((Object)mdRefResp));
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u5355\u636e\u5f52\u6863\u72b6\u6001\u5931\u8d25\uff01");
            }
            tableName = ((MdReferVO)mdRefResp.getData()).getTableName();
            projectName = ((MdReferVO)mdRefResp.getData()).getProjectName();
            this.logger.info("x\u9879\u76ee\u540d\u79f0{}", (Object)projectName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tableName", tableName);
            params.put("billId", entity.getSourceId());
            HashMap<String, Integer> fields = new HashMap<String, Integer>();
            HashMap<String, String> tableNames = new HashMap<String, String>();
            if (entity.getFilingTypeName().indexOf("\u53d8\u66f4") > 0) {
                tableNames.put("filingStatus", "change_filing_status");
            } else {
                tableNames.put("filingStatus", "filing_status");
            }
            fields.put("filingStatus", status);
            tableNames.put("filingRef", "filing_ref");
            fields.put("filingRef", refStatus);
            params.put("fields", fields);
            params.put("tableNames", tableNames);
            String authority = null;
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
            this.logger.info("\u83b7\u53d6\u7684\u8bf7\u6c42\u5934 authority\uff1a{}", (Object)request.getHeader("authority"));
            if (StringUtils.isNotBlank((CharSequence)request.getHeader("authority"))) {
                authority = request.getHeader("authority");
            }
            String url = this.BaseHost + projectName + "/commonUpdate/updateFilingStatus";
            String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("authority", authority)).body(JSON.toJSONString(params)).timeout(10000).execute().body();
            Assert.hasLength((String)response, (String)"\u5f52\u6863\u4fee\u6539\u72b6\u6001\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{}\uff0cparam-{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), response});
            CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
            if (commonResponse.isSuccess()) continue;
            this.logger.error("\u4fee\u6539\u5f52\u6863\u72b6\u6001\uff0c\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a{}\uff01", (Object)commonResponse.getMsg());
            throw new BusinessException("\u4fee\u6539\u5f52\u6863\u72b6\u6001\uff0c\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a" + commonResponse.getMsg());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ContractFilingVO saveOrUpdateFilingVO(ContractFilingVO saveorUpdateVO) {
        ContractFilingEntity entity = (ContractFilingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractFilingEntity.class));
        if (null == entity.getId()) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"contract_id", (Object)entity.getContractId());
            query.eq((Object)"dr", (Object)0);
            int count = super.count((Wrapper)query);
            if (count > 0) {
                this.logger.info("\u5f53\u524d{}\u5408\u540c\u5df2\u5b58\u5728\u751f\u6548\u7684\u5f52\u6863\u5355 ", (Object)entity.getContractName());
                throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u5f52\u6863\u5355\uff0c \u8bf7\u66f4\u6362\u5408\u540c\uff01");
            }
            this.logger.info("\u6d4b\u8bd5\u5355{}", (Object)entity.getFilingTypeInnerCode());
            this.logger.info("\u83b7\u53d6\u7f16\u7801\u8bf7\u6c42\u53c2\u6570 --BILL_CODE{}/n --InvocationInfoProxy.getTenantid()--{}/n saveorUpdateVO--{}", new Object[]{FilingBillTypeEnum.getByName((String)entity.getFilingTypeInnerCode()).getTypeCode(), InvocationInfoProxy.getTenantid(), JSONObject.toJSONString((Object)saveorUpdateVO)});
            BillCodeParam billCodeParam = BillCodeParam.build((String)FilingBillTypeEnum.getByName((String)entity.getFilingTypeInnerCode()).getTypeCode(), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                this.logger.info("\u83b7\u53d6\u7f16\u7801\u8bf7\u6c42\u6210\u529f \u7ed3\u679c\u5931\u8d25--{}", (Object)JSONObject.toJSONString((Object)billCode));
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff01");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            this.updateFilingStatus(entity, FilingStatusEnum.\u5f52\u6863\u4e2d.getTypeCode(), 1);
        }
        super.saveOrUpdate((Object)entity, false);
        return (ContractFilingVO)BeanMapper.map((Object)((Object)entity), ContractFilingVO.class);
    }

    @Override
    public JSONObject queryContractDetail(String contractId, String contractSubType) {
        String authority = null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractSubType", new Parameter("eq", (Object)contractSubType));
        List typeEntityList = this.filingTypeService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)typeEntityList) || null == typeEntityList.get(0)) {
            throw new BusinessException("\u83b7\u53d6\u5f52\u6863\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570-contractSubType\uff01");
        }
        FilingTypeEntity typeEntity = (FilingTypeEntity)((Object)typeEntityList.get(0));
        this.logger.info("\u83b7\u53d6\u5f52\u6863\u4fe1\u606f\u6210\u529f\uff1atypeEntity\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)typeEntity)));
        String columns = typeEntity.getQueryColumns();
        String databaseName = typeEntity.getQueryDatabaseName();
        String tableName = typeEntity.getQueryTableName();
        String parameter = "id=" + contractId;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        this.logger.info("\u83b7\u53d6\u7684\u8bf7\u6c42\u5934 authority\uff1a{}", (Object)request.getHeader("authority"));
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("authority"))) {
            authority = request.getHeader("authority");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columns", columns);
        params.put("databaseName", databaseName);
        params.put("parameter", parameter);
        params.put("tableName", tableName);
        params.put("projectName", typeEntity.getQueryProjectName());
        this.logger.info("\u67e5\u8be2\u53c2\u6570 params\uff1a{}", (Object)JSONObject.toJSONString(params));
        String url = this.BaseHost + typeEntity.getQueryProjectName() + "/pubQuery/queryBillMap";
        String response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("authority", authority)).body(JSON.toJSONString(params)).timeout(10000).execute().body();
        Assert.hasLength((String)response, (String)"\u5408\u540c\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
        this.logger.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{}\uff0cparam-{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{url, JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}), response});
        CommonResponse commonResponse = (CommonResponse)JSON.parseObject((String)response, CommonResponse.class);
        if (!commonResponse.isSuccess()) {
            this.logger.error("\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a{}\uff01", (Object)commonResponse);
            throw new BusinessException("\u8bf7\u6c42\u300c\u6210\u529f\u300d\uff0c\u8fd4\u56de\u7ed3\u679c\u300c\u5931\u8d25\u300d\uff1a" + commonResponse);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("record", ((JSONObject)commonResponse.getData()).get((Object)"data"));
        jsonObject.put("filingType", BeanMapper.map((Object)((Object)typeEntity), FilingTypeVO.class));
        return jsonObject;
    }

    public void queryFilingDataRef() {
    }
}

