/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.pool.settlepool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.BillUrlDictEntity;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.mapper.BillUrlDictMapper;
import com.ejianc.business.contractbase.pool.settlepool.mapper.SettlePoolMapper;
import com.ejianc.business.contractbase.pool.settlepool.service.IBillUrlDictService;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.pool.settlepool.vo.ImportSettlePoolVO;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.pool.util.BeanUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="settlePoolService")
public class SettlePoolServiceImpl
extends BaseServiceImpl<SettlePoolMapper, SettlePoolEntity>
implements ISettlePoolService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BillUrlDictMapper urlMapper;
    @Autowired
    SettlePoolMapper poolMapper;
    @Autowired
    private IBillUrlDictService billUrlDictService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ContractPoolMapper contractPoolMapper;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_CODE = "SETTLE_POOL_TEMP";
    private static final String BILL_CODE_NO_CONTRACT = "SETTLE_POOL_NO_CONTRACT_TEMP";

    @Override
    public List<BillUrlDictEntity> queryDetailUrlList(List<String> typeList) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_type", typeList);
        return this.urlMapper.selectList((Wrapper)query);
    }

    @Override
    public void delBySourceId(Long sourceId) {
        this.poolMapper.delBySourceId(sourceId);
    }

    @Override
    public SettlePoolVO saveOrUpdateSettle(SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity saveEntity = null;
        SettlePoolEntity dbEntity = this.selectBySourceId(saveOrUpdateVO.getSourceId());
        if (null != dbEntity) {
            saveEntity = this.copyProperty(dbEntity, saveOrUpdateVO);
        } else {
            saveEntity = (SettlePoolEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlePoolEntity.class));
            if (saveEntity.getResidueApplyMny() == null) {
                saveEntity.setResidueApplyMny(saveEntity.getCurTaxMny() == null ? BigDecimal.ZERO : saveEntity.getCurTaxMny());
            }
            this.billCheck(saveEntity);
            saveEntity.setAlreadyApplyMny(BigDecimal.ZERO);
            this.findDetailUrl(saveEntity);
            this.poolMapper.delBySourceId(saveEntity.getSourceId());
        }
        this.fillTypeName(saveEntity);
        super.saveOrUpdate((Object)saveEntity, false);
        return (SettlePoolVO)BeanMapper.map((Object)((Object)saveEntity), SettlePoolVO.class);
    }

    @Override
    public List<SettlePoolVO> saveOrUpdateSettleBatch(List<SettlePoolVO> saveOrUpdateVOs) {
        Map<Long, SettlePoolVO> vosMap = saveOrUpdateVOs.stream().collect(Collectors.toMap(BaseVO::getId, e -> e));
        List<SettlePoolEntity> list = this.selectBySourceIds(new ArrayList<Long>(vosMap.keySet()));
        ArrayList<SettlePoolEntity> saveList = new ArrayList<SettlePoolEntity>();
        if (CollectionUtils.isNotEmpty(list)) {
            SettlePoolEntity saveEntity = null;
            for (SettlePoolEntity dbEntity : list) {
                saveEntity = this.copyProperty(dbEntity, vosMap.get(dbEntity.getSourceId()));
                this.fillTypeName(saveEntity);
                saveList.add(saveEntity);
                vosMap.remove(dbEntity.getSourceId());
            }
        }
        if (!vosMap.isEmpty()) {
            List newList = BeanMapper.mapList(vosMap.values(), SettlePoolEntity.class);
            newList.forEach(item -> {
                this.billCheck((SettlePoolEntity)((Object)item));
                this.fillTypeName((SettlePoolEntity)((Object)item));
                if (item.getResidueApplyMny() == null) {
                    item.setResidueApplyMny(item.getCurTaxMny() == null ? BigDecimal.ZERO : item.getCurTaxMny());
                }
                item.setAlreadyApplyMny(BigDecimal.ZERO);
                this.findDetailUrl((SettlePoolEntity)((Object)item));
                this.poolMapper.delBySourceId(item.getSourceId());
            });
            saveList.addAll(newList);
        }
        super.saveOrUpdateBatch(saveList, saveList.size(), false);
        return BeanMapper.mapList(saveList, SettlePoolVO.class);
    }

    private void billCheck(SettlePoolEntity settle) {
        if (null == settle.getSourceId()) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u6765\u6e90\u4e1a\u52a1\u5355\u636eid-[sourceId]\u4e3a\u7a7a\uff01");
        }
        if (null != settle.getId() && !settle.getId().equals(settle.getSourceId())) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355Id\u4e0esourceId\u4e0d\u4e00\u81f4\uff01");
        }
        if (StringUtils.isBlank((CharSequence)settle.getSourceType())) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u4e1a\u52a1\u7c7b\u578b-[sourceType]\u4e3a\u7a7a\uff01");
        }
        if (null == settle.getSettleProperty()) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u5c5e\u6027\u7c7b\u522b-[settleProperty]\u4e3a\u7a7a\uff01");
        }
        if (null == settle.getContractFlag()) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u5408\u540c\u6807\u8bc6\u5b57\u6bb5\u4e3a\u7a7a-[contractFlag]\u4e3a\u7a7a\uff01");
        }
        if (null == settle.getUltimateFlag()) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u5408\u662f\u5426\u6700\u7ec8\u7ed3\u7b97\u6807\u8bc6\u4e3a\u7a7a-[ultimateFlag]\u4e3a\u7a7a\uff01");
        }
        if (settle.getContractFlag().equals(1) && null == settle.getContractId()) {
            throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c \u7ed3\u7b97\u5355\u5408\u540cId\u4e3a\u7a7a-[contractId]\u4e3a\u7a7a\uff01");
        }
        if (null == settle.getHandleType()) {
            settle.setHandleType(0);
        }
    }

    private void fillTypeName(SettlePoolEntity item) {
        ContractTypeEnum ct;
        SettleSourceTypeEnum settleType;
        if (StringUtils.isNotBlank((CharSequence)item.getSourceType()) && null != (settleType = SettleSourceTypeEnum.getByCode((String)item.getSourceType()))) {
            item.setSettleSourceTypeName(settleType.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getContractType()) && null != (ct = ContractTypeEnum.getByCode((String)item.getContractType()))) {
            item.setContractTypeName(ct.getTypeName());
        }
    }

    private SettlePoolEntity copyProperty(SettlePoolEntity dbEntity, SettlePoolVO saveOrUpdateVO) {
        SettlePoolEntity saveEnitty = null;
        if (UpdateLevelEnum.\u5168\u91cf\u8986\u76d6\u66f4\u65b0.getLevelCode().equals(saveOrUpdateVO.getUpdateLevel())) {
            this.logger.info("\u5168\u91cf\u66f4\u65b0\u7ed3\u7b97\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
            saveEnitty = (SettlePoolEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlePoolEntity.class));
        } else {
            saveEnitty = (SettlePoolEntity)((Object)BeanMapper.map((Object)((Object)dbEntity), SettlePoolEntity.class));
            String[] updateFields = BeanUtil.getPropertyNames(saveOrUpdateVO, saveOrUpdateVO.getUpdateLevel());
            this.logger.info("\u90e8\u5206\u66f4\u65b0\u7ed3\u7b97\u5355\uff1a{}, \u672c\u6b21\u66f4\u65b0\u5b57\u6bb5-{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO), (Object)JSONObject.toJSONString((Object)updateFields));
            BeanUtils.copyProperties((Object)saveOrUpdateVO, (Object)((Object)saveEnitty), (String[])updateFields);
            this.logger.info("\u5f85\u66f4\u65b0\u7ed3\u7b97\u5355\u6570\u636e\uff1a{}, \u672c\u6b21\u66f4\u65b0\u5b57\u6bb5-{}", (Object)JSONObject.toJSONString((Object)((Object)saveEnitty)), (Object)JSONObject.toJSONString((Object)updateFields));
        }
        saveEnitty.setId(dbEntity.getId());
        saveEnitty.setVersion(dbEntity.getVersion());
        saveEnitty.setCreateTime(dbEntity.getCreateTime());
        saveEnitty.setCreateUserCode(dbEntity.getCreateUserCode());
        this.findDetailUrl(saveEnitty);
        return saveEnitty;
    }

    private void findDetailUrl(SettlePoolEntity saveEntity) {
        ArrayList<String> sourceTypes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)saveEntity.getSourceType())) {
            sourceTypes.add(saveEntity.getSourceType() + "Pc");
        }
        if (StringUtils.isNotBlank((CharSequence)saveEntity.getContractType())) {
            sourceTypes.add(saveEntity.getContractType() + "PC");
        }
        Map<String, String> urlMap = this.billUrlDictService.getDictMapBySourceTypes(sourceTypes);
        this.logger.info("\u7ed3\u7b97\u5355id-{}\uff0c\u67e5\u8be2\u8be6\u60c5\u53c2\u6570-{}\uff0c \u7ed3\u679c\uff1a{}", new Object[]{saveEntity.getId(), JSONObject.toJSONString(sourceTypes), JSONObject.toJSONString(urlMap)});
        if (MapUtils.isNotEmpty(urlMap)) {
            if (StringUtils.isBlank((CharSequence)saveEntity.getBillCodeUrl()) && null != urlMap.get(saveEntity.getSourceType() + "Pc")) {
                saveEntity.setBillCodeUrl(urlMap.get(saveEntity.getSourceType() + "Pc"));
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractUrl()) && null != urlMap.get(saveEntity.getContractType() + "Pc")) {
                saveEntity.setContractUrl(urlMap.get(saveEntity.getContractType() + "Pc"));
            }
        }
        if (null == saveEntity.getHandleType()) {
            saveEntity.setHandleType(0);
        }
        if (null == saveEntity.getId()) {
            saveEntity.setId(saveEntity.getSourceId());
        }
        if (StringUtils.isBlank((CharSequence)saveEntity.getSettleSourceTypeName())) {
            saveEntity.setSettleSourceTypeName(SettleSourceTypeEnum.getByCode((String)saveEntity.getSourceType()).getName());
        }
        if (null != saveEntity.getContractId()) {
            ContractPoolEntity contract = (ContractPoolEntity)((Object)this.contractPoolMapper.selectById(saveEntity.getContractId()));
            if (null == contract) {
                this.logger.error("\u65b0\u589e\u540c\u6b65\u7ed3\u7b97\u5355-\u3010{}\u3011\u5931\u8d25,\uff0c\u5408\u540c\u6c60\u65e0\u5339\u914d\u5408\u540c\u6570\u636e\uff01", (Object)JSONObject.toJSONString((Object)((Object)saveEntity)));
                throw new BusinessException("\u540c\u6b65\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u5408\u540c\u6c60\u65e0\u5339\u914d\u5408\u540c\u6570\u636e\uff01");
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractName())) {
                saveEntity.setContractName(contract.getContractName());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractCode())) {
                saveEntity.setContractCode(saveEntity.getContractCode());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractUrl())) {
                saveEntity.setContractUrl(contract.getPcCardUrl());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractType())) {
                saveEntity.setContractType(contract.getSourceType());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getContractTypeName())) {
                saveEntity.setContractTypeName(contract.getSourceTypeName());
            }
            if (null == saveEntity.getSupplementFlag()) {
                saveEntity.setSupplementFlag(contract.getSupplementFlag());
            }
            if (null == saveEntity.getMaiContractId()) {
                saveEntity.setMaiContractId(contract.getMainContractId());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getMaiContractCode())) {
                saveEntity.setMaiContractCode(contract.getMainContractCode());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getMaiContractName())) {
                saveEntity.setMaiContractName(contract.getMainContractName());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getSettleSourceTypeName())) {
                saveEntity.setSettleSourceTypeName(SettleSourceTypeEnum.getByCode((String)saveEntity.getSourceType()).getName());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getPartyaName())) {
                saveEntity.setPartyaName(contract.getPartyaName());
            }
            if (null == saveEntity.getPartyaId()) {
                saveEntity.setPartyaId(contract.getPartyaId());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getPartybName())) {
                saveEntity.setPartybName(contract.getPartybName());
            }
            if (null == saveEntity.getPartybId()) {
                saveEntity.setPartybId(contract.getPartybId());
            }
            if (null == saveEntity.getDepartmentId()) {
                saveEntity.setDepartmentId(contract.getDepartmentId());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getDepartmentName())) {
                saveEntity.setDepartmentName(contract.getDepartmentName());
            }
            if (null == saveEntity.getProjectId()) {
                saveEntity.setProjectId(contract.getProjectId());
            }
            if (null == saveEntity.getOrgId()) {
                saveEntity.setOrgId(contract.getOrgId());
            }
            if (null == saveEntity.getParentOrgId()) {
                saveEntity.setParentOrgId(contract.getParentOrgId());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getProjectCode())) {
                saveEntity.setProjectCode(contract.getProjectCode());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getOrgCode())) {
                saveEntity.setOrgCode(contract.getOrgCode());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getParentOrgCode())) {
                saveEntity.setParentOrgCode(contract.getParentOrgCode());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getProjectName())) {
                saveEntity.setProjectName(contract.getProjectName());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getOrgName())) {
                saveEntity.setOrgName(contract.getOrgName());
            }
            if (StringUtils.isBlank((CharSequence)saveEntity.getParentOrgName())) {
                saveEntity.setParentOrgName(contract.getParentOrgName());
            }
        }
    }

    @Override
    public SettlePoolVO getBySourceId(Long sourceId) {
        SettlePoolEntity dbEntity = this.selectBySourceId(sourceId);
        if (null != dbEntity) {
            return (SettlePoolVO)BeanMapper.map((Object)((Object)dbEntity), SettlePoolVO.class);
        }
        return null;
    }

    @Override
    public List<SettlePoolVO> getBySourceIds(List<Long> sourceIds) {
        List<SettlePoolEntity> list = this.selectBySourceIds(sourceIds);
        if (CollectionUtils.isNotEmpty(list)) {
            return BeanMapper.mapList(list, SettlePoolVO.class);
        }
        return new ArrayList<SettlePoolVO>();
    }

    @Override
    public Map<String, BigDecimal> queryLaborMny(Long contractId) {
        this.logger.info("ejc-contractbase-impl***SettlePoolServiceImpl***queryLaborMny\u65b9\u6cd5***begin***contractId-{}", (Object)contractId);
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"sum(if(source_type in ('labor_month','pro_month'), cur_tax_mny, 0)) as totalProcessSettleNum, sum(if(source_type in ('labor_node','pro_node'), cur_tax_mny, 0)) as totalNodeSettleNum , sum(if(source_type in ('labor_final','pro_final'), finish_cur_tax_mny, 0)) as totalFinalSettleNum"});
        query.eq((Object)"contract_id", (Object)contractId);
        query.in((Object)"source_type", Arrays.asList(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode(), SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode()));
        Map rs = super.getMap((Wrapper)query);
        resMap.put("nodeTotal", null != rs && null != rs.get("totalNodeSettleNum") ? new BigDecimal(rs.get("totalNodeSettleNum").toString()) : BigDecimal.ZERO);
        resMap.put("processTotal", null != rs && null != rs.get("totalProcessSettleNum") ? new BigDecimal(rs.get("totalProcessSettleNum").toString()) : BigDecimal.ZERO);
        resMap.put("finalTotal", null != rs && null != rs.get("totalFinalSettleNum") ? new BigDecimal(rs.get("totalFinalSettleNum").toString()) : BigDecimal.ZERO);
        this.logger.info("ejc-contractbase-impl***SettlePoolServiceImpl***queryLaborMny\u65b9\u6cd5***end***\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString(resMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return resMap;
    }

    @Override
    public BigDecimal calcTotalMny(QueryParam param) {
        QueryWrapper wrapper = SettlePoolServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(if(source_type in ('labor_final','pro_final'), ifnull(total_node_tax_difference,0), cur_tax_mny)) as totalMny"});
        Map result = super.getMap((Wrapper)wrapper);
        return null != result && null != result.get("totalMny") ? (BigDecimal)result.get("totalMny") : BigDecimal.ZERO;
    }

    @Override
    public SettlePoolVO queryTotalMny(SettlePoolVO settlePoolVO) {
        ArrayList<String> typeList;
        QueryParam queryParam = new QueryParam();
        if (null != settlePoolVO.getContractId()) {
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)settlePoolVO.getContractId()));
        }
        if (null != settlePoolVO.getContractType()) {
            queryParam.getParams().put("contractType", new Parameter("eq", (Object)settlePoolVO.getContractType()));
        }
        if (null != settlePoolVO.getProjectId()) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)settlePoolVO.getProjectId()));
        }
        if (ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode().equals(settlePoolVO.getContractType())) {
            typeList = new ArrayList<String>();
            typeList.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
            typeList.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
            queryParam.getParams().put("source_type", new Parameter("in", typeList));
        }
        if (ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(settlePoolVO.getContractType())) {
            typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
            typeList.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
            queryParam.getParams().put("source_type", new Parameter("in", typeList));
        }
        if (ContractTypeEnum.\u94a2\u6784\u516c\u53f8\u5206\u5305\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(settlePoolVO.getContractType())) {
            typeList = new ArrayList();
            typeList.add(SettleSourceTypeEnum.\u94a2\u6784\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
            typeList.add(SettleSourceTypeEnum.\u94a2\u6784\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
            queryParam.getParams().put("source_type", new Parameter("in", typeList));
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("source_type", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        queryParam.getComplexParams().add(c1);
        List settleList = super.queryList(queryParam, false);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (SettlePoolEntity entity : settleList) {
            if (SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType()) || SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType())) {
                if (entity.getTotalNodeTaxDifference() == null) continue;
                totalMny = totalMny.add(entity.getTotalNodeTaxDifference());
                continue;
            }
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)entity.getCurTaxMny());
        }
        SettlePoolVO settleVO = new SettlePoolVO();
        settleVO.setCurTaxMny(totalMny);
        return settleVO;
    }

    @Override
    public CommonResponse<JSONObject> queryNoContractTotalMny(SettlePoolVO settlePoolVO) {
        QueryParam queryParam = new QueryParam();
        if (settlePoolVO.getPartybId() != null) {
            queryParam.getParams().put("partyb_id", new Parameter("eq", (Object)settlePoolVO.getPartybId()));
        }
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)settlePoolVO.getProjectId()));
        if (StringUtils.isNotBlank((CharSequence)settlePoolVO.getSourceType())) {
            if (settlePoolVO.getSourceType().indexOf(",") > 0) {
                queryParam.getParams().put("source_type", new Parameter("in", (Object)settlePoolVO.getSourceType().split(",")));
            } else {
                queryParam.getParams().put("source_type", new Parameter("eq", (Object)settlePoolVO.getSourceType()));
            }
        }
        if (settlePoolVO.getContractFlag() != null) {
            queryParam.getParams().put("contract_flag", new Parameter("eq", (Object)settlePoolVO.getContractFlag()));
        }
        queryParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List settleList = super.queryList(queryParam);
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        for (SettlePoolEntity entity : settleList) {
            totalSettleMny = totalSettleMny.add(entity.getCurTaxMny());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalSettleMny", (Object)totalSettleMny);
        return CommonResponse.success((Object)jsonObject);
    }

    private SettlePoolEntity selectBySourceId(Long sourceId) {
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.eq((Object)"source_id", (Object)sourceId)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return (SettlePoolEntity)((Object)super.getOne((Wrapper)query));
    }

    private List<SettlePoolEntity> selectBySourceIds(List<Long> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)query.in((Object)"source_id", sourceIds)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        HashMap<String, OrgVO> orgVOMap = new HashMap<String, OrgVO>();
        HashMap<String, ProjectPoolSetVO> projectPoolVoMap = new HashMap<String, ProjectPoolSetVO>();
        HashMap<String, ContractPoolEntity> contractPoolVoMap = new HashMap<String, ContractPoolEntity>();
        HashMap<String, SupplierVO> supplierVOMap = new HashMap<String, SupplierVO>();
        HashMap<String, OrgVO> projectOrgVoMap = new HashMap<String, OrgVO>();
        HashMap payTypeNoContractMap = new HashMap();
        HashMap<String, String> payTypeMapMaterial = new HashMap<String, String>();
        payTypeMapMaterial.put("id", "1522760479528308738");
        payTypeMapMaterial.put("name", "\u96f6\u661f\u6750\u6599\u8d39\u7528");
        payTypeMapMaterial.put("code", "sporadic_material_fee");
        payTypeNoContractMap.put("\u96f6\u661f\u6750\u6599\u8d39\u7528", payTypeMapMaterial);
        HashMap<String, String> payTypeMapEquip = new HashMap<String, String>();
        payTypeMapEquip.put("id", "1522760553071235074");
        payTypeMapEquip.put("name", "\u4e34\u65f6\u8bbe\u5907\u8d39\u7528");
        payTypeMapEquip.put("code", "temp_equip_fee");
        payTypeNoContractMap.put("\u4e34\u65f6\u8bbe\u5907\u8d39\u7528", payTypeMapEquip);
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportSettlePoolVO> successList = new ArrayList<ImportSettlePoolVO>();
        ArrayList<ImportSettlePoolVO> errorList = new ArrayList<ImportSettlePoolVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 14) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                OrgVO orgVO;
                OrgVO orgVO2;
                CommonResponse orgVORes;
                Long orgIdP = 0L;
                List datas = (List)result.get(i);
                ImportSettlePoolVO detailVO = new ImportSettlePoolVO();
                String parentOrgNameEx = (String)datas.get(0);
                detailVO.setParentOrgName(parentOrgNameEx);
                String contractNameEx = (String)datas.get(1);
                detailVO.setContractName(contractNameEx);
                String contractCodeEx = (String)datas.get(2);
                detailVO.setContractCode(contractCodeEx);
                String projectNameEx = (String)datas.get(3);
                detailVO.setProjectName(projectNameEx);
                String projectCodeEx = (String)datas.get(4);
                detailVO.setProjectCode(projectCodeEx);
                String settlePropertyNameEx = (String)datas.get(5);
                detailVO.setSettlePropertyName(settlePropertyNameEx);
                String partyaNameEx = (String)datas.get(6);
                detailVO.setPartyaName(partyaNameEx);
                String partybNameEx = (String)datas.get(7);
                detailVO.setPartybName(partybNameEx);
                String sourceTypeNameEx = (String)datas.get(8);
                detailVO.setSourceTypeName(sourceTypeNameEx);
                String settleDateStrEx = (String)datas.get(9);
                String curTaxMnyEx = (String)datas.get(10);
                detailVO.setCurTaxMnyStr(curTaxMnyEx);
                String curMnyEx = (String)datas.get(11);
                detailVO.setCurMnyStr(curMnyEx);
                String ultimateFlagNameEx = (String)datas.get(12);
                detailVO.setUltimateFlagName(ultimateFlagNameEx);
                String memoEx = (String)datas.get(13);
                detailVO.setMemo(memoEx);
                if (StringUtils.isBlank((CharSequence)parentOrgNameEx)) {
                    detailVO.setErrorMessage("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u53ef\u4e3a\u7a7a");
                } else if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(parentOrgNameEx) == null) {
                    orgVORes = this.orgApi.findByNameAndTenantId(parentOrgNameEx, tenantid);
                    if (orgVORes.isSuccess()) {
                        orgVO2 = (OrgVO)orgVORes.getData();
                        if (orgVO2 == null) {
                            detailVO.setErrorMessage("\u6839\u636e\u6240\u5c5e\u7ec4\u7ec7\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        } else {
                            orgVOMap.put(parentOrgNameEx, orgVO2);
                            orgIdP = orgVO2.getId();
                            detailVO.setParentOrgId(orgVO2.getId());
                            detailVO.setParentOrgCode(orgVO2.getCode());
                            detailVO.setParentOrgName(orgVO2.getName());
                        }
                    } else {
                        detailVO.setErrorMessage("\u6839\u636e\u6240\u5c5e\u7ec4\u7ec7\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                    }
                } else {
                    orgVO = (OrgVO)orgVOMap.get(parentOrgNameEx);
                    detailVO.setParentOrgId(orgVO.getId());
                    detailVO.setParentOrgCode(orgVO.getCode());
                    detailVO.setParentOrgName(orgVO.getName());
                }
                if (StringUtils.isNotBlank((CharSequence)contractNameEx) && StringUtils.isBlank((CharSequence)contractCodeEx) || StringUtils.isBlank((CharSequence)contractNameEx) && StringUtils.isNotBlank((CharSequence)contractCodeEx)) {
                    detailVO.setErrorMessage("\u5408\u540c\u540d\u79f0\u548c\u5408\u540c\u7f16\u7801\u8981\u4e48\u540c\u65f6\u4e3a\u7a7a\uff0c\u8981\u4e48\u540c\u65f6\u4e0d\u4e3a\u7a7a");
                } else if (StringUtils.isNotBlank((CharSequence)contractNameEx) && StringUtils.isNotBlank((CharSequence)contractCodeEx)) {
                    detailVO.setContractFlag(Integer.valueOf(1));
                    detailVO.setContractFlagName("\u662f");
                    if (MapUtils.isEmpty(contractPoolVoMap) || contractPoolVoMap.get(contractNameEx + "&" + contractCodeEx) == null) {
                        QueryWrapper contractPoolEntityQueryWrapper = new QueryWrapper();
                        ((QueryWrapper)((QueryWrapper)((QueryWrapper)contractPoolEntityQueryWrapper.eq((Object)"contract_name", (Object)contractNameEx)).eq((Object)"contract_code", (Object)contractCodeEx)).eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid);
                        List contractPoolEntityList = this.contractPoolMapper.selectList((Wrapper)contractPoolEntityQueryWrapper);
                        if (CollectionUtils.isEmpty((Collection)contractPoolEntityList)) {
                            detailVO.setErrorMessage("\u5408\u540c\u540d\u79f0\u548c\u5408\u540c\u7f16\u7801\u4e0d\u5339\u914d");
                        } else if (contractPoolEntityList.size() == 1) {
                            ContractPoolEntity contractPoolEntity = (ContractPoolEntity)((Object)contractPoolEntityList.get(0));
                            Long contractId = contractPoolEntity.getContractId();
                            if (contractId == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u540d\u79f0\u548c\u5408\u540c\u7f16\u7801\u67e5\u8be2\u5230\u7684\u6570\u636e\u7684\u5408\u540cID\u4e3a\u7a7a");
                            } else {
                                contractPoolVoMap.put(contractNameEx + "&" + contractCodeEx, contractPoolEntity);
                                detailVO.setContractId(contractId);
                                detailVO.setContractCode(contractCodeEx);
                                detailVO.setContractName(contractNameEx);
                                this.setDetailVOPartData(detailVO, contractPoolEntity);
                            }
                        } else {
                            detailVO.setErrorMessage("\u5408\u540c\u540d\u79f0\u548c\u5408\u540c\u7f16\u7801\u4e0d\u5339\u914d");
                        }
                    } else {
                        ContractPoolEntity contractPoolEntity = (ContractPoolEntity)((Object)contractPoolVoMap.get(contractNameEx + "&" + contractCodeEx));
                        detailVO.setContractId(contractPoolEntity.getContractId());
                        detailVO.setContractCode(contractCodeEx);
                        detailVO.setContractName(contractNameEx);
                        this.setDetailVOPartData(detailVO, contractPoolEntity);
                    }
                } else {
                    detailVO.setContractFlag(Integer.valueOf(0));
                    detailVO.setContractFlagName("\u5426");
                    if (StringUtils.isBlank((CharSequence)projectNameEx) || StringUtils.isBlank((CharSequence)projectCodeEx)) {
                        detailVO.setErrorMessage("\u9879\u76ee\u540d\u79f0\u6216\u9879\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
                    } else if (MapUtils.isEmpty(projectPoolVoMap) || projectPoolVoMap.get(projectNameEx + "&" + projectCodeEx) == null) {
                        CommonResponse projectListRes = this.projectPoolApi.queryProjectListByNameAndCodeAndTenantId(projectNameEx, projectCodeEx, tenantid);
                        if (projectListRes.isSuccess()) {
                            List projectList = (List)projectListRes.getData();
                            if (CollectionUtils.isEmpty((Collection)projectList)) {
                                detailVO.setErrorMessage("\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u4e0d\u5339\u914d");
                            } else if (projectList.size() == 1) {
                                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectList.get(0);
                                Long projectDepartmentId = projectPoolSetVO.getProjectDepartmentId();
                                if (MapUtils.isEmpty(projectOrgVoMap) || projectOrgVoMap.get(projectDepartmentId.toString()) == null) {
                                    CommonResponse orgVOCommonResponse = this.orgApi.detailById(projectDepartmentId);
                                    if (orgVOCommonResponse.isSuccess()) {
                                        OrgVO orgVO3 = (OrgVO)orgVOCommonResponse.getData();
                                        if (orgVO3 == null) {
                                            detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                        } else {
                                            projectOrgVoMap.put(projectDepartmentId.toString(), orgVO3);
                                            String innerCode = orgVO3.getInnerCode();
                                            if (StringUtils.isEmpty((CharSequence)innerCode)) {
                                                detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25");
                                            } else {
                                                List innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                                if (!innerCodes.contains(orgIdP)) {
                                                    detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                                } else {
                                                    detailVO.setOrgId(orgVO3.getId());
                                                    detailVO.setOrgCode(orgVO3.getCode());
                                                    detailVO.setOrgName(orgVO3.getName());
                                                }
                                            }
                                        }
                                    } else {
                                        detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u7f16\u7801\u67e5\u8be2\u6240\u5728\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25");
                                    }
                                } else {
                                    OrgVO orgVO4 = (OrgVO)projectOrgVoMap.get(projectDepartmentId.toString());
                                    String innerCode = orgVO4.getInnerCode();
                                    if (StringUtils.isEmpty((CharSequence)innerCode)) {
                                        detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u5931\u8d25");
                                    } else {
                                        List innerCodes = Arrays.stream(innerCode.split("\\|")).map(Long::parseLong).distinct().collect(Collectors.toList());
                                        if (!innerCodes.contains(orgIdP)) {
                                            detailVO.setErrorMessage("\u5f53\u524d\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u6240\u5728\u7684\u9879\u76ee\u4e0d\u5728\u6240\u5c5e\u7ec4\u7ec7\u4e0b");
                                        } else {
                                            detailVO.setOrgId(orgVO4.getId());
                                            detailVO.setOrgCode(orgVO4.getCode());
                                            detailVO.setOrgName(orgVO4.getName());
                                        }
                                    }
                                }
                                projectPoolVoMap.put(projectNameEx + "&" + projectCodeEx, projectPoolSetVO);
                                detailVO.setProjectId(projectPoolSetVO.getId());
                                detailVO.setProjectCode(projectPoolSetVO.getCode());
                                detailVO.setProjectName(projectPoolSetVO.getName());
                            } else {
                                detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u5931\u8d25");
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u9879\u76ee\u540d\u79f0\u548c\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u5931\u8d25");
                        }
                    } else {
                        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectPoolVoMap.get(projectNameEx + "&" + projectCodeEx);
                        detailVO.setProjectId(projectPoolSetVO.getId());
                        detailVO.setProjectCode(projectPoolSetVO.getCode());
                        detailVO.setProjectName(projectPoolSetVO.getName());
                    }
                    if (StringUtils.isBlank((CharSequence)settlePropertyNameEx)) {
                        detailVO.setErrorMessage("\u5c5e\u6027\u7c7b\u522b\u4e0d\u53ef\u4e3a\u7a7a");
                    } else if ("\u6536\u5165".equals(settlePropertyNameEx)) {
                        detailVO.setSettleProperty(Integer.valueOf(1));
                        detailVO.setSettlePropertyName(settlePropertyNameEx);
                    } else if ("\u652f\u51fa".equals(settlePropertyNameEx)) {
                        detailVO.setSettleProperty(Integer.valueOf(0));
                        detailVO.setSettlePropertyName(settlePropertyNameEx);
                    } else {
                        detailVO.setErrorMessage("\u5c5e\u6027\u7c7b\u522b\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                    if (StringUtils.isBlank((CharSequence)partyaNameEx)) {
                        detailVO.setErrorMessage("\u5408\u540c\u7532\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                    } else if (MapUtils.isEmpty(orgVOMap) || orgVOMap.get(partyaNameEx) == null) {
                        orgVORes = this.orgApi.findByNameAndTenantId(partyaNameEx, tenantid);
                        if (orgVORes.isSuccess()) {
                            orgVO2 = (OrgVO)orgVORes.getData();
                            if (orgVO2 == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                            } else {
                                orgVOMap.put(partyaNameEx, orgVO2);
                                detailVO.setPartyaId(orgVO2.getId());
                                detailVO.setPartyaName(orgVO2.getName());
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u7532\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        }
                    } else {
                        orgVO = (OrgVO)orgVOMap.get(partyaNameEx);
                        detailVO.setPartyaId(orgVO.getId());
                        detailVO.setPartyaName(orgVO.getName());
                    }
                    if (StringUtils.isBlank((CharSequence)partybNameEx)) {
                        detailVO.setErrorMessage("\u5408\u540c\u4e59\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
                    } else if (MapUtils.isEmpty(supplierVOMap) || supplierVOMap.get(partybNameEx) == null) {
                        CommonResponse supplierVORes = this.shareSupplierApi.findOneByName(partybNameEx, tenantid);
                        if (supplierVORes.isSuccess()) {
                            SupplierVO supplierVO = (SupplierVO)supplierVORes.getData();
                            if (supplierVO == null) {
                                detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                            } else {
                                supplierVOMap.put(partybNameEx, supplierVO);
                                detailVO.setPartybId(supplierVO.getId());
                                detailVO.setPartybName(supplierVO.getName());
                            }
                        } else {
                            detailVO.setErrorMessage("\u6839\u636e\u5408\u540c\u4e59\u65b9\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                        }
                    } else {
                        SupplierVO supplierVO = (SupplierVO)supplierVOMap.get(partybNameEx);
                        detailVO.setPartybId(supplierVO.getId());
                        detailVO.setPartybName(supplierVO.getName());
                    }
                }
                if (StringUtils.isBlank((CharSequence)sourceTypeNameEx)) {
                    detailVO.setErrorMessage("\u7ed3\u7b97\u5355\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    String sourceType;
                    Integer contractFlag = detailVO.getContractFlag();
                    if (contractFlag == 0) {
                        if (!"\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97".equals(sourceTypeNameEx) && !"\u96f6\u661f\u8d39\u7528\u7ed3\u7b97".equals(sourceTypeNameEx)) {
                            detailVO.setErrorMessage("\u5f53\u524d\u4e3a\u65e0\u5408\u540c\u7ed3\u7b97\uff0c\u7ed3\u7b97\u5355\u7c7b\u578b\u53ea\u80fd\u662f\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u6216\u96f6\u661f\u8d39\u7528\u7ed3\u7b97");
                        }
                    } else if (contractFlag == 1 && ("\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97".equals(sourceTypeNameEx) || "\u96f6\u661f\u8d39\u7528\u7ed3\u7b97".equals(sourceTypeNameEx))) {
                        detailVO.setErrorMessage("\u5f53\u524d\u4e3a\u65e0\u5408\u540c\u7ed3\u7b97\uff0c\u7ed3\u7b97\u5355\u7c7b\u578b\u4e0d\u80fd\u662f\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u6216\u96f6\u661f\u8d39\u7528\u7ed3\u7b97");
                    }
                    if (StringUtils.isBlank((CharSequence)(sourceType = this.getSourceTypeBySourceTypeName(sourceTypeNameEx)))) {
                        detailVO.setErrorMessage("\u7ed3\u7b97\u5355\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e");
                    } else {
                        detailVO.setSourceTypeName(sourceTypeNameEx);
                        detailVO.setSourceType(sourceType);
                    }
                    if (contractFlag == 0) {
                        Map materialMap = (Map)payTypeNoContractMap.get("\u96f6\u661f\u6750\u6599\u8d39\u7528");
                        Map equipMap = (Map)payTypeNoContractMap.get("\u4e34\u65f6\u8bbe\u5907\u8d39\u7528");
                        if ("\u96f6\u661f\u8d39\u7528\u7ed3\u7b97".equals(sourceTypeNameEx)) {
                            detailVO.setPayTypeNoContractId(Long.valueOf(Long.parseLong(materialMap.get("id").toString())));
                            detailVO.setPayTypeNoContractCode(materialMap.get("code").toString());
                            detailVO.setPayTypeNoContractName(materialMap.get("name").toString());
                        } else if ("\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97".equals(sourceTypeNameEx)) {
                            detailVO.setPayTypeNoContractId(Long.valueOf(Long.parseLong(equipMap.get("id").toString())));
                            detailVO.setPayTypeNoContractCode(equipMap.get("code").toString());
                            detailVO.setPayTypeNoContractName(equipMap.get("name").toString());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)settleDateStrEx)) {
                    detailVO.setErrorMessage("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        detailVO.setSettleDate(HSSFDateUtil.getJavaDate((double)Double.parseDouble(settleDateStrEx)));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f\u586b\u5199\u4e0d\u6b63\u786e");
                    }
                }
                if (StringUtils.isBlank((CharSequence)curTaxMnyEx)) {
                    detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal curTaxMny = new BigDecimal(curTaxMnyEx);
                        if (curTaxMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setCurTaxMny(curTaxMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isBlank((CharSequence)curMnyEx)) {
                    detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a");
                } else {
                    try {
                        BigDecimal curMny = new BigDecimal(curMnyEx);
                        if (curMny.compareTo(BigDecimal.ZERO) < 0) {
                            detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u5c0f\u4e8e0");
                        } else {
                            detailVO.setCurMny(curMny);
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                try {
                    BigDecimal curTax = new BigDecimal(curTaxMnyEx).subtract(new BigDecimal(curMnyEx));
                    if (curTax.compareTo(BigDecimal.ZERO) < 0) {
                        detailVO.setErrorMessage("\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d\uff08\u65e0\u7a0e\uff09");
                    } else {
                        detailVO.setCurTax(curTax.abs());
                    }
                }
                catch (Exception e) {
                    detailVO.setErrorMessage("\u8ba1\u7b97\u672c\u671f\u7ed3\u7b97\u7a0e\u989d\u5931\u8d25\uff0c\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u548c\u672c\u671f\u7ed3\u7b97\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3a\u6570\u5b57");
                }
                if (StringUtils.isBlank((CharSequence)ultimateFlagNameEx)) {
                    detailVO.setErrorMessage("\u662f\u5426\u6700\u7ec8\u7ed3\u7b97\u4e0d\u53ef\u4e3a\u7a7a");
                } else if ("\u662f".equals(ultimateFlagNameEx)) {
                    detailVO.setUltimateFlag(Integer.valueOf(1));
                    detailVO.setUltimateFlagName(ultimateFlagNameEx);
                } else if ("\u5426".equals(ultimateFlagNameEx)) {
                    detailVO.setUltimateFlag(Integer.valueOf(0));
                    detailVO.setUltimateFlagName(ultimateFlagNameEx);
                } else {
                    detailVO.setErrorMessage("\u662f\u5426\u6700\u7ec8\u7ed3\u7b97\u586b\u5199\u4e0d\u6b63\u786e");
                }
                if (StringUtils.isNotBlank((CharSequence)memoEx) && memoEx.length() > 100) {
                    detailVO.setErrorMessage("\u5907\u6ce8\u957f\u5ea6\u4e0d\u53ef\u5927\u4e8e100");
                } else {
                    detailVO.setMemo(memoEx);
                }
                if (StringUtils.isBlank((CharSequence)detailVO.getErrorMessage())) {
                    detailVO.setHandleType(Integer.valueOf(1));
                    detailVO.setHandleTypeName("\u662f");
                    successList.add(detailVO);
                    continue;
                }
                errorList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        List sucEntityList = BeanMapper.mapList(successList, SettlePoolEntity.class);
        if (CollectionUtils.isNotEmpty((Collection)sucEntityList)) {
            for (SettlePoolEntity entity : sucEntityList) {
                CommonResponse billCodeRes;
                SettlePoolVO saveOrUpdateVO = (SettlePoolVO)BeanMapper.map((Object)((Object)entity), SettlePoolVO.class);
                entity.setCreateTime(new Date());
                UserContext userContext = this.sessionManager.getUserContext();
                entity.setCreateUserCode(userContext.getUserCode());
                entity.setCreateUserName(userContext.getUserName());
                BillCodeParam billCodeParam = new BillCodeParam();
                if (entity.getContractFlag() != null) {
                    billCodeParam = entity.getContractFlag() == 0 ? BillCodeParam.build((String)BILL_CODE_NO_CONTRACT, (Long)tenantid, (BaseVO)saveOrUpdateVO) : BillCodeParam.build((String)BILL_CODE, (Long)tenantid, (BaseVO)saveOrUpdateVO);
                }
                if ((billCodeRes = this.billCodeApi.generateBillCode(billCodeParam)).isSuccess()) {
                    entity.setBillCode((String)billCodeRes.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            this.saveOrUpdateBatch(sucEntityList, sucEntityList.size(), false);
        }
        return CommonResponse.success((Object)json);
    }

    private void setDetailVOPartData(ImportSettlePoolVO detailVO, ContractPoolEntity contractPoolEntity) {
        detailVO.setProjectId(contractPoolEntity.getProjectId());
        detailVO.setProjectCode(contractPoolEntity.getProjectCode());
        detailVO.setProjectName(contractPoolEntity.getProjectName());
        detailVO.setOrgId(contractPoolEntity.getOrgId());
        detailVO.setOrgCode(contractPoolEntity.getOrgCode());
        detailVO.setOrgName(contractPoolEntity.getOrgName());
        detailVO.setSettleProperty(contractPoolEntity.getContractProperty());
        detailVO.setPartyaId(contractPoolEntity.getPartyaId());
        detailVO.setPartyaName(contractPoolEntity.getPartyaName());
        detailVO.setPartybId(contractPoolEntity.getPartybId());
        detailVO.setPartybName(contractPoolEntity.getPartybName());
    }

    private String getSourceTypeBySourceTypeName(String sourceTypeName) {
        String sourceType = "";
        switch (sourceTypeName) {
            case "\u4ea7\u503c\u62a5\u91cf": {
                sourceType = "product_value";
                break;
            }
            case "\u5bf9\u7532\u62a5\u91cf": {
                sourceType = "product_value_first";
                break;
            }
            case "\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97": {
                sourceType = "labor_month";
                break;
            }
            case "\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97": {
                sourceType = "labor_node";
                break;
            }
            case "\u52b3\u52a1\u5206\u5305\u7ae3\u5de5\u7ed3\u7b97": {
                sourceType = "labor_final";
                break;
            }
            case "\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97": {
                sourceType = "pro_month";
                break;
            }
            case "\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97": {
                sourceType = "pro_node";
                break;
            }
            case "\u4e13\u4e1a\u5206\u5305\u7ae3\u5de5\u7ed3\u7b97": {
                sourceType = "pro_final";
                break;
            }
            case "\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97": {
                sourceType = "equip_buy_in";
                break;
            }
            case "\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97": {
                sourceType = "beton_buy_in";
                break;
            }
            case "\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97": {
                sourceType = "material_buy_in";
                break;
            }
            case "\u5468\u8f6c\u6750\u79df\u5165\u7ed3\u7b97": {
                sourceType = "material_week_rent_in";
                break;
            }
            case "\u8bbe\u5907\u79df\u5165\u7ed3\u7b97": {
                sourceType = "equip_rent_in";
                break;
            }
            case "\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97": {
                sourceType = "temp_equip";
                break;
            }
            case "\u96f6\u661f\u8d39\u7528\u7ed3\u7b97": {
                sourceType = "sporadic_material";
                break;
            }
            case "\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u7ed3\u7b97": {
                sourceType = "big_equip_install_uninstall";
                break;
            }
            case "\u8bc9\u8bbc\u8d39\u7ed3\u7b97": {
                sourceType = "law_cost";
                break;
            }
            case "\u5176\u4ed6\u652f\u51fa\u7ed3\u7b97": {
                sourceType = "other_out";
                break;
            }
            case "\u5176\u4ed6\u6536\u5165\u7ed3\u7b97": {
                sourceType = "other_in";
                break;
            }
            case "\u5468\u8f6c\u6750\u79df\u51fa\u7ed3\u7b97\uff08\u516c\u53f8\uff09": {
                sourceType = "material_week_rent_out_company";
                break;
            }
            case "\u5468\u8f6c\u6750\u79df\u5165\u7ed3\u7b97\uff08\u516c\u53f8\uff09": {
                sourceType = "material_week_rent_in_company";
                break;
            }
            case "\u5468\u8f6c\u6750\u91c7\u8d2d\u7ed3\u7b97\uff08\u516c\u53f8\uff09": {
                sourceType = "material_week_buy_in_company";
                break;
            }
            case "\u8bbe\u5907\u7ec4\u51fa\u7ed3\u7b97\uff08\u516c\u53f8\uff09": {
                sourceType = "equip_rent_out_company";
                break;
            }
            case "\u8bbe\u5907\u79df\u5165\u7ed3\u7b97\uff08\u516c\u53f8\uff09": {
                sourceType = "equip_rent_in_company";
                break;
            }
        }
        return sourceType;
    }

    @Override
    public BigDecimal fetchTotalProductValueTaxMny(Long projectId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"source_type", (Object)"product_value");
        queryWrapper.select(new String[]{"ifnull(sum(cur_tax_mny), 0) as total"});
        Map resultMap = super.getMap((Wrapper)queryWrapper);
        if (resultMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(resultMap.get("total").toString());
    }

    @Override
    public Map<String, Object> fetchTotalSettleTaxMny(Collection<Long> contractIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new BusinessException("\u5408\u540cid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in((Object)"contract_id", contractIds);
        queryWrapper.groupBy((Object[])new String[]{"contract_id"});
        queryWrapper.select(new String[]{"contract_id as contractId, ifnull(sum(cur_tax_mny), 0) as total"});
        List resultMaps = super.listMaps((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)resultMaps)) {
            return Collections.emptyMap();
        }
        for (Map map : resultMaps) {
            if (result.containsKey(map.get("contractId").toString())) continue;
            result.put(map.get("contractId").toString(), map.get("total").toString());
        }
        return result;
    }

    @Override
    public Map<String, BigDecimal> queryContractsTotalSettleMny(QueryParam queryParam) {
        Map params = queryParam.getParams();
        ArrayList<String> settleType = new ArrayList<String>();
        if (null != params.get("contractType")) {
            ArrayList<String> contractTypeList = new ArrayList<String>();
            Object contractTypeObj = ((Parameter)params.get("contractType")).getValue();
            if (contractTypeObj instanceof String) {
                contractTypeList.addAll(Arrays.asList(((Parameter)params.get("contractType")).getValue().toString().split(",")));
            } else {
                contractTypeList.addAll(JSONObject.parseArray((String)JSONObject.toJSONString((Object)contractTypeObj), String.class));
            }
            ComplexParam cp1 = new ComplexParam();
            cp1.setLogic("and");
            if (contractTypeList.contains(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode())) {
                settleType.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
                settleType.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
                contractTypeList.remove(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            }
            if (contractTypeList.contains(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode())) {
                settleType.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
                settleType.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
                contractTypeList.remove(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
            }
            if (contractTypeList.contains(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode())) {
                settleType.add(SettleSourceTypeEnum.\u96f6\u661f\u6750\u6599\u7ed3\u7b97.getCode());
            }
            if (contractTypeList.indexOf(ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode()) >= 0) {
                settleType.add(SettleSourceTypeEnum.\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97.getCode());
            }
            if (CollectionUtils.isNotEmpty(settleType)) {
                ComplexParam cp3 = new ComplexParam();
                cp3.setLogic("or");
                cp3.getParams().put("source_type", new Parameter("in", (Object)StringUtils.join(settleType, (String)",")));
                cp1.getComplexParams().add(cp3);
                queryParam.getComplexParams().add(cp1);
                if (CollectionUtils.isNotEmpty(contractTypeList)) {
                    ComplexParam cp2 = new ComplexParam();
                    cp2.setLogic("or");
                    cp2.getParams().put("contract_type", new Parameter("in", (Object)StringUtils.join(contractTypeList, (String)",")));
                    cp1.getComplexParams().add(cp2);
                }
                queryParam.getParams().remove("contractType");
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("source_type", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        queryParam.getComplexParams().add(c1);
        List settleList = super.queryList(queryParam, false);
        BigDecimal totalMny = null;
        HashMap<String, BigDecimal> resp = new HashMap<String, BigDecimal>();
        String tmpContractType = null;
        for (SettlePoolEntity entity : settleList) {
            tmpContractType = Integer.valueOf(1).equals(entity.getContractFlag()) ? entity.getContractType() : (SettleSourceTypeEnum.\u96f6\u661f\u6750\u6599\u7ed3\u7b97.getCode().equals(entity.getSourceType()) ? ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode() : ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
            totalMny = (BigDecimal)resp.get(tmpContractType);
            if (null == totalMny) {
                totalMny = BigDecimal.ZERO;
            }
            if (SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType()) || SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode().equals(entity.getSourceType())) {
                if (entity.getTotalNodeTaxDifference() != null) {
                    totalMny = totalMny.add(entity.getTotalNodeTaxDifference());
                }
            } else {
                totalMny = totalMny.add(entity.getCurTaxMny());
            }
            resp.put(tmpContractType, totalMny);
        }
        SettlePoolVO settleVO = new SettlePoolVO();
        settleVO.setCurTaxMny(totalMny);
        return resp;
    }

    @Override
    public List<JSONObject> getSynergyList(Long groupId, List<Long> orgIds, String groupField) {
        return this.poolMapper.getSynergyList(groupId, orgIds, groupField);
    }
}

