package com.ejianc.business.contractbase.cooperative.controller;

import java.io.Serializable;

import com.ejianc.business.contractbase.cooperative.vo.CooperativeRatioVO;
import com.ejianc.business.contractbase.util.DateUtil;
import com.ejianc.business.contractbase.util.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.contractbase.cooperative.bean.CooperativeCollectEntity;
import com.ejianc.business.contractbase.cooperative.service.ICooperativeCollectService;
import com.ejianc.business.contractbase.cooperative.vo.CooperativeCollectVO;

/**
 * 协同数据汇总表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("cooperativeCollect")
public class CooperativeCollectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICooperativeCollectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CooperativeCollectVO> saveOrUpdate(@RequestBody CooperativeCollectVO saveOrUpdateVO) {
    	CooperativeCollectEntity entity = BeanMapper.map(saveOrUpdateVO, CooperativeCollectEntity.class);
    	service.saveOrUpdate(entity, false);
    	CooperativeCollectVO vo = BeanMapper.map(entity, CooperativeCollectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CooperativeCollectVO> queryDetail(Long id) {
    	CooperativeCollectEntity entity = service.selectById(id);
    	CooperativeCollectVO vo = BeanMapper.map(entity, CooperativeCollectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CooperativeCollectVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CooperativeCollectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CooperativeCollectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CooperativeCollectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CooperativeCollectEntity> page = service.queryPage(param,false);
        IPage<CooperativeCollectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CooperativeCollectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CooperativeCollectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CooperativeCollect-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCooperativeCollectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CooperativeCollectVO>> refCooperativeCollectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CooperativeCollectEntity> page = service.queryPage(param,false);
        IPage<CooperativeCollectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CooperativeCollectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 协同率数据初始化
     */
    @RequestMapping(value = "/initCooperativeCollect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> initCooperativeCollect(HttpServletRequest request) {
        service.initCooperativeCollect();
        return CommonResponse.success("协同率数据初始化成功");
    }



    /**
     * @Description 项目协同率统计
     */
    @RequestMapping(value = "/getProjectCooperativeRatio", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CooperativeRatioVO>> getProjectCooperativeRatio(@RequestBody QueryParam param){
        return CommonResponse.success("查询协同率数据成功！", service.getProjectCooperativeRatio(param));
    }


    /**
     * @Description 供应商协同率统计
     */
    @RequestMapping(value = "/getSupplierCooperativeRatio", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CooperativeRatioVO>> getSupplierCooperativeRatio(@RequestBody QueryParam param){
        return CommonResponse.success("查询协同率数据成功！", service.getSupplierCooperativeRatio(param));
    }


    @GetMapping(value = "/getCooperativeList")
    public CommonResponse<List<JSONObject>> getCooperativeList(@RequestParam Long id,
                                                           @RequestParam String groupField,
                                                           @RequestParam(required = false) String startDate,
                                                           @RequestParam(required = false) String endDate,
                                                           @RequestParam(required = false) Long orgId) {
        QueryParam queryParam = new QueryParam();
        //组织
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        if ("projectId".equals(groupField)){
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, id));
            queryParam.getOrderMap().put("projectId", QueryParam.ASC);
        }else {
            queryParam.getParams().put("supplierId", new Parameter(QueryParam.EQ, id));
            queryParam.getOrderMap().put("supplierId", QueryParam.ASC);
        }
        queryParam.getParams().put("cooperativeFlag", new Parameter(QueryParam.EQ, 1));
        if (null != startDate && StringUtils.isNotBlank(startDate) && null != endDate && StringUtils.isNotBlank(endDate)){
            queryParam.getParams().put("billCreateDate", new Parameter(QueryParam.BETWEEN, startDate + "," + endDate));
        }

        List<CooperativeCollectVO> dataList = BeanMapper.mapList(service.queryList(queryParam), CooperativeCollectVO.class);
        logger.info("groupId-{}, groupFields-{},查询出协同列表数据:{}条", id, groupField, dataList.size());
        Map<String, List<CooperativeCollectVO>> groupData = dataList.stream().collect(Collectors.groupingBy(item -> ("projectId".equals(groupField) ? item.getSupplierId().toString() : item.getProjectId().toString())  + item.getBillTypeName()));

        List<JSONObject> resp = new ArrayList<>();
        JSONObject tmp = null;
        CooperativeCollectVO cooperativeCollectVO = null;
        for(String key : groupData.keySet()) {
            tmp = new JSONObject();
            cooperativeCollectVO = groupData.get(key).get(0);
            tmp.put("billType", cooperativeCollectVO.getBillTypeName());
            tmp.put("supplierName", cooperativeCollectVO.getSupplierName());
            tmp.put("projectName", cooperativeCollectVO.getProjectName());
            tmp.put("ratioBillNum", groupData.get(key).size());
            tmp.put("list", groupData.get(key));
            resp.add(tmp);
        }
        resp.sort(Comparator.comparing(obj->obj.getString("ratioBillNum")));
        return CommonResponse.success("查询成功！", resp);
    }



}
