package com.ejianc.business.contractbase.filing.controller;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.entity.ContractFilingEntity;
import com.ejianc.business.contractbase.filing.entity.FilingTypeEntity;
import com.ejianc.business.contractbase.filing.enums.FilingBillTypeEnum;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.filing.enums.FilingTypeEnum;
import com.ejianc.business.contractbase.filing.service.IContractFilingService;
import com.ejianc.business.contractbase.filing.service.IFilingTypeService;
import com.ejianc.business.contractbase.filing.vo.ContractFilingVO;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.json.JsonObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@RestController
@RequestMapping("contractFiling")
public class ContractFilingController {


    private static final String BILL_CODE = "FIL_LAB";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractFilingService service;
    @Value("${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IFilingTypeService typeService;

    @Autowired
    private IContractPoolService contractPoolService;

    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractFilingVO> saveOrUpdate(@RequestBody ContractFilingVO saveorUpdateVO) {
        logger.info("nnnnno{}",saveorUpdateVO.getContractId());
        ContractFilingVO resp = service.saveOrUpdateFilingVO(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功!", resp);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractFilingVO> queryDetail(String id) {
        logger.info("归档");
        ContractFilingEntity entity = null;
        ContractFilingVO vo = null;
        if (id.startsWith("10086")) {
            String sourceId = id.substring(5);
            QueryWrapper<ContractFilingEntity> query = new QueryWrapper<>();
            query.eq("source_id", sourceId);
            entity = service.getOne(query);
        } else {
            entity = service.selectById(id);
        }
        if (entity == null) {
            return CommonResponse.error("当前数据是自动归档无对应信息！");
        }
        vo = BeanMapper.map(entity, ContractFilingVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractFilingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractFilingVO vo : vos) {
                ContractFilingEntity contractFilingEntity = service.selectById(vo.getId());
                service.updateFilingStatus(contractFilingEntity, FilingStatusEnum.未归档.getTypeCode(),0);
            }
        }
        service.removeByIds(vos.stream().map(ContractFilingVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractFilingVO>> queryList(@RequestBody QueryParam param) {

        //模糊搜索配置字段示例
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");

        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ContractFilingEntity> page = service.queryPage(param, false);
        IPage<ContractFilingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractFilingVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        //查询本下范围内日的数据
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        //查询所有满足的数据 按照创建时间倒叙
        param.getOrderMap().put("create_time", QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<ContractFilingEntity> pageData = service.queryPage(param, false);

        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ContractFilingVO> list = BeanMapper.mapList(pageData.getRecords(), ContractFilingVO.class);
            for (ContractFilingVO vo : list) {
                vo.setBillStateStr(BillStateEnum.getEnumByStateCode(Integer.valueOf(vo.getBillState())).getDescription());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                vo.setFilingDateStr(sdf.format(vo.getFilingDate()));
            }
            Map<String, Object> beans = new HashMap<>(list.size());
            logger.error(JSONObject.toJSONString(list));
            beans.put("records", list);
            ExcelExport.getInstance().export("filing-export.xlsx", beans, response);
        }
    }

    /**
     * 参照查询
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/filingDataRef", method = RequestMethod.GET)
    public CommonResponse<JSONObject> filingDataRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        if (null == condition || org.apache.commons.lang.StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (!(null != conditionMap.get("orgId"))) {
            return CommonResponse.error("当前传入组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error("当前传入组织类型为空！");
        }
        String columns = null;
        String databaseName = null;
        String parameter = null;
        String tableName = null;
        String authority = null;
        if (!(null != conditionMap.get("filingTypeId"))) {
            return CommonResponse.error("当前传入归档类型为空！");
        }
        Object filingTypeId = conditionMap.get("filingTypeId");
        FilingTypeEntity typeEntity = typeService.selectById(filingTypeId.toString());
        columns = typeEntity.getQueryColumns();
        databaseName = typeEntity.getQueryDatabaseName();
        tableName = typeEntity.getQueryTableName();
        parameter = typeEntity.getQueryParameter();
        //查询本下范围内日的合同
        Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
            parameter = parameter + " and org_id =" + orgId+" ";
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            parameter = parameter + " and org_id in (" + StringUtils.join(orgIdList, ",") + ")";
        }
        if (StringUtils.isNotBlank(searchText)) {
            parameter = parameter + "and(contract_name LIKE '%" + searchText + "%' OR project_name LIKE '%" + searchText + "%' OR bill_code LIKE '%" + searchText + "%')";

        }
        parameter = parameter + " ORDER BY create_time DESC limit " + (pageNumber - 1) * pageSize + "," + pageSize;

        //获取请求头
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        logger.info("获取的请求头 authority：{}", request.getHeader("authority"));
        if (StringUtils.isNotBlank(request.getHeader("authority"))) {
            authority = request.getHeader("authority");
        }
        Map<String, Object> params = new HashMap<>();
        params.put("columns", columns);
        params.put("databaseName", databaseName);
        params.put("parameter", parameter);
        params.put("tableName", tableName);
        params.put("projectName", typeEntity.getQueryProjectName());

        logger.info("查询参数 params：{}", JSONObject.toJSONString(params));
        String url = BaseHost + typeEntity.getQueryProjectName() + "/pubQuery/queryBillMap";
        String response = HttpUtil.createRequest(Method.POST, url)
                .header("authority", authority)
                .body(JSON.toJSONString(params))
                .timeout(10000)
                .execute().body();
        Assert.hasLength(response, "合同请求失败，返回结果为空！");
        logger.info("调用业务系统url-{}，param-{}，结果：{}", url, JSON.toJSONString(params, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue), response);
        CommonResponse<JSONObject> commonResponse = JSON.parseObject(response, CommonResponse.class);
        if (!commonResponse.isSuccess()) {
            logger.error("请求「成功」，返回结果「失败」：{}！", commonResponse);
            throw new BusinessException("请求「成功」，返回结果「失败」：" + commonResponse);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", pageNumber);
        jsonObject.put("size", pageSize);
        if (commonResponse.getData().get("count") != null && Integer.valueOf((String) commonResponse.getData().get("count")) != 0) {
            jsonObject.put("records", commonResponse.getData().get("data"));
            jsonObject.put("total", commonResponse.getData().get("count"));
            jsonObject.put("pages", getPages(pageSize, Integer.valueOf((String) commonResponse.getData().get("count"))));
        } else {
            jsonObject.put("records", null);
            jsonObject.put("total", 0);
            jsonObject.put("pages", 0);
        }

        return CommonResponse.success("查询成功", jsonObject);
    }


    long getPages(long size, long total) {
        if (size == 0) {
            return 0L;
        }
        long pages = total / size;
        if (total % size != 0) {
            pages++;
        }
        return pages;
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId   合同Id
     * @return
     */
    @GetMapping(value = "/checkReturnFileId")
    public CommonResponse<JSONObject> checkReturnFileId(@RequestParam(value = "billId") Long billId,Long fileId,String fileName
    ) {
        JSONObject json = new JSONObject();
        //查询是否有存储归档信息
        QueryWrapper<ContractFilingEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", billId);
        queryWrapper.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        queryWrapper.eq("dr", 0);
        List<ContractFilingEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)&&list.get(0).getFileId()!= null) {
            fileId =list.get(0).getFileId();
            fileName =list.get(0).getFileName();

        }
        json.put("fileId",fileId);
        json.put("fileName",fileName);
        return CommonResponse.success("查询成功", json);
    }


    /**
     * @param contractId
     * @Description queryDetail 根据合同id在合同池查询合同详情
     */
    @RequestMapping(value = "/queryContractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryContractDetail(String contractId, String contractSubType) {
        logger.info("归档通过合同id：{}，单据编码-contractSubType：{}，查询合同详情！", contractId, contractSubType);
        JSONObject object = service.queryContractDetail(contractId, contractSubType);
        if (object.getString("record") == null){
            return CommonResponse.error("查询失败，根据合同id未查询到对应合同！");
        }
        return CommonResponse.success("查询详情数据成功！", object);
    }

}
