/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.home.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.api.IAnnualOperatingIndicatorsApi;
import com.ejianc.business.contractbase.home.consts.BusinessStatusEnum;
import com.ejianc.business.contractbase.home.consts.DevTypeEnum;
import com.ejianc.business.contractbase.home.consts.ProjectStatusEnum;
import com.ejianc.business.contractbase.home.consts.ProjectSurveyEnum;
import com.ejianc.business.contractbase.home.mapper.HomePortalMapper;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.home.util.EJCDateUtil;
import com.ejianc.business.contractbase.home.util.ListCallable;
import com.ejianc.business.contractbase.home.util.PageUtil;
import com.ejianc.business.contractbase.home.vo.CostDetailVO;
import com.ejianc.business.contractbase.home.vo.FinanceCountVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResSubVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.contractbase.home.vo.ProjectInOutVO;
import com.ejianc.business.contractbase.home.vo.ProjectPoolSetTreeVO;
import com.ejianc.business.contractbase.home.vo.TargetCostDetailVO;
import com.ejianc.business.contractbase.pool.contractpool.bean.ContractPoolEntity;
import com.ejianc.business.contractbase.pool.contractpool.service.IContractPoolService;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.bean.SettlePoolEntity;
import com.ejianc.business.contractbase.pool.settlepool.service.ISettlePoolService;
import com.ejianc.business.contractbase.utils.TreeNodeBUtil;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.outputvalcount.vo.OutputValDTO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="ContractService")
public class HomePortalServiceImpl
extends BaseServiceImpl<HomePortalMapper, ContractPoolEntity>
implements IHomePortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IAnnualOperatingIndicatorsApi indicatorsApi;
    @Autowired
    private IContractPoolService contractService;
    @Autowired
    private ISettlePoolService settleService;
    @Autowired
    private HomePortalMapper mapper;
    @Autowired
    private IShareSubjectOrgApi subjectOrgApi;
    @Autowired
    private IOutputValueApi outputValueApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMdApi mdApi;
    private String PROJECT_SETTLE_RANGE_PARAM = "P-zF77230174";
    @Autowired
    private IProSupplierApi proSupplierApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCount(String range, String dateIn, Long orgId) {
        String projectStatus = null;
        String year = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            year = EJCDateUtil.getYear() + "";
        }
        List<Object> projectIds = new ArrayList();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList(projectStatus, year, orgId);
        projectIds = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectIds)) {
            return CommonResponse.success((String)"\u9879\u76ee\u4e3a\u7a7a\uff01", new HashMap());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode()));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        param3.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode()));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)param);
        param4.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        param5.getParams().put("sourceType", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param9 = (QueryParam)Utils.deepCopy((Object)webParam);
        param9.getParams().put("enableState", new Parameter("eq", (Object)1));
        param9.getParams().put("latestFlag", new Parameter("eq", (Object)1));
        QueryParam param10 = (QueryParam)Utils.deepCopy((Object)webParam);
        param10.getParams().remove("billState");
        param10.getParams().put("proportionFlag", new Parameter("eq", (Object)1));
        QueryParam param11 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param12 = (QueryParam)Utils.deepCopy((Object)webParam);
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param2, (IBaseService)this.settleService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param3, (IBaseService)this.settleService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param4, (IBaseService)this.contractService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/paymentRegister/queryList"), (QueryParam)param6);
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/queryList"), (QueryParam)param7);
        Future future9 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-targetcost-web/duty/queryList"), (QueryParam)param9);
        Future future10 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-procost-web/costDetail/queryList"), (QueryParam)param10);
        Future future11 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proincome-web/costAdjust/queryList"), (QueryParam)param11);
        Future future12 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proincome-web/budget/queryList"), (QueryParam)param12);
        List contractList = new ArrayList();
        List productionList = new ArrayList();
        List quoteList = new ArrayList();
        List outContractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        JSONArray targetList = new JSONArray();
        JSONArray costList = new JSONArray();
        JSONArray adjustList = new JSONArray();
        JSONArray budgetList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), SettlePoolEntity.class);
            quoteList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = (JSONArray)future6.get();
            receiptList = (JSONArray)future7.get();
            targetList = (JSONArray)future9.get();
            costList = (JSONArray)future10.get();
            adjustList = (JSONArray)future11.get();
            budgetList = (JSONArray)future12.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal incomeMny = contractList.stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalReceiveMoney = receiptList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null).map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal shouldRecNotRec = ComputeUtil.safeSub((BigDecimal)totalReceiveMoney, (BigDecimal)totalQuoteMoney);
        BigDecimal openInvoiceMoney = BigDecimal.ZERO;
        BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal performanceMoney = this.getPerformanceMny(projectIds);
        BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal receiveInvoiceMoney = BigDecimal.ZERO;
        BigDecimal totalOutMoney = paymentList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("payMny") != null).map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal shouldPayNotPay = ComputeUtil.safeSub((BigDecimal)totalSettleMoney, (BigDecimal)totalOutMoney);
        BigDecimal totalClaimMoney = contractList.stream().filter(x -> x.getTotalClaimTaxMny() != null).map(ContractPoolEntity::getTotalClaimTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal budgetMoney = budgetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("budgetTaxMny") != null).map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalReplyMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTargetMoney = targetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("mny") != null).map(x -> x.getBigDecimal("mny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCostMoney = costList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("happenMny") != null).map(x -> x.getBigDecimal("happenMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal adjustMny = adjustList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("applyChangeTaxMny") != null).map(x -> x.getBigDecimal("applyChangeTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal inContractMoney = ComputeUtil.safeAdd((BigDecimal)incomeMny, (BigDecimal)totalReplyMoney);
        BigDecimal totalAdjustMoney = ComputeUtil.safeAdd((BigDecimal)incomeMny, (BigDecimal)adjustMny);
        BigDecimal receiveRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalReceiveMoney, (BigDecimal)inContractMoney, (int)2);
        BigDecimal settleOutRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalOutMoney, (BigDecimal)totalSettleMoney, (int)2);
        BigDecimal newContracatTarget = BigDecimal.ZERO;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            CommonResponse detailByOrgId = this.indicatorsApi.getDetailByOrgId(orgId, Integer.valueOf(EJCDateUtil.getYear()));
            if (!detailByOrgId.isSuccess()) {
                this.logger.error("\u4ea7\u503c\u7ecf\u8425\u6307\u6807-{}", (Object)detailByOrgId.getMsg());
            } else {
                newContracatTarget = ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailByOrgId.getData()), (BigDecimal)new BigDecimal("10000"));
            }
        }
        BigDecimal productionRate = ComputeUtil.safeDiv((BigDecimal)productionMoney, (BigDecimal)newContracatTarget);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("inContractMoney", inContractMoney);
        map.put("productionMoney", productionMoney);
        map.put("totalQuoteMoney", totalQuoteMoney);
        map.put("totalReceiveMoney", totalReceiveMoney);
        map.put("shouldRecNotRec", shouldRecNotRec);
        map.put("openInvoiceMoney", openInvoiceMoney);
        map.put("outContractMoney", outContractMoney);
        map.put("performanceMoney", performanceMoney);
        map.put("totalSettleMoney", totalSettleMoney);
        map.put("receiveInvoiceMoney", receiveInvoiceMoney);
        map.put("totalOutMoney", totalOutMoney);
        map.put("shouldPayNotPay", shouldPayNotPay);
        map.put("newContracatTarget", newContracatTarget);
        map.put("productionRate", productionRate);
        map.put("totalClaimMoney", totalClaimMoney);
        map.put("totalReplyMoney", totalReplyMoney);
        map.put("totalAdjustMoney", totalAdjustMoney);
        map.put("totalTargetMoney", totalTargetMoney);
        map.put("totalCostMoney", totalCostMoney);
        map.put("budgetMoney", budgetMoney);
        map.put("receiveRate", receiveRate);
        map.put("settleOutRate", settleOutRate);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCountLeader(String range, String dateIn, Long orgId) {
        String projectStatus = null;
        String year = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            year = EJCDateUtil.getYear() + "";
        }
        List<Object> projectIds = new ArrayList();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList(projectStatus, year, orgId);
        projectIds = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectIds)) {
            return CommonResponse.success((String)"\u9879\u76ee\u4e3a\u7a7a\uff01", new HashMap());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode()));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)param);
        param4.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        CommonResponse paramResponse = this.paramConfigApi.getByCode(this.PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + paramResponse.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)paramResponse.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        param5.getParams().put("sourceType", new Parameter("in", (Object)valueData));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param2, (IBaseService)this.settleService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param4, (IBaseService)this.contractService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/paymentRegister/querySumPayMny"), (QueryParam)param6);
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/querySumReceivedMny"), (QueryParam)param7);
        List contractList = new ArrayList();
        List productionList = new ArrayList();
        List outContractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = (JSONArray)future6.get();
            receiptList = (JSONArray)future7.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal incomeMny = contractList.stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal baseMny = contractList.stream().filter(x -> x.getBaseTaxMny() != null).map(ContractPoolEntity::getBaseTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal adjustMny = contractList.stream().filter(x -> x.getTotalCostAdjustTaxMny() != null).map(ContractPoolEntity::getTotalCostAdjustTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal costAdjustMoney = ComputeUtil.safeAdd((BigDecimal)baseMny, (BigDecimal)adjustMny);
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalReceiveMoney = receiptList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null).map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal performanceMoney = this.getPerformanceMny(projectIds);
        BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalOutMoney = paymentList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("payMny") != null).map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalReplyMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal inContractMoney = ComputeUtil.safeAdd((BigDecimal)incomeMny, (BigDecimal)totalReplyMoney);
        BigDecimal receiveRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalReceiveMoney, (BigDecimal)inContractMoney, (int)2);
        BigDecimal settleOutRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalOutMoney, (BigDecimal)totalSettleMoney, (int)2);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("inContractMoney", inContractMoney);
        map.put("productionMoney", productionMoney);
        map.put("costAdjustMoney", costAdjustMoney);
        map.put("totalReceiveMoney", totalReceiveMoney);
        map.put("receiveRate", receiveRate);
        map.put("outContractMoney", outContractMoney);
        map.put("performanceMoney", performanceMoney);
        map.put("totalSettleMoney", totalSettleMoney);
        map.put("totalOutMoney", totalOutMoney);
        map.put("settleOutRate", settleOutRate);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPage<FinanceCountVO> capitalCountOrgLeader(QueryParam param) {
        this.logger.info("\u5206\u5b50\u5355\u4f4d\u67e5\u8be2\u5f00\u59cb\uff01");
        Page page = new Page();
        Integer pageNumber = Integer.valueOf(String.valueOf(param.getPageIndex()));
        Integer pageSize = Integer.valueOf(String.valueOf(param.getPageSize()));
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        Long orgId = null;
        orgId = param.getParams().containsKey("orgId") ? Long.valueOf(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue())) : InvocationInfoProxy.getOrgId();
        Boolean flag = false;
        if (param.getParams().containsKey("excel")) {
            flag = true;
            param.getParams().remove("excel");
        }
        List allOrgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgVOList = allOrgVOList.stream().filter(e -> e.getOrgType() == 2 || e.getOrgType() == 3).collect(Collectors.toList());
        Map<Long, OrgVO> orgIdMap = allOrgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (k1, k2) -> k2));
        List<Object> result = new ArrayList();
        if (param.getParams().containsKey("orgName")) {
            List pOrgId = allOrgVOList.stream().filter(e -> e.getName().equals(((Parameter)param.getParams().get("orgName")).getValue())).map(e -> e.getId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(pOrgId)) {
                result = this.queryProjectPoolList(null, null, (Long)pOrgId.get(0));
            }
            param.getParams().remove("orgName");
        } else {
            result = this.queryProjectPoolList(null, null, orgId);
        }
        ArrayList projectList = new ArrayList();
        projectList = result;
        List<Long> projectIds = projectList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectIds)) {
            this.logger.info("\u67e5\u8be2\u5206\u5b50\u5355\u4f4d-{}\uff0c\u9879\u76ee\u4e3a\u7a7a\uff01", orgVOList);
            return new Page();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)queryParam);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        param2.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode()));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)queryParam);
        param4.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)queryParam);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        param5.getParams().put("sourceType", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)queryParam);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param8 = (QueryParam)Utils.deepCopy((Object)param);
        param8.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode()));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param2, (IBaseService)this.settleService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param4, (IBaseService)this.contractService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/paymentRegister/querySumPayMny"), (QueryParam)param6);
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/querySumReceivedMny"), (QueryParam)param7);
        Future future8 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param8, (IBaseService)this.settleService);
        List contractList = new ArrayList();
        List productionList = new ArrayList();
        List outContractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        List quoteList = new ArrayList();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = (JSONArray)future6.get();
            receiptList = (JSONArray)future7.get();
            quoteList = JSONObject.parseArray((String)((JSONArray)future8.get()).toJSONString(), SettlePoolEntity.class);
        }
        catch (Exception e2) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e2);
        }
        finally {
            threadPool.shutdown();
        }
        Map<Long, List<ContractPoolEntity>> incomeMap = contractList.stream().collect(Collectors.groupingBy(ContractPoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> productionMap = productionList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<ContractPoolEntity>> outContractMap = outContractList.stream().collect(Collectors.groupingBy(ContractPoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> settleMap = settleList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<SettlePoolEntity>> quoteMap = quoteList.stream().collect(Collectors.groupingBy(SettlePoolEntity::getProjectId));
        Map<Long, List<Object>> paymentMap = paymentList.stream().collect(Collectors.groupingBy(item -> ((JSONObject)item).getLong("projectId")));
        Map<Long, List<Object>> receiptMap = receiptList.stream().collect(Collectors.groupingBy(item -> ((JSONObject)item).getLong("projectId")));
        Map<Long, ProjectPoolSetVO> projectMap = projectList.stream().collect(Collectors.toMap(BaseVO::getId, a -> a, (k1, k2) -> k1));
        Map<Long, BigDecimal> performanceMap = this.getPerformProjectMap(projectIds);
        ArrayList<FinanceCountVO> fclist = new ArrayList<FinanceCountVO>();
        BigDecimal incomeMny = BigDecimal.ZERO;
        BigDecimal totalReplyMoney = BigDecimal.ZERO;
        BigDecimal costAdjustMoney = BigDecimal.ZERO;
        BigDecimal productionMoney = BigDecimal.ZERO;
        BigDecimal outContractMoney = BigDecimal.ZERO;
        BigDecimal totalSettleMoney = BigDecimal.ZERO;
        BigDecimal totalReceiveMoney = BigDecimal.ZERO;
        BigDecimal totalOutMoney = BigDecimal.ZERO;
        BigDecimal inContractMoney = BigDecimal.ZERO;
        BigDecimal receiveRate = BigDecimal.ZERO;
        BigDecimal settleOutRate = BigDecimal.ZERO;
        BigDecimal performanceMoney = BigDecimal.ZERO;
        BigDecimal totalQuoteMoney = BigDecimal.ZERO;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        for (Long k : projectMap.keySet()) {
            incomeMny = BigDecimal.ZERO;
            totalReplyMoney = BigDecimal.ZERO;
            costAdjustMoney = BigDecimal.ZERO;
            productionMoney = BigDecimal.ZERO;
            outContractMoney = BigDecimal.ZERO;
            totalSettleMoney = BigDecimal.ZERO;
            totalReceiveMoney = BigDecimal.ZERO;
            totalOutMoney = BigDecimal.ZERO;
            inContractMoney = BigDecimal.ZERO;
            receiveRate = BigDecimal.ZERO;
            settleOutRate = BigDecimal.ZERO;
            performanceMoney = BigDecimal.ZERO;
            totalQuoteMoney = BigDecimal.ZERO;
            contractTaxMny = BigDecimal.ZERO;
            if (incomeMap.containsKey(k)) {
                incomeMny = incomeMap.get(k).stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalReplyMoney = incomeMap.get(k).stream().filter(x -> x.getTotalTeplyTaxMny() != null).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                costAdjustMoney = incomeMap.get(k).stream().filter(x -> x.getTotalCostAdjustTaxMny() != null).map(ContractPoolEntity::getTotalCostAdjustTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                contractTaxMny = incomeMap.get(k).stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (productionMap.containsKey(k)) {
                productionMoney = productionMap.get(k).stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (outContractMap.containsKey(k)) {
                outContractMoney = outContractMap.get(k).stream().filter(x -> x.getContractTaxMny() != null).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (settleMap.containsKey(k)) {
                totalSettleMoney = settleMap.get(k).stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (quoteMap.containsKey(k)) {
                totalQuoteMoney = quoteMap.get(k).stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (receiptMap.containsKey(k)) {
                totalReceiveMoney = receiptMap.get(k).stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null).map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (paymentMap.containsKey(k)) {
                totalOutMoney = paymentMap.get(k).stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("payMny") != null).map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (performanceMap.containsKey(k)) {
                performanceMoney = performanceMap.get(k);
            }
            inContractMoney = ComputeUtil.safeAdd((BigDecimal)incomeMny, (BigDecimal)totalReplyMoney);
            receiveRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalReceiveMoney, (BigDecimal)inContractMoney, (int)2);
            settleOutRate = ComputeUtil.bigDecimalPercent((BigDecimal)totalOutMoney, (BigDecimal)totalSettleMoney, (int)2);
            FinanceCountVO vo = new FinanceCountVO();
            if (projectMap.get(k).getProjectDepartmentId() != null) {
                vo.setOrgId(projectMap.get(k).getProjectDepartmentId());
                if (!orgIdMap.containsKey(vo.getOrgId())) continue;
                vo.setOrgName(orgIdMap.get(vo.getOrgId()).getName());
                vo.setOrgType(orgIdMap.get(vo.getOrgId()).getOrgType());
                vo.setInnerCode(orgIdMap.get(vo.getOrgId()).getInnerCode());
                vo.setParentId(orgIdMap.get(vo.getOrgId()).getParentId());
            } else {
                vo.setOrgId(projectMap.get(k).getOrgId());
                vo.setOrgName(projectMap.get(k).getOrgName());
                if (!orgIdMap.containsKey(vo.getOrgId())) continue;
                vo.setOrgType(orgIdMap.get(vo.getOrgId()).getOrgType());
                vo.setInnerCode(orgIdMap.get(vo.getOrgId()).getInnerCode());
                vo.setParentId(orgIdMap.get(vo.getOrgId()).getParentId());
            }
            vo.setProjectId(k);
            vo.setProjectCode(projectMap.get(k).getCode());
            vo.setProjectName(projectMap.get(k).getName());
            vo.setInContractMoney(inContractMoney);
            vo.setProductionMoney(productionMoney);
            vo.setCostAdjustMoney(ComputeUtil.safeAdd((BigDecimal)costAdjustMoney, (BigDecimal)contractTaxMny));
            vo.setTotalReceiveMoney(totalReceiveMoney);
            vo.setReceiveRate(receiveRate);
            vo.setOutContractMoney(outContractMoney);
            vo.setPerformanceMoney(performanceMoney);
            vo.setTotalSettleMoney(totalSettleMoney);
            vo.setTotalOutMoney(totalOutMoney);
            vo.setSettleOutRate(settleOutRate);
            vo.setTotalQuoteMoney(totalQuoteMoney);
            fclist.add(vo);
        }
        ArrayList<Object> fList = new ArrayList();
        List<Object> listTree = new ArrayList();
        if (((OrgVO)orgIdMap.get(orgId)).getOrgType() != 5) {
            List xmList = fclist.stream().filter(x -> x.getOrgType() == 5).collect(Collectors.toList());
            HashMap fzMap = new HashMap();
            HashMap<Long, FinanceCountVO> xmMap = new HashMap<Long, FinanceCountVO>();
            for (FinanceCountVO fVO : xmList) {
                if (!orgIdMap.containsKey(fVO.getParentId())) continue;
                if (xmMap.containsKey(fVO.getOrgId())) {
                    FinanceCountVO fco = (FinanceCountVO)xmMap.get(fVO.getOrgId());
                    fco.setInContractMoney(ComputeUtil.safeAdd((BigDecimal)fco.getInContractMoney(), (BigDecimal)fVO.getInContractMoney()));
                    fco.setProductionMoney(ComputeUtil.safeAdd((BigDecimal)fco.getProductionMoney(), (BigDecimal)fVO.getProductionMoney()));
                    fco.setCostAdjustMoney(ComputeUtil.safeAdd((BigDecimal)fco.getCostAdjustMoney(), (BigDecimal)fVO.getCostAdjustMoney()));
                    fco.setTotalReceiveMoney(ComputeUtil.safeAdd((BigDecimal)fco.getTotalReceiveMoney(), (BigDecimal)fVO.getTotalReceiveMoney()));
                    fco.setOutContractMoney(ComputeUtil.safeAdd((BigDecimal)fco.getOutContractMoney(), (BigDecimal)fVO.getOutContractMoney()));
                    fco.setPerformanceMoney(ComputeUtil.safeAdd((BigDecimal)fco.getPerformanceMoney(), (BigDecimal)fVO.getPerformanceMoney()));
                    fco.setTotalSettleMoney(ComputeUtil.safeAdd((BigDecimal)fco.getTotalSettleMoney(), (BigDecimal)fVO.getTotalSettleMoney()));
                    fco.setTotalQuoteMoney(ComputeUtil.safeAdd((BigDecimal)fco.getTotalQuoteMoney(), (BigDecimal)fVO.getTotalQuoteMoney()));
                    fco.setTotalOutMoney(ComputeUtil.safeAdd((BigDecimal)fco.getTotalOutMoney(), (BigDecimal)fVO.getTotalOutMoney()));
                    fco.setReceiveRate(ComputeUtil.bigDecimalPercent((BigDecimal)fco.getTotalReceiveMoney(), (BigDecimal)fco.getInContractMoney(), (int)2));
                    fco.setSettleOutRate(ComputeUtil.bigDecimalPercent((BigDecimal)fco.getTotalOutMoney(), (BigDecimal)fco.getTotalSettleMoney(), (int)2));
                    xmMap.put(fco.getOrgId(), fco);
                    continue;
                }
                FinanceCountVO fvo = new FinanceCountVO();
                fvo.setOrgId(fVO.getOrgId());
                fvo.setOrgName(fVO.getOrgName());
                fvo.setInnerCode(fVO.getInnerCode());
                fvo.setParentId(this.getOrgType(fVO.getParentId(), orgIdMap));
                fvo.setInContractMoney(fVO.getInContractMoney());
                fvo.setProductionMoney(fVO.getProductionMoney());
                fvo.setCostAdjustMoney(fVO.getCostAdjustMoney());
                fvo.setTotalReceiveMoney(fVO.getTotalReceiveMoney());
                fvo.setReceiveRate(fVO.getReceiveRate());
                fvo.setOutContractMoney(fVO.getOutContractMoney());
                fvo.setPerformanceMoney(fVO.getPerformanceMoney());
                fvo.setTotalSettleMoney(fVO.getTotalSettleMoney());
                fvo.setTotalOutMoney(fVO.getTotalOutMoney());
                fvo.setSettleOutRate(fVO.getSettleOutRate());
                fvo.setTotalQuoteMoney(fVO.getTotalQuoteMoney());
                xmMap.put(fvo.getOrgId(), fvo);
            }
            ArrayList result4 = new ArrayList(xmMap.values());
            Map<Long, List<FinanceCountVO>> fcMap = result4.stream().collect(Collectors.groupingBy(FinanceCountVO::getParentId));
            for (Map.Entry entry : fcMap.entrySet()) {
                List v = (List)entry.getValue();
                FinanceCountVO fvo = new FinanceCountVO();
                if (!orgIdMap.containsKey(entry.getKey())) continue;
                fvo.setOrgId((Long)entry.getKey());
                fvo.setOrgName(orgIdMap.get(entry.getKey()).getName());
                fvo.setInnerCode(orgIdMap.get(entry.getKey()).getInnerCode());
                fvo.setParentId(Long.valueOf(0L));
                fvo.setInContractMoney(v.stream().filter(x -> x.getInContractMoney() != null).map(FinanceCountVO::getInContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setProductionMoney(v.stream().filter(x -> x.getProductionMoney() != null).map(FinanceCountVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setCostAdjustMoney(v.stream().filter(x -> x.getCostAdjustMoney() != null).map(FinanceCountVO::getCostAdjustMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalReceiveMoney(v.stream().filter(x -> x.getTotalReceiveMoney() != null).map(FinanceCountVO::getTotalReceiveMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setOutContractMoney(v.stream().filter(x -> x.getOutContractMoney() != null).map(FinanceCountVO::getOutContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setPerformanceMoney(v.stream().filter(x -> x.getPerformanceMoney() != null).map(FinanceCountVO::getPerformanceMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalSettleMoney(v.stream().filter(x -> x.getTotalSettleMoney() != null).map(FinanceCountVO::getTotalSettleMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalOutMoney(v.stream().filter(x -> x.getTotalOutMoney() != null).map(FinanceCountVO::getTotalOutMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setTotalQuoteMoney(v.stream().filter(x -> x.getTotalQuoteMoney() != null).map(FinanceCountVO::getTotalQuoteMoney).reduce(BigDecimal.ZERO, BigDecimal::add));
                fvo.setReceiveRate(ComputeUtil.bigDecimalPercent((BigDecimal)fvo.getTotalReceiveMoney(), (BigDecimal)fvo.getInContractMoney(), (int)2));
                fvo.setSettleOutRate(ComputeUtil.bigDecimalPercent((BigDecimal)fvo.getTotalOutMoney(), (BigDecimal)fvo.getTotalSettleMoney(), (int)2));
                fzMap.put(entry.getKey(), fvo);
            }
            fzMap.putAll(xmMap);
            ArrayList<Object> finalFList = fList = new ArrayList(fzMap.values());
            listTree = fList.stream().filter(x -> x.getParentId() == 0L).map(e -> {
                e.setChildren(this.getChildList((FinanceCountVO)e, (List<FinanceCountVO>)finalFList));
                return e;
            }).collect(Collectors.toList());
        } else {
            listTree = fclist;
        }
        if (Boolean.TRUE.equals(flag)) {
            page.setRecords(fList);
            return page;
        }
        if (CollectionUtils.isNotEmpty(listTree)) {
            page.setTotal((long)listTree.size());
            listTree = PageUtil.listToPage(listTree, (int)pageNumber, (int)pageSize);
        }
        page.setRecords(listTree);
        return page;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private Long getOrgType(Long parentId, Map<Long, OrgVO> orgVOMap) {
        Integer orgType = orgVOMap.get(parentId).getOrgType();
        if (orgType == 1) {
            return 0L;
        }
        if (orgType == 2 || orgType == 3) {
            return parentId;
        }
        if (orgType == 4) {
            this.getOrgType(orgVOMap.get(parentId).getParentId(), orgVOMap);
        }
        return parentId;
    }

    private List<FinanceCountVO> getChildList(FinanceCountVO vo, List<FinanceCountVO> list) {
        List<FinanceCountVO> children = list.stream().filter(x -> Objects.equals(x.getParentId(), vo.getOrgId())).map(x -> {
            x.setChildren(this.getChildList((FinanceCountVO)x, list));
            return x;
        }).collect(Collectors.toList());
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPage<ProjectInOutVO> proPageList(Map<String, Object> params) {
        List list;
        Page page = new Page();
        Integer pageNumber = Integer.valueOf(String.valueOf(params.get("pageIndex")));
        Integer pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        String projectStatus = null;
        String dateIn = null;
        if (params.containsKey("range") && ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(String.valueOf(params.get("range")))) {
            projectStatus = "1";
        }
        if (params.containsKey("dateIn") && ProjectSurveyEnum.THISYEAR.getCode().equals(String.valueOf(params.get("dateIn")))) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectInOutVO> projectList = new ArrayList<ProjectInOutVO>();
        ArrayList<Long> projectIds = new ArrayList();
        Long orgId = null;
        if (params.containsKey("orgId")) {
            orgId = Long.valueOf(String.valueOf(params.get("orgId")));
        }
        if (CollectionUtils.isNotEmpty(list = this.queryProjectPoolList(projectStatus, dateIn, orgId))) {
            page.setTotal((long)list.size());
            list = PageUtil.listToPage(list, (int)pageNumber, (int)pageSize);
            projectIds = list.stream().map(BaseVO::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ProjectPoolSetVO project : list) {
                    ProjectInOutVO vo = new ProjectInOutVO();
                    vo.setId(project.getId());
                    vo.setProjectName(project.getName());
                    vo.setProjectDepartmentId(project.getProjectDepartmentId());
                    if (StringUtils.isNotEmpty((CharSequence)project.getProjectStatus())) {
                        vo.setProjectState(ProjectStatusEnum.getEnumByCode((String)project.getProjectStatus()).getName());
                    } else {
                        vo.setProjectState(null);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)project.getDevType())) {
                        vo.setProjectType(DevTypeEnum.getEnumByCode((String)project.getDevType()).getName());
                    } else {
                        vo.setProjectType(null);
                    }
                    vo.setEngineeringType(project.getEngineeringTypeId());
                    vo.setEngineeringTypeName(this.getDefDocById(project.getEngineeringTypeId()) != null ? this.getDefDocById(project.getEngineeringTypeId()).getName() : project.getEngineeringTypeId().toString());
                    projectList.add(vo);
                }
            }
        }
        if (CollectionUtils.isEmpty(projectIds)) {
            return new Page();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(9);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        param3.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode()));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)param);
        param4.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        CommonResponse paramResponse = this.paramConfigApi.getByCode(this.PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + paramResponse.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)paramResponse.getData()).getValueData();
        if (valueData.contains(SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode())) {
            valueData = valueData.replace("," + SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode(), "");
        }
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param8 = (QueryParam)Utils.deepCopy((Object)webParam);
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param3, (IBaseService)this.settleService);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param4, (IBaseService)this.contractService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proincome-web/budget/queryList"), (QueryParam)param2);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-targetcost-web/duty/queryList"), (QueryParam)param6);
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/paymentRegister/queryList"), (QueryParam)param7);
        Future future8 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/queryList"), (QueryParam)param8);
        List contractList = new ArrayList();
        List quoteList = new ArrayList();
        List outContractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray budgetList = new JSONArray();
        JSONArray targetList = new JSONArray();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            quoteList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), SettlePoolEntity.class);
            outContractList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            budgetList = (JSONArray)future2.get();
            targetList = (JSONArray)future6.get();
            paymentList = (JSONArray)future7.get();
            receiptList = (JSONArray)future8.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<Long, BigDecimal> performanceMap = this.getPerformProjectMap(projectIds);
        for (ProjectInOutVO vo : projectList) {
            BigDecimal inContractMoney = contractList.stream().filter(x -> x.getContractTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null && vo.getId().equals(x.getProjectId())).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalReceiveMoney = receiptList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null && vo.getId().equals(x.getLong("projectId"))).map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal performanceMoney = performanceMap.get(vo.getId());
            BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null && vo.getId().equals(x.getProjectId())).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalOutMoney = paymentList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("payMny") != null && vo.getId().equals(x.getLong("projectId"))).map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal claimMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal changeCostMoney = ComputeUtil.safeAdd((BigDecimal)inContractMoney, (BigDecimal)claimMoney);
            BigDecimal budgetMoney = budgetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("budgetTaxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal targetMoney = targetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("taxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setInContractMoney(inContractMoney);
            vo.setClaimMoney(claimMoney);
            vo.setChangeCostMoney(changeCostMoney);
            vo.setBudgetMoney(budgetMoney);
            vo.setTotalQuoteMoney(totalQuoteMoney);
            vo.setTotalReceiveMoney(totalReceiveMoney);
            vo.setTargetMoney(targetMoney);
            vo.setOutContractMoney(outContractMoney);
            vo.setPerformanceMoney(performanceMoney);
            vo.setTotalSettleMoney(totalSettleMoney);
            vo.setTotalOutMoney(totalOutMoney);
        }
        page.setRecords(projectList);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPage<ProjectInOutVO> proPageOrgList(Map<String, Object> params) {
        List<Object> listProject;
        Page page = new Page();
        Integer pageNumber = Integer.valueOf(String.valueOf(params.get("pageIndex")));
        Integer pageSize = Integer.valueOf(String.valueOf(params.get("pageSize")));
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        String projectStatus = null;
        String dateIn = null;
        if (params.containsKey("range") && ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(String.valueOf(params.get("range")))) {
            projectStatus = "1";
        }
        if (params.containsKey("dateIn") && ProjectSurveyEnum.THISYEAR.getCode().equals(String.valueOf(params.get("dateIn")))) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectInOutVO> projectList = new ArrayList<ProjectInOutVO>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        ArrayList<Long> ordIdsList = new ArrayList<Long>();
        Long orgId = null;
        Long projectId = null;
        if (params.containsKey("orgId")) {
            orgId = Long.valueOf(String.valueOf(params.get("orgId")));
        }
        this.logger.info("\u5165\u53c2params-{}", params);
        if (params.containsKey("projectId")) {
            projectId = Long.valueOf(String.valueOf(params.get("projectId")));
            this.logger.info("projectId-{}", (Object)projectId);
        }
        long start1 = System.currentTimeMillis();
        if (null == projectId) {
            listProject = this.queryProjectPoolList(projectStatus, dateIn, orgId);
            this.logger.info("\u67e5\u8be2\u5230\u9879\u76ee\u6c60\u7684\u6570\u636e-{}", (Object)JSONObject.toJSONString(listProject));
        } else {
            listProject = this.queryProjectPoolByProjectId(projectId);
            this.logger.info("\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2\u5230\u9879\u76ee\u6c60\u7684\u6570\u636e-{}", (Object)JSONObject.toJSONString(listProject));
        }
        long end1 = System.currentTimeMillis();
        this.logger.info("1-----\u67e5\u8be2\u9879\u76ee\u6c60\u7ed3\u675f{}", (Object)(end1 - start1));
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(listProject)) {
            long start2 = System.currentTimeMillis();
            listProject = listProject.stream().sorted(Comparator.comparing(ProjectPoolSetVO::getOrgCode, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
            long end2 = System.currentTimeMillis();
            this.logger.info("2-----\u9879\u76ee\u6392\u5e8f\u7ed3\u675f{}", (Object)(end2 - start2));
            long start3 = System.currentTimeMillis();
            List listTree = BeanMapper.mapList(listProject, ProjectPoolSetTreeVO.class);
            list = TreeNodeBUtil.buildTree((List)listTree);
            page.setTotal((long)list.size());
            list = PageUtil.listToPage(list, (int)pageNumber, (int)pageSize);
            this.logger.info("\u8f6c\u4e3a\u4e3b\u5b50\u9879\u76ee\u540e\u6570\u636e-{}", (Object)JSONObject.toJSONString(list));
            long end3 = System.currentTimeMillis();
            this.logger.info("3-----\u8f6c\u4e3a\u4e3b\u5b50\u9879\u76ee\u7ed3\u675f{}", (Object)(end3 - start3));
            if (CollectionUtils.isNotEmpty(list)) {
                for (ProjectPoolSetTreeVO project : list) {
                    ProjectInOutVO vo = new ProjectInOutVO();
                    projectIds.add(project.getId());
                    ordIdsList.add(project.getProjectDepartmentId());
                    vo.setId(project.getId());
                    vo.setProjectName(project.getName());
                    vo.setParentProjectId(project.getParentProjectId());
                    vo.setParentProjectName(project.getParentProjectName());
                    vo.setProjectDepartmentId(project.getProjectDepartmentId());
                    if (StringUtils.isNotEmpty((CharSequence)project.getBusinessStatus())) {
                        vo.setBusinessStatus(BusinessStatusEnum.getEnumByCode((String)project.getBusinessStatus()).getName());
                    } else {
                        vo.setBusinessStatus(null);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)project.getDevType())) {
                        vo.setProjectType(DevTypeEnum.getEnumByCode((String)project.getDevType()).getName());
                    } else {
                        vo.setProjectType(null);
                    }
                    vo.setEngineeringType(project.getEngineeringTypeId());
                    vo.setEngineeringTypeName(this.getDefDocById(project.getEngineeringTypeId()).getName());
                    vo.setOrgId(project.getOrgId());
                    vo.setOrgName(project.getOrgName());
                    projectList.add(vo);
                    if (null == project.getChildren()) continue;
                    List children = BeanMapper.mapList((Iterable)project.getChildren(), ProjectPoolSetTreeVO.class);
                    children.forEach(e -> {
                        ProjectInOutVO voChildren = new ProjectInOutVO();
                        projectIds.add(e.getId());
                        voChildren.setId(e.getId());
                        ordIdsList.add(e.getProjectDepartmentId());
                        voChildren.setProjectName(e.getName());
                        voChildren.setParentProjectId(e.getParentProjectId());
                        voChildren.setParentProjectName(e.getParentProjectName());
                        voChildren.setProjectDepartmentId(e.getProjectDepartmentId());
                        if (StringUtils.isNotEmpty((CharSequence)e.getBusinessStatus())) {
                            voChildren.setBusinessStatus(BusinessStatusEnum.getEnumByCode((String)e.getBusinessStatus()).getName());
                        } else {
                            voChildren.setBusinessStatus(null);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)e.getDevType())) {
                            voChildren.setProjectType(DevTypeEnum.getEnumByCode((String)e.getDevType()).getName());
                        } else {
                            voChildren.setProjectType(null);
                        }
                        voChildren.setEngineeringType(e.getEngineeringTypeId());
                        voChildren.setEngineeringTypeName(this.getDefDocById(e.getEngineeringTypeId()).getName());
                        voChildren.setOrgId(e.getOrgId());
                        voChildren.setOrgName(e.getOrgName());
                        projectList.add(voChildren);
                    });
                }
            }
            this.logger.info("\u4e3b\u5b50\u9879\u76ee\u5e73\u94fa\u540e-{}", (Object)JSONObject.toJSONString(projectList));
        }
        if (CollectionUtils.isEmpty(projectIds)) {
            return new Page();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(11);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        param3.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode()));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)param);
        param4.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        long start4 = System.currentTimeMillis();
        CommonResponse paramResponse = this.paramConfigApi.getByCode(this.PROJECT_SETTLE_RANGE_PARAM);
        if (!paramResponse.isSuccess() || paramResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + paramResponse.getMsg());
        }
        long end4 = System.currentTimeMillis();
        this.logger.info("4-----\u83b7\u53d6\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u7ed3\u675f{}", (Object)(end4 - start4));
        String valueData = ((ParamRegisterSetVO)paramResponse.getData()).getValueData();
        if (valueData.contains(SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode())) {
            valueData = valueData.replace("," + SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode(), "");
        }
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u9879\u76ee\u7ed3\u7b97\u67e5\u8be2\u7ed3\u7b97\u5355\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
        param5.getParams().put("sourceType", new Parameter("in", (Object)valueData));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param8 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param9 = (QueryParam)Utils.deepCopy((Object)webParam);
        QueryParam param10 = (QueryParam)Utils.deepCopy((Object)webParam);
        param10.getParams().put("isEstimation", new Parameter("in", (Object)0));
        long start5 = System.currentTimeMillis();
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        long start6 = System.currentTimeMillis();
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param3, (IBaseService)this.settleService);
        long start7 = System.currentTimeMillis();
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param4, (IBaseService)this.contractService);
        long start8 = System.currentTimeMillis();
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        long start9 = System.currentTimeMillis();
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proincome-web/budget/queryList"), (QueryParam)param2);
        long start10 = System.currentTimeMillis();
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-targetcost-web/duty/queryList"), (QueryParam)param6);
        long start11 = System.currentTimeMillis();
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/paymentRegister/querySumPayMny"), (QueryParam)param7);
        long start12 = System.currentTimeMillis();
        Future future8 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/querySumReceivedMny"), (QueryParam)param8);
        long start13 = System.currentTimeMillis();
        Future future9 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-procost-web/handshare/queryList"), (QueryParam)param9);
        Future future10 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proincome-web/contractRegister/queryList"), (QueryParam)param10);
        List contractList = new ArrayList();
        List quoteList = new ArrayList();
        List outContractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray budgetList = new JSONArray();
        JSONArray targetList = new JSONArray();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        JSONArray incomeList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            long end5 = System.currentTimeMillis();
            this.logger.info("5-----\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u7ed3\u675f{}", (Object)(end5 - start5));
            quoteList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), SettlePoolEntity.class);
            long end6 = System.currentTimeMillis();
            this.logger.info("6-----\u83b7\u53d6\u5bf9\u7532\u62a5\u91cf\u7ed3\u675f{}", (Object)(end6 - start6));
            outContractList = JSONObject.parseArray((String)((JSONArray)future4.get()).toJSONString(), ContractPoolEntity.class);
            long end7 = System.currentTimeMillis();
            this.logger.info("7-----\u83b7\u53d6\u652f\u51fa\u5408\u540c\u7ed3\u675f{}", (Object)(end7 - start7));
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            long end8 = System.currentTimeMillis();
            this.logger.info("8-----\u83b7\u53d6\u7d2f\u8ba1\u7ed3\u7b97\u7ed3\u675f{}", (Object)(end8 - start8));
            budgetList = (JSONArray)future2.get();
            long end9 = System.currentTimeMillis();
            this.logger.info("9-----\u83b7\u53d6\u6536\u5165\u9884\u7b97\u7ed3\u675f{}", (Object)(end9 - start9));
            targetList = (JSONArray)future6.get();
            long end10 = System.currentTimeMillis();
            this.logger.info("10-----\u83b7\u53d6\u76ee\u6807\u8d23\u4efb\u6210\u672c\u7ed3\u675f{}", (Object)(end10 - start10));
            paymentList = (JSONArray)future7.get();
            long end11 = System.currentTimeMillis();
            this.logger.info("11-----\u83b7\u53d6\u4ed8\u6b3e\u767b\u8bb0\u7ed3\u675f{}", (Object)(end11 - start11));
            receiptList = (JSONArray)future8.get();
            long end12 = System.currentTimeMillis();
            this.logger.info("12-----\u83b7\u53d6\u6536\u6b3e\u767b\u8bb0\u7ed3\u675f{}", (Object)(end12 - start12));
            incomeList = (JSONArray)future10.get();
            long end13 = System.currentTimeMillis();
            this.logger.info("13-----\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u7ed3\u675f{}", (Object)(end13 - start13));
        }
        catch (Exception e2) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e2);
        }
        finally {
            threadPool.shutdown();
        }
        OutputValDTO dto = new OutputValDTO();
        dto.setYear(Integer.valueOf(0));
        dto.setOrgIds(ordIdsList);
        CommonResponse outPut = this.outputValueApi.getSumByOrgIds(dto);
        HashMap outPutMap = new HashMap();
        if (outPut.isSuccess()) {
            outPutMap = (HashMap)outPut.getData();
        } else {
            this.logger.error(outPut.getMsg());
        }
        ArrayList<Long> targetIds = new ArrayList<Long>();
        for (int i = 0; i < targetList.size(); ++i) {
            JSONObject obj = targetList.getJSONObject(i);
            targetIds.add(obj.getLong("id"));
        }
        List<Object> targetCost = new ArrayList();
        if (CollectionUtils.isNotEmpty(targetIds)) {
            targetCost = this.mapper.queryTargetCostDetailByIds(targetIds);
        }
        List directList = targetCost.stream().filter(x -> Integer.valueOf(x.getTreeIndex()) < 6).collect(Collectors.toList());
        List indirectList = targetCost.stream().filter(x -> Integer.valueOf(x.getTreeIndex()) == 6).collect(Collectors.toList());
        List<TargetCostDetailVO> paidIndirectList = this.mapper.queryProCostDetailByProjectIds(projectIds);
        HashMap performanceMap = new HashMap();
        for (ProjectInOutVO vo : projectList) {
            BigDecimal inContractMoney = contractList.stream().filter(x -> x.getBaseTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getBaseTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal bgIncomeMoney = contractList.stream().filter(x -> x.getContractTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalQuoteMoney = quoteList.stream().filter(x -> x.getCurTaxMny() != null && vo.getId().equals(x.getProjectId())).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalReceiveMoney = receiptList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null && vo.getId().equals(x.getLong("projectId"))).map(x -> x.getBigDecimal("sumReceivedMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outContractMoney = outContractList.stream().filter(x -> x.getContractTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal productionMoney = outPutMap.get(vo.getProjectDepartmentId()) != null ? (BigDecimal)outPutMap.get(vo.getProjectDepartmentId()) : BigDecimal.ZERO;
            BigDecimal handShareMoney = paidIndirectList.stream().filter(x -> x.getMny() != null && vo.getId().equals(x.getProjectId()) && x.getSubjectCode().startsWith("07")).map(TargetCostDetailVO::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paidIndirectMny = paidIndirectList.stream().filter(x -> x.getMny() != null && vo.getId().equals(x.getProjectId()) && x.getSubjectCode().startsWith("06")).map(TargetCostDetailVO::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal directMny = directList.stream().filter(x -> x.getTaxMny() != null && vo.getId().equals(x.getProjectId())).map(TargetCostDetailVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal indirectMny = indirectList.stream().filter(x -> x.getTaxMny() != null && vo.getId().equals(x.getProjectId())).map(TargetCostDetailVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalSettleMoney = settleList.stream().filter(x -> x.getCurTaxMny() != null && vo.getId().equals(x.getProjectId())).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalOutMoney = paymentList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("payMny") != null && vo.getId().equals(x.getLong("projectId"))).map(x -> x.getBigDecimal("payMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal claimMoney = contractList.stream().filter(x -> x.getTotalTeplyTaxMny() != null && vo.getId().equals(x.getProjectId())).map(ContractPoolEntity::getTotalTeplyTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal contractTaxMny = incomeList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("contractTaxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("contractTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCostAdjustTaxMny = incomeList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("totalCostAdjustTaxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("totalCostAdjustTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal budgetMoney = budgetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("budgetTaxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("budgetTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal targetMoney = targetList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("taxMny") != null && vo.getId().equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setInContractMoney(inContractMoney);
            vo.setClaimMoney(claimMoney);
            vo.setBgIncomeMoney(bgIncomeMoney);
            vo.setChangeCostMoney(ComputeUtil.safeAdd((BigDecimal)contractTaxMny, (BigDecimal)totalCostAdjustTaxMny));
            vo.setBudgetMoney(budgetMoney);
            vo.setTotalQuoteMoney(totalQuoteMoney);
            vo.setProductionMoney(productionMoney);
            vo.setPaidIndirectMny(paidIndirectMny);
            vo.setDirectMny(directMny);
            vo.setIndirectMny(indirectMny);
            vo.setTotalReceiveMoney(totalReceiveMoney);
            vo.setTargetMoney(targetMoney);
            vo.setOutContractMoney(outContractMoney);
            vo.setTotalSettleMoney(totalSettleMoney);
            vo.setTotalOutMoney(totalOutMoney);
            vo.setHandShareMoney(handShareMoney);
        }
        List projectListRes = TreeNodeBUtil.buildTree(projectList);
        if (CollectionUtils.isNotEmpty((Collection)projectListRes)) {
            for (ProjectInOutVO project : projectListRes) {
                if (null == project.getChildren()) continue;
                List children = BeanMapper.mapList((Iterable)project.getChildren(), ProjectInOutVO.class);
                BigDecimal inContractMoney = children.stream().filter(item -> null != item.getInContractMoney()).map(ProjectInOutVO::getInContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hinContractMoney = project.getInContractMoney() == null ? BigDecimal.ZERO : project.getInContractMoney();
                project.setInContractMoney(hinContractMoney.add(inContractMoney == null ? BigDecimal.ZERO : inContractMoney));
                BigDecimal claimMoney = children.stream().filter(item -> null != item.getClaimMoney()).map(ProjectInOutVO::getClaimMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hclaimMoney = project.getClaimMoney() == null ? BigDecimal.ZERO : project.getClaimMoney();
                project.setClaimMoney(hclaimMoney.add(claimMoney == null ? BigDecimal.ZERO : claimMoney));
                BigDecimal changeCostMoney = children.stream().filter(item -> null != item.getChangeCostMoney()).map(ProjectInOutVO::getChangeCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hchangeCostMoney = project.getChangeCostMoney() == null ? BigDecimal.ZERO : project.getChangeCostMoney();
                project.setChangeCostMoney(hchangeCostMoney.add(changeCostMoney == null ? BigDecimal.ZERO : changeCostMoney));
                BigDecimal budgetMoney = children.stream().filter(item -> null != item.getBudgetMoney()).map(ProjectInOutVO::getBudgetMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hbudgetMoney = project.getBudgetMoney() == null ? BigDecimal.ZERO : project.getBudgetMoney();
                project.setBudgetMoney(hbudgetMoney.add(budgetMoney == null ? BigDecimal.ZERO : budgetMoney));
                BigDecimal totalQuoteMoney = children.stream().filter(item -> null != item.getTotalQuoteMoney()).map(ProjectInOutVO::getTotalQuoteMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal htotalQuoteMoney = project.getTotalQuoteMoney() == null ? BigDecimal.ZERO : project.getTotalQuoteMoney();
                project.setTotalQuoteMoney(htotalQuoteMoney.add(totalQuoteMoney == null ? BigDecimal.ZERO : totalQuoteMoney));
                BigDecimal totalReceiveMoney = children.stream().filter(item -> null != item.getTotalReceiveMoney()).map(ProjectInOutVO::getTotalReceiveMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal htotalReceiveMoney = project.getTotalReceiveMoney() == null ? BigDecimal.ZERO : project.getTotalReceiveMoney();
                project.setTotalReceiveMoney(htotalReceiveMoney.add(totalReceiveMoney == null ? BigDecimal.ZERO : totalReceiveMoney));
                BigDecimal targetMoney = children.stream().filter(item -> null != item.getTargetMoney()).map(ProjectInOutVO::getTargetMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal htargetMoney = project.getTargetMoney() == null ? BigDecimal.ZERO : project.getTargetMoney();
                project.setTargetMoney(htargetMoney.add(targetMoney == null ? BigDecimal.ZERO : targetMoney));
                BigDecimal outContractMoney = children.stream().filter(item -> null != item.getOutContractMoney()).map(ProjectInOutVO::getOutContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal houtContractMoney = project.getOutContractMoney() == null ? BigDecimal.ZERO : project.getOutContractMoney();
                project.setOutContractMoney(houtContractMoney.add(outContractMoney == null ? BigDecimal.ZERO : outContractMoney));
                BigDecimal performanceMoney = children.stream().filter(item -> null != item.getPerformanceMoney()).map(ProjectInOutVO::getPerformanceMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hperformanceMoney = project.getPerformanceMoney() == null ? BigDecimal.ZERO : project.getPerformanceMoney();
                project.setPerformanceMoney(hperformanceMoney.add(performanceMoney == null ? BigDecimal.ZERO : performanceMoney));
                BigDecimal totalSettleMoney = children.stream().filter(item -> null != item.getTotalSettleMoney()).map(ProjectInOutVO::getTotalSettleMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal htotalSettleMoney = project.getTotalSettleMoney() == null ? BigDecimal.ZERO : project.getTotalSettleMoney();
                project.setTotalSettleMoney(htotalSettleMoney.add(totalSettleMoney == null ? BigDecimal.ZERO : totalSettleMoney));
                BigDecimal totalOutMoney = children.stream().filter(item -> null != item.getTotalOutMoney()).map(ProjectInOutVO::getTotalOutMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal htotalOutMoney = project.getTotalOutMoney() == null ? BigDecimal.ZERO : project.getTotalOutMoney();
                project.setTotalOutMoney(htotalOutMoney.add(totalOutMoney == null ? BigDecimal.ZERO : totalOutMoney));
                BigDecimal productionMoney = children.stream().filter(item -> null != item.getProductionMoney()).map(ProjectInOutVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hproductionMoney = project.getProductionMoney() == null ? BigDecimal.ZERO : project.getProductionMoney();
                project.setProductionMoney(hproductionMoney.add(productionMoney == null ? BigDecimal.ZERO : productionMoney));
                BigDecimal directMny = children.stream().filter(item -> null != item.getDirectMny()).map(ProjectInOutVO::getDirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hdirectMny = project.getDirectMny() == null ? BigDecimal.ZERO : project.getDirectMny();
                project.setDirectMny(hdirectMny.add(directMny == null ? BigDecimal.ZERO : directMny));
                BigDecimal indirectMny = children.stream().filter(item -> null != item.getIndirectMny()).map(ProjectInOutVO::getIndirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hindirectMny = project.getIndirectMny() == null ? BigDecimal.ZERO : project.getIndirectMny();
                project.setIndirectMny(hindirectMny.add(indirectMny == null ? BigDecimal.ZERO : indirectMny));
                BigDecimal paidIndirectMny = children.stream().filter(item -> null != item.getPaidIndirectMny()).map(ProjectInOutVO::getPaidIndirectMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hpaidIndirectMny = project.getPaidIndirectMny() == null ? BigDecimal.ZERO : project.getPaidIndirectMny();
                project.setPaidIndirectMny(hpaidIndirectMny.add(paidIndirectMny == null ? BigDecimal.ZERO : paidIndirectMny));
                BigDecimal bgIncomeMoney = children.stream().filter(item -> null != item.getBgIncomeMoney()).map(ProjectInOutVO::getBgIncomeMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hbgIncomeMoney = project.getBgIncomeMoney() == null ? BigDecimal.ZERO : project.getBgIncomeMoney();
                project.setBgIncomeMoney(hbgIncomeMoney.add(bgIncomeMoney == null ? BigDecimal.ZERO : bgIncomeMoney));
                BigDecimal handShareMoney = children.stream().filter(item -> null != item.getHandShareMoney()).map(ProjectInOutVO::getHandShareMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal hhandShareMoney = project.getHandShareMoney() == null ? BigDecimal.ZERO : project.getHandShareMoney();
                project.setHandShareMoney(hhandShareMoney.add(handShareMoney == null ? BigDecimal.ZERO : handShareMoney));
            }
        }
        page.setRecords(projectListRes);
        return page;
    }

    private List<ProjectPoolSetVO> queryProjectPoolByProjectId(Long projectId) {
        CommonResponse resp = this.projectSetApi.queryProjectPoolById(projectId);
        ArrayList<ProjectPoolSetVO> result = new ArrayList();
        if (resp.isSuccess()) {
            result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
        } else {
            this.logger.error(resp.getMsg());
        }
        return result;
    }

    public DefdocDetailVO getDefDocById(Long id) {
        if (id == null) {
            return new DefdocDetailVO();
        }
        CommonResponse resp = this.defdocApi.getDefDocById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData() != null ? (DefdocDetailVO)resp.getData() : new DefdocDetailVO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUse(String dateIn, Long orgId) {
        String startMonth = null;
        String endMonth = null;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-2) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-5) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01-01";
            endMonth = EJCDateUtil.getLastYear() + "-12-31";
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("sourceType", new Parameter("eq", (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode()));
        param1.getParams().put("signDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode()));
        param2.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        param3.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode()));
        param3.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        param5.getParams().put("sourceType", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        param5.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        param6.getParams().put("paymentDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param7 = (QueryParam)Utils.deepCopy((Object)webParam);
        param7.getParams().put("receiptDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param2, (IBaseService)this.settleService);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param3, (IBaseService)this.settleService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByMonth"), (QueryParam)param6, (boolean)false);
        Future future7 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/receiptRegister/queryList"), (QueryParam)param7);
        List contractList = new ArrayList();
        List productionList = new ArrayList();
        List quoteList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        JSONArray receiptList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            productionList = JSONObject.parseArray((String)((JSONArray)future2.get()).toJSONString(), SettlePoolEntity.class);
            quoteList = JSONObject.parseArray((String)((JSONArray)future3.get()).toJSONString(), SettlePoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = JSONObject.parseArray((String)((JSONArray)future6.get()).toJSONString());
            receiptList = (JSONArray)future7.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x -> x.getContractTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSignDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getContractTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> prodMap = productionList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> quoteMap = quoteList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> settleMap = settleList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        HashMap openInvoiceMap = new HashMap();
        HashMap recInvoiceMap = new HashMap();
        Map<String, BigDecimal> recMoneyMap = receiptList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("sumReceivedMny") != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getDate("receiptDate"), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("sumReceivedMny"), BigDecimal::add)));
        this.logger.info("\u6309\u6708\u67e5\u8be2\u5b9e\u4ed8\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paymentList));
        HashMap payMap = CollectionUtils.isNotEmpty((Collection)paymentList) ? (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)paymentList.get(0)), Map.class) : new HashMap();
        Map<String, BigDecimal> performanceMap = this.getPerformMonthMap(orgIds, startMonth, endMonth);
        FinanceUseResVO resVO = new FinanceUseResVO();
        List monthData = EJCDateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<String, FinanceUseResSubVO>();
        List<String> keyList = Arrays.asList("production", "partAReport", "backMoney", "openInvince", "jiesuanjine", "receiveInvince", "payMoney", "contract", "performance");
        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                FinanceUseResSubVO subVO;
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)prodMap.get(mon));
                }
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)quoteMap.get(mon));
                }
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)recMoneyMap.get(mon));
                }
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)openInvoiceMap.get(mon)));
                }
                if (key.equals(keyList.get(4))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)settleMap.get(mon));
                }
                if (key.equals(keyList.get(5))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)recInvoiceMap.get(mon)));
                }
                if (key.equals(keyList.get(6))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)payMap.get(mon)));
                }
                if (key.equals(keyList.get(7))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)contractMap.get(mon));
                }
                if (key.equals(keyList.get(8))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)performanceMap.get(mon));
                }
                if ((subVO = (FinanceUseResSubVO)subVOMap.get(key)) == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd((BigDecimal)subVO.getTotal(), (BigDecimal)monVal));
                ArrayList<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<BigDecimal>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }
        resVO.setMonthData(monthData);
        resVO.setProduction((FinanceUseResSubVO)subVOMap.get(keyList.get(0)));
        resVO.setPartAReport((FinanceUseResSubVO)subVOMap.get(keyList.get(1)));
        resVO.setBackMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(2)));
        resVO.setOpenInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(3)));
        resVO.setSettleMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(4)));
        resVO.setReceiveInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(5)));
        resVO.setPayMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(6)));
        resVO.setContract((FinanceUseResSubVO)subVOMap.get(keyList.get(7)));
        resVO.setPerformance((FinanceUseResSubVO)subVOMap.get(keyList.get(8)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(String dateIn, Long orgId) {
        String startMonth = null;
        String endMonth = null;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-2) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-5) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01-01";
            endMonth = EJCDateUtil.getLastYear() + "-12-31";
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        param1.getParams().put("signDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        param5.getParams().put("sourceType", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        param5.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        param6.getParams().put("paymentDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByMonth"), (QueryParam)param6, (boolean)false);
        List contractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = JSONObject.parseArray((String)((JSONArray)future6.get()).toJSONString());
            this.logger.info("\u6309\u6708\u67e5\u8be2\u5b9e\u4ed8\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paymentList));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x -> x.getContractTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSignDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getContractTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> settleMap = settleList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        HashMap payMap = CollectionUtils.isNotEmpty((Collection)paymentList) ? (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)paymentList.get(0)), Map.class) : new HashMap();
        Map<String, BigDecimal> performanceMap = this.getPerformMonthMap(orgIds, startMonth, endMonth);
        FinanceUseResVO resVO = new FinanceUseResVO();
        List monthData = EJCDateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<String, FinanceUseResSubVO>();
        List<String> keyList = Arrays.asList("jiesuanjine", "payMoney", "contract", "performance");
        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                FinanceUseResSubVO subVO;
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)settleMap.get(mon));
                }
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)payMap.get(mon)));
                }
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)contractMap.get(mon));
                }
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)performanceMap.get(mon));
                }
                if ((subVO = (FinanceUseResSubVO)subVOMap.get(key)) == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd((BigDecimal)subVO.getTotal(), (BigDecimal)monVal));
                ArrayList<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<BigDecimal>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }
        resVO.setMonthData(monthData);
        resVO.setSettleMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(0)));
        resVO.setPayMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(1)));
        resVO.setContract((FinanceUseResSubVO)subVOMap.get(keyList.get(2)));
        resVO.setPerformance((FinanceUseResSubVO)subVOMap.get(keyList.get(3)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPerformanceMny(List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        List<String> sourceTypes = HomePortalServiceImpl.getSourceTypes();
        param1.getParams().put("sourceType", new Parameter("in", sourceTypes));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)webParam);
        param2.getParams().put("inOutFlag", new Parameter("eq", (Object)1));
        param2.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        param2.getParams().put("turnFlag", new Parameter("in", (Object)new Integer[]{0, 1}));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)webParam);
        param3.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)webParam);
        param4.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.settleService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-store-web/statisics/queryList"), (QueryParam)param2);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-prormat-web/rentCalculate/queryList"), (QueryParam)param3);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proequipment-web/rentRental/queryList"), (QueryParam)param4);
        List settleList = new ArrayList();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), SettlePoolEntity.class);
            instoreList = (JSONArray)future2.get();
            rmatCalList = (JSONArray)future3.get();
            equipCalList = (JSONArray)future4.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal settleMny = settleList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal instoreMny = instoreList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("taxMny") != null).map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal rmatCalMny = rmatCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTaxMny") != null).map(x -> x.getBigDecimal("rentTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal equipCalMny = equipCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTotalTaxMny") != null).map(x -> x.getBigDecimal("rentTotalTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal performanceMny = ComputeUtil.safeAdd((BigDecimal)settleMny, (BigDecimal[])new BigDecimal[]{instoreMny, rmatCalMny, equipCalMny});
        return performanceMny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, BigDecimal> getPerformProjectMap(List<Long> projectIds) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectId", new Parameter("in", projectIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        List<String> sourceTypes = HomePortalServiceImpl.getSourceTypes();
        param1.getParams().put("sourceType", new Parameter("in", sourceTypes));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)webParam);
        param2.getParams().put("inOutFlag", new Parameter("eq", (Object)1));
        param2.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)webParam);
        param3.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)webParam);
        param4.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.settleService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-store-web/statisics/queryList"), (QueryParam)param2);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-prormat-web/rentCalculate/queryList"), (QueryParam)param3);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proequipment-web/rentRental/queryList"), (QueryParam)param4);
        List settleList = new ArrayList();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), SettlePoolEntity.class);
            instoreList = (JSONArray)future2.get();
            rmatCalList = (JSONArray)future3.get();
            equipCalList = (JSONArray)future4.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal settleMny = BigDecimal.ZERO;
        BigDecimal instoreMny = BigDecimal.ZERO;
        BigDecimal rmatCalMny = BigDecimal.ZERO;
        BigDecimal equipCalMny = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> performanceMap = new HashMap<Long, BigDecimal>();
        for (Long projectId : projectIds) {
            settleMny = settleList.stream().filter(x -> x.getCurTaxMny() != null && projectId.equals(x.getProjectId())).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            instoreMny = instoreList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("taxMny") != null && projectId.equals(x.getLong("projectId"))).map(x -> x.getBigDecimal("taxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            rmatCalMny = rmatCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTaxMny") != null && projectId.equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("rentTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            equipCalMny = equipCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTotalTaxMny") != null && projectId.equals(x.getJSONObject("projectId").getLong("id"))).map(x -> x.getBigDecimal("rentTotalTaxMny")).reduce(BigDecimal.ZERO, BigDecimal::add);
            performanceMap.put(projectId, ComputeUtil.safeAdd((BigDecimal)settleMny, (BigDecimal[])new BigDecimal[]{instoreMny, rmatCalMny, equipCalMny}));
        }
        return performanceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BigDecimal> getPerformMonthMap(List<Long> orgIds, String startMonth, String endMonth) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", orgIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        List<String> sourceTypes = HomePortalServiceImpl.getSourceTypes();
        param1.getParams().put("sourceType", new Parameter("in", sourceTypes));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)webParam);
        param2.getParams().put("inOutFlag", new Parameter("eq", (Object)1));
        param2.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        param2.getParams().put("sourceBillDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)webParam);
        param3.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param3.getParams().put("rentDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)webParam);
        param4.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param4.getParams().put("rentalDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.settleService);
        Future future2 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-store-web/statisics/queryStoreMnyGroupByDate"), (QueryParam)param2);
        Future future3 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-prormat-web/rentCalculate/queryList"), (QueryParam)param3);
        Future future4 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-proequipment-web/rentRental/queryList"), (QueryParam)param4);
        List settleList = new ArrayList();
        JSONArray instoreList = new JSONArray();
        JSONArray rmatCalList = new JSONArray();
        JSONArray equipCalList = new JSONArray();
        try {
            settleList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), SettlePoolEntity.class);
            instoreList = (JSONArray)future2.get();
            rmatCalList = (JSONArray)future3.get();
            equipCalList = (JSONArray)future4.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<String, BigDecimal> settleMap = settleList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> instoreMap = instoreList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("taxMny") != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getDate("sourceBillDate"), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("taxMny"), BigDecimal::add)));
        Map<String, BigDecimal> rmatCalMap = rmatCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTaxMny") != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getDate("rentDate"), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("rentTaxMny"), BigDecimal::add)));
        Map<String, BigDecimal> equipCalMap = equipCalList.stream().map(x -> (JSONObject)x).filter(x -> x.getBigDecimal("rentTotalTaxMny") != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getDate("rentalDate"), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("rentTotalTaxMny"), BigDecimal::add)));
        Map<String, BigDecimal> performanceMap = HomePortalServiceImpl.sumMap(settleMap, instoreMap, rmatCalMap, equipCalMap);
        return performanceMap;
    }

    public static Map<String, BigDecimal> sumMap(Map<String, BigDecimal> map1, Map<String, BigDecimal> ... addNums) {
        for (Map<String, BigDecimal> temp : addNums) {
            map1 = HomePortalServiceImpl.sumMap(map1, temp);
        }
        return map1;
    }

    private static Map<String, BigDecimal> sumMap(Map<String, BigDecimal> map1, Map<String, BigDecimal> map2) {
        for (String key : map2.keySet()) {
            if (map1.containsKey(key)) {
                map1.put(key, ComputeUtil.safeAdd((BigDecimal)map1.get(key), (BigDecimal)map2.get(key)));
                continue;
            }
            map1.put(key, map2.get(key));
        }
        return map1;
    }

    private static List<String> getSourceTypes() {
        ArrayList<String> sourceTypes = new ArrayList<String>();
        sourceTypes.add(SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u5b89\u62c6\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97.getCode());
        sourceTypes.add(SettleSourceTypeEnum.\u5176\u4ed6\u652f\u51fa\u5408\u540c\u6700\u7ec8\u7ed3\u7b97.getCode());
        return sourceTypes;
    }

    @Override
    public JSONObject queryOutputScale(Long projectId) {
        JSONObject object = new JSONObject();
        LambdaQueryWrapper contractQueryWrapper = new LambdaQueryWrapper();
        contractQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
        contractQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        contractQueryWrapper.eq(ContractPoolEntity::getSourceType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        contractQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List listContractPool = this.contractService.list((Wrapper)contractQueryWrapper);
        BigDecimal sumContractTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)listContractPool)) {
            sumContractTaxMny = listContractPool.stream().map(ContractPoolEntity::getContractTaxMny).reduce(BigDecimal::add).get();
        }
        LambdaQueryWrapper settleQueryWrapper = new LambdaQueryWrapper();
        settleQueryWrapper.eq(SettlePoolEntity::getProjectId, (Object)projectId);
        settleQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        settleQueryWrapper.eq(SettlePoolEntity::getSourceType, (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode());
        settleQueryWrapper.eq(SettlePoolEntity::getContractType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        settleQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        settleQueryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
        List listSettlePool = this.settleService.list((Wrapper)settleQueryWrapper);
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)listSettlePool)) {
            sumSettleTaxMny = listSettlePool.stream().map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal::add).get();
        }
        object.put("contractMoney", (Object)sumContractTaxMny);
        object.put("outputMoney", (Object)sumSettleTaxMny);
        if (sumContractTaxMny.compareTo(BigDecimal.ZERO) == 0) {
            object.put("outputProgress", (Object)BigDecimal.ZERO);
        } else {
            object.put("outputProgress", (Object)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumSettleTaxMny, (BigDecimal)sumContractTaxMny), (BigDecimal)new BigDecimal(100)));
        }
        return object;
    }

    @Override
    public JSONObject costSquareChart(Long projectId) {
        JSONObject object = new JSONObject();
        BigDecimal sumAllCostMny = BigDecimal.ZERO;
        BigDecimal sumRgfCostMny = BigDecimal.ZERO;
        BigDecimal sumJxfCostMny = BigDecimal.ZERO;
        BigDecimal sumZyfbfCostMny = BigDecimal.ZERO;
        BigDecimal sumClfCostMny = BigDecimal.ZERO;
        BigDecimal sumOtherCostMny = BigDecimal.ZERO;
        List<CostDetailVO> costDetailVOS = this.mapper.queryCostByProjectId(projectId);
        if (CollectionUtils.isNotEmpty(costDetailVOS)) {
            sumAllCostMny = costDetailVOS.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            List rgfSubjectOrgIds = (List)this.subjectOrgApi.querySubjectOrgIds("\u4eba\u5de5\u8d39").getData();
            List rgfList = costDetailVOS.stream().filter(e -> rgfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(rgfList)) {
                sumRgfCostMny = rgfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            List jxfSubjectOrgIds = (List)this.subjectOrgApi.querySubjectOrgIds("\u673a\u68b0\u8d39").getData();
            List jxfList = costDetailVOS.stream().filter(e -> jxfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(jxfList)) {
                sumJxfCostMny = jxfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            List zyfbfSubjectOrgIds = (List)this.subjectOrgApi.querySubjectOrgIds("\u4e13\u4e1a\u5206\u5305\u8d39").getData();
            List zyfbfList = costDetailVOS.stream().filter(e -> zyfbfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(zyfbfList)) {
                sumZyfbfCostMny = zyfbfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            List clfSubjectOrgIds = (List)this.subjectOrgApi.querySubjectOrgIds("\u6750\u6599\u8d39").getData();
            List clfList = costDetailVOS.stream().filter(e -> clfSubjectOrgIds.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(clfList)) {
                sumClfCostMny = clfList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            ArrayList allSubjectIdS = new ArrayList();
            allSubjectIdS.addAll(rgfSubjectOrgIds);
            allSubjectIdS.addAll(jxfSubjectOrgIds);
            allSubjectIdS.addAll(zyfbfSubjectOrgIds);
            allSubjectIdS.addAll(clfSubjectOrgIds);
            List otherList = costDetailVOS.stream().filter(e -> !allSubjectIdS.contains(e.getSubjectId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(otherList)) {
                sumOtherCostMny = otherList.stream().filter(x -> x.getHappenMny() != null).map(CostDetailVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        LambdaQueryWrapper contractQueryWrapper = new LambdaQueryWrapper();
        contractQueryWrapper.eq(ContractPoolEntity::getProjectId, (Object)projectId);
        contractQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        contractQueryWrapper.eq(ContractPoolEntity::getSourceType, (Object)ContractTypeEnum.\u65bd\u5de5\u5408\u540c.getTypeCode());
        contractQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List listContractPool = this.contractService.list((Wrapper)contractQueryWrapper);
        BigDecimal sumContractMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)listContractPool)) {
            BigDecimal contractMny = listContractPool.stream().filter(x -> x.getContractMny() != null).map(ContractPoolEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal replyMny = BigDecimal.ZERO;
            List replyList = listContractPool.stream().filter(e -> null != e.getTotalTeplyMny()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(replyList)) {
                replyMny = replyList.stream().map(ContractPoolEntity::getTotalTeplyMny).reduce(BigDecimal::add).get();
            }
            sumContractMny = ComputeUtil.safeAdd((BigDecimal)contractMny, (BigDecimal)replyMny);
        }
        Map<String, Object> targetCost = this.mapper.queryTargetCostByProjectId(projectId);
        BigDecimal targetCostMny = BigDecimal.ZERO;
        if (null != targetCost && null != targetCost.get("mny") && (targetCostMny = (BigDecimal)targetCost.get("mny")).compareTo(new BigDecimal("0E-8")) == 0) {
            targetCostMny = BigDecimal.ZERO;
        }
        LambdaQueryWrapper settleQueryWrapper = new LambdaQueryWrapper();
        settleQueryWrapper.eq(SettlePoolEntity::getProjectId, (Object)projectId);
        settleQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        settleQueryWrapper.eq(SettlePoolEntity::getSourceType, (Object)SettleSourceTypeEnum.\u5bf9\u7532\u62a5\u91cf.getCode());
        settleQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        settleQueryWrapper.in(SettlePoolEntity::getBillState, new Object[]{1, 3});
        List listSettlePool = this.settleService.list((Wrapper)settleQueryWrapper);
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)listSettlePool)) {
            sumSettleMny = listSettlePool.stream().filter(x -> x.getCurMny() != null).map(SettlePoolEntity::getCurMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal jjxyMny = ComputeUtil.safeSub((BigDecimal)sumContractMny, (BigDecimal)targetCostMny);
        BigDecimal glxyMny = ComputeUtil.safeSub((BigDecimal)targetCostMny, (BigDecimal)sumAllCostMny);
        BigDecimal jsxyMny = ComputeUtil.safeSub((BigDecimal)sumSettleMny, (BigDecimal)sumContractMny);
        object.put("sumRgfCostTaxMny", (Object)sumRgfCostMny);
        object.put("sumJxfCostTaxMny", (Object)sumJxfCostMny);
        object.put("sumZyfbfCostTaxMny", (Object)sumZyfbfCostMny);
        object.put("sumClfCostTaxMny", (Object)sumClfCostMny);
        object.put("sumOtherCostTaxMny", (Object)sumOtherCostMny);
        object.put("sumContractTaxMny", (Object)sumContractMny);
        object.put("targetCostTaxMny", (Object)targetCostMny);
        object.put("sumAllCostTaxMny", (Object)sumAllCostMny);
        object.put("sumSettleTaxMny", (Object)sumSettleMny);
        object.put("jjxyTaxMny", (Object)jjxyMny);
        object.put("glxyTaxMny", (Object)glxyMny);
        object.put("jsxyTaxMny", (Object)jsxyMny);
        return object;
    }

    @Override
    public BigDecimal thisProductMny() {
        String startMonth = EJCDateUtil.getYear() + "-01-01";
        String endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("sourceType", new Parameter("eq", (Object)SettleSourceTypeEnum.\u4ea7\u503c\u62a5\u91cf.getCode()));
        param.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        List productionList = this.settleService.queryList(param);
        BigDecimal productionMoney = productionList.stream().filter(x -> x.getCurTaxMny() != null).map(SettlePoolEntity::getCurTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return productionMoney;
    }

    public List<ProjectPoolSetVO> queryProjectPoolList() {
        return this.queryProjectPoolList(null, null, null);
    }

    public List<ProjectPoolSetVO> queryProjectPoolList(String projectStatus, String dateIn, Long orgId) {
        CommonResponse resp = this.projectSetApi.queryProjectPoolList(projectStatus, dateIn, orgId);
        ArrayList<ProjectPoolSetVO> result = new ArrayList();
        if (resp.isSuccess()) {
            result = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
        } else {
            this.logger.error(resp.getMsg());
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(EJCDateUtil.getMonthBetween((String)"2022-08-01", (String)"2023-03-31"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUseByYear(String year, Long orgId) {
        String startMonth = year + "-01-01";
        String endMonth = year + "-12-31";
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        param1.getParams().put("signDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param5 = (QueryParam)Utils.deepCopy((Object)param);
        param5.getParams().put("settleProperty", new Parameter("eq", (Object)"0"));
        param5.getParams().put("sourceType", new Parameter("ne", (Object)SettleSourceTypeEnum.\u8bc9\u8bbc\u8d39\u7ed3\u7b97.getCode()));
        param5.getParams().put("settleDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam webParam = (QueryParam)Utils.deepCopy((Object)param);
        webParam.setPageIndex(0);
        webParam.setPageSize(-1);
        webParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam param6 = (QueryParam)Utils.deepCopy((Object)webParam);
        param6.getParams().put("paymentDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        this.logger.info("\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)new Date());
        Future future1 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param1, (IBaseService)this.contractService);
        this.logger.info("\u65bd\u5de5\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)new Date());
        Future future5 = ListCallable.excute((ExecutorService)threadPool, (QueryParam)param5, (IBaseService)this.settleService);
        this.logger.info("\u7d2f\u8ba1\u7ed3\u7b97\u65f6\u95f4\uff1a{}", (Object)new Date());
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByMonth"), (QueryParam)param6, (boolean)false);
        this.logger.info("\u4ed8\u6b3e\u767b\u8bb0\u65f6\u95f4\uff1a{}", (Object)new Date());
        List contractList = new ArrayList();
        List settleList = new ArrayList();
        JSONArray paymentList = new JSONArray();
        try {
            contractList = JSONObject.parseArray((String)((JSONArray)future1.get()).toJSONString(), ContractPoolEntity.class);
            settleList = JSONObject.parseArray((String)((JSONArray)future5.get()).toJSONString(), SettlePoolEntity.class);
            paymentList = JSONObject.parseArray((String)((JSONArray)future6.get()).toJSONString());
            this.logger.info("\u6309\u6708\u67e5\u8be2\u5b9e\u4ed8\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paymentList));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x -> x.getContractTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSignDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getContractTaxMny(), BigDecimal::add)));
        Map<String, BigDecimal> settleMap = settleList.stream().filter(x -> x.getCurTaxMny() != null).collect(Collectors.groupingBy(x -> EJCDateUtil.format((Date)x.getSettleDate(), (String)"yyyy-MM"), Collectors.reducing(BigDecimal.ZERO, x -> x.getCurTaxMny(), BigDecimal::add)));
        HashMap payMap = CollectionUtils.isNotEmpty((Collection)paymentList) ? (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)paymentList.get(0)), Map.class) : new HashMap();
        Map<String, BigDecimal> performanceMap = this.getPerformMonthMap(orgIds, startMonth, endMonth);
        FinanceUseResVO resVO = new FinanceUseResVO();
        List monthData = EJCDateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<String, FinanceUseResSubVO>();
        this.logger.info("\u6570\u636e\u5904\u7406\u65f6\u95f4\uff1a{}", (Object)new Date());
        List<String> keyList = Arrays.asList("jiesuanjine", "payMoney", "contract", "performance");
        HashMap<Object, Object> g9FinanceUse = new HashMap();
        boolean flag = false;
        if (orgId.equals(1502571152583692289L)) {
            g9FinanceUse = this.getG9FinanceUse(startMonth, endMonth);
            flag = true;
        }
        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                FinanceUseResSubVO subVO;
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)settleMap.get(mon));
                    if (flag) {
                        monVal = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.nullToZero((BigDecimal)((BigDecimal)g9FinanceUse.get(mon + "-JS"))), (BigDecimal)monVal);
                    }
                }
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)payMap.get(mon)));
                    if (flag) {
                        monVal = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.nullToZero((BigDecimal)((BigDecimal)g9FinanceUse.get(mon + "-FK"))), (BigDecimal)monVal);
                    }
                }
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)contractMap.get(mon));
                    if (flag) {
                        monVal = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.nullToZero((BigDecimal)((BigDecimal)g9FinanceUse.get(mon + "-HT"))), (BigDecimal)monVal);
                    }
                }
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)performanceMap.get(mon));
                    if (flag) {
                        monVal = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.nullToZero((BigDecimal)((BigDecimal)g9FinanceUse.get(mon + "-LY"))), (BigDecimal)monVal);
                    }
                }
                if ((subVO = (FinanceUseResSubVO)subVOMap.get(key)) == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd((BigDecimal)subVO.getTotal(), (BigDecimal)monVal));
                ArrayList<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<BigDecimal>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }
        this.logger.info("\u6570\u636e\u5c01\u88c5\u65f6\u95f4\uff1a{}", (Object)new Date());
        resVO.setMonthData(monthData);
        resVO.setSettleMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(0)));
        resVO.setPayMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(1)));
        resVO.setContract((FinanceUseResSubVO)subVOMap.get(keyList.get(2)));
        resVO.setPerformance((FinanceUseResSubVO)subVOMap.get(keyList.get(3)));
        this.logger.info("\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)new Date());
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractMnyByYear(String year, Long orgId) {
        String startMonth = year + "-01-01";
        String endMonth = year + "-12-31";
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgIds = ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        QueryWrapper wrapper = HomePortalServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"contract_property", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
        wrapper.select(new String[]{"source_type", "source_type_name", "SUM(contract_tax_mny) as signTaxMny", "count(*) as signNum"});
        wrapper.eq((Object)"DATE_FORMAT(sign_date,'%Y')", (Object)year);
        wrapper.groupBy(new Object[]{"source_type"});
        List contractList = this.contractService.list((Wrapper)wrapper);
        this.logger.info("\u67e5\u51fa\u7b7e\u8ba2\u91d1\u989d\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)contractList));
        this.logger.info("\u67e5\u51fa\u7b7e\u8ba2\u91d1\u989d\u7ed3\u679c\u65f6\u95f4\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>\uff1a{}", (Object)new Date());
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.setPageIndex(0);
        param2.setPageSize(-1);
        param2.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param2.getParams().put("paymentContractFlag", new Parameter("eq", (Object)"0"));
        param2.getParams().put("paymentDate", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        Future future6 = ListCallable.excute((ExecutorService)threadPool, (String)(this.BASE_HOST + "ejc-profinance-web/api/paymentApplyApi/queryActualPayGroupByContractCategoryType"), (QueryParam)param2, (boolean)false);
        JSONArray paymentList = new JSONArray();
        try {
            paymentList = JSONObject.parseArray((String)((JSONArray)future6.get()).toJSONString());
            this.logger.info("\u6309\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5b9e\u4ed8\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)paymentList));
            this.logger.info("\u67e5\u51fa\u5b9e\u4ed8\u91d1\u989d\u7ed3\u679c\u65f6\u95f4\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>\uff1a{}", (Object)new Date());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<String, BigDecimal> contractMap = contractList.stream().filter(x -> null != x.getSignTaxMny() && null != x.getSourceType()).collect(Collectors.groupingBy(ContractPoolEntity::getSourceType, Collectors.reducing(BigDecimal.ZERO, x -> x.getSignTaxMny(), BigDecimal::add)));
        this.logger.info("\u6309\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u7b7e\u8ba2\u91d1\u989d\u7ed3\u679ccontractMap\uff1a{}", (Object)JSONObject.toJSONString(contractMap));
        HashMap payMap = CollectionUtils.isNotEmpty((Collection)paymentList) ? (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)paymentList.get(0)), Map.class) : new HashMap();
        this.logger.info("\u6309\u5408\u540c\u7c7b\u578b\u67e5\u8be2\u5b9e\u4ed8\u7ed3\u679cpayMap\uff1a{}", (Object)JSONObject.toJSONString(payMap));
        LinkedList contractMnyAndNumRatioVOList = new LinkedList();
        LinkedHashMap<String, ContractMnyAndNumRatioVO> resultMap = new LinkedHashMap<String, ContractMnyAndNumRatioVO>();
        LinkedList<String> contractTypes = this.getContractTypes();
        for (String contractType : contractTypes) {
            ContractMnyAndNumRatioVO contractMnyAndNumRatioVO;
            if (ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode().equals(contractType) || ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode().equals(contractType) || ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode().equals(contractType)) {
                if (resultMap.containsKey("\u6750\u6599")) {
                    if (contractMap.containsKey(contractType)) {
                        ((ContractMnyAndNumRatioVO)resultMap.get("\u6750\u6599")).setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)((ContractMnyAndNumRatioVO)resultMap.get("\u6750\u6599")).getSignTaxMny(), (BigDecimal)contractMap.get(contractType)));
                    }
                    if (!payMap.containsKey(contractType)) continue;
                    ((ContractMnyAndNumRatioVO)resultMap.get("\u6750\u6599")).setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)((ContractMnyAndNumRatioVO)resultMap.get("\u6750\u6599")).getContractTaxMny(), (BigDecimal)((BigDecimal)payMap.get(contractType))));
                    continue;
                }
                contractMnyAndNumRatioVO = new ContractMnyAndNumRatioVO();
                contractMnyAndNumRatioVO.setContractTypeName("\u6750\u6599");
                if (contractMap.containsKey(contractType)) {
                    contractMnyAndNumRatioVO.setSignTaxMny(contractMap.get(contractType));
                } else {
                    contractMnyAndNumRatioVO.setSignTaxMny(BigDecimal.ZERO);
                }
                if (payMap.containsKey(contractType)) {
                    contractMnyAndNumRatioVO.setContractTaxMny((BigDecimal)payMap.get(contractType));
                } else {
                    contractMnyAndNumRatioVO.setContractTaxMny(BigDecimal.ZERO);
                }
                resultMap.put("\u6750\u6599", contractMnyAndNumRatioVO);
                continue;
            }
            if (ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode().equals(contractType) || ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode().equals(contractType) || ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode().equals(contractType)) {
                if (resultMap.containsKey("\u8bbe\u5907")) {
                    if (contractMap.containsKey(contractType)) {
                        ((ContractMnyAndNumRatioVO)resultMap.get("\u8bbe\u5907")).setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)((ContractMnyAndNumRatioVO)resultMap.get("\u8bbe\u5907")).getSignTaxMny(), (BigDecimal)contractMap.get(contractType)));
                    }
                    if (!payMap.containsKey(contractType)) continue;
                    ((ContractMnyAndNumRatioVO)resultMap.get("\u8bbe\u5907")).setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)((ContractMnyAndNumRatioVO)resultMap.get("\u8bbe\u5907")).getContractTaxMny(), (BigDecimal)((BigDecimal)payMap.get(contractType))));
                    continue;
                }
                contractMnyAndNumRatioVO = new ContractMnyAndNumRatioVO();
                contractMnyAndNumRatioVO.setContractTypeName("\u8bbe\u5907");
                if (contractMap.containsKey(contractType)) {
                    contractMnyAndNumRatioVO.setSignTaxMny(contractMap.get(contractType));
                } else {
                    contractMnyAndNumRatioVO.setSignTaxMny(BigDecimal.ZERO);
                }
                if (payMap.containsKey(contractType)) {
                    contractMnyAndNumRatioVO.setContractTaxMny((BigDecimal)payMap.get(contractType));
                } else {
                    contractMnyAndNumRatioVO.setContractTaxMny(BigDecimal.ZERO);
                }
                resultMap.put("\u8bbe\u5907", contractMnyAndNumRatioVO);
                continue;
            }
            contractMnyAndNumRatioVO = new ContractMnyAndNumRatioVO();
            contractMnyAndNumRatioVO.setContractTypeName(ContractTypeEnum.getByCode((String)contractType).getTypeName());
            if (contractMap.containsKey(contractType)) {
                contractMnyAndNumRatioVO.setSignTaxMny(contractMap.get(contractType));
            } else {
                contractMnyAndNumRatioVO.setSignTaxMny(BigDecimal.ZERO);
            }
            if (payMap.containsKey(contractType)) {
                contractMnyAndNumRatioVO.setContractTaxMny((BigDecimal)payMap.get(contractType));
            } else {
                contractMnyAndNumRatioVO.setContractTaxMny(BigDecimal.ZERO);
            }
            resultMap.put(ContractTypeEnum.getByCode((String)contractType).getTypeName(), contractMnyAndNumRatioVO);
        }
        this.logger.info("resultMap\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(resultMap));
        for (String key : resultMap.keySet()) {
            contractMnyAndNumRatioVOList.add(resultMap.get(key));
        }
        if (orgId.equals(1502571152583692289L)) {
            HashMap<String, BigDecimal> g9ContractMny = this.getG9ContractMny(startMonth, endMonth);
            this.logger.info("G9\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u7ed3\u679cg9ContractMny\uff1a{}", (Object)JSONObject.toJSONString(g9ContractMny));
            HashMap<String, BigDecimal> g9PayMny = this.getG9PayMny(startMonth, endMonth);
            this.logger.info("G9\u652f\u51fa\u91d1\u989d\u7ed3\u679cg9PayMny\uff1a{}", (Object)JSONObject.toJSONString(g9PayMny));
            for (ContractMnyAndNumRatioVO contractMnyAndNumRatioVO : contractMnyAndNumRatioVOList) {
                if ("\u6750\u6599".equals(contractMnyAndNumRatioVO.getContractTypeName())) {
                    contractMnyAndNumRatioVO.setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getSignTaxMny(), (BigDecimal[])new BigDecimal[]{g9ContractMny.get("CL"), g9ContractMny.get("HNT"), g9ContractMny.get("ZZC")}));
                    contractMnyAndNumRatioVO.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getContractTaxMny(), (BigDecimal)g9PayMny.get("WZ")));
                    continue;
                }
                if ("\u8bbe\u5907".equals(contractMnyAndNumRatioVO.getContractTypeName())) {
                    contractMnyAndNumRatioVO.setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getSignTaxMny(), (BigDecimal[])new BigDecimal[]{g9ContractMny.get("SBAC"), g9ContractMny.get("SBZL"), g9ContractMny.get("SBGZ")}));
                    contractMnyAndNumRatioVO.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getContractTaxMny(), (BigDecimal)g9PayMny.get("SB")));
                    continue;
                }
                if ("\u52b3\u52a1\u5206\u5305\u5408\u540c".equals(contractMnyAndNumRatioVO.getContractTypeName())) {
                    contractMnyAndNumRatioVO.setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getSignTaxMny(), (BigDecimal)g9ContractMny.get("LW")));
                    contractMnyAndNumRatioVO.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getContractTaxMny(), (BigDecimal)g9PayMny.get("LW")));
                    continue;
                }
                if ("\u4e13\u4e1a\u5206\u5305\u5408\u540c".equals(contractMnyAndNumRatioVO.getContractTypeName())) {
                    contractMnyAndNumRatioVO.setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getSignTaxMny(), (BigDecimal)g9ContractMny.get("ZYFB")));
                    contractMnyAndNumRatioVO.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getContractTaxMny(), (BigDecimal)g9PayMny.get("ZY")));
                    continue;
                }
                if (!"\u5176\u4ed6\u652f\u51fa".equals(contractMnyAndNumRatioVO.getContractTypeName())) continue;
                contractMnyAndNumRatioVO.setSignTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getSignTaxMny(), (BigDecimal)g9ContractMny.get("QT")));
                contractMnyAndNumRatioVO.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)contractMnyAndNumRatioVO.getContractTaxMny(), (BigDecimal)g9PayMny.get("QT")));
            }
        }
        this.logger.info("\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>\uff1a{}", (Object)new Date());
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", contractMnyAndNumRatioVOList);
    }

    private List<ContractPoolEntity> getReferenceMapData(Map<String, List<JSONObject>> data) {
        this.logger.info("data:{}", (Object)JSONObject.toJSONString(data));
        ArrayList<ContractPoolEntity> resp = new ArrayList<ContractPoolEntity>();
        for (String billType : data.keySet()) {
            List<JSONObject> dataList = data.get(billType);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            for (JSONObject dataRow : dataList) {
                ContractPoolEntity tmp = new ContractPoolEntity();
                tmp.setSourceType(dataRow.getString("sourceType"));
                tmp.setSignTaxMny(new BigDecimal(dataRow.getString("signTaxMny")));
                resp.add(tmp);
            }
        }
        return resp;
    }

    private Map<String, String> getQueryDataParam(List<Long> orgIds, String year) {
        LinkedHashMap<String, String> queryParam = new LinkedHashMap<String, String>();
        StringBuilder sp = new StringBuilder();
        String orgIdsStr = JSONObject.toJSONString(orgIds);
        orgIdsStr = orgIdsStr.substring(1, orgIdsStr.length() - 1);
        this.logger.info("\u8fc7\u6ee4\u51fa\u7ec4\u7ec7\uff1a{}", (Object)orgIdsStr);
        sp.append("SELECT sourceType,sum( signTaxMny ) as signTaxMny FROM(SELECT\t'contractOther' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_proother_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) AND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'contractOther' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_proother_contract_change WHERE\tdr = 0 \tAND org_id IN ( " + orgIdsStr + ")\tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) \t) t GROUP BY sourceType");
        queryParam.put("BT220308000000001", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT sourceType,sum( signTaxMny ) as signTaxMny FROM(SELECT\t'laborSub' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_prosub_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) \tAND contract_type = 0 \tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'laborSub' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_prosub_contract_change WHERE\tdr = 0 \tAND org_id IN ( " + orgIdsStr + " ) \tAND contract_type = 0 \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'proSub' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_prosub_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) \tAND contract_type = 1 \tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'proSub' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_prosub_contract_change WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) \tAND contract_type = 1 \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) \t) t GROUP BY\tsourceType");
        queryParam.put("BT211108000000002", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT sourceType,sum( signTaxMny ) as signTaxMny FROM(SELECT\t'contractMaterial' AS sourceType,\tifnull( sum( base_money_with_tax ), 0 ) AS signTaxMny FROM\tejc_promaterial_contract WHERE\tdr = 0 \tAND org_id IN ( " + orgIdsStr + ")\t\tAND contract_type = 0 \tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'contractMaterial' AS sourceType,\tifnull( sum( change_money ), 0 ) AS signTaxMny FROM\tejc_promaterial_contract_change WHERE\tdr = 0 \t\tAND org_id IN (" + orgIdsStr + " )\tAND contract_type = 0 \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'contractConcrete' AS sourceType,\tifnull( sum( base_money_with_tax ), 0 ) AS signTaxMny FROM\tejc_promaterial_contract WHERE\tdr = 0 \t\tAND org_id IN ( " + orgIdsStr + ") \tAND contract_type = 1 \tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'contractConcrete' AS sourceType,\tifnull( sum( change_money ), 0 ) AS signTaxMny FROM\tejc_promaterial_contract_change WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " )\tAND contract_type = 1 \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) \t) t GROUP BY\tsourceType");
        queryParam.put("BT211227000000003", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT sourceType,sum( signTaxMny ) as signTaxMny FROM(SELECT\t'rmat' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_prormat_contract WHERE\tdr = 0 AND org_id IN (" + orgIdsStr + " )\t AND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'rmat' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_prormat_contract_change WHERE\tdr = 0 AND org_id IN ( " + orgIdsStr + ")\tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) \t) t GROUP BY sourceType");
        queryParam.put("BT220210000000004", sp.toString());
        sp = new StringBuilder();
        sp.append("SELECT sourceType,sum( signTaxMny ) as signTaxMny FROM(SELECT\t'equipmentPurchase' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_purchase_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " )\tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'equipmentPurchase' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_purchase_contract_change WHERE\tdr = 0 \tAND org_id IN ( " + orgIdsStr + ")\tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'equipmentRent' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_rent_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) \tAND DATE_FORMAT( signed_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'equipmentRent' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_rent_contract_change WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + " ) \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 )  UNION SELECT\t'contractAC' AS sourceType,\tifnull( sum( base_tax_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_ac_contract WHERE\tdr = 0 \tAND org_id IN (" + orgIdsStr + ") \tAND DATE_FORMAT( sign_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) UNION SELECT\t'contractAC' AS sourceType,\tifnull( sum( change_mny ), 0 ) AS signTaxMny FROM\tejc_proequipment_ac_contract_change WHERE\tdr = 0 \tAND org_id IN ( " + orgIdsStr + ") \tAND DATE_FORMAT( change_date, '%Y' ) = " + year + " \tAND bill_state IN ( 1, 3 ) \t) t GROUP BY\tsourceType");
        queryParam.put("BT220303000000002", sp.toString());
        return queryParam;
    }

    @Override
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractProjectMnyByYear(String year, Long orgId) {
        QueryParam param = new QueryParam();
        CommonResponse cSupplier = this.proSupplierApi.getSupplierIdByGradeName("C");
        if (cSupplier.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)cSupplier.getData()))) {
            param.getParams().put("partyb_id", new Parameter("not_in", cSupplier.getData()));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("contractProperty", new Parameter("eq", (Object)ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode()));
        QueryWrapper wrapper = HomePortalServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"DATE_FORMAT(sign_date,'%Y')", (Object)year);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.select(new String[]{"partyb_id, partyb_name, sum( base_tax_mny ) AS signTaxMny"});
        wrapper.isNotNull((Object)"partyb_id");
        wrapper.groupBy((Object[])new String[]{"partyb_id"});
        wrapper.orderByDesc((Object)"signTaxMny");
        wrapper.last("limit 10");
        List list = this.contractService.list((Wrapper)wrapper);
        List contractMnyAndNumRatioVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("\u67e5\u51fa\u5e74\u5ea6\u5408\u540c\u89c4\u6a21\u53ca\u6392\u540dtop10\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)list));
            contractMnyAndNumRatioVOList = BeanMapper.mapList((Iterable)list, ContractMnyAndNumRatioVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", contractMnyAndNumRatioVOList);
    }

    @Override
    public CommonResponse<List<SubUnitTopVO>> querySubUnitTopByYear(String year, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List allOrgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List ordIdsList = allOrgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List orgVOList = allOrgVOList.stream().filter(e -> e.getOrgType() == 2 || e.getOrgType() == 3).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", ordIdsList));
        param.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode())));
        QueryWrapper wrapper = HomePortalServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq((Object)"DATE_FORMAT(sign_date,'%Y')", (Object)year);
        List list = this.contractService.list((Wrapper)wrapper);
        Map orgIdMap = allOrgVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (k1, k2) -> k2));
        Map innerCodeMap = orgVOList.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity(), (k1, k2) -> k2));
        HashMap<String, SubUnitTopVO> map = new HashMap<String, SubUnitTopVO>();
        for (ContractPoolEntity vo : list) {
            OrgVO orgVO = (OrgVO)orgIdMap.get(vo.getOrgId());
            String innerCode = orgVO.getInnerCode();
            for (Map.Entry entry : innerCodeMap.entrySet()) {
                SubUnitTopVO topVO;
                BigDecimal money;
                if (!innerCode.contains(entry.getKey())) continue;
                OrgVO subOrgVO = (OrgVO)entry.getValue();
                String orgName = subOrgVO.getName();
                BigDecimal bigDecimal = money = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny().setScale(2, RoundingMode.HALF_DOWN);
                if (map.containsKey(orgName)) {
                    topVO = (SubUnitTopVO)map.get(orgName);
                    topVO.setMoney(ComputeUtil.safeAdd((BigDecimal)topVO.getMoney(), (BigDecimal)money));
                    map.put(orgName, topVO);
                    continue;
                }
                topVO = new SubUnitTopVO();
                topVO.setOrgId(subOrgVO.getId());
                topVO.setOrgCode(subOrgVO.getCode());
                topVO.setOrgName(subOrgVO.getName());
                topVO.setOrgType(subOrgVO.getOrgType());
                topVO.setMoney(money);
                map.put(orgName, topVO);
            }
        }
        List<Object> resultList = new ArrayList(map.values());
        this.logger.info("\u53d6\u51fa\u6240\u6709\u5b50\u5206\u5355\u4f4d\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(resultList));
        resultList = resultList.stream().sorted(Comparator.comparing(SubUnitTopVO::getMoney).reversed()).limit(6L).collect(Collectors.toList());
        this.logger.info("\u5b50\u5206\u5355\u4f4d\u91c7\u8d2d\u6392\u540d\uff1a{}", (Object)JSONObject.toJSONString(resultList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5b50\u5206\u5355\u4f4d\u91c7\u8d2d\u6392\u540d\u6570\u636e\u6210\u529f\uff01", resultList);
    }

    private static LinkedList<String> getContractTypes() {
        LinkedList<String> contractTypes = new LinkedList<String>();
        contractTypes.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        contractTypes.add(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
        return contractTypes;
    }

    private HashMap<String, BigDecimal> getG9ContractMny(String startMonth, String endMonth) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d25");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        Statement stmt = null;
        ResultSet rs = null;
        HashMap<String, BigDecimal> g9ValDTOS = new HashMap<String, BigDecimal>();
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            String SQL = "SELECT SUM(F_HZJE) AS je,\nCASE \n\tWHEN F_MODULE_CODE = 'GEPS.Material.Purchase.CLCGHTModule' THEN 'CL'\n\tWHEN F_MODULE_CODE = 'GEPS.Contract.Expenditure.QTZCHTModule' THEN 'QT'\n\tWHEN F_MODULE_CODE = 'GEPS.Labor.Contract.LWFBHTDJModule' THEN 'LW'\n\tWHEN F_MODULE_CODE = 'GEPS.Equipment.Leasing.JXSBZLHTModule' THEN 'SBZL'\n\tWHEN F_MODULE_CODE = 'GEPS.Material.Leasing.ZZCLZLHTModule' THEN 'ZZC'\n\tWHEN F_MODULE_CODE = 'GEPS.Material.Concrete.SPHNTGYHTModule' THEN 'HNT'\n\tWHEN F_MODULE_CODE = 'GEPS.Professional.Contract.ZYFBHTDJModule' THEN 'ZYFB'\n\tWHEN F_MODULE_CODE = 'GEPS.Equipment.Purchase.JXSBGZHTModule' THEN 'SBGZ'\n\tWHEN F_MODULE_CODE = 'GEPS.Equipment.Installation.DXSBACHTModule' THEN 'SBAC'\nEND AS type\t\nFROM [gtp-default].[dbo].[TE_GCB_HT]\nwhere  F_MODULE_NAME is not null \nand F_CREATE_TIME >= '" + startMonth + "'\nand F_CREATE_TIME <= '" + endMonth + "'\nand F_MODULE_CODE != 'GEPS.Contract.SGHT.SGHTDJModule'\nGROUP BY F_MODULE_CODE";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                g9ValDTOS.put(rs.getString("type"), rs.getBigDecimal("je"));
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d25");
        }
        return g9ValDTOS;
    }

    private HashMap<String, BigDecimal> getG9PayMny(String startMonth, String endMonth) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d25");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        HashMap<String, BigDecimal> g9ValDTOS = new HashMap<String, BigDecimal>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            String SQL = "SELECT SUM(F_JE) AS je,F_YWLX AS type\nFROM [gtp-default].[dbo].[TE_GYSLYQK]\nwhere F_BZRQ >= '" + startMonth + "' \nand F_BZRQ <= '" + endMonth + "' \nand F_LYLX in ('FK')\nGROUP BY F_LYLX,F_YWLX";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                g9ValDTOS.put(rs.getString("type"), rs.getBigDecimal("je"));
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d25");
        }
        return g9ValDTOS;
    }

    private HashMap<String, BigDecimal> getG9FinanceUse(String startMonth, String endMonth) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d25");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        HashMap<String, BigDecimal> g9ValDTOS = new HashMap<String, BigDecimal>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            String SQL = "SELECT SUM(F_JE) AS je,CONCAT(convert(nvarchar(7),F_BZRQ,120),'-',F_LYLX ) AS flag\nFROM [gtp-default].[dbo].[TE_GYSLYQK]\nwhere F_BZRQ >= '" + startMonth + "' \nand F_BZRQ <= '" + endMonth + "' \nand F_LYLX in ('FK','JS','LY')\nGROUP BY F_LYLX,convert(nvarchar(7),F_BZRQ,120)\nUNION\nSELECT SUM(F_HZJE) AS je,CONCAT(convert(nvarchar(7),F_CREATE_TIME,120),'-','HT' ) AS flag\nFROM [gtp-default].[dbo].[TE_GCB_HT]\nwhere F_DELETED = 0 and F_STATE = 3 and F_MODULE_NAME is not null \nand F_CREATE_TIME >= '" + startMonth + "'\nand F_CREATE_TIME <= '" + endMonth + "'\nand F_MODULE_CODE != 'GEPS.Contract.SGHT.SGHTDJModule'\nGROUP BY convert(nvarchar(7),F_CREATE_TIME,120)";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                g9ValDTOS.put(rs.getString("flag"), rs.getBigDecimal("je"));
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d25");
        }
        return g9ValDTOS;
    }
}

