/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contractbase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.entity.TemplateEntity;
import com.ejianc.business.contractbase.entity.TemplateSignatoryRectEntity;
import com.ejianc.business.contractbase.entity.TemplateVersionEntity;
import com.ejianc.business.contractbase.mapper.TemplateMapper;
import com.ejianc.business.contractbase.service.ITemplateService;
import com.ejianc.business.contractbase.service.ITemplateSignatoryRectService;
import com.ejianc.business.contractbase.service.ITemplateVersionService;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
extends BaseServiceImpl<TemplateMapper, TemplateEntity>
implements ITemplateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LJL_TEMPLATE";
    @Autowired
    private ITemplateVersionService versionService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ITemplateSignatoryRectService templateSignatoryRectService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<TemplateVO> returnCommon(Long id) {
        TemplateEntity entity = (TemplateEntity)((Object)this.selectById(id));
        TemplateVO templateVO = (TemplateVO)BeanMapper.map((Object)((Object)entity), TemplateVO.class);
        return CommonResponse.success((Object)templateVO);
    }

    @Override
    public TemplateVO saveCopyTempl(TemplateVO copyVo) {
        TemplateEntity sourceDbEntity = (TemplateEntity)((Object)super.selectById((Serializable)copyVo.getId()));
        TemplateEntity newTeTmpl = (TemplateEntity)((Object)BeanMapper.map((Object)copyVo, TemplateEntity.class));
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        newTeTmpl.setId(IdWorker.getId());
        newTeTmpl.setTenantId(sourceDbEntity.getTenantId());
        newTeTmpl.setQrCodePagePosition(sourceDbEntity.getQrCodePagePosition());
        newTeTmpl.setQrCodeShowType(sourceDbEntity.getQrCodeShowType());
        newTeTmpl.setQrCodeFlag(sourceDbEntity.getQrCodeFlag());
        newTeTmpl.setBillTypeCode(sourceDbEntity.getBillTypeCode());
        newTeTmpl.setCode((String)billCode.getData());
        newTeTmpl.setEnableStatus(TemplateVO.STATUS_DISABLE);
        CommonResponse copyResp = this.attachmentApi.copyFile(sourceDbEntity.getFileId().toString(), newTeTmpl.getId().toString(), "BT211109000000002", "concractFiles", false);
        if (!copyResp.isSuccess()) {
            this.logger.error("\u6a21\u677f\u6587\u4ef6-{}, \u590d\u5236\u5230\u5355\u636e-{}\u4e0b\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{sourceDbEntity.getFileId(), newTeTmpl.getId(), JSONObject.toJSONString((Object)copyResp)});
            throw new BusinessException("\u6a21\u677f\u590d\u5236\u5931\u8d25\uff0c\u6a21\u677f\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
        AttachmentVO newFile = (AttachmentVO)copyResp.getData();
        newTeTmpl.setFileId(newFile.getId());
        newTeTmpl.setOnlinePath(newFile.getOnlinePath());
        newTeTmpl.setFileSize(Integer.valueOf(newFile.getFileSize().toString()));
        newTeTmpl.setFilePath(newFile.getFilePath());
        newTeTmpl.setFileName(newFile.getFileName());
        if (null != newTeTmpl.getBelongOrgId()) {
            CommonResponse orgResp = this.orgApi.getOneById(newTeTmpl.getBelongOrgId());
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            newTeTmpl.setBelongOrgInnerCode(((OrgVO)orgResp.getData()).getInnerCode());
        }
        TemplateVersionEntity version = this.versionService.createVersion(newTeTmpl);
        newTeTmpl.setCurVersionId(version.getId());
        newTeTmpl.setCurVersion(1L);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(TemplateSignatoryRectEntity::getTemplateId, (Object)sourceDbEntity.getId());
        queryWrapper.orderByAsc(TemplateSignatoryRectEntity::getPartyCode);
        List entityList = this.templateSignatoryRectService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List newSignList = BeanMapper.mapList((Iterable)entityList, TemplateSignatoryRectEntity.class);
            newSignList.stream().forEach(item -> {
                item.setId(IdWorker.getId());
                item.setTemplateId(newTeTmpl.getId());
            });
            this.templateSignatoryRectService.saveOrUpdateBatch(newSignList, newSignList.size(), false);
        }
        super.saveOrUpdate((Object)newTeTmpl, false);
        return (TemplateVO)BeanMapper.map((Object)((Object)newTeTmpl), TemplateVO.class);
    }
}

