package com.ejianc.business.contractbase.home.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.contractbase.home.service.IHomePortalService;
import com.ejianc.business.contractbase.home.vo.FinanceCountVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.contractbase.home.vo.ProjectInOutVO;
import com.ejianc.business.contractbase.vo.ContractMnyAndNumRatioVO;
import com.ejianc.business.contractbase.vo.report.SubUnitTopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 门户首页 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@RestController
@RequestMapping("/homePortal")
public class HomePortalController {

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IHomePortalService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    // 资金统计
    @RequestMapping(value = "/capitalCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,BigDecimal>> capitalCount(
            @RequestParam(value = "range",required = false) String range,
            @RequestParam(value = "dateIn", required = false) String dateIn,
            @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.capitalCount(range, dateIn, orgId);
    }

    // 资金波动
    @RequestMapping(value = "/queryFinanceUse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUse(@RequestParam String dateIn, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryFinanceUse(dateIn, orgId);
    }

    // 领导桌面资金统计
    @RequestMapping(value = "/capitalCountLeader", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,BigDecimal>> capitalCountLeader(
            @RequestParam(value = "range",required = false) String range,
            @RequestParam(value = "dateIn", required = false) String dateIn,
            @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.capitalCountLeader(range, dateIn, orgId);
    }

    @RequestMapping(value = "/capitalCountOrgLeader", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinanceCountVO>> capitalCountOrgLeader(@RequestBody QueryParam param) {
        IPage<FinanceCountVO> page =  service.capitalCountOrgLeader(param);
        return CommonResponse.success(page);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("excel",new Parameter(QueryParam.EQ,"excel"));
        IPage<FinanceCountVO> list = service.capitalCountOrgLeader(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list.getRecords());
        ExcelExport.getInstance().export("FinanceCount-export.xlsx", beans, response);
    }

    // 领导桌面资金波动
    @RequestMapping(value = "/queryFinanceUseLeader", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(@RequestParam String dateIn, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryFinanceUseLeader(dateIn, orgId);
    }

    // 项目收支统计
    @RequestMapping(value = "/proPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> proPageList(@RequestBody(required = false) Map<String, Object> params) {
        JSONObject resp = new JSONObject();
        IPage<ProjectInOutVO> page =  service.proPageList(params);
        resp.put("data", page);
        return CommonResponse.success(resp);
    }

    // 本年完成产值
    @RequestMapping(value = "/thisProductMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BigDecimal> thisProductMny() {
        return CommonResponse.success(service.thisProductMny());
    }

    // 产值进度比例
    /*@RequestMapping(value = "/queryOutputScale", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryOutputScale(@RequestParam Long projectId) {
        return CommonResponse.success(service.queryOutputScale(projectId));
    }*/


    // 成本方圆图
    @RequestMapping(value = "/costSquareChart", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> costSquareChart(@RequestParam(value = "projectId",required = false) Long projectId,@RequestParam("projectDepartmentId") Long projectDepartmentId) {
        CommonResponse<List<ProjectPoolSetVO>> resp = projectPoolApi.queryProjectListByProjectDepartmentId(projectDepartmentId);
        if (resp.isSuccess()&& CollectionUtils.isNotEmpty(resp.getData())){
            return CommonResponse.success(service.costSquareChart(resp.getData().get(0).getId()));
        }else{
            return CommonResponse.error("查询项目异常！");
        }
    }

    // 项目收支统计
    @RequestMapping(value = "/proPageOrgList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> proPageOrgList(@RequestBody(required = false) Map<String, Object> params) {
        JSONObject resp = new JSONObject();
        IPage<ProjectInOutVO> page =  service.proPageOrgList(params);
        resp.put("data", page);
        return CommonResponse.success(resp);
    }

    // 一建BI大屏-资金支出月度趋势
    @RequestMapping(value = "/queryFinanceUseByYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUseByYear(@RequestParam String year, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryFinanceUseByYear(year, orgId);
    }

    // 一建BI大屏-施工年度总支出
    @RequestMapping(value = "/queryContractMnyByYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractMnyByYear(@RequestParam String year, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryContractMnyByYear(year, orgId);
    }

    // 一建BI大屏-年度合作规模及排名top10
    @RequestMapping(value = "/queryContractProjectMnyByYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractMnyAndNumRatioVO>> queryContractProjectMnyByYear(@RequestParam String year, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryContractProjectMnyByYear(year, orgId);
    }

    // 一建BI大屏-子分单位采购排名
    @RequestMapping(value = "/querySubUnitTopByYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubUnitTopVO>> querySubUnitTopByYear(@RequestParam String year, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.querySubUnitTopByYear(year, orgId);
    }

}

