package com.ejianc.business.contractbase.mapper;

import com.ejianc.business.contractbase.entity.TemplDetailExportSettingEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/11/8 10:53
 */
@Mapper
public interface TemplDetailExportSettingMapper extends BaseCrudMapper<TemplDetailExportSettingEntity> {
    /**
     * 根据合同分类查询所有可用的子表导出模板里列表
     *
     * @param categoryId
     * @return
     */
    List<TemplDetailExportSettingEntity> findExportDetailByCategoryId(@Param(value = "categoryId") Long categoryId, @Param(value = "parentCategoryId") Long parentCategoryId);

    /**
     *
     *
     * @param templIdList
     * @return
     */
    List<Map<Long, String>> getTemplExportMode(@Param(value = "templIdList") List<Long> templIdList);

    /**
     * 物理删除匹配的清单设置
     *
     * @param templateId
     * @return
     */
    void delByTemplateId(@Param(value = "templateId") Long templateId);
}
