package com.ejianc.business.contractbase.pool.contractpool.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractWarnDTO;
import com.ejianc.business.contractbase.pool.contractpool.mapper.ContractPoolMapper;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author
 * @Description:
 * @date
 */
@RestController
@RequestMapping(value = "/contractWarn/")
public class ContractWarnController {
//       * * * 26 * ?
//       {"dispatchCode":"WARNING000088"}
//    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ContractPoolMapper mapper;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    static  String  PC_URL_EC = "/ejc-targetcost-frontend/#/execution?projectId=";
    static  String  TEST_AGENTID = "1000038";
    static  String  TEST_SECRET = "0n0MCtZ1vNtJsKQWPIREQ1UNMM8BXDkQZat6nbRqGGE";
    static  String  PRO_AGENTID = "1000036";
    static  String  PRO_SECRET = "dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40";

    static  String  PC_URL = "/ejc-report-frontend/#/reportChat?tableCode=Excontracts?projectId=";
    static  String  PC_URL_COST = "/ejc-procost-frontend/#/costShare?projectId=";

    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            List<ContractWarnDTO> contractWarnDTOS = mapper.contractWarnList();

            if (ListUtil.isNotEmpty(contractWarnDTOS)) {
                for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if (assessDetailVO.getPercent().compareTo(new BigDecimal(0.5)) < 0) {
                                if (assessDetailVO.getDays()<14){
                                    low = true;
                                    useSetLow = set;
                                }else if (assessDetailVO.getDays()<28){
                                    meddle = true;
                                    useSetMeddle = set;
                                }else{
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            String pattern = "yyyy-MM-dd HH:mm:ss";
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getName());
                            vo.setPcTitle("支出合同滞后");
                            vo.setPcUrl(PC_URL + assessDetailVO.getProjectId());
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getOrgName());
                            vo.setSourceId(assessDetailVO.getProjectId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    @PostMapping(value = "execute70")
    public CommonResponse<String> execute70(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            List<ContractWarnDTO> contractWarnDTOS = mapper.contractWarnList();

            if (ListUtil.isNotEmpty(contractWarnDTOS)) {
                for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if (assessDetailVO.getPercent().compareTo(new BigDecimal(0.5)) > 0) {
                                if (assessDetailVO.getDays()<14){
                                    low = true;
                                    useSetLow = set;
                                }else if (assessDetailVO.getDays()<28){
                                    meddle = true;
                                    useSetMeddle = set;
                                }else{
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            String pattern = "yyyy-MM-dd HH:mm:ss";
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getName());
                            vo.setPcTitle("支出合同滞后");
                            vo.setPcUrl(PC_URL + assessDetailVO.getProjectId());
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getOrgName());
                            vo.setSourceId(assessDetailVO.getProjectId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    //实际归集金额低于累计产值统计70%
    @PostMapping(value = "executeCostWarn")
    public CommonResponse<String> executeCostWarn(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = mapper.costWarnList();
            if (ListUtil.isNotEmpty(contractWarnDTOS)) {
                for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if (assessDetailVO.getDays()<14){
                                low = true;
                                useSetLow = set;
                            }else if (assessDetailVO.getDays()<28){
                                meddle = true;
                                useSetMeddle = set;
                            }else{
                                high = true;
                                useSetHigh = set;
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            String pattern = "yyyy-MM-dd HH:mm:ss";
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getName());
                            vo.setPcTitle("合同滞后-成本归集");
                            vo.setPcUrl(PC_URL_COST + assessDetailVO.getProjectId());
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getOrgName());
                            vo.setSourceId(assessDetailVO.getProjectId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                                .replaceAll("#percent#", assessDetailVO.getPercent().multiply(new BigDecimal(100)).setScale(2, BigDecimal.ROUND_HALF_UP)+"")

                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    //未进行成本归集
    @PostMapping(value = "costShareWarn")
    public CommonResponse<String> costShareWarn(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<ContractWarnDTO> contractWarnDTOS = mapper.costShareWarnList();
            if (ListUtil.isNotEmpty(contractWarnDTOS)) {
                for (ContractWarnDTO assessDetailVO : contractWarnDTOS) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = assessDetailVO.getOrgId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;

                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if (assessDetailVO.getDays()<=2){
                                low = true;
                                useSetLow = set;
                            }else if (assessDetailVO.getDays()<=3){
                                meddle = true;
                                useSetMeddle = set;
                            }else{
                                high = true;
                                useSetHigh = set;
                            }
                        }

                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName(orgSet.getString("moduleName") + "-" +
                                    assessDetailVO.getName());
                            vo.setPcTitle("成本单据未归集");
                            vo.setPcUrl(PC_URL_COST + assessDetailVO.getProjectId());
                            vo.setOrgId(assessDetailVO.getOrgId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(assessDetailVO.getOrgId() + "");
                            vo.setOrgName(assessDetailVO.getOrgName());
                            vo.setSourceId(assessDetailVO.getProjectId().toString());
                            vo.setTenantId(999999L);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", assessDetailVO.getName())
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }

}