create table ejc_conbase_contract_freeze
(
    id               bigint      not null comment '主键ID'primary key,
    create_user_code varchar(50) null comment '创建者账号',
    create_time      datetime    null comment '创建时间',
    update_user_code varchar(50) null comment '修改者账号',
    update_time      datetime    null comment '修改时间',
    dr               tinyint     null comment '删除标识',
    tenant_id        bigint      null comment '租户ID',
    sync_es_flag     tinyint     null comment '是否同步es(1:是，0：否)',
    version          int         null comment '乐观锁',

    contract_name  varchar(50) null comment '合同名称',

    source_bill_id bigint(20) null comment '合同id',

    source_bill_code varchar(50) null comment '合同编号',

    project_id bigint(20) null comment '项目Id',

    project_ame varchar(50) null comment '项目名称',

    org_name varchar(20) null comment '项目所属单位',

    org_id bigint(50) null comment '项目所属单位id',

    first_party_name varchar(50) null comment '甲方',

    first_party_id bigint(20) null comment '甲方id',

    supplier_id bigint(20) null comment '供应商id',

    supplier_name varchar(50) null comment '供应商名称',

    freeze_data datetime null comment '冻结日期',

    operator_id bigint(20) null comment '经办人',

    operator_name varchar(50) null comment '经办人名',

    operator_unit_id  bigint(20)null comment '经办单位id',

    operator_unit_name varchar(50) null comment '经办单位',

    freeze_cause varchar(500) null comment '冻结/取消冻结 原因',

    performance_status tinyint comment '合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结',

    bill_code varchar(50) null comment '单据编号'
)
    comment '合同冻结表';


create table ejc_conbase_contract_relieve
(
    id               bigint      not null comment '主键ID'primary key,
    create_user_code varchar(50) null comment '创建者账号',
    create_time      datetime    null comment '创建时间',
    update_user_code varchar(50) null comment '修改者账号',
    update_time      datetime    null comment '修改时间',
    dr               tinyint     null comment '删除标识',
    tenant_id        bigint      null comment '租户ID',
    sync_es_flag     tinyint     null comment '是否同步es(1:是，0：否)',
    version          int         null comment '乐观锁',

    source_bill_name  varchar(50) null comment '合同名称',

    source_bill_id bigint(20) null comment '合同id',

    contract_bill varchar(50) null comment '合同编号',

    project_id bigint(20) null comment '项目Id',

    project_name varchar(50) null comment '项目名称',

    org_name varchar(50) null comment '项目所属单位',

    org_id bigint(20) null comment '项目所属单位id',

    first_party_name varchar(50) null comment '甲方',

    first_party_id bigint(20) null comment '甲方id',

    supplier_id bigint(20) null comment '供应商id',

    supplier_name varchar(50) null comment '供应商名称',

    relieve_data datetime null comment '解除日期',

    operator_id bigint(20) null comment '经办人',

    operator_name varchar(50) null comment '经办人名',

    operator_org_id  bigint(20)null comment ' 经办单位id',

    operator_org_name varchar(50) null comment '经办单位',

    relieve_cause varchar(500) null comment '解除 原因',

    draft_type tinyint null comment '起草方式 1、上传解除协议，2、已签章；',

    attachment_file_path varchar(50) null comment '合同附件路径',

    attachment_file_id bigint(50) null comment '附件协议 Id',

    performance_status tinyint comment '合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结',

    bill_code varchar(50) null comment '单据编号'
)
    comment '合同解除表';