CREATE TABLE `ejc_conbase_contract_filing`
(
    `id`                     bigint(20) NOT NULL COMMENT '主键ID',
    `create_user_code`       varchar(50)   DEFAULT NULL COMMENT '创建者账号',
    `create_time`            datetime      DEFAULT NULL COMMENT '创建时间',
    `update_user_code`       varchar(50)   DEFAULT NULL COMMENT '修改者账号',
    `update_time`            datetime      DEFAULT NULL COMMENT '修改时间',
    `dr`                     tinyint(4)    DEFAULT NULL COMMENT '删除标识',
    `tenant_id`              bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`           tinyint(4)    DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
    `version`                int(11)       DEFAULT NULL COMMENT '乐观锁',
    `filing_date`            date          DEFAULT NULL COMMENT '归档日期',
    `contract_name`          varchar(50)   DEFAULT NULL COMMENT '合同名称',
    `contract_id`            bigint(20)    DEFAULT NULL COMMENT '合同id',
    `contract_code`          varchar(50)   DEFAULT NULL COMMENT '合同编码',
    `supplier_id`            bigint(20)    DEFAULT NULL COMMENT '供应商Id（乙方id）',
    `supplier_name`          varchar(50)   DEFAULT NULL COMMENT '供应商名称（乙方名称）',
    `project_id`             bigint(20)    DEFAULT NULL COMMENT '项目Id',
    `project_name`           varchar(50)   DEFAULT NULL COMMENT '项目名称（带入）',
    `project_code`           varchar(50)   DEFAULT NULL COMMENT '项目编号',
    `filing_explain`         varchar(50)   DEFAULT NULL COMMENT '归档说明',
    `employee_name`          varchar(50)   DEFAULT NULL COMMENT '经办人 名称',
    `employee_id`            bigint(20)    DEFAULT NULL COMMENT '经办人',
    `employee_code`          varchar(50)   DEFAULT NULL COMMENT '经办人 编码',
    `department_name`        varchar(50)   DEFAULT NULL COMMENT '经办部门 名称',
    `department_id`          bigint(20)    DEFAULT NULL COMMENT '经办部门',
    `department_code`        varchar(50)   DEFAULT NULL COMMENT '经办部门 编码',
    `first_party_id`         bigint(20)    DEFAULT NULL COMMENT '甲方Id',
    `first_party_name`       varchar(50)   DEFAULT NULL COMMENT '甲方名称',
    `org_id`                 bigint(20)    DEFAULT NULL COMMENT '项目部ID',
    `org_name`               varchar(128)  DEFAULT NULL COMMENT '项目部名称',
    `org_code`               varchar(50)   DEFAULT NULL COMMENT '项目部编码',
    `parent_org_code`        varchar(50)   DEFAULT NULL COMMENT '项目部上级编码',
    `parent_org_name`        varchar(50)   DEFAULT NULL COMMENT '项目部上级名称',
    `parent_org_id`          bigint(20)    DEFAULT NULL COMMENT '项目部上级id',
    `memo`                   varchar(1024) DEFAULT NULL COMMENT '备注',
    `bill_state`             tinyint(4)    DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    `bill_code`              varchar(50)   DEFAULT NULL COMMENT '编码',
    `source_id`              bigint(20)    DEFAULT NULL COMMENT '来源 id',
    `effective_date`         datetime      DEFAULT NULL COMMENT '生效日期',
    `commit_date`            datetime      DEFAULT NULL COMMENT '提交日期',
    `commit_user_name`       varchar(50)   DEFAULT NULL COMMENT '提交人名称',
    `commit_user_code`       varchar(50)   DEFAULT NULL COMMENT '提交人账号',
    `update_bill_type`       varchar(64)   DEFAULT NULL COMMENT '单据类型',
    `filing_type_id`         bigint(20)    DEFAULT NULL COMMENT '归档类型 id',
    `filing_type_name`       varchar(64)   DEFAULT NULL COMMENT '归档类型 参照名称',
    `filing_type_code`       varchar(255)  DEFAULT NULL COMMENT '归档类型编码',
    `file_name`       varchar(255)  DEFAULT NULL COMMENT '归档类型编码',
    `file_id`       BIGINT ( 25 )  DEFAULT NULL COMMENT '文件Id',
    `filing_type_inner_code` varchar(255)  DEFAULT NULL COMMENT '归档类型内码',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 COMMENT ='归档主表';



CREATE TABLE `ejc_conbase_filing_type`
(
    `id`                      bigint(20) NOT NULL COMMENT '主键ID',
    `create_user_code`        varchar(50)   DEFAULT NULL COMMENT '创建者账号',
    `create_time`             datetime      DEFAULT NULL COMMENT '创建时间',
    `update_user_code`        varchar(50)   DEFAULT NULL COMMENT '修改者账号',
    `update_time`             datetime      DEFAULT NULL COMMENT '修改时间',
    `dr`                      tinyint(4)    DEFAULT NULL COMMENT '删除标识',
    `tenant_id`               bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`            tinyint(4)    DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
    `version`                 int(11)       DEFAULT NULL COMMENT '乐观锁',
    `pid`                     bigint(20)    DEFAULT NULL COMMENT '父Id',
    `bill_code`               varchar(50)   DEFAULT NULL COMMENT '编码',
    `memo`                    varchar(1024) DEFAULT NULL COMMENT '备注',
    `is_children`             tinyint(4)    DEFAULT NULL COMMENT '1:是，0：否',
    `filing_type_name`        varchar(128)  DEFAULT NULL COMMENT '归档类型名称',
    `p_name`                  varchar(64)   DEFAULT NULL COMMENT '父名称',
    `inner_code`              varchar(64)   DEFAULT NULL COMMENT '合同归档类型',
    `source_query_bill_type`  varchar(64)   DEFAULT NULL COMMENT '查询单据类型',
    `source_update_bill_type` varchar(64)   DEFAULT NULL COMMENT '修改单据类型',
    `query_table_name`        varchar(50)   DEFAULT NULL COMMENT '表名称',
    `query_parameter`         varchar(512)  DEFAULT NULL COMMENT '查询条件',
    `query_database_name`     varchar(50)   DEFAULT NULL COMMENT '数据库名称',
    `query_columns`           varchar(512)  DEFAULT NULL COMMENT '关系映射',
    `query_url`               varchar(512)  DEFAULT NULL COMMENT '请求数据地址',
    `query_project_name`      varchar(255)  DEFAULT NULL COMMENT '请求项目',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 COMMENT ='归档关系表';



CREATE TABLE `ejc-conbase`.`undo_log`
(
    `branch_id`     bigint(20)   NOT NULL COMMENT 'branch transaction id',
    `xid`           varchar(128) NOT NULL COMMENT 'global transaction id',
    `context`       varchar(128) NOT NULL COMMENT 'undo_log context,such as serialization',
    `rollback_info` longblob     NOT NULL COMMENT 'rollback info',
    `log_status`    int(11)      NOT NULL COMMENT '0:normal status,1:defense status',
    `log_created`   datetime(6)  NOT NULL COMMENT 'create datetime',
    `log_modified`  datetime(6)  NOT NULL COMMENT 'modify datetime',
    UNIQUE KEY `ux_undo_log` (`xid`, `branch_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8 COMMENT ='AT transaction mode undo table';



INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130114, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610001', NULL, 0, '劳务分包', NULL, 'laborSub', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130115, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610002', NULL, 0, '材料采购', NULL, 'contractMaterial', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130116, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610003', NULL, 0, '混凝土采购', NULL, 'contractConcrete', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130117, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610004', NULL, 0, '周转材租赁', NULL, 'rmat', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130118, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610005', NULL, 0, '专业分包', NULL, 'proSub', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130119, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610006', NULL, 0, '设备采购合同', NULL, 'equipmentPurchase', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130120, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610007', NULL, 0, '设备租赁合同', NULL, 'equipmentRent', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ejc-conbase`.`ejc_conbase_filing_type`(`id`, `create_user_code`, `create_time`, `update_user_code`, `update_time`, `dr`, `tenant_id`, `sync_es_flag`, `version`, `pid`, `bill_code`, `memo`, `is_children`, `filing_type_name`, `p_name`, `inner_code`, `source_query_bill_type`, `source_update_bill_type`, `query_table_name`, `query_parameter`, `query_database_name`, `query_columns`, `query_url`, `query_project_name`) VALUES (592739634007130121, 'guoming', '2022-06-17 15:35:38', NULL, NULL, 0, 999999, 0, 1, NULL, 'FIL_TYP20220610008', NULL, 0, '其他合同', NULL, 'contractOther', '不能修改', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
# 合同池新增归档状态
ALTER TABLE `ejc-conbase`.ejc_conbase_contract_pool ADD filing_status TINYINT ( 4 ) NULL COMMENT '是否归档 1：是；0：否；2归档中';
# 结算池新增归档状态
ALTER TABLE `ejc-conbase`.ejc_conbase_settle_pool ADD filing_status TINYINT ( 4 ) NULL COMMENT '是否归档 1：是；0：否；2归档中';
# 结算池新增归档状态
ALTER TABLE `ejc-conbase`.ejc_conbase_contract_filing ADD file_name varchar ( 100 ) NULL COMMENT '文件名称';
# 结算池新增归档状态
ALTER TABLE `ejc-conbase`.ejc_conbase_filing_type ADD bill_type varchar ( 100 ) NULL COMMENT ' 单据类型编码';