package com.ejianc.framework.core.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang3.StringUtils;

public class InvocationInfoProxy {
	private static final ThreadLocal<InvocationInfo> threadLocal = new ThreadLocal<InvocationInfo>() {
		protected InvocationInfo initialValue() {
			return new InvocationInfo();
		}
	};

	public static void reset() {
		threadLocal.remove();
	}

	public static String getSysid() {
		return threadLocal.get().sysid;
	}

	public static void setSysid(String sysid) {
		threadLocal.get().sysid = sysid;
	}

	public static Long getTenantid() {
		String tenantId = threadLocal.get().tenantid;
		if(StringUtils.isNotBlank(tenantId)) {
			return Long.parseLong(tenantId);
		}else{
			return null;
		}
	}

	public static  void setTenantid(Long tenantid) {
		threadLocal.get().tenantid = String.valueOf(tenantid);
	}

	public static Long getUserid() {
		String userId = threadLocal.get().userid;
		if(StringUtils.isNotBlank(userId)) {
			return Long.parseLong(userId);
		}else{
			return null;
		}
	}

	public static void setUserid(Long userid) {
		threadLocal.get().userid = String.valueOf(userid);
	}
	
	public static String getUsercode() {
		return threadLocal.get().usercode;
	}
	
	public static void setUsercode(String usercode) {
		threadLocal.get().usercode = usercode;
	}

	public static String getCallid() {
		return threadLocal.get().callid;
	}

	public static void setCallid(String callid) {
		threadLocal.get().callid = callid;
	}

	public static  String getToken() {
		return threadLocal.get().token;
	}
	
	public static void setToken(String token) {
		threadLocal.get().token = token;
	}
	
	public static String getLogints() {
		return threadLocal.get().logints;
	}
	
	public static void setLogints(String logints) {
		threadLocal.get().logints = logints;
	}

	public static String getTheme() {
		return threadLocal.get().theme;
	}

	public static void setTheme(String theme) {
		threadLocal.get().theme = theme;
	}
	public static String getLocale() {
		return threadLocal.get().locale;
	}

	public static void setLocale(String locale) {
		threadLocal.get().locale = locale;
	}
	public static Object getExtendAttribute(String key) {
		return threadLocal.get().extendAttributes.get(key);
	}
	@SuppressWarnings("unchecked")
	public static <T> T getExtendAttribute(Class<T> cls) {
		return (T) threadLocal.get().extendAttributes.get(cls);
	}
	
	public static boolean isBlank() {
		String userId = threadLocal.get().userid;
		String tenantId = threadLocal.get().tenantid;
		if(StringUtils.isBlank(userId) && StringUtils.isBlank(tenantId)) {
			return true;
		}else{
			return false;
		}
	}
	/**
	 * set extends attributes
	 * <p>Extends attributes will not be transferred when a remote process call</p>
	 *
	 * @param key
	 * @param value
	 */
	public static void setExtendAttribute(Object key, Object value) {
		threadLocal.get().extendAttributes.put(key, value);
	}

	public static Map<String,String> getParamters(){
		return threadLocal.get().parameters ;
	}
	
	public static String getParameter(String parameter) {
		return threadLocal.get().parameters.get(parameter);
	}

	public static String setParameter(String parameter, String value) {
		return threadLocal.get().parameters.put(parameter, value);
	}

	public static Iterator<Entry<String, String>> getSummry() {
		return threadLocal.get().getSummry();
	}

	public static String getTimeZone() {
		return threadLocal.get().parameters.get("timezone");
	}

	public static void setTimeZone(String timeZone) {
		if(timeZone != null)
			threadLocal.get().parameters.put("timezone", timeZone) ;
	}

}

class InvocationInfo {
	String sysid;
	String tenantid;
	String userid;
	String usercode;
	String callid;
	String token;
	String theme;
	String locale;
	String logints;

	Map<Object, Object> extendAttributes = new HashMap<Object, Object>();
	Map<String, String> parameters = new HashMap<String, String>();

	public Iterator<Entry<String, String>> getSummry() {
		Map<String, String> map = new HashMap<String, String>();
		map.putAll(parameters);
		map.put("sysid", sysid);
		map.put("token", token);
		map.put("tenantid", tenantid);
		map.put("userid", userid);
		map.put("usercode", usercode);
		map.put("callid", callid);
		map.put("locale", locale);
		return map.entrySet().iterator();
	}
}