package com.ejianc.framework.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.io.ClassPathResource;

public class ImportTemplate {
	
	private static HttpServletResponse httpResponse;
	
	public static void initialize(HttpServletResponse response) {
		try {
			httpResponse = response;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static boolean templetdownload(HttpServletRequest request, String filename,String downfilename) {
		try {
			String ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
			ClassPathResource resource = new ClassPathResource("static/"+filename);
			downfilename = downfilename + "." + ext;
			File file = resource.getFile();
			getFile(file, httpResponse, downfilename);
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
	
	/**
	 * 将指定文件输出到页面输出流中 flag:下载类型,true="attachment",false="inline" 可以要保存的目标文件名
	 */
	private static void getFile(File file, HttpServletResponse httpservletresponse,String downfilename1) throws IOException {
		String downfilename= downfilename1;
		downfilename=downfilename.trim();
		String fileName = (downfilename != null && downfilename.trim().length() > 0) ? downfilename : file.getName();
		httpservletresponse.setContentType("application/octet-stream");
		httpservletresponse.setHeader("Content-Disposition","attachment;filename=" + URLEncoder.encode(fileName,"utf-8"));
		javax.servlet.ServletOutputStream servletoutputstream1 = httpservletresponse.getOutputStream();
		dumpFile(file, servletoutputstream1, httpservletresponse);
		servletoutputstream1.flush();
		servletoutputstream1.close();  
	}
	
	/**
	 * 将指定文件输出到指定的输出流
	 */
	private static void dumpFile(File file, OutputStream outputstream,HttpServletResponse httpservletresponse) throws FileNotFoundException, IOException {
		byte abyte0[] = new byte[4096];
		FileInputStream fileinputstream = new FileInputStream(file);
		int i, length = fileinputstream.available();
		if (httpservletresponse != null)
			httpservletresponse.setContentLength(length); // 设置下载字节长度
		while ((i = fileinputstream.read(abyte0)) != -1) outputstream.write(abyte0, 0, i);
		fileinputstream.close();
	}
	
}
