/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.kit.base;

import org.apache.commons.lang3.StringUtils;

public class ValueValidator {
    public static <T> T checkAndGet(T value, T defaultValue, Validator<T> v) {
        if (v.validate(value)) {
            return value;
        }
        return defaultValue;
    }

    public static interface Validator<T> {
        public static final Validator<Integer> INTEGER_GT_ZERO_VALIDATOR = new Validator<Integer>(){

            @Override
            public boolean validate(Integer value) {
                return value != null && value > 0;
            }
        };
        public static final Validator<String> STRING_EMPTY_VALUE_VALIDATOR = new Validator<String>(){

            @Override
            public boolean validate(String value) {
                return StringUtils.isNotEmpty((CharSequence)value);
            }
        };
        public static final Validator<String> STRICT_BOOL_VALUE_VALIDATOR = new Validator<String>(){

            @Override
            public boolean validate(String value) {
                return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
            }
        };

        public boolean validate(T var1);
    }
}

