/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ExcelExport {
    private static ExcelExport excelExport = null;

    private ExcelExport() {
        System.out.println("============jxls\u5bfc\u51fa===========");
    }

    public static synchronized ExcelExport getInstance() {
        if (excelExport == null) {
            excelExport = new ExcelExport();
        }
        return excelExport;
    }

    public void download(String name, HttpServletResponse response) {
        try {
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
            response.setHeader("Content-disposition", "attachment;success=true;filename =" + new String(name.getBytes("GB2312"), "ISO-8859-1"));
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            ServletOutputStream fos = null;
            FileInputStream fis = null;
            File uploadFile = new File(name);
            fis = new FileInputStream(uploadFile);
            bis = new BufferedInputStream(fis);
            fos = response.getOutputStream();
            bos = new BufferedOutputStream((OutputStream)fos);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = bis.read(buffer, 0, 8192)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            bos.flush();
            ((InputStream)fis).close();
            bis.close();
            fos.close();
            bos.close();
            response.flushBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void export(String exitsName, Map<String, Object> data, String fileFileName, HttpServletResponse response) {
        XLSTransformer transformer = new XLSTransformer();
        try {
            String path = this.getClass().getClassLoader().getResource("excel").getPath() + "/" + exitsName;
            transformer.transformXLS(path, data, fileFileName);
        }
        catch (ParsePropertyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        ExcelExport.getInstance().download(fileFileName, response);
    }
}

