/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import com.ejianc.framework.core.util.Utils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateFormater
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT+08:00");
    public static final String LONG_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_FORMAT = "yyyy-MM-dd";
    public static final String YEAR_MONTH = "yyyy-MM";
    public static final String SHORT_TIME = "MM-dd HH:mm";
    private Date date = null;
    private TimeZone timeZone = DEFAULT_TIME_ZONE;

    private DateFormater(TimeZone tz) {
        this.timeZone = tz;
    }

    @Deprecated
    public static DateFormater getInstance() {
        return DateFormater.getInstance(System.currentTimeMillis());
    }

    @Deprecated
    public static DateFormater getInstance(Date date) {
        return DateFormater.getInstance(date.getTime());
    }

    @Deprecated
    public static DateFormater getInstance(long millis) {
        DateFormater formater = new DateFormater(DEFAULT_TIME_ZONE);
        formater.date = new Date(millis);
        return formater;
    }

    @Deprecated
    public static DateFormater getInstance(String dateStr) {
        return DateFormater.getInstance(dateStr, DEFAULT_TIME_ZONE);
    }

    public static DateFormater getInstance(Date date, int timeZone) {
        return DateFormater.getInstance(date.getTime(), DateFormater.getTimeZone(timeZone));
    }

    public static DateFormater getInstance(Date date, TimeZone timeZone) {
        return DateFormater.getInstance(date.getTime(), timeZone);
    }

    public static DateFormater getInstance(long millis, TimeZone timeZone) {
        DateFormater formater = new DateFormater(DEFAULT_TIME_ZONE);
        formater.date = new Date(millis);
        formater.timeZone = timeZone;
        return formater;
    }

    public static DateFormater getInstance(String dateStr, int timeZone) {
        return DateFormater.getInstance(dateStr, DateFormater.getTimeZone(timeZone));
    }

    public static DateFormater getInstance(String dateStr, String timeZone) {
        return DateFormater.getInstance(dateStr, TimeZone.getTimeZone(timeZone));
    }

    public static DateFormater getInstance(String dateStr, TimeZone timeZone) {
        DateFormater formater = new DateFormater(timeZone);
        try {
            formater.date = dateStr == null || "".equals(dateStr) ? new Date() : (dateStr.length() == 10 && Utils.isNum(dateStr) ? new Date(Long.parseLong(dateStr) * 1000L) : (dateStr.length() == 13 && Utils.isNum(dateStr) ? new Date(Long.parseLong(dateStr)) : DateFormater.convert2Date(dateStr, timeZone)));
        }
        catch (Throwable t) {
            throw new RuntimeException("\u65e5\u671f\u975e\u6cd5\uff1a" + dateStr);
        }
        return formater;
    }

    public static Date convert2Date(String dateStr, TimeZone timeZone) throws ParseException {
        SimpleDateFormat sdf = null;
        sdf = dateStr.length() == 10 ? new SimpleDateFormat(SHORT_FORMAT) : (dateStr.length() == 7 ? new SimpleDateFormat(YEAR_MONTH) : new SimpleDateFormat(LONG_FORMAT));
        sdf.setTimeZone(timeZone);
        return sdf.parse(dateStr);
    }

    public DateFormater setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateFormater setTimeZone(String timeZoneId) {
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
        return this;
    }

    public DateFormater setTimeZone(int timeZone) {
        if (timeZone > 12) {
            timeZone = 12;
        } else if (timeZone < -12) {
            timeZone = -12;
        }
        this.timeZone = TimeZone.getTimeZone((timeZone >= 0 ? "GMT+" : "GMT") + timeZone);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Date getDate() {
        return this.date;
    }

    public DateFormater getOffsetSecond(int seconds) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.add(13, seconds);
        DateFormater formater = new DateFormater(this.timeZone);
        formater.date = calendar.getTime();
        return formater;
    }

    public DateFormater getOffset(int days) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.add(5, days);
        DateFormater formater = new DateFormater(this.timeZone);
        formater.date = calendar.getTime();
        return formater;
    }

    public DateFormater getOffsetMonth(int months) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.add(2, months);
        DateFormater formater = new DateFormater(this.timeZone);
        formater.date = calendar.getTime();
        return formater;
    }

    public int getHour24() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        return calendar.get(11);
    }

    public int getDay() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        return calendar.get(5);
    }

    public DateFormater setDay(int day) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.set(5, day);
        this.date = calendar.getTime();
        return this;
    }

    public int getDaysOfWeek() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        return calendar.get(7);
    }

    public String getDayOfWeekName() {
        int day = this.getDaysOfWeek();
        switch (day) {
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
            case 1: {
                return "\u65e5";
            }
        }
        return null;
    }

    public int getDaysOfMonth() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        return calendar.getActualMaximum(5);
    }

    public DateFormater getFirstDateOfMonth() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.set(5, 1);
        DateFormater formater = new DateFormater(this.timeZone);
        formater.date = calendar.getTime();
        return formater;
    }

    public DateFormater getLastDateOfMonth() {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.date);
        calendar.set(5, this.getDaysOfMonth());
        DateFormater formater = new DateFormater(this.timeZone);
        formater.date = calendar.getTime();
        return formater;
    }

    public int getDaysBetween(DateFormater df) {
        long differSeconds = Math.abs(this.getDate().getTime() - df.getDate().getTime()) / 1000L;
        return (int)Math.ceil((double)differSeconds * 1.0 / 86400.0);
    }

    public DateFormater getBegin() {
        return DateFormater.getInstance(this.format("yyyy-MM-dd 00:00:00"), this.timeZone);
    }

    public DateFormater getEnd() {
        return DateFormater.getInstance(this.format("yyyy-MM-dd 23:59:59"), this.timeZone);
    }

    public DateFormater getNoon() {
        return DateFormater.getInstance(this.format("yyyy-MM-dd 12:00:00"), this.timeZone);
    }

    public boolean before(DateFormater df) {
        return this.getDate().before(df.getDate());
    }

    public boolean after(DateFormater df) {
        return this.getDate().after(df.getDate());
    }

    public int compareTo(Date date) {
        return this.getDate().compareTo(date);
    }

    public int compareTo(DateFormater df) {
        return this.getDate().compareTo(df.getDate());
    }

    public boolean equals(Object obj) {
        if (obj != null && (obj instanceof DateFormater || obj instanceof Date)) {
            if (obj instanceof DateFormater) {
                return this.getDate().getTime() == ((DateFormater)obj).getDate().getTime();
            }
            return this.getDate().getTime() == ((Date)obj).getTime();
        }
        return false;
    }

    public String getLongFormat() {
        return this.format(LONG_FORMAT);
    }

    public String getShortFormat() {
        return this.format(SHORT_FORMAT);
    }

    public String getYearMonth() {
        return this.format(YEAR_MONTH);
    }

    public String getShortTime() {
        return this.format(SHORT_TIME);
    }

    public String format(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(this.timeZone);
        return sdf.format(this.date);
    }

    public static Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static TimeZone getTimeZone(int tz) {
        if (tz > 12) {
            tz = 12;
        } else if (tz < -12) {
            tz = -12;
        }
        return TimeZone.getTimeZone((tz >= 0 ? "GMT+" : "GMT") + tz);
    }

    public String toString() {
        return this.getLongFormat();
    }

    public static void main(String[] args) {
        DateFormater now = DateFormater.getInstance();
        System.out.println(now);
        System.out.println(now.getBegin());
        System.out.println(now.getBegin().getDate().getTime());
        System.out.println(now.getDate().getTime());
        now.setTimeZone(-9);
        System.out.println(now);
        System.out.println(now.getBegin());
        System.out.println(now.getBegin().getDate().getTime());
        System.out.println(now.getDate().getTime());
    }
}

