/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.core.io.ClassPathResource;

public class ExcelTemplate {
    public static final String DATA_LINE = "datas";
    public static final String DEFAULT_STYLE = "defaultStyle";
    public static final String STYLE = "styles";
    public static final String SER_NUM = "sernums";
    private static ExcelTemplate et = new ExcelTemplate();
    private Workbook wb;
    private Sheet sheet;
    private int initColIndex;
    private int initRowIndex;
    private int curColIndex;
    private int curRowIndex;
    private Row curRow;
    private int lastRowIndex;
    private CellStyle defaultStyle;
    private float rowHeight;
    private Map<Integer, CellStyle> styles = new HashMap<Integer, CellStyle>();
    private int serColIndex;

    private ExcelTemplate() {
    }

    public static ExcelTemplate getInstance() {
        return et;
    }

    public ExcelTemplate readTemplateByClasspath(String path) {
        try {
            this.wb = WorkbookFactory.create((InputStream)ExcelTemplate.class.getResourceAsStream(path));
            this.initTemplate();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        return this;
    }

    public ExcelTemplate readTemplateByPath(String template) {
        try {
            ClassPathResource resource = new ClassPathResource("static/" + template);
            this.wb = WorkbookFactory.create((File)resource.getFile());
            this.initTemplate();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
        }
        return this;
    }

    public void writeToFile(String filePath) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            this.wb.write((OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5199\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u6570\u636e\u5931\u8d25" + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void write(OutputStream fos) {
        try {
            this.wb.write(fos);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u5199\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u6570\u636e\u5931\u8d25" + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createCell(String value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(int value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue((double)value);
        ++this.curColIndex;
    }

    public void createCell(Date value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(double value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(boolean value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(Calendar value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    private void setCellStyle(Cell c) {
        if (this.styles.containsKey(this.curColIndex)) {
            c.setCellStyle(this.styles.get(this.curColIndex));
        } else {
            c.setCellStyle(this.defaultStyle);
        }
    }

    public void createNewRow() {
        if (this.lastRowIndex >= this.curRowIndex && this.curRowIndex != this.initRowIndex) {
            this.sheet.shiftRows(this.curRowIndex, this.lastRowIndex, 1, true, true);
            ++this.lastRowIndex;
        }
        this.curRow = this.sheet.createRow(this.curRowIndex);
        this.curRow.setHeightInPoints(this.rowHeight);
        ++this.curRowIndex;
        this.curColIndex = this.initColIndex;
    }

    public void insertSer() {
        int index = 1;
        Row row = null;
        Cell c = null;
        for (int i = this.initRowIndex; i < this.curRowIndex; ++i) {
            row = this.sheet.getRow(i);
            c = row.createCell(this.serColIndex);
            this.setCellStyle(c);
            c.setCellValue((double)index++);
        }
    }

    public void replaceFinalData(Map<String, String> datas) {
        if (datas == null) {
            return;
        }
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellType() != 1 || !(str = c.getStringCellValue().trim()).startsWith("#") || !datas.containsKey(str.substring(1))) continue;
                c.setCellValue(datas.get(str.substring(1)));
            }
        }
    }

    private void initTemplate() {
        this.sheet = this.wb.getSheetAt(0);
        this.initConfigData();
        this.lastRowIndex = this.sheet.getLastRowNum();
        this.curRow = this.sheet.createRow(this.curRowIndex);
    }

    private void initConfigData() {
        boolean findData = false;
        boolean findSer = false;
        for (Row row : this.sheet) {
            if (findData) break;
            for (Cell c : row) {
                if (c.getCellType() != 1) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(SER_NUM)) {
                    this.serColIndex = c.getColumnIndex();
                    findSer = true;
                }
                if (!str.equals(DATA_LINE)) continue;
                this.initColIndex = c.getColumnIndex();
                this.initRowIndex = row.getRowNum();
                this.curColIndex = this.initColIndex;
                this.curRowIndex = this.initRowIndex;
                this.defaultStyle = c.getCellStyle();
                this.rowHeight = row.getHeightInPoints();
                this.initStyles();
                findData = true;
                break;
            }
            if (findSer) continue;
            this.initSer();
        }
    }

    private void initSer() {
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellType() != 1 || !(str = c.getStringCellValue().trim()).equals(SER_NUM)) continue;
                this.serColIndex = c.getColumnIndex();
            }
        }
    }

    private void initStyles() {
        for (Row row : this.sheet) {
            for (Cell c : row) {
                if (c.getCellType() != 1) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(DEFAULT_STYLE)) {
                    this.defaultStyle = c.getCellStyle();
                }
                if (!str.equals(STYLE)) continue;
                this.styles.put(c.getColumnIndex(), c.getCellStyle());
            }
        }
    }
}

